/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.gf.tool;

import com.objectshare.gf.base.GFGO;
import com.objectshare.gf.base.GFHandle;
import com.objectshare.gf.base.event.GFDrawingMouseEvent;
import com.objectshare.gf.connect.GFLocator;
import com.objectshare.gf.tool.GF3DRotatable;
import java.awt.Dimension;

public class GF3DRotationHandle
extends GFHandle {
    public float yawXRatio;
    public float pitchXRatio;
    public float rollXRatio;
    public float yawYRatio;
    public float pitchYRatio;
    public float rollYRatio;
    protected float initialYaw;
    protected float initialPitch;
    protected float initialRoll;
    protected GF3DRotatable theOwner;

    protected GF3DRotationHandle() {
        this(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public GF3DRotationHandle(GFLocator gFLocator, float f, float f2, float f3, float f4, float f5, float f6) {
        this(gFLocator, f, f2, f3, f4, f5, f6, GFHandle.defaultDescription, GFHandle.defaultHandleExtent, GFHandle.defaultLimit, GFHandle.defaultSnapToGrid);
    }

    public GF3DRotationHandle(GFLocator gFLocator, float f, float f2, float f3, float f4, float f5, float f6, String string, Dimension dimension, boolean bl, boolean bl2) {
        super(gFLocator, string, dimension, bl, bl2);
        this.yawXRatio = f;
        this.yawYRatio = f2;
        this.pitchXRatio = f3;
        this.pitchYRatio = f4;
        this.rollXRatio = f5;
        this.rollYRatio = f6;
    }

    public GFHandle copyForOwner(GFGO gFGO) {
        return this.copyForOwnerInto(new GF3DRotationHandle(), gFGO);
    }

    protected GFHandle copyForOwnerInto(GFHandle gFHandle) {
        GF3DRotationHandle gF3DRotationHandle = (GF3DRotationHandle)gFHandle;
        super.copyForOwnerInto(gFHandle);
        gF3DRotationHandle.yawXRatio = this.yawXRatio;
        gF3DRotationHandle.yawYRatio = this.yawYRatio;
        gF3DRotationHandle.pitchXRatio = this.pitchXRatio;
        gF3DRotationHandle.pitchYRatio = this.pitchYRatio;
        gF3DRotationHandle.rollXRatio = this.rollXRatio;
        gF3DRotationHandle.rollYRatio = this.rollYRatio;
        return gFHandle;
    }

    public GF3DRotatable get3DOwner() {
        GFGO gFGO;
        if (this.theOwner == null && (gFGO = this.getOwner()) instanceof GF3DRotatable) {
            this.theOwner = (GF3DRotatable)((Object)gFGO);
        }
        return this.theOwner;
    }

    public void processMouseDown(GFDrawingMouseEvent gFDrawingMouseEvent) {
        super.processMouseDown(gFDrawingMouseEvent);
        GF3DRotatable gF3DRotatable = this.get3DOwner();
        if (gF3DRotatable != null) {
            this.getManager().hideHandles();
            this.initialYaw = gF3DRotatable.getYaw();
            this.initialPitch = gF3DRotatable.getPitch();
            this.initialRoll = gF3DRotatable.getRoll();
            gFDrawingMouseEvent.setHandled(true);
        }
    }

    public void processMouseDrag(GFDrawingMouseEvent gFDrawingMouseEvent) {
        super.processMouseDrag(gFDrawingMouseEvent);
        GF3DRotatable gF3DRotatable = this.get3DOwner();
        if (gF3DRotatable != null) {
            int n = gFDrawingMouseEvent.getViewX() - this.mouseDownEvent.getViewX();
            int n2 = gFDrawingMouseEvent.getViewY() - this.mouseDownEvent.getViewY();
            float f = this.initialYaw + (float)n * this.yawXRatio + (float)n2 * this.yawYRatio;
            float f2 = this.initialPitch + (float)n * this.pitchXRatio + (float)n2 * this.pitchYRatio;
            float f3 = this.initialRoll + (float)n * this.rollXRatio + (float)n2 * this.rollYRatio;
            gF3DRotatable.changeYawPitchRoll(f - gF3DRotatable.getYaw(), f2 - gF3DRotatable.getPitch(), f3 - gF3DRotatable.getRoll());
            gFDrawingMouseEvent.setHandled(true);
        }
    }

    protected void completed() {
        this.getManager().showHandles();
    }
}

