/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.gf.tool;

import com.objectshare.gf.base.GF2DGO;
import com.objectshare.gf.base.GFDrawingManager;
import com.objectshare.gf.base.GFGO;
import com.objectshare.gf.base.GFGraphics;
import com.objectshare.gf.base.GFHandle;
import com.objectshare.gf.base.event.GFDrawingMouseEvent;
import com.objectshare.gf.base.geometry.GF2DPoint;
import com.objectshare.gf.base.geometry.GF2DRectangle;
import com.objectshare.gf.base.geometry.GFPoint;
import com.objectshare.gf.connect.GFDisplayBoxLocator;
import com.objectshare.gf.tool.GFCreationHandle;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;

public class GF2DReshapeCreationHandle
extends GFHandle
implements GFCreationHandle {
    public static int defaultMinWidth = 10;
    public static int defaultMinHeight = 10;
    public int minWidth;
    public int minHeight;
    protected GF2DPoint anchor = new GF2DPoint(0.0f, 0.0f);
    protected Point viewAnchor = new Point(0, 0);
    protected GF2DPoint corner = new GF2DPoint(0.0f, 0.0f);
    protected Point viewCorner = new Point(0, 0);
    protected GF2DGO theOwner;

    protected GF2DReshapeCreationHandle() {
        this((GF2DGO)null);
    }

    public GF2DReshapeCreationHandle(GF2DGO gF2DGO) {
        this(gF2DGO, GFHandle.defaultDescription, GFHandle.defaultHandleExtent, GFHandle.defaultLimit, GFHandle.defaultSnapToGrid);
    }

    public GF2DReshapeCreationHandle(GF2DGO gF2DGO, String string, Dimension dimension, boolean bl, boolean bl2) {
        super(gF2DGO == null ? null : GFDisplayBoxLocator.rightBottomOf(gF2DGO), string, dimension, bl, bl2);
        this.handleColor = new Color(192, 0, 64);
        this.minWidth = defaultMinWidth;
        this.minHeight = defaultMinHeight;
    }

    public GFHandle copyForOwner(GFGO gFGO) {
        return this.copyForOwnerInto(new GF2DReshapeCreationHandle((GF2DGO)gFGO));
    }

    protected GFHandle copyForOwnerInto(GFHandle gFHandle) {
        GF2DReshapeCreationHandle gF2DReshapeCreationHandle = (GF2DReshapeCreationHandle)gFHandle;
        super.copyForOwnerInto(gFHandle);
        gF2DReshapeCreationHandle.minWidth = this.minWidth;
        gF2DReshapeCreationHandle.minHeight = this.minHeight;
        return gFHandle;
    }

    public GF2DGO get2DOwner() {
        GFGO gFGO;
        if (this.theOwner == null && (gFGO = this.getOwner()) instanceof GF2DGO) {
            this.theOwner = (GF2DGO)gFGO;
        }
        return this.theOwner;
    }

    public void basicDisplayAt(GFGraphics gFGraphics, float f, float f2) {
        Point point = gFGraphics.getWorldViewTransform().world2View(f, f2);
        int n = point.x + (this.handleExtent.width + 1) / 2;
        int n2 = point.y + (this.handleExtent.height + 1) / 2;
        Graphics graphics = gFGraphics.getGraphics();
        graphics.setColor(Color.white);
        graphics.fillRect(point.x, n2 - 1, this.handleExtent.width, 3);
        graphics.fillRect(n - 1, point.y, 3, this.handleExtent.height);
        graphics.setColor(this.handleColor);
        graphics.drawLine(point.x, n2, point.x + this.handleExtent.width, n2);
        graphics.drawLine(n, point.y, n, point.y + this.handleExtent.height);
    }

    protected void computeLocator() {
        GF2DGO gF2DGO = this.get2DOwner();
        if (gF2DGO == null) {
            return;
        }
        GFDisplayBoxLocator gFDisplayBoxLocator = this.corner.isAbove(this.anchor) ? (this.corner.isLeftOf(this.anchor) ? GFDisplayBoxLocator.leftTopOf(gF2DGO) : GFDisplayBoxLocator.rightTopOf(gF2DGO)) : (this.corner.isLeftOf(this.anchor) ? GFDisplayBoxLocator.leftBottomOf(gF2DGO) : GFDisplayBoxLocator.rightBottomOf(gF2DGO));
        this.setLocator(gFDisplayBoxLocator);
    }

    public void initializeCreationTarget(GFDrawingManager gFDrawingManager, GFDrawingMouseEvent gFDrawingMouseEvent) {
        GF2DGO gF2DGO = this.get2DOwner();
        if (gF2DGO != null) {
            GF2DPoint gF2DPoint = gFDrawingMouseEvent.getWorldLocation();
            gF2DGO.reshape(gF2DPoint.x, gF2DPoint.y, 0.0f, 0.0f);
        }
    }

    public void processMouseDown(GFDrawingMouseEvent gFDrawingMouseEvent) {
        super.processMouseDown(gFDrawingMouseEvent);
        this.anchor = gFDrawingMouseEvent.getWorldLocation();
        this.viewAnchor = gFDrawingMouseEvent.getViewLocation();
        this.corner = this.anchor;
        this.viewCorner = this.viewAnchor;
        gFDrawingMouseEvent.setHandled(true);
    }

    public void processMouseDrag(GFDrawingMouseEvent gFDrawingMouseEvent) {
        this.corner = gFDrawingMouseEvent.getWorldLocation();
        this.viewCorner = gFDrawingMouseEvent.getViewLocation();
        this.beginDamage();
        this.computeLocator();
        GF2DRectangle gF2DRectangle = new GF2DRectangle(this.anchor.leftMostAndHighest(this.corner), this.anchor.absExtent(this.corner));
        GF2DGO gF2DGO = this.get2DOwner();
        if (gF2DGO != null) {
            gF2DGO.reshape(gF2DRectangle.x, gF2DRectangle.y, gF2DRectangle.width, gF2DRectangle.height);
            gFDrawingMouseEvent.setHandled(true);
        }
        this.endDamage();
    }

    protected void completed() {
        Dimension dimension = GFPoint.absExtent(this.viewAnchor, this.viewCorner);
        if (dimension.width < this.minWidth && dimension.height < this.minHeight) {
            this.getManager().remove(this.get2DOwner());
        }
    }
}

