/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.gf.go3d;

import com.objectshare.gf.base.GF2DGraphicObject;
import com.objectshare.gf.base.GFHandle;
import com.objectshare.gf.connect.GFDisplayBoxLocator;
import com.objectshare.gf.tool.GF2DXlateHandle;

public abstract class GF3DGraphicObject
extends GF2DGraphicObject {
    protected static final float goldenRatio = (float)((1.0 + Math.sqrt(5.0)) / 2.0);
    protected float yaw;
    protected float sinYaw;
    protected float cosYaw;
    protected float pitch;
    protected float sinPitch;
    protected float cosPitch;
    protected float roll;
    protected float sinRoll;
    protected float cosRoll;

    public GF3DGraphicObject() {
        this.basicSetYaw(0.0f);
        this.basicSetPitch(0.0f);
        this.basicSetRoll(0.0f);
    }

    protected void basicSetPitch(float f) {
        this.pitch = f;
        this.sinPitch = (float)Math.sin(this.pitch);
        this.cosPitch = (float)Math.cos(this.pitch);
    }

    protected void basicSetRoll(float f) {
        this.roll = f;
        this.sinRoll = (float)Math.sin(this.roll);
        this.cosRoll = (float)Math.cos(this.roll);
    }

    protected void basicSetYaw(float f) {
        this.yaw = f;
        this.sinYaw = (float)Math.sin(this.yaw);
        this.cosYaw = (float)Math.cos(this.yaw);
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getRoll() {
        return this.roll;
    }

    public float getYaw() {
        return this.yaw;
    }

    public GFHandle defaultPositionHandle() {
        return new GF2DXlateHandle(new GFDisplayBoxLocator(this, 0.5f, 0.5f, 0.0f, 0.0f), 0.6f, 0.6f);
    }
}

