/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.gf.go.adapter;

import com.objectshare.gf.base.GF2DGO;
import com.objectshare.gf.base.geometry.GF2DDimension;
import com.objectshare.gf.base.geometry.GF2DPoint;
import com.objectshare.gf.base.geometry.GF2DRectangle;
import com.objectshare.gf.go.event.GF2DGOEvent;
import com.objectshare.gf.go.event.GF2DGOLocationListener;
import com.objectshare.gf.go.event.GF2DGOReshapingEvent;
import com.objectshare.gf.go.event.GF2DGORotatingEvent;
import com.objectshare.gf.go.event.GF2DGOTranslatingEvent;

public class GF2DGridConstraint
implements GF2DGOLocationListener {
    protected GF2DDimension gridSpacing;
    protected GF2DPoint gridOrigin;
    protected boolean constrainTranslation = true;
    protected boolean constrainReshaping = true;

    public GF2DGridConstraint(GF2DDimension gF2DDimension, GF2DPoint gF2DPoint) {
        this.setGridSpacing(gF2DDimension);
        this.setGridOrigin(gF2DPoint);
    }

    public GF2DGridConstraint(float f, float f2, float f3, float f4) {
        this(new GF2DDimension(f, f2), new GF2DPoint(f3, f4));
    }

    public GF2DGridConstraint(GF2DDimension gF2DDimension) {
        this(gF2DDimension, new GF2DPoint(0.0f, 0.0f));
    }

    public GF2DGridConstraint(float f, float f2) {
        this(new GF2DDimension(f, f2));
    }

    public GF2DDimension getGridSpacing() {
        return this.gridSpacing;
    }

    public void setGridSpacing(GF2DDimension gF2DDimension) {
        this.gridSpacing = gF2DDimension;
    }

    public void setGridSpacing(float f, float f2) {
        this.setGridSpacing(new GF2DDimension(f, f2));
    }

    public GF2DPoint getGridOrigin() {
        return this.gridOrigin;
    }

    public void setGridOrigin(GF2DPoint gF2DPoint) {
        this.gridOrigin = gF2DPoint;
    }

    public void setGridOrigin(float f, float f2) {
        this.setGridOrigin(new GF2DPoint(f, f2));
    }

    public boolean getConstrainTranslation() {
        return this.constrainTranslation;
    }

    public void setConstrainTranslation(boolean bl) {
        this.constrainTranslation = bl;
    }

    public boolean getConstrainReshaping() {
        return this.constrainReshaping;
    }

    public void setConstrainReshaping(boolean bl) {
        this.constrainReshaping = bl;
    }

    public void aboutToReshapeGO(GF2DGOReshapingEvent gF2DGOReshapingEvent) {
        if (!this.getConstrainReshaping()) {
            return;
        }
        GF2DRectangle gF2DRectangle = gF2DGOReshapingEvent.getBoundingBox();
        int n = Math.round((gF2DRectangle.left() - this.gridOrigin.x) / this.gridSpacing.width);
        int n2 = Math.round((gF2DRectangle.right() - this.gridOrigin.x) / this.gridSpacing.width);
        int n3 = Math.round((gF2DRectangle.top() - this.gridOrigin.y) / this.gridSpacing.height);
        int n4 = Math.round((gF2DRectangle.bottom() - this.gridOrigin.y) / this.gridSpacing.height);
        float f = this.gridOrigin.x + (float)n * this.gridSpacing.width;
        float f2 = this.gridOrigin.x + (float)n2 * this.gridSpacing.width;
        float f3 = this.gridOrigin.y + (float)n3 * this.gridSpacing.height;
        float f4 = this.gridOrigin.y + (float)n4 * this.gridSpacing.height;
        gF2DGOReshapingEvent.setBoundingBox(new GF2DRectangle(f, f3, f2 - f, f4 - f3));
    }

    public void goReshaped(GF2DGOEvent gF2DGOEvent) {
    }

    public void aboutToTranslateGO(GF2DGOTranslatingEvent gF2DGOTranslatingEvent) {
        if (!this.getConstrainTranslation()) {
            return;
        }
        GF2DGO gF2DGO = gF2DGOTranslatingEvent.getGraphicObject();
        GF2DRectangle gF2DRectangle = gF2DGO.displayBox();
        GF2DRectangle gF2DRectangle2 = gF2DRectangle.translateBy(gF2DGOTranslatingEvent.getTranslation());
        int n = Math.round((gF2DRectangle2.left() - this.gridOrigin.x) / this.gridSpacing.width);
        int n2 = Math.round((gF2DRectangle2.right() - this.gridOrigin.x) / this.gridSpacing.width);
        int n3 = Math.round((gF2DRectangle2.top() - this.gridOrigin.y) / this.gridSpacing.height);
        int n4 = Math.round((gF2DRectangle2.bottom() - this.gridOrigin.y) / this.gridSpacing.height);
        float f = this.gridOrigin.x + (float)n * this.gridSpacing.width;
        float f2 = this.gridOrigin.x + (float)n2 * this.gridSpacing.width;
        float f3 = this.gridOrigin.y + (float)n3 * this.gridSpacing.height;
        float f4 = this.gridOrigin.y + (float)n4 * this.gridSpacing.height;
        float f5 = f - gF2DRectangle.left();
        float f6 = f2 - gF2DRectangle.right();
        float f7 = f3 - gF2DRectangle.top();
        float f8 = f4 - gF2DRectangle.bottom();
        gF2DGOTranslatingEvent.setTranslation(Math.abs(f5) <= Math.abs(f6) ? f5 : f6, Math.abs(f7) <= Math.abs(f8) ? f7 : f8);
    }

    public void goTranslated(GF2DGOEvent gF2DGOEvent) {
    }

    public void aboutToRotateGO(GF2DGORotatingEvent gF2DGORotatingEvent) {
    }

    public void goRotated(GF2DGOEvent gF2DGOEvent) {
    }
}

