/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.gf.go;

import com.objectshare.gf.base.GF2DGO;
import com.objectshare.gf.base.GFCompositeGO;
import com.objectshare.gf.base.GFGO;
import com.objectshare.gf.base.GFGOArray;
import com.objectshare.gf.base.GFGraphicObject;
import com.objectshare.gf.base.GFGraphics;
import com.objectshare.gf.base.GFUnsortedGOArray;
import com.objectshare.gf.base.geometry.GF2DPoint;
import com.objectshare.gf.base.geometry.GF2DRectangle;
import java.awt.Color;

public class GFClippedCompositeGO
extends GFCompositeGO {
    protected boolean showVisibleArea = false;
    protected GF2DRectangle visibleArea = null;
    protected Color visibleAreaLineColor = GFGraphicObject.getDefaultLineColor();

    public GFGO copyForCreation() {
        return this.copyForCreationInto(new GFClippedCompositeGO());
    }

    protected GFGO copyForCreationInto(GFGO gFGO) {
        super.copyForCreationInto(gFGO);
        GFClippedCompositeGO gFClippedCompositeGO = (GFClippedCompositeGO)gFGO;
        gFClippedCompositeGO.visibleArea = this.visibleArea;
        gFClippedCompositeGO.showVisibleArea = this.showVisibleArea;
        gFClippedCompositeGO.visibleAreaLineColor = this.visibleAreaLineColor;
        return gFGO;
    }

    public GFGO graphicObjectContaining(GF2DPoint gF2DPoint) {
        if (this.visibleArea != null && !this.visibleArea.inside(gF2DPoint)) {
            return null;
        }
        return super.graphicObjectContaining(gF2DPoint);
    }

    public GFGOArray graphicObjectsContaining(GF2DPoint gF2DPoint) {
        if (this.visibleArea != null && !this.visibleArea.inside(gF2DPoint)) {
            return new GFUnsortedGOArray(0);
        }
        return super.graphicObjectsContaining(gF2DPoint);
    }

    public GFGOArray graphicObjectsIntersecting(GF2DRectangle gF2DRectangle) {
        GF2DRectangle gF2DRectangle2 = gF2DRectangle;
        if (this.visibleArea != null) {
            gF2DRectangle2 = gF2DRectangle2.intersection(this.visibleArea);
        }
        if (gF2DRectangle2.isEmpty()) {
            return new GFUnsortedGOArray();
        }
        return super.graphicObjectsIntersecting(gF2DRectangle2);
    }

    public GFGOArray graphicObjectsContainedBy(GF2DRectangle gF2DRectangle) {
        return super.graphicObjectsContainedBy(gF2DRectangle);
    }

    public GF2DRectangle displayBox() {
        if (this.visibleArea != null) {
            return this.visibleArea;
        }
        return super.displayBox();
    }

    public void display(GFGraphics gFGraphics) {
        GFGraphics gFGraphics2 = gFGraphics.create();
        if (this.visibleArea != null) {
            gFGraphics2.clipRect(this.visibleArea.x, this.visibleArea.y, this.visibleArea.width, this.visibleArea.height);
        }
        super.display(gFGraphics2);
        this.displayVisibleArea(gFGraphics2);
        gFGraphics2.dispose();
    }

    public void displayShape(GFGraphics gFGraphics) {
        GFGraphics gFGraphics2 = gFGraphics.create();
        if (this.visibleArea != null) {
            gFGraphics2.clipRect(this.visibleArea.x, this.visibleArea.y, this.visibleArea.width, this.visibleArea.height);
        }
        super.displayShape(gFGraphics2);
        this.displayVisibleArea(gFGraphics2);
        gFGraphics2.dispose();
    }

    protected void displayVisibleArea(GFGraphics gFGraphics) {
        if (this.isVisibleAreaShowing()) {
            gFGraphics.setColor(this.visibleAreaLineColor);
            gFGraphics.drawRect(this.visibleArea);
        }
    }

    public boolean basicReshape(float f, float f2, float f3, float f4) {
        return super.basicReshape(f, f2, f3, f4);
    }

    public boolean basicTranslate(float f, float f2) {
        if (this.visibleArea != null) {
            this.visibleArea = this.visibleArea.translateBy(f, f2);
        }
        super.basicTranslate(f, f2);
        return true;
    }

    public GF2DRectangle getVisibleArea() {
        return this.visibleArea;
    }

    public void setVisibleArea(GF2DRectangle gF2DRectangle) {
        this.visibleArea = gF2DRectangle;
    }

    public void setVisibleAreaFromGOs() {
        this.visibleArea = null;
        GF2DGO gF2DGO = this.firstGO();
        if (gF2DGO != null) {
            this.visibleArea = new GF2DRectangle(gF2DGO.displayBox());
            gF2DGO = gF2DGO.getNextGO();
            while (gF2DGO != null) {
                this.visibleArea = this.visibleArea.union(gF2DGO.displayBox());
                gF2DGO = gF2DGO.getNextGO();
            }
        }
        this.visibleArea = new GF2DRectangle(this.visibleArea.x, this.visibleArea.y, this.visibleArea.width + 1.0f, this.visibleArea.height + 1.0f);
    }

    public boolean isVisibleAreaShowing() {
        return this.visibleArea != null && this.showVisibleArea;
    }

    public void showVisibleArea() {
        this.showVisibleArea = true;
        this.damaged();
    }

    public void hideVisibleArea() {
        this.showVisibleArea = false;
        this.damaged();
    }

    public Color getVisibleAreaLineColor() {
        return this.visibleAreaLineColor;
    }

    public void setVisibleAreaLineColor(Color color) {
        this.visibleAreaLineColor = color;
    }
}

