/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.gf.example.howto.gridconstraint;

import com.objectshare.base.example.OSIExampleApplet;
import com.objectshare.base.example.OSIExampleFrame;
import com.objectshare.gf.base.GFDrawingLayer;
import com.objectshare.gf.base.GFDrawingManager;
import com.objectshare.gf.base.geometry.GF2DDimension;
import com.objectshare.gf.example.howto.HowTo;
import com.objectshare.gf.example.howto.gridconstraint.GOConstraint;
import com.objectshare.gf.go.GFGridGO;
import com.objectshare.gf.tool.GFToolCategory;
import com.objectshare.gf.tool.GFToolPalette;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Event;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;

public class GridConstraint
extends HowTo {
    protected static GF2DDimension gridSpacing = new GF2DDimension(18.0f, 36.0f);
    protected GOConstraint constraint = new GOConstraint(gridSpacing);
    protected GFGridGO gridGO;
    protected TextField xGridField;
    protected TextField yGridField;
    protected Button gridButton;
    protected Checkbox translationCheckbox;
    protected Checkbox reshapingCheckbox;

    protected void initDrawing(GFDrawingManager gFDrawingManager) {
        this.gridGO = new GFGridGO(gridSpacing);
        this.gridGO.setVerticalColor(Color.lightGray);
        this.gridGO.setHorizontalColor(Color.lightGray);
        GFDrawingLayer gFDrawingLayer = new GFDrawingLayer();
        gFDrawingLayer.add(this.gridGO);
        gFDrawingManager.getDrawing().addFirst(gFDrawingLayer);
        gFDrawingManager.getActiveLayer().addCompositeListener(this.constraint);
    }

    public void initPalette(GFToolPalette gFToolPalette) {
        gFToolPalette.addCategory(this.createSelectionTools());
        GFToolCategory gFToolCategory = this.createShapeGOTools();
        gFToolCategory.addTool(this.createLineTool());
        gFToolPalette.addCategory(gFToolCategory);
    }

    protected void initTopControls(Panel panel) {
        panel.add(new Label("Grid spacing:"));
        this.xGridField = new TextField(5);
        panel.add(this.xGridField);
        panel.add(new Label("    x"));
        this.yGridField = new TextField(5);
        panel.add(this.yGridField);
        panel.add(new Label("   "));
        this.gridButton = new Button("  Set  ");
        panel.add(this.gridButton);
    }

    protected void initBottomControls(Panel panel) {
        this.translationCheckbox = new Checkbox("Constrain Translation");
        panel.add(this.translationCheckbox);
        this.reshapingCheckbox = new Checkbox("Constrain Reshaping");
        panel.add(this.reshapingCheckbox);
    }

    protected void postInit(GFDrawingManager gFDrawingManager) {
        ((TextComponent)this.xGridField).setText(String.valueOf(GridConstraint.gridSpacing.width));
        ((TextComponent)this.yGridField).setText(String.valueOf(GridConstraint.gridSpacing.height));
        this.translationCheckbox.setState(this.constraint.getConstrainTranslation());
        this.reshapingCheckbox.setState(this.constraint.getConstrainReshaping());
    }

    protected String getHowtoPath() {
        return "../";
    }

    public static void main(String[] stringArray) {
        GridConstraint gridConstraint = new GridConstraint();
        new OSIExampleFrame((OSIExampleApplet)gridConstraint, ((Object)((Object)gridConstraint)).getClass().getName(), 550, 350);
    }

    public boolean action(Event event, Object object) {
        if (event.target == this.gridButton) {
            gridSpacing = new GF2DDimension(new Float(this.xGridField.getText()).floatValue(), new Float(this.yGridField.getText()).floatValue());
            this.constraint.setGridSpacing(gridSpacing);
            this.gridGO.setGridSpacing(gridSpacing);
            this.getManager().redraw();
            return true;
        }
        if (event.target == this.translationCheckbox) {
            this.constraint.setConstrainTranslation(this.translationCheckbox.getState());
            return true;
        }
        if (event.target == this.reshapingCheckbox) {
            this.constraint.setConstrainReshaping(this.reshapingCheckbox.getState());
            return true;
        }
        return false;
    }
}

