/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.gf.example.howto.events.toolhittesting;

import com.objectshare.gf.base.GFGO;
import com.objectshare.gf.base.GFHandle;
import com.objectshare.gf.base.event.GFDrawingMouseEvent;
import com.objectshare.gf.tool.event.GFToolMouseAdapter;
import com.objectshare.gf.tool.event.GFToolMouseEvent;
import java.awt.TextArea;

class ToolMouseAdapter
extends GFToolMouseAdapter {
    protected TextArea displayPane;

    protected void setDisplayPane(TextArea textArea) {
        this.displayPane = textArea;
    }

    protected void displayEventInfo(GFDrawingMouseEvent gFDrawingMouseEvent) {
        if (this.displayPane == null) {
            return;
        }
        switch (gFDrawingMouseEvent.getID()) {
            case 501: {
                this.displayPane.appendText("Mouse Down");
                break;
            }
            case 506: {
                this.displayPane.appendText("Mouse Drag");
                break;
            }
            case 502: {
                this.displayPane.appendText("Mouse Up");
                break;
            }
            case 500: {
                this.displayPane.appendText("Mouse Click " + gFDrawingMouseEvent.getClickCount());
                break;
            }
            case 503: {
                this.displayPane.appendText("Mouse Move");
                break;
            }
        }
        GFHandle gFHandle = gFDrawingMouseEvent.getGraphicObjectHandle();
        if (gFHandle != null) {
            this.displayPane.appendText(" in " + gFHandle.getClass().getName() + " for " + gFHandle.getOwner().getMetaObject());
        } else {
            GFGO gFGO = gFDrawingMouseEvent.getGraphicObject();
            if (gFGO != null) {
                this.displayPane.appendText(" in " + gFGO.getMetaObject());
            } else {
                this.displayPane.appendText(" in background");
            }
        }
        this.displayPane.appendText("\n");
    }

    public void toolMouseDown(GFToolMouseEvent gFToolMouseEvent) {
        this.displayEventInfo(gFToolMouseEvent.getMouseEvent());
    }

    public void toolMouseUp(GFToolMouseEvent gFToolMouseEvent) {
        this.displayEventInfo(gFToolMouseEvent.getMouseEvent());
    }

    public void toolMouseClick(GFToolMouseEvent gFToolMouseEvent) {
        this.displayEventInfo(gFToolMouseEvent.getMouseEvent());
    }

    ToolMouseAdapter() {
    }
}

