/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.gf.base.geometry;

import com.objectshare.gf.base.geometry.GF2DPoint;
import com.objectshare.gf.base.geometry.GF2DRectangle;
import com.objectshare.gf.base.geometry.GFLiangBarskyClipTestValues;
import java.awt.Point;
import java.io.Serializable;

public class GF2DVector
implements Serializable {
    public GF2DPoint p1;
    public GF2DPoint p2;

    public GF2DVector(GF2DPoint gF2DPoint, GF2DPoint gF2DPoint2) {
        this.p1 = gF2DPoint;
        this.p2 = gF2DPoint2;
    }

    public GF2DVector(Point point, Point point2) {
        this(new GF2DPoint(point), new GF2DPoint(point2));
    }

    public GF2DVector(float f, float f2, float f3, float f4) {
        this(new GF2DPoint(f, f2), new GF2DPoint(f3, f4));
    }

    public GF2DVector(GF2DVector gF2DVector) {
        this(new GF2DPoint(gF2DVector.p1), new GF2DPoint(gF2DVector.p2));
    }

    public GF2DVector translateBy(float f, float f2) {
        return new GF2DVector(this.p1.translateBy(f, f2), this.p2.translateBy(f, f2));
    }

    public GF2DVector translateBy(GF2DPoint gF2DPoint) {
        return this.translateBy(gF2DPoint.x, gF2DPoint.y);
    }

    public float projectR(GF2DPoint gF2DPoint) {
        return ((this.p1.y - gF2DPoint.y) * (this.p1.y - this.p2.y) - (this.p1.x - gF2DPoint.x) * (this.p2.x - this.p1.x)) / this.lengthSquared();
    }

    public float projectR(Point point) {
        return this.projectR(new GF2DPoint(point));
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    public float lengthSquared() {
        float f = this.p2.x - this.p1.x;
        float f2 = this.p2.y - this.p1.y;
        return f * f + f2 * f2;
    }

    public float getTheta() {
        GF2DPoint gF2DPoint = this.p2.subtract(this.p1);
        return (float)Math.atan2(gF2DPoint.y, gF2DPoint.x);
    }

    public float distanceTo(GF2DPoint gF2DPoint) {
        return Math.abs(((this.p1.y - gF2DPoint.y) * (this.p2.x - this.p1.x) - (this.p1.x - gF2DPoint.x) * (this.p2.y - this.p1.y)) / this.length());
    }

    public float distanceTo(Point point) {
        return this.distanceTo(new GF2DPoint(point));
    }

    public boolean includes(GF2DPoint gF2DPoint, float f) {
        if (this.distanceTo(gF2DPoint) > f / 2.0f) {
            return false;
        }
        float f2 = this.projectR(gF2DPoint);
        return f2 >= 0.0f && f2 <= 1.0f;
    }

    public boolean isHorizontal() {
        return this.p1.y == this.p2.y;
    }

    public boolean isVertical() {
        return this.p1.x == this.p2.x;
    }

    public GF2DPoint leftMostAndHighest() {
        return this.p1.leftMostAndHighest(this.p2);
    }

    public GF2DPoint rightMostAndLowest() {
        return this.p1.rightMostAndLowest(this.p2);
    }

    protected boolean lbClipTest(float f, float f2, GFLiangBarskyClipTestValues gFLiangBarskyClipTestValues) {
        boolean bl = true;
        if (f < 0.0f) {
            float f3 = f2 / f;
            if (f3 > gFLiangBarskyClipTestValues.u2) {
                bl = false;
            } else if (f3 > gFLiangBarskyClipTestValues.u1) {
                gFLiangBarskyClipTestValues.u1 = f3;
            }
        } else if (f > 0.0f) {
            float f4 = f2 / f;
            if (f4 < gFLiangBarskyClipTestValues.u1) {
                bl = false;
            } else if (f4 < gFLiangBarskyClipTestValues.u2) {
                gFLiangBarskyClipTestValues.u2 = f4;
            }
        } else if (f2 < 0.0f) {
            bl = false;
        }
        return bl;
    }

    public GF2DVector liangBarskyClipTo(GF2DRectangle gF2DRectangle) {
        GFLiangBarskyClipTestValues gFLiangBarskyClipTestValues = new GFLiangBarskyClipTestValues(0.0f, 1.0f);
        float f = this.p2.x - this.p1.x;
        if (!this.lbClipTest(-f, this.p1.x - gF2DRectangle.left(), gFLiangBarskyClipTestValues)) {
            return null;
        }
        if (!this.lbClipTest(f, gF2DRectangle.right() - this.p1.x, gFLiangBarskyClipTestValues)) {
            return null;
        }
        float f2 = this.p2.y - this.p1.y;
        if (!this.lbClipTest(-f2, this.p1.y - gF2DRectangle.top(), gFLiangBarskyClipTestValues)) {
            return null;
        }
        if (!this.lbClipTest(f2, gF2DRectangle.bottom() - this.p1.y, gFLiangBarskyClipTestValues)) {
            return null;
        }
        float f3 = this.p1.x;
        float f4 = this.p1.y;
        float f5 = this.p2.x;
        float f6 = this.p2.y;
        if (gFLiangBarskyClipTestValues.u2 < 1.0f) {
            f5 = f3 + gFLiangBarskyClipTestValues.u2 * f;
            f6 = f4 + gFLiangBarskyClipTestValues.u2 * f2;
        }
        if (gFLiangBarskyClipTestValues.u1 > 0.0f) {
            f3 += gFLiangBarskyClipTestValues.u1 * f;
            f4 += gFLiangBarskyClipTestValues.u1 * f2;
        }
        return new GF2DVector(f3, f4, f5, f6);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.p1 + ", " + this.p2 + "]";
    }
}

