/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.gf.base.geometry;

import com.objectshare.gf.base.geometry.GF2DDimension;
import com.objectshare.gf.base.geometry.GF2DPoint;
import com.objectshare.gf.base.geometry.GF2DVector;
import java.awt.Rectangle;
import java.io.Serializable;

public class GF2DRectangle
implements Serializable {
    public float x;
    public float y;
    public float width;
    public float height;

    public GF2DRectangle() {
    }

    public GF2DRectangle(float f, float f2, float f3, float f4) {
        this.x = f;
        this.y = f2;
        this.width = f3;
        this.height = f4;
    }

    public GF2DRectangle(GF2DRectangle gF2DRectangle) {
        this(gF2DRectangle.x, gF2DRectangle.y, gF2DRectangle.width, gF2DRectangle.height);
    }

    public GF2DRectangle(GF2DPoint gF2DPoint, GF2DDimension gF2DDimension) {
        this(gF2DPoint.x, gF2DPoint.y, gF2DDimension.width, gF2DDimension.height);
    }

    public GF2DRectangle(GF2DPoint gF2DPoint, GF2DPoint gF2DPoint2) {
        GF2DPoint gF2DPoint3 = gF2DPoint.leftMostAndHighest(gF2DPoint2);
        GF2DPoint gF2DPoint4 = gF2DPoint.rightMostAndLowest(gF2DPoint2);
        this.x = gF2DPoint3.x;
        this.y = gF2DPoint3.y;
        this.width = gF2DPoint4.x - gF2DPoint3.x;
        this.height = gF2DPoint4.y - gF2DPoint3.y;
    }

    public GF2DRectangle(Rectangle rectangle) {
        this(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public GF2DRectangle(float f, float f2) {
        this(0.0f, 0.0f, f, f2);
    }

    public GF2DRectangle(GF2DPoint gF2DPoint) {
        this(gF2DPoint.x, gF2DPoint.y, 0.0f, 0.0f);
    }

    public Rectangle asRectangle() {
        return new Rectangle(Math.round(this.x), Math.round(this.y), Math.round(this.width), Math.round(this.height));
    }

    public GF2DRectangle expandBy(float f, float f2) {
        return new GF2DRectangle(this.x - f, this.y - f2, this.width + 2.0f * f, this.height + 2.0f * f2);
    }

    public GF2DRectangle expandBy(GF2DPoint gF2DPoint) {
        return this.expandBy(gF2DPoint.x, gF2DPoint.y);
    }

    public GF2DRectangle expandBy(GF2DDimension gF2DDimension) {
        return this.expandBy(gF2DDimension.width, gF2DDimension.height);
    }

    public GF2DRectangle insetBy(float f, float f2) {
        return this.expandBy(-f, -f2);
    }

    public GF2DRectangle insetBy(GF2DPoint gF2DPoint) {
        return this.insetBy(gF2DPoint.x, gF2DPoint.y);
    }

    public GF2DRectangle insetBy(GF2DDimension gF2DDimension) {
        return this.insetBy(gF2DDimension.width, gF2DDimension.height);
    }

    public GF2DRectangle translateBy(float f, float f2) {
        return new GF2DRectangle(this.x + f, this.y + f2, this.width, this.height);
    }

    public GF2DRectangle translateBy(GF2DPoint gF2DPoint) {
        return this.translateBy(gF2DPoint.x, gF2DPoint.y);
    }

    public float bottom() {
        return this.y + this.height;
    }

    public GF2DPoint bottomCenter() {
        return new GF2DPoint(this.x + this.width / 2.0f, this.y + this.height);
    }

    public GF2DPoint center() {
        return new GF2DPoint(this.x + this.width / 2.0f, this.y + this.height / 2.0f);
    }

    public GF2DDimension extent() {
        return new GF2DDimension(this.width, this.height);
    }

    public boolean inside(float f, float f2) {
        return f >= this.x && f - this.x < this.width && f2 >= this.y && f2 - this.y < this.height;
    }

    public boolean inside(GF2DPoint gF2DPoint) {
        return this.inside(gF2DPoint.x, gF2DPoint.y);
    }

    public boolean inside(GF2DRectangle gF2DRectangle) {
        return gF2DRectangle.x >= this.x && gF2DRectangle.y >= this.y && gF2DRectangle.x + gF2DRectangle.width <= this.x + this.width && gF2DRectangle.y + gF2DRectangle.height <= this.y + this.height;
    }

    public GF2DRectangle intersection(GF2DRectangle gF2DRectangle) {
        float f = Math.max(this.x, gF2DRectangle.x);
        float f2 = Math.min(this.x + this.width, gF2DRectangle.x + gF2DRectangle.width);
        float f3 = Math.max(this.y, gF2DRectangle.y);
        float f4 = Math.min(this.y + this.height, gF2DRectangle.y + gF2DRectangle.height);
        return new GF2DRectangle(f, f3, f2 - f, f4 - f3);
    }

    public GF2DVector intersection(GF2DVector gF2DVector) {
        return gF2DVector.liangBarskyClipTo(this);
    }

    public boolean intersects(GF2DRectangle gF2DRectangle) {
        return !(gF2DRectangle.x + gF2DRectangle.width <= this.x || gF2DRectangle.y + gF2DRectangle.height <= this.y || gF2DRectangle.x >= this.x + this.width) && !(gF2DRectangle.y >= this.y + this.height);
    }

    public boolean isEmpty() {
        return this.width <= 0.0f || this.height <= 0.0f;
    }

    public float left() {
        return this.x;
    }

    public GF2DPoint leftBottom() {
        return new GF2DPoint(this.x, this.y + this.height);
    }

    public GF2DPoint leftCenter() {
        return new GF2DPoint(this.x, this.y + this.height / 2.0f);
    }

    public GF2DPoint leftTop() {
        return new GF2DPoint(this.x, this.y);
    }

    public float right() {
        return this.x + this.width;
    }

    public GF2DPoint rightBottom() {
        return new GF2DPoint(this.x + this.width, this.y + this.height);
    }

    public GF2DPoint rightCenter() {
        return new GF2DPoint(this.x + this.width, this.y + this.height / 2.0f);
    }

    public GF2DPoint rightTop() {
        return new GF2DPoint(this.x + this.width, this.y);
    }

    public float top() {
        return this.y;
    }

    public GF2DPoint topCenter() {
        return new GF2DPoint(this.x + this.width / 2.0f, this.y);
    }

    public GF2DRectangle union(GF2DRectangle gF2DRectangle) {
        float f = Math.min(this.x, gF2DRectangle.x);
        float f2 = Math.max(this.x + this.width, gF2DRectangle.x + gF2DRectangle.width);
        float f3 = Math.min(this.y, gF2DRectangle.y);
        float f4 = Math.max(this.y + this.height, gF2DRectangle.y + gF2DRectangle.height);
        return new GF2DRectangle(f, f3, f2 - f, f4 - f3);
    }

    public GF2DRectangle union(GF2DPoint gF2DPoint) {
        float f = Math.min(this.x, gF2DPoint.x);
        float f2 = Math.max(this.x + this.width, gF2DPoint.x);
        float f3 = Math.min(this.y, gF2DPoint.y);
        float f4 = Math.max(this.y + this.height, gF2DPoint.y);
        return new GF2DRectangle(f, f3, f2 - f, f4 - f3);
    }

    public int hashCode() {
        int n = new Float(this.x).hashCode();
        n = 37 * n + new Float(this.y).hashCode();
        n = 37 * n + new Float(this.width).hashCode();
        n = 37 * n + new Float(this.height).hashCode();
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        GF2DRectangle gF2DRectangle = (GF2DRectangle)object;
        return this.x == gF2DRectangle.x && this.y == gF2DRectangle.y && this.width == gF2DRectangle.width && this.height == gF2DRectangle.height;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[org=" + this.x + "," + this.y + ", ext=" + this.width + "," + this.height + "]";
    }
}

