/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.gf.base.geometry;

import com.objectshare.gf.base.geometry.GF2DPoint;
import com.objectshare.gf.base.geometry.GF2DRectangle;
import java.awt.Polygon;
import java.io.Serializable;
import java.util.Vector;

public class GF2DPolygon
implements Serializable {
    public GF2DPoint[] points;
    protected GF2DRectangle bounds;

    public GF2DPolygon(GF2DPolygon gF2DPolygon) {
        this(gF2DPolygon.points);
    }

    public GF2DPolygon(Polygon polygon) {
        this(polygon.xpoints, polygon.ypoints, polygon.npoints);
    }

    public GF2DPolygon(GF2DPoint[] gF2DPointArray) {
        this.points = gF2DPointArray;
    }

    public GF2DPolygon(GF2DPoint[] gF2DPointArray, int n) {
        this.points = new GF2DPoint[n];
        System.arraycopy(gF2DPointArray, 0, this.points, 0, n);
    }

    public GF2DPolygon(float[] fArray, float[] fArray2, int n) {
        this.points = new GF2DPoint[n];
        int n2 = 0;
        while (n2 < n) {
            this.points[n2] = new GF2DPoint(fArray[n2], fArray2[n2]);
            ++n2;
        }
    }

    public GF2DPolygon(int[] nArray, int[] nArray2, int n) {
        this.points = new GF2DPoint[n];
        int n2 = 0;
        while (n2 < n) {
            this.points[n2] = new GF2DPoint(nArray[n2], nArray2[n2]);
            ++n2;
        }
    }

    public GF2DPolygon(Vector vector) {
        GF2DPoint[] gF2DPointArray = new GF2DPoint[vector.size()];
        int n = 0;
        int n2 = 0;
        while (n2 < vector.size()) {
            Object e = vector.elementAt(n2);
            if (e instanceof GF2DPoint) {
                gF2DPointArray[n] = (GF2DPoint)e;
                ++n;
            }
            ++n2;
        }
        if (n == gF2DPointArray.length) {
            this.points = gF2DPointArray;
            return;
        }
        this.points = new GF2DPoint[n];
        System.arraycopy(gF2DPointArray, 0, this.points, 0, n);
    }

    public GF2DPolygon(GF2DPoint gF2DPoint, GF2DPoint gF2DPoint2) {
        this.points = new GF2DPoint[2];
        this.points[0] = gF2DPoint;
        this.points[1] = gF2DPoint2;
    }

    protected void calculateBounds() {
        float f = Float.MAX_VALUE;
        float f2 = Float.MAX_VALUE;
        float f3 = Float.MIN_VALUE;
        float f4 = Float.MIN_VALUE;
        int n = 0;
        while (n < this.points.length) {
            GF2DPoint gF2DPoint = this.points[n];
            float f5 = gF2DPoint.x;
            f = Math.min(f, f5);
            f3 = Math.max(f3, f5);
            float f6 = gF2DPoint.y;
            f2 = Math.min(f2, f6);
            f4 = Math.max(f4, f6);
            ++n;
        }
        this.bounds = new GF2DRectangle(f, f2, f3 - f, f4 - f2);
    }

    public GF2DRectangle getBoundingBox() {
        if (this.bounds == null) {
            this.calculateBounds();
        }
        return this.bounds;
    }

    public int getNumPoints() {
        return this.points.length;
    }

    public boolean inside(float f, float f2) {
        if (this.getBoundingBox().inside(f, f2)) {
            int n = 0;
            int n2 = 0;
            while (n2 < this.points.length) {
                float f3 = this.points[n2].x;
                float f4 = this.points[n2].y;
                int n3 = (n2 + 1) % this.points.length;
                float f5 = this.points[n3].x;
                float f6 = this.points[n3].y;
                float f7 = f5 - f3;
                float f8 = f6 - f4;
                if (f8 != 0.0f) {
                    float f9;
                    float f10 = f - f3;
                    float f11 = f2 - f4;
                    if (f4 == f2) {
                        f11 -= 1.0f;
                    }
                    if (f6 == f2) {
                        f8 += 1.0f;
                    }
                    if ((double)(f9 = f11 / f8) >= 0.0 && (double)f9 <= 1.0 && f9 * f7 > f10) {
                        ++n;
                    }
                }
                ++n2;
            }
            return n % 2 != 0;
        }
        return false;
    }

    public boolean inside(GF2DPoint gF2DPoint) {
        return this.inside(gF2DPoint.x, gF2DPoint.y);
    }

    public GF2DPolygon addPoint(GF2DPoint gF2DPoint) {
        GF2DPoint[] gF2DPointArray = new GF2DPoint[this.points.length + 1];
        System.arraycopy(this.points, 0, gF2DPointArray, 0, this.points.length);
        gF2DPointArray[this.points.length] = gF2DPoint;
        return new GF2DPolygon(gF2DPointArray);
    }

    public GF2DPolygon setPoint(int n, GF2DPoint gF2DPoint) {
        if (n >= this.points.length) {
            return this;
        }
        GF2DPoint[] gF2DPointArray = new GF2DPoint[this.points.length];
        System.arraycopy(this.points, 0, gF2DPointArray, 0, this.points.length);
        gF2DPointArray[n] = gF2DPoint;
        return new GF2DPolygon(gF2DPointArray);
    }

    public GF2DPolygon translateBy(float f, float f2) {
        GF2DPoint[] gF2DPointArray = new GF2DPoint[this.points.length];
        int n = 0;
        while (n < this.points.length) {
            gF2DPointArray[n] = this.points[n].translateBy(f, f2);
            ++n;
        }
        return new GF2DPolygon(gF2DPointArray);
    }

    public GF2DPolygon translateBy(GF2DPoint gF2DPoint) {
        return this.translateBy(gF2DPoint.x, gF2DPoint.y);
    }
}

