/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.gf.base.geometry;

import com.objectshare.gf.base.geometry.GF2DDimension;
import java.awt.Point;
import java.io.Serializable;

public class GF2DPoint
implements Serializable {
    public float x;
    public float y;

    public GF2DPoint(float f, float f2) {
        this.x = f;
        this.y = f2;
    }

    public GF2DPoint(GF2DPoint gF2DPoint) {
        this(gF2DPoint.x, gF2DPoint.y);
    }

    public GF2DPoint(Point point) {
        this(point.x, point.y);
    }

    public Point toPoint() {
        return new Point(Math.round(this.x), Math.round(this.y));
    }

    public GF2DPoint unit() {
        return this.divide(this.r());
    }

    public GF2DPoint translateBy(float f, float f2) {
        return this.add(f, f2);
    }

    public GF2DPoint translateBy(GF2DPoint gF2DPoint) {
        return this.add(gF2DPoint);
    }

    public int hashCode() {
        Float f = new Float(this.x);
        Float f2 = new Float(this.y);
        return 37 * f.hashCode() + f2.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        GF2DPoint gF2DPoint = (GF2DPoint)object;
        return this.x == gF2DPoint.x && this.y == gF2DPoint.y;
    }

    public boolean isAbove(GF2DPoint gF2DPoint) {
        return GF2DPoint.isAbove(this.y, gF2DPoint.y);
    }

    public boolean isBelow(GF2DPoint gF2DPoint) {
        return GF2DPoint.isBelow(this.y, gF2DPoint.y);
    }

    public boolean isLeftOf(GF2DPoint gF2DPoint) {
        return GF2DPoint.isLeft(this.x, gF2DPoint.x);
    }

    public boolean isRightOf(GF2DPoint gF2DPoint) {
        return GF2DPoint.isRight(this.x, gF2DPoint.x);
    }

    public GF2DPoint leftMostAndHighest(GF2DPoint gF2DPoint) {
        return new GF2DPoint(GF2DPoint.leftMost(this.x, gF2DPoint.x), GF2DPoint.highest(this.y, gF2DPoint.y));
    }

    public GF2DPoint leftMostAndLowest(GF2DPoint gF2DPoint) {
        return new GF2DPoint(GF2DPoint.leftMost(this.x, gF2DPoint.x), GF2DPoint.lowest(this.y, gF2DPoint.y));
    }

    public GF2DPoint rightMostAndHighest(GF2DPoint gF2DPoint) {
        return new GF2DPoint(GF2DPoint.rightMost(this.x, gF2DPoint.x), GF2DPoint.highest(this.y, gF2DPoint.y));
    }

    public GF2DPoint rightMostAndLowest(GF2DPoint gF2DPoint) {
        return new GF2DPoint(GF2DPoint.rightMost(this.x, gF2DPoint.x), GF2DPoint.lowest(this.y, gF2DPoint.y));
    }

    public GF2DDimension absExtent(GF2DPoint gF2DPoint) {
        return new GF2DDimension(Math.abs(this.x - gF2DPoint.x), Math.abs(this.y - gF2DPoint.y));
    }

    public static boolean isLeft(float f, float f2) {
        return f < f2;
    }

    public static boolean isRight(float f, float f2) {
        return f > f2;
    }

    public static boolean isAbove(float f, float f2) {
        return f < f2;
    }

    public static boolean isBelow(float f, float f2) {
        return f > f2;
    }

    public static float leftMost(float f, float f2) {
        return Math.min(f, f2);
    }

    public static float rightMost(float f, float f2) {
        return Math.max(f, f2);
    }

    public static float highest(float f, float f2) {
        return Math.min(f, f2);
    }

    public static float lowest(float f, float f2) {
        return Math.max(f, f2);
    }

    public GF2DPoint add(float f, float f2) {
        return new GF2DPoint(this.x + f, this.y + f2);
    }

    public GF2DPoint add(GF2DPoint gF2DPoint) {
        return this.add(gF2DPoint.x, gF2DPoint.y);
    }

    public GF2DPoint add(GF2DDimension gF2DDimension) {
        return this.add(gF2DDimension.width, gF2DDimension.height);
    }

    public GF2DPoint divide(float f, float f2) {
        return new GF2DPoint(this.x / f, this.y / f2);
    }

    public GF2DPoint divide(float f) {
        return this.divide(f, f);
    }

    public float dotProduct(GF2DPoint gF2DPoint) {
        return this.x * gF2DPoint.x + this.y * gF2DPoint.y;
    }

    public GF2DPoint multiply(float f, float f2) {
        return new GF2DPoint(this.x * f, this.y * f2);
    }

    public GF2DPoint multiply(float f) {
        return this.multiply(f, f);
    }

    public GF2DPoint subtract(float f, float f2) {
        return new GF2DPoint(this.x - f, this.y - f2);
    }

    public GF2DPoint subtract(GF2DPoint gF2DPoint) {
        return this.subtract(gF2DPoint.x, gF2DPoint.y);
    }

    public GF2DPoint subtract(GF2DDimension gF2DDimension) {
        return this.subtract(gF2DDimension.width, gF2DDimension.height);
    }

    public float r() {
        return (float)Math.sqrt(this.dotProduct(this));
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.x + "," + this.y + "]";
    }
}

