/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.gf.base.geometry;

import com.objectshare.gf.base.geometry.GF2DDimension;
import com.objectshare.gf.base.geometry.GF2DPoint;
import com.objectshare.gf.base.geometry.GF2DRectangle;
import com.objectshare.gf.base.geometry.GF2DVector;
import java.awt.Rectangle;
import java.io.Serializable;

public class GF2DEllipse
implements Serializable {
    protected GF2DPoint origin;
    protected GF2DDimension extent;

    public GF2DEllipse() {
        this(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public GF2DEllipse(float f, float f2, float f3, float f4) {
        this(new GF2DPoint(f, f2), new GF2DDimension(f3, f4));
    }

    public GF2DEllipse(GF2DRectangle gF2DRectangle) {
        this(gF2DRectangle.leftTop(), gF2DRectangle.extent());
    }

    public GF2DEllipse(Rectangle rectangle) {
        this(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public GF2DEllipse(GF2DPoint gF2DPoint, GF2DDimension gF2DDimension) {
        this.origin = gF2DPoint;
        this.extent = gF2DDimension;
    }

    public GF2DEllipse(GF2DPoint gF2DPoint, GF2DPoint gF2DPoint2) {
        this(new GF2DRectangle(gF2DPoint, gF2DPoint2));
    }

    public GF2DEllipse expandBy(float f, float f2) {
        return new GF2DEllipse(this.origin.translateBy(-f, -f2), this.extent.add(2.0f * f, 2.0f * f2));
    }

    public GF2DEllipse translateBy(float f, float f2) {
        return new GF2DEllipse(this.origin.translateBy(f, f2), this.extent);
    }

    public GF2DPoint center() {
        return this.origin.add(this.extent.divide(2.0f));
    }

    public GF2DDimension extent() {
        return this.extent;
    }

    public GF2DRectangle getBoundingBox() {
        return new GF2DRectangle(this.origin, this.extent);
    }

    public boolean inside(float f, float f2) {
        float f3 = this.extent.width / 2.0f;
        float f4 = f - (this.origin.x + f3);
        float f5 = this.extent.height / 2.0f;
        float f6 = f2 - (this.origin.y + f5);
        return f4 * f4 / (f3 * f3) + f6 * f6 / (f5 * f5) <= 1.0f;
    }

    public boolean inside(GF2DPoint gF2DPoint) {
        return this.inside(gF2DPoint.x, gF2DPoint.y);
    }

    public boolean intersects(GF2DRectangle gF2DRectangle) {
        float f;
        float f2;
        Object object;
        GF2DRectangle gF2DRectangle2 = this.getBoundingBox().intersection(gF2DRectangle);
        if (gF2DRectangle2.isEmpty()) {
            return false;
        }
        float[] fArray = new float[]{gF2DRectangle2.top(), gF2DRectangle2.bottom()};
        int n = 0;
        while (n < fArray.length) {
            object = this.horizontalChord(fArray[n]);
            if (object != null) {
                float f3 = ((GF2DVector)object).leftMostAndHighest().x;
                float f4 = ((GF2DVector)object).rightMostAndLowest().x;
                f2 = GF2DPoint.rightMost(gF2DRectangle2.left(), f3);
                if (!GF2DPoint.isRight(f2, f = GF2DPoint.leftMost(gF2DRectangle2.right(), f4))) {
                    return true;
                }
            }
            ++n;
        }
        object = new float[]{gF2DRectangle2.left(), gF2DRectangle2.right()};
        int n2 = 0;
        while (n2 < ((Object)object).length) {
            GF2DVector gF2DVector = this.verticalChord((float)object[n2]);
            if (gF2DVector != null) {
                float f5;
                f2 = gF2DVector.leftMostAndHighest().y;
                f = gF2DVector.rightMostAndLowest().y;
                float f6 = GF2DPoint.lowest(gF2DRectangle2.top(), f2);
                if (!GF2DPoint.isBelow(f6, f5 = GF2DPoint.highest(gF2DRectangle2.bottom(), f))) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    public GF2DVector verticalChord(float f) {
        float f2 = this.extent.width / 2.0f;
        float f3 = this.extent.height / 2.0f;
        float f4 = this.origin.x + f2;
        float f5 = this.origin.y + f3;
        float f6 = f - f4;
        float f7 = f6 * f6 / (f2 * f2);
        if (f7 > 1.0f) {
            return null;
        }
        float f8 = (float)Math.sqrt((1.0f - f7) * f3 * f3);
        return new GF2DVector(f, f5 + f8, f, f5 - f8);
    }

    public GF2DVector horizontalChord(float f) {
        float f2 = this.extent.width / 2.0f;
        float f3 = this.extent.height / 2.0f;
        float f4 = this.origin.x + f2;
        float f5 = this.origin.y + f3;
        float f6 = f - f5;
        float f7 = f6 * f6 / (f3 * f3);
        if (f7 > 1.0f) {
            return null;
        }
        float f8 = (float)Math.sqrt((1.0f - f7) * f2 * f2);
        return new GF2DVector(f4 + f8, f, f4 - f8, f);
    }

    public int hashCode() {
        return 37 * this.center().hashCode() + this.extent().hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        GF2DEllipse gF2DEllipse = (GF2DEllipse)object;
        return this.center().equals(gF2DEllipse.center()) && this.extent().equals(gF2DEllipse.extent());
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[ctr=" + this.center() + ", ext=" + this.extent() + "]";
    }
}

