/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.gf.base;

import com.objectshare.gf.base.GFGO;
import com.objectshare.gf.base.GFGOArray;
import com.objectshare.gf.base.geometry.GF2DRectangle;
import java.util.Vector;

public class GFUnsortedGOArray
extends GFGOArray {
    protected static int defaultCapacity = 5;
    protected GFGO[] elements;

    public GFUnsortedGOArray() {
        this(defaultCapacity);
    }

    public GFUnsortedGOArray(int n) {
        this.elements = new GFGO[n + 1];
        this.size = 0;
    }

    public GFUnsortedGOArray(GFGOArray gFGOArray) {
        this(gFGOArray.size());
        this.addAll(gFGOArray);
    }

    public GFUnsortedGOArray(GFGO[] gFGOArray) {
        this(gFGOArray, gFGOArray.length);
    }

    protected GFUnsortedGOArray(GFGO[] gFGOArray, int n) {
        this(n);
        this.addAll(gFGOArray, n);
    }

    public GFUnsortedGOArray(Vector vector) {
        this(vector.size());
        this.addAll(vector);
    }

    public GFGOArray copy() {
        return new GFUnsortedGOArray(this);
    }

    public GFGO[] elements() {
        return this.elements;
    }

    public GFGO elementAt(int n) throws ArrayIndexOutOfBoundsException {
        return this.elements[n];
    }

    public void add(GFGO gFGO) {
        if (gFGO != null) {
            this.elements[this.size++] = gFGO;
            this.checkCapacity();
        }
    }

    protected void addAll(GFGO[] gFGOArray, int n) {
        this.checkCapacity(n + 1);
        System.arraycopy(gFGOArray, 0, this.elements, this.size, n);
        this.size += n;
    }

    public void addFirst(GFGO gFGO) {
        int n = this.elements.length >= this.size + 2 ? this.elements.length : this.elements.length + 10;
        GFGO[] gFGOArray = new GFGO[n];
        System.arraycopy(this.elements, 0, gFGOArray, 1, this.size);
        gFGOArray[0] = gFGO;
        this.elements = gFGOArray;
        ++this.size;
    }

    public void addLast(GFGO gFGO) {
        this.add(gFGO);
    }

    protected void checkCapacity(int n) {
        while (this.size + n >= this.elements.length) {
            GFGO[] gFGOArray = new GFGO[this.elements.length * 2];
            System.arraycopy(this.elements, 0, gFGOArray, 0, this.elements.length);
            this.elements = gFGOArray;
        }
    }

    public GFUnsortedGOArray intersect(GF2DRectangle gF2DRectangle) {
        GFUnsortedGOArray gFUnsortedGOArray = new GFUnsortedGOArray(this.size);
        int n = 0;
        while (n < this.size) {
            if (this.elements[n].displayBox().intersects(gF2DRectangle)) {
                gFUnsortedGOArray.add(this.elements[n]);
            }
            ++n;
        }
        return gFUnsortedGOArray;
    }

    public GFGO containing(float f, float f2) {
        int n = 0;
        while (n < this.size) {
            if (this.elements[n].displayBox().inside(f, f2)) {
                return this.elements[n];
            }
            ++n;
        }
        return null;
    }
}

