/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.gf.base;

import com.objectshare.gf.base.GF2DGO;
import com.objectshare.gf.base.GF2DGraphicObject;
import com.objectshare.gf.base.GFDrawingLayer;
import com.objectshare.gf.base.GFDrawingManager;
import com.objectshare.gf.base.GFGO;
import com.objectshare.gf.base.GFGOParent;
import com.objectshare.gf.base.GFGraphics;
import com.objectshare.gf.base.event.GFDrawingEvent;
import com.objectshare.gf.base.event.GFDrawingKeyEvent;
import com.objectshare.gf.base.event.GFDrawingMouseEvent;
import com.objectshare.gf.base.event.GFDrawingXFormListener;
import com.objectshare.gf.base.geometry.GF2DDimension;
import com.objectshare.gf.base.geometry.GF2DPoint;
import com.objectshare.gf.base.geometry.GF2DRectangle;
import com.objectshare.gf.connect.GFLocator;
import com.objectshare.gf.tool.GFTool;
import com.objectshare.gf.tool.event.GFToolDelegate;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.io.IOException;
import java.io.ObjectInputStream;

public abstract class GFHandle
extends GF2DGraphicObject
implements GFToolDelegate,
GFGOParent,
GFDrawingXFormListener {
    public static Dimension defaultHandleExtent = new Dimension(6, 6);
    public static String defaultDescription = "";
    public static boolean defaultLimit = true;
    public static boolean defaultSnapToGrid = true;
    protected String description;
    protected GF2DGO displayGO;
    protected GFLocator locator;
    protected Dimension handleExtent;
    protected Color handleColor = Color.black;
    protected Dimension hitTestMargin;
    protected boolean limit;
    protected boolean snapToGrid;
    protected boolean scroll;
    protected String mementoType;
    protected transient GF2DDimension handleWorldExtent;
    protected transient GF2DDimension hitTestWorldMargin;
    protected GFTool parentTool;
    protected GFDrawingMouseEvent mouseDownEvent;
    protected boolean completing = false;

    public GFHandle(GFLocator gFLocator) {
        this(gFLocator, defaultDescription, defaultHandleExtent, defaultLimit, defaultSnapToGrid);
    }

    public GFHandle(GFLocator gFLocator, String string, Dimension dimension, boolean bl, boolean bl2) {
        this.setLocator(gFLocator);
        this.description = string;
        this.handleExtent = dimension;
        this.hitTestMargin = new Dimension(1, 1);
        this.limit = bl;
        this.snapToGrid = bl2;
    }

    public abstract GFHandle copyForOwner(GFGO var1);

    protected GFHandle copyForOwnerInto(GFHandle gFHandle, GFGO gFGO) {
        this.copyOwnerInto(gFHandle, gFGO);
        return this.copyForOwnerInto(gFHandle);
    }

    protected GFHandle copyOwnerInto(GFHandle gFHandle, GFGO gFGO) {
        if (this.getLocator() != null) {
            gFHandle.setLocator(this.getLocator().copyForTarget(gFGO));
        }
        return gFHandle;
    }

    protected GFHandle copyForOwnerInto(GFHandle gFHandle) {
        gFHandle.setDisplayGO(this.displayGO == null ? null : (GF2DGO)this.displayGO.copyForCreation());
        gFHandle.description = new String(this.description);
        gFHandle.handleExtent = new Dimension(this.handleExtent.width, this.handleExtent.height);
        gFHandle.handleColor = new Color(this.handleColor.getRGB());
        gFHandle.hitTestMargin = new Dimension(this.hitTestMargin.width, this.hitTestMargin.height);
        gFHandle.limit = this.limit;
        gFHandle.snapToGrid = this.snapToGrid;
        return gFHandle;
    }

    public GFDrawingLayer getLayerFor(GFDrawingManager gFDrawingManager) {
        return gFDrawingManager.getHandleLayer();
    }

    public void basicSetManager(GFDrawingManager gFDrawingManager) {
        if (gFDrawingManager != null) {
            gFDrawingManager.addTransformListener(this);
        } else {
            GFDrawingManager gFDrawingManager2 = this.getManager();
            if (gFDrawingManager2 != null) {
                gFDrawingManager2.removeTransformListener(this);
            }
        }
        super.basicSetManager(gFDrawingManager);
        if (this.displayGO != null) {
            this.displayGO.basicSetManager(gFDrawingManager);
        }
    }

    public void basicSetAllManagerAttributes(GFDrawingManager gFDrawingManager) {
        super.basicSetAllManagerAttributes(gFDrawingManager);
        if (this.displayGO != null) {
            this.displayGO.basicSetAllManagerAttributes(gFDrawingManager);
        }
    }

    public GFGO getOwner() {
        if (this.getLocator() == null) {
            return null;
        }
        return this.getLocator().getTarget();
    }

    public GFLocator getLocator() {
        return this.locator;
    }

    public void setLocator(GFLocator gFLocator) {
        this.locator = gFLocator;
    }

    public void drawingTransformChanged(GFDrawingEvent gFDrawingEvent) {
        this.handleWorldExtent = null;
        this.hitTestWorldMargin = null;
    }

    public boolean containsPoint(GF2DPoint gF2DPoint) {
        GF2DRectangle gF2DRectangle = this.displayBox();
        GF2DDimension gF2DDimension = this.getHitTestMargin();
        return gF2DRectangle.expandBy(gF2DDimension.width, gF2DDimension.height).inside(gF2DPoint);
    }

    public GF2DRectangle displayBox() {
        GF2DDimension gF2DDimension = this.displayExtent();
        GF2DPoint gF2DPoint = this.getLocator().toPoint().translateBy(-(gF2DDimension.width / 2.0f), -(gF2DDimension.height / 2.0f));
        return new GF2DRectangle(gF2DPoint, gF2DDimension);
    }

    public GF2DDimension displayExtent() {
        if (this.displayGO == null) {
            if (this.handleWorldExtent == null) {
                this.handleWorldExtent = this.getWorldViewTransform().view2World(this.handleExtent);
            }
            return this.handleWorldExtent;
        }
        return this.displayGO.displayExtent();
    }

    protected GF2DDimension getHitTestMargin() {
        if (this.hitTestWorldMargin == null) {
            this.hitTestWorldMargin = this.getWorldViewTransform().view2World(this.hitTestMargin);
        }
        return this.hitTestWorldMargin;
    }

    public void display(GFGraphics gFGraphics) {
        GF2DPoint gF2DPoint = this.displayLeftTop();
        this.displayAt(gFGraphics, gF2DPoint.x, gF2DPoint.y);
    }

    protected void basicDisplayAt(GFGraphics gFGraphics, float f, float f2) {
        Point point = gFGraphics.getWorldViewTransform().world2View(f, f2);
        Graphics graphics = gFGraphics.getGraphics();
        graphics.setColor(Color.white);
        graphics.drawRect(point.x, point.y, this.handleExtent.width - 1, this.handleExtent.height - 1);
        graphics.setColor(this.handleColor);
        graphics.fillRect(point.x + 1, point.y + 1, this.handleExtent.width - 2, this.handleExtent.height - 2);
    }

    public void displayAt(GFGraphics gFGraphics, float f, float f2) {
        if (this.displayGO != null) {
            GF2DPoint gF2DPoint = this.displayGO.displayLeftTop();
            this.displayGO.basicTranslate(f - gF2DPoint.x, f2 - gF2DPoint.y);
            this.displayGO.display(gFGraphics);
            return;
        }
        this.basicDisplayAt(gFGraphics, f, f2);
    }

    public void displayShape(GFGraphics gFGraphics) {
        gFGraphics.setColor(Color.black);
        gFGraphics.fillRect(this.displayBox());
    }

    public GF2DGO getDisplayGO() {
        return this.displayGO;
    }

    public void setDisplayGO(GF2DGO gF2DGO) {
        if (this.displayGO != null) {
            this.displayGO.basicSetParent(null);
        }
        this.displayGO = gF2DGO;
        if (this.displayGO != null) {
            this.displayGO.basicSetParent(this);
        }
    }

    public boolean basicRemove(GFGO gFGO) {
        if (gFGO != null && gFGO == this.displayGO) {
            this.setDisplayGO(null);
            return true;
        }
        return false;
    }

    public void beginDelegationFor(GFTool gFTool) {
        this.parentTool = gFTool;
    }

    public void endDelegationFor(GFTool gFTool) {
        this.parentTool = null;
    }

    protected void undelegate() {
        if (this.parentTool != null) {
            this.parentTool.removeDelegate(this);
        }
    }

    public void activated(GFDrawingManager gFDrawingManager) {
    }

    public void deactivated(GFDrawingManager gFDrawingManager) {
        this.complete();
    }

    public void complete() {
        if (this.completing) {
            return;
        }
        this.completing = true;
        this.completed();
        this.undelegate();
        this.completing = false;
    }

    protected void completed() {
    }

    public void processMouseDown(GFDrawingMouseEvent gFDrawingMouseEvent) {
        this.mouseDownEvent = gFDrawingMouseEvent;
    }

    public void processMouseDrag(GFDrawingMouseEvent gFDrawingMouseEvent) {
    }

    public void processMouseUp(GFDrawingMouseEvent gFDrawingMouseEvent) {
        this.processMouseDrag(gFDrawingMouseEvent);
        this.complete();
        gFDrawingMouseEvent.setHandled(true);
    }

    public void processMouseClick(GFDrawingMouseEvent gFDrawingMouseEvent) {
    }

    public void processMouseMove(GFDrawingMouseEvent gFDrawingMouseEvent) {
    }

    public void processMouseEnter(GFDrawingMouseEvent gFDrawingMouseEvent) {
    }

    public void processMouseExit(GFDrawingMouseEvent gFDrawingMouseEvent) {
    }

    public void processKeyTyped(GFDrawingKeyEvent gFDrawingKeyEvent) {
    }

    public void processKeyDown(GFDrawingKeyEvent gFDrawingKeyEvent) {
    }

    public void processKeyUp(GFDrawingKeyEvent gFDrawingKeyEvent) {
    }

    protected GFDrawingMouseEvent snapToGridAndLimitMouseDown(GFDrawingManager gFDrawingManager, GFDrawingMouseEvent gFDrawingMouseEvent) {
        this.mouseDownEvent = this.snapToGridAndLimitMouse(gFDrawingManager, gFDrawingMouseEvent);
        return this.mouseDownEvent;
    }

    protected GFDrawingMouseEvent snapToGridAndLimitMouse(GFDrawingManager gFDrawingManager, GFDrawingMouseEvent gFDrawingMouseEvent) {
        return gFDrawingManager.snapToGridAndLimit(gFDrawingMouseEvent, this.snapToGrid, this.limit);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.displayGO != null) {
            this.displayGO.basicSetParentAttribute(this);
        }
    }
}

