/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.gf.base;

import com.objectshare.base.event.OSIEventMulticaster;
import com.objectshare.gf.base.GF2DGO;
import com.objectshare.gf.base.GF2DGraphicObject;
import com.objectshare.gf.base.GFDrawingManager;
import com.objectshare.gf.base.GFGO;
import com.objectshare.gf.base.GFGOArray;
import com.objectshare.gf.base.GFGOContainer;
import com.objectshare.gf.base.GFGOLinkedList;
import com.objectshare.gf.base.GFGOList;
import com.objectshare.gf.base.GFGraphics;
import com.objectshare.gf.base.GFHandle;
import com.objectshare.gf.base.GFUnsortedGOArray;
import com.objectshare.gf.base.geometry.GF2DPoint;
import com.objectshare.gf.base.geometry.GF2DRectangle;
import com.objectshare.gf.go.event.GFCompositeGOChildEvent;
import com.objectshare.gf.go.event.GFCompositeGOListener;
import com.objectshare.gf.go.event.GFGOEventMulticaster;
import com.objectshare.gf.tool.GF2DXlateCreationHandle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Vector;

public class GFCompositeGO
extends GF2DGraphicObject
implements GFGOContainer {
    protected GFGOList graphicObjects;
    protected boolean grouped;
    protected transient GFCompositeGOListener compositeListener;
    protected static final String compositeGOListenerK = "compositeGOL";

    public GFCompositeGO() {
        this.initializeGOList();
        this.grouped = false;
    }

    public GFCompositeGO(GFGOArray gFGOArray) {
        this();
        this.addAll(gFGOArray);
    }

    protected void initializeGOList() {
        this.graphicObjects = new GFGOLinkedList(this);
    }

    public GFGO copyForCreation() {
        return this.copyForCreationInto(new GFCompositeGO());
    }

    protected GFGO copyForCreationInto(GFGO gFGO) {
        super.copyForCreationInto(gFGO);
        GFCompositeGO gFCompositeGO = (GFCompositeGO)gFGO;
        GF2DGO gF2DGO = this.firstGO();
        while (gF2DGO != null) {
            gFCompositeGO.add(gF2DGO.copyForCreation());
            gF2DGO = gF2DGO.getNextGO();
        }
        gFCompositeGO.grouped = this.grouped;
        return gFGO;
    }

    public GFGOArray getContents() {
        return this.graphicObjects.toArray();
    }

    public Enumeration contentElements() {
        return this.graphicObjects.elements();
    }

    public boolean includes(GFGO gFGO) {
        if (this == gFGO) {
            return true;
        }
        GF2DGO gF2DGO = this.firstGO();
        while (gF2DGO != null) {
            if (gF2DGO.includes(gFGO)) {
                return true;
            }
            gF2DGO = gF2DGO.getNextGO();
        }
        return false;
    }

    public boolean isContainerFor(GFGO gFGO) {
        return gFGO.getContainer() == this;
    }

    public GF2DGO firstGO() {
        return this.graphicObjects.firstGO();
    }

    public GF2DGO lastGO() {
        return this.graphicObjects.lastGO();
    }

    public void add(GFGO gFGO) {
        this.addLast(gFGO);
    }

    public void addAll(GFGOArray gFGOArray) {
        this.addAllLast(gFGOArray);
    }

    public void addAll(Vector vector) {
        this.addAllLast(vector);
    }

    public void addAll(Object[] objectArray) {
        this.addAllLast(objectArray);
    }

    public void addAll(Object[] objectArray, int n) {
        this.addAllLast(objectArray, n);
    }

    public void addFirst(GFGO gFGO) {
        if (gFGO instanceof GF2DGO) {
            if (!this.triggerAboutToAddGOEvent(gFGO)) {
                return;
            }
            GF2DGO gF2DGO = (GF2DGO)gFGO;
            this.graphicObjects.addFirst(gF2DGO);
            this.triggerGOAddedEvent(gF2DGO);
            gF2DGO.damaged();
        }
    }

    public void addAllFirst(GFGOArray gFGOArray) {
        GFGO[] gFGOArray2 = gFGOArray.elements();
        int n = gFGOArray.size() - 1;
        while (n >= 0) {
            this.addFirst(gFGOArray2[n]);
            --n;
        }
    }

    public void addAllFirst(Vector vector) {
        int n = vector.size() - 1;
        while (n >= 0) {
            Object e = vector.elementAt(n);
            if (e instanceof GFGO) {
                this.addFirst((GFGO)e);
            }
            --n;
        }
    }

    public void addAllFirst(Object[] objectArray) {
        this.addAllFirst(objectArray, objectArray.length);
    }

    public void addAllFirst(Object[] objectArray, int n) {
        int n2 = n - 1;
        while (n2 >= 0) {
            Object object = objectArray[n2];
            if (object instanceof GFGO) {
                this.addFirst((GFGO)object);
            }
            --n2;
        }
    }

    public void addLast(GFGO gFGO) {
        if (gFGO instanceof GF2DGO) {
            if (!this.triggerAboutToAddGOEvent(gFGO)) {
                return;
            }
            GF2DGO gF2DGO = (GF2DGO)gFGO;
            this.graphicObjects.addLast(gF2DGO);
            this.triggerGOAddedEvent(gF2DGO);
            gF2DGO.damaged();
        }
    }

    public void addAllLast(GFGOArray gFGOArray) {
        int n = gFGOArray.size();
        GFGO[] gFGOArray2 = gFGOArray.elements();
        int n2 = 0;
        while (n2 < n) {
            this.addLast(gFGOArray2[n2]);
            ++n2;
        }
    }

    public void addAllLast(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            Object e = vector.elementAt(n);
            if (e instanceof GFGO) {
                this.addLast((GFGO)e);
            }
            ++n;
        }
    }

    public void addAllLast(Object[] objectArray) {
        this.addAllLast(objectArray, objectArray.length);
    }

    public void addAllLast(Object[] objectArray, int n) {
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof GFGO) {
                this.addLast((GFGO)object);
            }
            ++n2;
        }
    }

    public void addBefore(GFGO gFGO, GFGO gFGO2) {
        if (gFGO instanceof GF2DGO && (gFGO2 == null || gFGO2 instanceof GF2DGO)) {
            if (!this.triggerAboutToAddGOEvent(gFGO)) {
                return;
            }
            this.graphicObjects.addBefore((GF2DGO)gFGO, (GF2DGO)gFGO2);
            this.triggerGOAddedEvent(gFGO);
            gFGO.damaged();
        }
    }

    public void addAfter(GFGO gFGO, GFGO gFGO2) {
        if (gFGO instanceof GF2DGO && (gFGO2 == null || gFGO2 instanceof GF2DGO)) {
            if (!this.triggerAboutToAddGOEvent(gFGO)) {
                return;
            }
            this.graphicObjects.addAfter((GF2DGO)gFGO, (GF2DGO)gFGO2);
            this.triggerGOAddedEvent(gFGO);
            gFGO.damaged();
        }
    }

    public boolean basicRemove(GFGO gFGO) {
        if (gFGO instanceof GF2DGO) {
            GF2DGO gF2DGO = (GF2DGO)gFGO;
            boolean bl = this.graphicObjects.remove(gF2DGO);
            if (bl) {
                this.triggerGORemovedEvent(gFGO);
            }
            return bl;
        }
        return false;
    }

    public boolean remove(GFGO gFGO) {
        if (gFGO instanceof GF2DGO) {
            GF2DGO gF2DGO = (GF2DGO)gFGO;
            if (this.isContainerFor(gF2DGO) && this.triggerAboutToRemoveGOEvent(gFGO)) {
                this.disableRedraw();
                gF2DGO.unselect();
                gF2DGO.damagedWithoutEvent();
                gF2DGO.disconnectAllConnectors();
                this.basicRemove(gF2DGO);
                this.enableRedraw();
                return true;
            }
            return false;
        }
        return false;
    }

    public void removeAll() {
        this.removeAll(this.getContents());
    }

    public void removeAll(GFGOArray gFGOArray) {
        this.disableRedraw();
        int n = gFGOArray.size();
        GFGO[] gFGOArray2 = gFGOArray.elements();
        int n2 = 0;
        while (n2 < n) {
            this.remove(gFGOArray2[n2]);
            ++n2;
        }
        this.enableRedraw();
    }

    public void removeAll(Vector vector) {
        this.disableRedraw();
        int n = 0;
        while (n < vector.size()) {
            Object e = vector.elementAt(n);
            if (e instanceof GFGO) {
                this.remove((GFGO)e);
            }
            ++n;
        }
        this.enableRedraw();
    }

    public void removeAll(Object[] objectArray) {
        this.removeAll(objectArray, objectArray.length);
    }

    public void removeAll(Object[] objectArray, int n) {
        this.disableRedraw();
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof GFGO) {
                this.remove((GFGO)object);
            }
            ++n2;
        }
        this.enableRedraw();
    }

    public void basicSetManager(GFDrawingManager gFDrawingManager) {
        super.basicSetManager(gFDrawingManager);
        GF2DGO gF2DGO = this.firstGO();
        while (gF2DGO != null) {
            gF2DGO.basicSetManager(gFDrawingManager);
            gF2DGO = gF2DGO.getNextGO();
        }
    }

    public void basicSetAllManagerAttributes(GFDrawingManager gFDrawingManager) {
        super.basicSetAllManagerAttributes(gFDrawingManager);
        Enumeration enumeration = this.contentElements();
        while (enumeration.hasMoreElements()) {
            GFGO gFGO = (GFGO)enumeration.nextElement();
            gFGO.basicSetAllManagerAttributes(gFDrawingManager);
        }
    }

    public void bringToFront(GF2DGO gF2DGO) {
        if (this.isContainerFor(gF2DGO) && !gF2DGO.isLast()) {
            this.addLast(gF2DGO);
        }
    }

    public void sendToBack(GF2DGO gF2DGO) {
        if (this.isContainerFor(gF2DGO) && !gF2DGO.isFirst()) {
            this.addFirst(gF2DGO);
        }
    }

    public void ungroup() {
        GFGOContainer gFGOContainer = this.getContainer();
        if (gFGOContainer != null) {
            GF2DGO gF2DGO = this.nextGO;
            GFGOArray gFGOArray = this.getContents();
            int n = gFGOArray.size();
            GFGO[] gFGOArray2 = gFGOArray.elements();
            gFGOContainer.remove(this);
            int n2 = 0;
            while (n2 < n) {
                gFGOContainer.addBefore(gFGOArray2[n2], gF2DGO);
                ++n2;
            }
        }
    }

    public boolean getGroupMode() {
        return this.grouped;
    }

    public void setGroupMode(boolean bl) {
        this.grouped = bl;
    }

    public boolean containsPoint(GF2DPoint gF2DPoint) {
        return this.graphicObjectContaining(gF2DPoint) != null;
    }

    public GFGO graphicObjectContaining(GF2DPoint gF2DPoint) {
        GFGO gFGO = this.graphicObjects.elementContaining(gF2DPoint);
        if (this.getGroupMode()) {
            if (gFGO == null) {
                return null;
            }
            return this;
        }
        return gFGO;
    }

    public GFGOArray graphicObjectsContaining(GF2DPoint gF2DPoint) {
        GFGOArray gFGOArray = this.graphicObjects.elementsContaining(gF2DPoint);
        if (this.getGroupMode()) {
            GFUnsortedGOArray gFUnsortedGOArray = new GFUnsortedGOArray();
            if (gFGOArray.size() > 0) {
                gFUnsortedGOArray.add(this);
            }
            return gFUnsortedGOArray;
        }
        return gFGOArray;
    }

    public boolean intersects(GF2DRectangle gF2DRectangle) {
        return this.graphicObjectsIntersecting(gF2DRectangle).size() > 0;
    }

    public GFGOArray graphicObjectsIntersecting(GF2DRectangle gF2DRectangle) {
        GFGOArray gFGOArray = this.graphicObjects.elementsIntersecting(gF2DRectangle);
        if (this.getGroupMode()) {
            GFUnsortedGOArray gFUnsortedGOArray = new GFUnsortedGOArray();
            if (gFGOArray.size() > 0) {
                gFUnsortedGOArray.add(this);
            }
            return gFUnsortedGOArray;
        }
        return gFGOArray;
    }

    public GFGOArray graphicObjectsContainedBy(GF2DRectangle gF2DRectangle) {
        return this.graphicObjects.elementsContainedBy(gF2DRectangle);
    }

    public GF2DRectangle displayBox() {
        GF2DGO gF2DGO = this.firstGO();
        if (gF2DGO == null) {
            return new GF2DRectangle(0.0f, 0.0f, 0.0f, 0.0f);
        }
        GF2DRectangle gF2DRectangle = gF2DGO.displayBox();
        gF2DGO = gF2DGO.getNextGO();
        while (gF2DGO != null) {
            gF2DRectangle = gF2DRectangle.union(gF2DGO.displayBox());
            gF2DGO = gF2DGO.getNextGO();
        }
        return gF2DRectangle;
    }

    public void display(GFGraphics gFGraphics) {
        GFGOArray gFGOArray = this.graphicObjects.elementsIntersectingDisplay(gFGraphics.getClipRect());
        GFGO[] gFGOArray2 = gFGOArray.elements();
        int n = gFGOArray.size();
        int n2 = 0;
        while (n2 < n) {
            gFGOArray2[n2].display(gFGraphics);
            ++n2;
        }
    }

    public void displayShape(GFGraphics gFGraphics) {
        GF2DGO gF2DGO = this.firstGO();
        while (gF2DGO != null) {
            gF2DGO.displayShape(gFGraphics);
            gF2DGO = gF2DGO.getNextGO();
        }
    }

    public boolean basicTranslate(float f, float f2) {
        if (f != 0.0f || f2 != 0.0f) {
            GF2DGO gF2DGO = this.firstGO();
            while (gF2DGO != null) {
                gF2DGO.translate(f, f2);
                gF2DGO = gF2DGO.getNextGO();
            }
        }
        return true;
    }

    public GFHandle defaultCreationHandle() {
        return new GF2DXlateCreationHandle(this);
    }

    public void releaseAllResources() {
        this.graphicObjects.releaseElementResources();
        super.releaseAllResources();
    }

    public void addCompositeListener(GFCompositeGOListener gFCompositeGOListener) {
        this.compositeListener = GFGOEventMulticaster.add(this.compositeListener, gFCompositeGOListener);
    }

    public void removeCompositeListener(GFCompositeGOListener gFCompositeGOListener) {
        this.compositeListener = GFGOEventMulticaster.remove(this.compositeListener, gFCompositeGOListener);
    }

    protected boolean triggerAboutToAddGOEvent(GFGO gFGO) {
        GFCompositeGOListener gFCompositeGOListener = this.compositeListener;
        if (gFCompositeGOListener != null) {
            GFCompositeGOChildEvent gFCompositeGOChildEvent = new GFCompositeGOChildEvent(this, gFGO);
            gFCompositeGOListener.aboutToAddGO(gFCompositeGOChildEvent);
            return !gFCompositeGOChildEvent.isVetoed();
        }
        return true;
    }

    protected void triggerGOAddedEvent(GFGO gFGO) {
        GFCompositeGOListener gFCompositeGOListener = this.compositeListener;
        if (gFCompositeGOListener != null) {
            gFCompositeGOListener.goAdded(new GFCompositeGOChildEvent(this, gFGO));
        }
    }

    protected boolean triggerAboutToRemoveGOEvent(GFGO gFGO) {
        GFCompositeGOListener gFCompositeGOListener = this.compositeListener;
        if (gFCompositeGOListener != null) {
            GFCompositeGOChildEvent gFCompositeGOChildEvent = new GFCompositeGOChildEvent(this, gFGO);
            gFCompositeGOListener.aboutToRemoveGO(gFCompositeGOChildEvent);
            return !gFCompositeGOChildEvent.isVetoed();
        }
        return true;
    }

    protected void triggerGORemovedEvent(GFGO gFGO) {
        GFCompositeGOListener gFCompositeGOListener = this.compositeListener;
        if (gFCompositeGOListener != null) {
            gFCompositeGOListener.goRemoved(new GFCompositeGOChildEvent(this, gFGO));
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Enumeration enumeration = this.contentElements();
        while (enumeration.hasMoreElements()) {
            GFGO gFGO = (GFGO)enumeration.nextElement();
            gFGO.basicSetParentAttribute(this);
        }
    }

    protected void writeEventListeners(ObjectOutputStream objectOutputStream) throws IOException {
        super.writeEventListeners(objectOutputStream);
        OSIEventMulticaster.save((ObjectOutputStream)objectOutputStream, (String)compositeGOListenerK, (EventListener)this.compositeListener);
    }

    protected boolean registerEventListener(String string, Object object) throws IOException {
        if (super.registerEventListener(string, object)) {
            return true;
        }
        if (string == compositeGOListenerK) {
            this.addCompositeListener((GFCompositeGOListener)object);
            return true;
        }
        return false;
    }
}

