/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.base.util;

import com.objectshare.base.util.OSIEnumeration;
import com.objectshare.base.util.OSIIntDictionary;
import com.objectshare.base.util.OSIIntEnumeration;
import com.objectshare.base.util.OSIIntHashtableKeyEnum;
import com.objectshare.base.util.OSIIntHashtableKeysOfEnum;
import com.objectshare.base.util.OSIIntVector;
import java.io.Serializable;
import java.util.NoSuchElementException;

public class OSIIntHashtable
extends OSIIntDictionary
implements Cloneable,
Serializable {
    protected int elementStart;
    protected Object[] elementArray;
    protected int elementCount;
    public static int defaultInitialCapicity = 2;

    public OSIIntHashtable() {
        this(defaultInitialCapicity);
    }

    public OSIIntHashtable(int n) {
        this.elementStart = 0;
        this.elementArray = new Object[n];
        this.elementCount = 0;
    }

    public OSIIntHashtable(int n, Object[] objectArray) {
        this.elementStart = n;
        this.elementArray = new Object[objectArray.length];
        System.arraycopy(objectArray, 0, this.elementArray, 0, objectArray.length);
        this.elementCount = n + objectArray.length - 1;
    }

    public synchronized Object clone() {
        return new OSIIntHashtable(this.elementStart, this.elementArray);
    }

    public synchronized int size() {
        return this.elementCount;
    }

    public boolean isEmpty() {
        int n = this.elementArray.length;
        while (--n >= 0) {
            if (this.elementArray[n] == null) continue;
            return false;
        }
        return true;
    }

    public int getLowestKey() {
        int n = 0;
        while (n < this.elementArray.length) {
            if (this.elementArray[n] != null) {
                return this.elementStart + n;
            }
            ++n;
        }
        return 1;
    }

    public int getHighestKey() {
        int n = this.elementArray.length;
        while (--n >= 0) {
            if (this.elementArray[n] == null) continue;
            return this.elementStart + n;
        }
        return 0;
    }

    public synchronized OSIIntEnumeration keys() {
        return new OSIIntHashtableKeyEnum(this, true);
    }

    public synchronized OSIEnumeration elements() {
        return OSIEnumeration.newNonNullFor(OSIEnumeration.copyArray(this.elementArray));
    }

    public synchronized boolean contains(Object object) {
        OSIIntHashtableKeysOfEnum oSIIntHashtableKeysOfEnum = new OSIIntHashtableKeysOfEnum(this, object, false);
        return ((OSIIntEnumeration)oSIIntHashtableKeysOfEnum).hasMoreElements();
    }

    public boolean containsKey(int n) {
        return this.get(n) != null;
    }

    public synchronized int getKey(Object object) throws NoSuchElementException {
        return new OSIIntHashtableKeysOfEnum(this, object, false).nextElement();
    }

    public synchronized OSIIntEnumeration getKeys(Object object) {
        return new OSIIntHashtableKeysOfEnum(this, object, true);
    }

    public synchronized OSIIntEnumeration getKeys(Object[] objectArray) throws NoSuchElementException {
        int n = objectArray.length;
        int[] nArray = new int[n];
        while (--n >= 0) {
            nArray[n] = this.getKey(objectArray[n]);
        }
        return OSIIntEnumeration.newFor(nArray);
    }

    public synchronized Object get(int n) {
        int n2 = n - this.elementStart;
        if (n2 >= 0 && n2 < this.elementArray.length) {
            return this.elementArray[n2];
        }
        return null;
    }

    public synchronized Object[] getArray(int n, int n2) {
        int n3;
        if (n2 < 1) {
            return new Object[0];
        }
        Object[] objectArray = new Object[n2];
        int n4 = n > this.elementStart ? n : this.elementStart;
        int n5 = n3 = n + n2 < this.elementStart + this.elementArray.length ? n + n2 : this.elementStart + this.elementArray.length;
        if (n4 < n3) {
            System.arraycopy(this.elementArray, n4 - this.elementStart, objectArray, n4 - n, n3 - n4);
        }
        return objectArray;
    }

    public synchronized Object put(int n, Object object) {
        this.grow(n);
        Object object2 = this.get(n);
        int n2 = n - this.elementStart;
        this.elementArray[n2] = object;
        this.triggerChanged(n, 1, object2);
        return object2;
    }

    public synchronized void putAll(int n, Object[] objectArray) {
        Object[] objectArray2 = this.getArray(n, objectArray.length);
        this.internalPutAll(n, objectArray);
        this.triggerChanged(n, objectArray.length, objectArray2);
    }

    public synchronized void insertAll(int n, Object[] objectArray) {
        if (objectArray != null && objectArray.length > 0) {
            this.internalCopy(n, n + objectArray.length, this.elementStart + this.elementArray.length - n);
            this.internalPutAll(n, objectArray);
            if (n <= this.elementCount + 1) {
                this.elementCount += objectArray.length;
            }
            this.triggerKeysAdded(n, objectArray.length);
        }
    }

    public synchronized void reorder(int n, Object[] objectArray) {
        this.reorderKeys(n, this.getKeys(objectArray).toVector());
    }

    public synchronized void reorderKeys(int n, OSIIntVector oSIIntVector) {
        if (oSIIntVector.size() == 0) {
            return;
        }
        int n2 = oSIIntVector.remap(n);
        int[] nArray = oSIIntVector.toArray();
        Object[] objectArray = new Object[nArray.length];
        int n3 = 0;
        while (n3 < nArray.length) {
            objectArray[n3] = this.get(nArray[n3]);
            ++n3;
        }
        this.internalPutAll(n2, objectArray);
        this.triggerKeysReordered(n2, oSIIntVector);
    }

    public synchronized Object removeKey(int n) {
        Object object = null;
        int n2 = n - this.elementStart;
        if (n2 < 0) {
            --this.elementStart;
        } else if (n2 < this.elementArray.length) {
            object = this.elementArray[n2];
            System.arraycopy(this.elementArray, n2 + 1, this.elementArray, n2, this.elementArray.length - n2 - 1);
            this.elementArray[this.elementArray.length - 1] = null;
        }
        if (n <= this.elementCount && this.elementCount > 0) {
            --this.elementCount;
        }
        this.triggerKeysRemoved(n, object);
        return object;
    }

    public synchronized Object[] removeKeys(int n, int n2) {
        Object[] objectArray = this.getArray(n, n2);
        if (n2 > 0) {
            if (n + n2 <= this.elementStart) {
                this.elementStart -= n2;
            } else if (n < this.elementStart + this.elementArray.length) {
                this.grow(n);
                int n3 = n - this.elementStart;
                int n4 = this.elementStart + this.elementArray.length - (n + n2);
                if (n4 > 0) {
                    System.arraycopy(this.elementArray, n3 + n2, this.elementArray, n3, n4);
                    n3 += n4;
                }
                while (n3 < this.elementArray.length) {
                    this.elementArray[n3++] = null;
                }
            }
            if (n <= this.elementCount) {
                this.elementCount = n + n2 <= this.elementCount ? (this.elementCount -= n2) : n - 1;
                if (this.elementCount < 0) {
                    this.elementCount = 0;
                }
            }
            this.triggerKeysRemoved(n, objectArray);
        }
        return objectArray;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    public synchronized void removeAll(Object[] objectArray) {
        if (objectArray.length == 0) {
            return;
        }
        Object object = objectArray[0];
        int n = 0;
        while (n < this.elementArray.length) {
            block12: {
                block10: {
                    boolean bl;
                    block11: {
                        block9: {
                            if (object != null) break block9;
                            if (this.elementArray[n] == null) break block10;
                            bl = false;
                            break block11;
                        }
                        bl = object.equals(this.elementArray[n]);
                    }
                    if (!bl) break block12;
                }
                int n2 = n;
                boolean bl = true;
                while (true) {
                    boolean bl2;
                    if (!bl || (bl = false) || !true) {
                        if (++n2 - n == objectArray.length) {
                            this.removeKeys(this.elementStart + n, objectArray.length);
                            return;
                        }
                        if (n2 == this.elementArray.length) break;
                    }
                    if (objectArray[n2 - n] == null) {
                        if (this.elementArray[n2] == null) continue;
                        bl2 = false;
                    } else {
                        bl2 = objectArray[n2 - n].equals(this.elementArray[n2]);
                    }
                    if (!bl2) break;
                }
            }
            ++n;
        }
        super.removeAll(objectArray);
    }

    public synchronized void grow(int n) {
        if (n < this.elementStart) {
            int n2 = this.elementStart - n + 10;
            Object[] objectArray = new Object[this.elementArray.length + n2];
            System.arraycopy(this.elementArray, 0, objectArray, n2, this.elementArray.length);
            this.elementArray = objectArray;
            this.elementStart -= n2;
        }
        if (n >= this.elementStart + this.elementArray.length) {
            Object[] objectArray = new Object[n - this.elementStart + 10];
            System.arraycopy(this.elementArray, 0, objectArray, 0, this.elementArray.length);
            this.elementArray = objectArray;
        }
    }

    public synchronized void trim() {
        int n = 0;
        while (n < this.elementArray.length && this.elementArray[n] == null) {
            ++n;
        }
        int n2 = this.elementArray.length - 1;
        while (n2 >= n && this.elementArray[n2] == null) {
            --n2;
        }
        if (n > 0 || n2 < this.elementArray.length - 1) {
            if (n <= n2) {
                Object[] objectArray = new Object[n2 - n + 1];
                System.arraycopy(this.elementArray, n, objectArray, 0, objectArray.length);
                this.elementStart += n;
                this.elementArray = objectArray;
                return;
            }
            this.elementStart = 0;
            this.elementArray = new Object[2];
        }
    }

    protected void internalPutAll(int n, Object[] objectArray) {
        int n2 = 0;
        int n3 = n;
        while (n2 < objectArray.length) {
            if (objectArray[n2] != this.get(n3)) break;
            ++n2;
            ++n3;
        }
        int n4 = objectArray.length - 1;
        int n5 = n + n4;
        while (n4 >= n2) {
            if (objectArray[n4] != this.get(n5)) break;
            --n4;
            --n5;
        }
        if (n2 <= n4) {
            this.grow(n3);
            this.grow(n5);
            System.arraycopy(objectArray, n2, this.elementArray, n3 - this.elementStart, n4 - n2 + 1);
        }
    }

    protected void internalCopy(int n, int n2, int n3) {
        if (n == n2 || n3 < 1) {
            return;
        }
        int n4 = n;
        int n5 = n2;
        int n6 = n + n3 - 1;
        int n7 = n2 + n3 - 1;
        while (n4 <= n6) {
            if (this.get(n4) != this.get(n5)) break;
            ++n4;
            ++n5;
        }
        while (n4 <= n6) {
            if (this.get(n6) != this.get(n7)) break;
            --n6;
            --n7;
        }
        if (n4 <= n6) {
            this.grow(n4);
            this.grow(n5);
            this.grow(n6);
            this.grow(n7);
            System.arraycopy(this.elementArray, n4 - this.elementStart, this.elementArray, n5 - this.elementStart, n6 - n4 + 1);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static int[] remapKeys(int var0, int[] var1_1) {
        var2_2 = var0;
        var3_3 = var0;
        var4_4 = 0;
        while (var4_4 < var1_1.length) {
            var5_5 = var1_1[var4_4];
            if (var2_2 > var5_5) {
                var2_2 = var5_5;
            }
            if (var3_3 < var5_5) {
                var3_3 = var5_5;
            }
            ++var4_4;
        }
        var5_6 = new int[var3_3 - var2_2 + 1];
        var6_7 = new boolean[var3_3 - var2_2 + 1];
        var7_8 = var0 - var2_2;
        var8_9 = var0 - var2_2;
        var9_10 = 0;
        while (var9_10 < var1_1.length) {
            var10_11 = var1_1[var9_10];
            var11_12 = var10_11 - var2_2;
            if (!var6_7[var11_12]) {
                var6_7[var11_12] = true;
                var5_6[var8_9++] = var10_11;
            }
            ++var9_10;
        }
        var10_11 = 0;
        var11_12 = 0;
        ** GOTO lbl32
        {
            ++var10_11;
            do {
                if (var6_7[var10_11]) continue block2;
                var5_6[var11_12++] = var2_2 + var10_11++;
lbl32:
                // 2 sources

            } while (var11_12 < var7_8);
        }
        var11_12 = var8_9;
        ** GOTO lbl39
        {
            ++var10_11;
            do {
                if (var6_7[var10_11]) continue block4;
                var5_6[var11_12++] = var2_2 + var10_11++;
lbl39:
                // 2 sources

            } while (var11_12 < var5_6.length);
        }
        return var5_6;
    }
}

