/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.base.util;

import com.objectshare.base.util.OSIEnumeration;
import com.objectshare.base.util.OSIIntEnumeration;
import java.util.Vector;

public class OSIIntArray {
    int elementCount;
    int[] elementArray;

    public OSIIntArray() {
        this(0);
    }

    public OSIIntArray(int n) {
        this.elementCount = 0;
        this.elementArray = new int[n];
    }

    public OSIIntArray(int[] nArray) {
        this.elementCount = nArray.length;
        this.elementArray = nArray;
    }

    public OSIIntArray(int[] nArray, int n) {
        this.elementCount = nArray.length;
        this.elementArray = new int[this.elementCount > n ? this.elementCount : n];
        System.arraycopy(nArray, 0, this.elementArray, 0, this.elementCount);
    }

    public int size() {
        return this.elementCount;
    }

    public boolean contains(int n) {
        int n2 = 0;
        while (n2 < this.elementCount) {
            if (this.elementArray[n2] == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void add(int n) {
        if (this.elementArray.length < this.elementCount + 1) {
            int[] nArray = new int[this.elementCount * 2 + 2];
            System.arraycopy(this.elementArray, 0, nArray, 0, this.elementCount);
            this.elementArray = nArray;
        }
        this.elementArray[this.elementCount++] = n;
    }

    public boolean addOnce(int n) {
        if (this.contains(n)) {
            return false;
        }
        this.add(n);
        return true;
    }

    public void addAll(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.add(nArray[n]);
            ++n;
        }
    }

    public void addAll(OSIIntEnumeration oSIIntEnumeration) {
        while (oSIIntEnumeration.hasMoreElements()) {
            this.add(oSIIntEnumeration.nextElement());
        }
    }

    public void addAllOnce(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.addOnce(nArray[n]);
            ++n;
        }
    }

    public void addAllOnce(OSIIntEnumeration oSIIntEnumeration) {
        while (oSIIntEnumeration.hasMoreElements()) {
            this.addOnce(oSIIntEnumeration.nextElement());
        }
    }

    public boolean remove(int n) {
        int n2 = this.elementCount;
        while (--n2 >= 0) {
            if (this.elementArray[n2] != n) continue;
            System.arraycopy(this.elementArray, n2 + 1, this.elementArray, n2, this.elementCount - n2 - 1);
            --this.elementCount;
            return true;
        }
        return false;
    }

    public void trim() {
        if (this.elementCount < this.elementArray.length) {
            int[] nArray = new int[this.elementCount];
            System.arraycopy(this.elementArray, 0, nArray, 0, this.elementCount);
            this.elementArray = nArray;
        }
    }

    public OSIEnumeration elements() {
        this.trim();
        return OSIEnumeration.newFor((Object)this.elementArray);
    }

    public int[] toArray() {
        this.trim();
        return this.elementArray;
    }

    public int[] copyArray() {
        return OSIIntEnumeration.copyArray(this.toArray());
    }

    public Vector toVector() {
        return this.elements().toVector();
    }
}

