/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.base.util;

import com.objectshare.base.util.OSICachedIntDictSource;
import com.objectshare.base.util.OSIDynamicIntDictionary;
import com.objectshare.base.util.OSIEnumeration;
import com.objectshare.base.util.OSIIntDictAddedEvent;
import com.objectshare.base.util.OSIIntDictChangedEvent;
import com.objectshare.base.util.OSIIntDictRemovedEvent;
import com.objectshare.base.util.OSIIntDictReorderEvent;
import com.objectshare.base.util.OSIIntDictionary;
import com.objectshare.base.util.OSIIntDictionaryListener;
import com.objectshare.base.util.OSIIntEnumeration;
import com.objectshare.base.util.OSIIntVector;
import com.objectshare.base.util.OSIReadOnlyIntDictionary;
import com.objectshare.base.util.OSIReadWriteIntDictionary;
import java.util.NoSuchElementException;

public class OSICachedIntDictionary
extends OSIIntDictionary
implements OSIIntDictionaryListener {
    protected OSIReadOnlyIntDictionary source;
    protected int cacheStart;
    protected Object[] cache;
    protected int lookAhead;
    public static int defaultCacheSize = 100;
    public static int defaultLookAhead = 40;

    public OSICachedIntDictionary(OSIReadOnlyIntDictionary oSIReadOnlyIntDictionary) {
        this(oSIReadOnlyIntDictionary, defaultCacheSize, defaultLookAhead);
    }

    public OSICachedIntDictionary(OSIReadOnlyIntDictionary oSIReadOnlyIntDictionary, int n, int n2) {
        this.cacheStart = n;
        this.lookAhead = n2;
        this.setSource(oSIReadOnlyIntDictionary);
    }

    public OSIReadOnlyIntDictionary getSource() {
        return this.source;
    }

    public void setSource(OSIReadOnlyIntDictionary oSIReadOnlyIntDictionary) {
        if (this.source != oSIReadOnlyIntDictionary) {
            this.releaseSource();
            this.source = oSIReadOnlyIntDictionary;
            if (this.source != null) {
                OSIReadOnlyIntDictionary oSIReadOnlyIntDictionary2 = this.source;
                synchronized (oSIReadOnlyIntDictionary2) {
                    this.initCache();
                    if (this.source instanceof OSIDynamicIntDictionary) {
                        ((OSIDynamicIntDictionary)this.source).addDictionaryListener(this);
                    }
                    return;
                }
            }
        }
    }

    public void releaseSource() {
        if (this.source != null) {
            if (this.source instanceof OSIDynamicIntDictionary) {
                ((OSIDynamicIntDictionary)this.source).removeDictionaryListener(this);
            }
            this.releaseCache();
            this.source = null;
        }
    }

    public int getCacheStart() {
        if (this.cache != null) {
            return this.cacheStart;
        }
        return 0;
    }

    public void setCacheStart(int n) {
        if (this.cache == null) {
            return;
        }
        int n2 = n;
        if (n2 > this.source.getHighestKey() - this.cache.length + 1) {
            n2 = this.source.getHighestKey() - this.cache.length + 1;
        }
        if (n2 < this.source.getLowestKey()) {
            n2 = this.source.getLowestKey();
        }
        if (n2 < this.cacheStart) {
            int n3 = this.cacheStart - n2;
            if (n3 >= this.cache.length) {
                n3 = this.cache.length;
            }
            this.basicReleaseCache(this.cache.length - n3, n3);
            System.arraycopy(this.cache, 0, this.cache, n3, this.cache.length - n3);
            this.cacheStart = n2;
            this.basicLoadCache(0, n3);
            return;
        }
        if (n2 > this.cacheStart) {
            int n4 = n2 - this.cacheStart;
            if (n4 >= this.cache.length) {
                n4 = this.cache.length;
            }
            this.basicReleaseCache(0, n4);
            System.arraycopy(this.cache, n4, this.cache, 0, this.cache.length - n4);
            this.cacheStart = n2;
            this.basicLoadCache(this.cache.length - n4, n4);
        }
    }

    public int getCacheSize() {
        if (this.cache != null) {
            return this.cache.length;
        }
        return this.cacheStart;
    }

    public int getLookAhead() {
        return this.lookAhead;
    }

    public int size() {
        return this.source.size();
    }

    public boolean isEmpty() {
        return this.size() < 1;
    }

    public int getLowestKey() {
        return this.source.getLowestKey();
    }

    public int getHighestKey() {
        return this.source.getHighestKey();
    }

    public OSIIntEnumeration keys() {
        int n = this.getLowestKey();
        int n2 = this.getHighestKey();
        return OSIIntEnumeration.newFor(n, n2 - n + 1);
    }

    public synchronized OSIIntEnumeration cachedKeys() {
        int n = this.getLowestKey();
        int n2 = this.getHighestKey();
        if (n < this.cacheStart) {
            n = this.cacheStart;
        }
        if (n2 > this.cacheStart + this.cache.length - 1) {
            n2 = this.cacheStart + this.cache.length - 1;
        }
        return OSIIntEnumeration.newFor(n, n2 - n + 1);
    }

    public OSIEnumeration elements() {
        throw new Error("not implemented yet");
    }

    public OSIEnumeration cachedElements() {
        return OSIEnumeration.newFor(this.cachedElementArray());
    }

    public synchronized Object[] cachedElementArray() {
        return this.cachedElementArray(this.getLowestKey(), this.getHighestKey() - this.getLowestKey() + 1);
    }

    public OSIEnumeration cachedElements(int n, int n2) {
        return OSIEnumeration.newFor(this.cachedElementArray(n, n2));
    }

    public synchronized Object[] cachedElementArray(int n, int n2) {
        Object[] objectArray;
        int n3 = n;
        int n4 = n + n2;
        if (n3 < this.cacheStart) {
            n3 = this.cacheStart;
        }
        if (n4 > this.cacheStart + this.cache.length) {
            n4 = this.cacheStart + this.cache.length;
        }
        if (n4 > n3) {
            objectArray = new Object[n4 - n3];
            System.arraycopy(this.cache, n3 - this.cacheStart, objectArray, 0, n4 - n3);
        } else {
            objectArray = new Object[]{};
        }
        return objectArray;
    }

    public boolean contains(Object object) {
        try {
            this.getKey(object);
            return true;
        }
        catch (NoSuchElementException noSuchElementException) {
            return false;
        }
    }

    public boolean containsKey(int n) {
        return this.get(n) != null;
    }

    public boolean cachedKey(int n) {
        return n >= this.cacheStart && n < this.cacheStart + this.cache.length;
    }

    public synchronized int getKey(Object object) throws NoSuchElementException {
        if (object != null) {
            int n = 0;
            while (n < this.cache.length) {
                if (object.equals(this.cache[n])) {
                    return this.cacheStart + n;
                }
                ++n;
            }
        }
        OSIIntEnumeration oSIIntEnumeration = this.keys();
        while (oSIIntEnumeration.hasMoreElements()) {
            int n = oSIIntEnumeration.nextElement();
            if (!object.equals(this.get(n))) continue;
            return n;
        }
        throw new NoSuchElementException();
    }

    public synchronized OSIIntEnumeration getKeys(Object object) {
        OSIIntVector oSIIntVector = new OSIIntVector();
        OSIIntEnumeration oSIIntEnumeration = this.keys();
        while (oSIIntEnumeration.hasMoreElements()) {
            int n = oSIIntEnumeration.nextElement();
            if (!object.equals(this.get(n))) continue;
            oSIIntVector.add(n);
        }
        return oSIIntVector.elements();
    }

    public synchronized OSIIntEnumeration getKeys(Object[] objectArray) throws NoSuchElementException {
        int n = objectArray.length;
        int[] nArray = new int[n];
        while (--n >= 0) {
            nArray[n] = this.getKey(objectArray[n]);
        }
        return OSIIntEnumeration.newFor(nArray);
    }

    public synchronized Object get(int n) {
        if (this.loadIntoCache(n)) {
            return this.cache[n - this.cacheStart];
        }
        return null;
    }

    public synchronized Object[] getArray(int n, int n2) {
        int n3;
        if (n2 < 1) {
            return new Object[0];
        }
        if (n + n2 <= this.cacheStart || n >= this.cacheStart + this.cache.length) {
            return this.source.getArray(n, n2);
        }
        Object[] objectArray = new Object[n2];
        if (n < this.cacheStart) {
            n3 = this.cacheStart - n;
            Object[] objectArray2 = this.basicLoad(n, n3);
            System.arraycopy(objectArray2, 0, objectArray, 0, n3);
        } else {
            n3 = 0;
        }
        int n4 = n - this.cacheStart + n3;
        int n5 = n3;
        n3 = this.cache.length - n4;
        if (n3 > n2 - n5) {
            n3 = n2 - n5;
        }
        System.arraycopy(this.cache, n4, objectArray, n5, n3);
        if ((n5 += n3) < n2) {
            n3 = n2 - n5;
            Object[] objectArray3 = this.basicLoad(n + n5, n3);
            System.arraycopy(objectArray3, 0, objectArray, n5, n3);
        }
        return objectArray;
    }

    public synchronized Object put(int n, Object object) {
        Object object2 = this.get(n);
        Object[] objectArray = new Object[]{object};
        this.putAll(n, objectArray);
        return object2;
    }

    public synchronized void putAll(int n, Object[] objectArray) {
        if (!(this.source instanceof OSIReadWriteIntDictionary)) {
            this.errorNotReadWrite();
        }
        ((OSIReadWriteIntDictionary)this.source).putAll(n, objectArray);
    }

    public synchronized void insertAll(int n, Object[] objectArray) {
        if (!(this.source instanceof OSIReadWriteIntDictionary)) {
            this.errorNotReadWrite();
        }
        ((OSIReadWriteIntDictionary)this.source).insertAll(n, objectArray);
    }

    public synchronized void reorder(int n, Object[] objectArray) {
        this.reorderKeys(n, this.getKeys(objectArray).toVector());
    }

    public synchronized void reorderKeys(int n, OSIIntVector oSIIntVector) {
        if (!(this.source instanceof OSIReadWriteIntDictionary)) {
            this.errorNotReadWrite();
        }
        if (oSIIntVector.size() > 0) {
            ((OSIReadWriteIntDictionary)this.source).reorderKeys(n, oSIIntVector);
        }
    }

    public synchronized Object[] removeKeys(int n, int n2) {
        if (!(this.source instanceof OSIReadWriteIntDictionary)) {
            this.errorNotReadWrite();
        }
        return ((OSIReadWriteIntDictionary)this.source).removeKeys(n, n2);
    }

    public void dictionaryChanged(OSIIntDictChangedEvent oSIIntDictChangedEvent) {
        OSIReadOnlyIntDictionary oSIReadOnlyIntDictionary = this.source;
        synchronized (oSIReadOnlyIntDictionary) {
            this.refreshCache(oSIIntDictChangedEvent.getKey(), oSIIntDictChangedEvent.getSize());
        }
        this.triggerChanged(oSIIntDictChangedEvent.getKey(), oSIIntDictChangedEvent.getSize(), oSIIntDictChangedEvent.getOld().toArray());
    }

    public void dictionaryKeysAdded(OSIIntDictAddedEvent oSIIntDictAddedEvent) {
        OSIReadOnlyIntDictionary oSIReadOnlyIntDictionary = this.source;
        synchronized (oSIReadOnlyIntDictionary) {
            this.insertCache(oSIIntDictAddedEvent.getKey(), oSIIntDictAddedEvent.getSize());
        }
        this.triggerKeysAdded(oSIIntDictAddedEvent.getKey(), oSIIntDictAddedEvent.getSize());
    }

    public void dictionaryKeysRemoved(OSIIntDictRemovedEvent oSIIntDictRemovedEvent) {
        OSIReadOnlyIntDictionary oSIReadOnlyIntDictionary = this.source;
        synchronized (oSIReadOnlyIntDictionary) {
            this.removeCache(oSIIntDictRemovedEvent.getKey(), oSIIntDictRemovedEvent.getSize());
        }
        this.triggerKeysRemoved(oSIIntDictRemovedEvent.getKey(), oSIIntDictRemovedEvent.getRemoved());
    }

    public void dictionaryKeysReordered(OSIIntDictReorderEvent oSIIntDictReorderEvent) {
        OSIReadOnlyIntDictionary oSIReadOnlyIntDictionary = this.source;
        synchronized (oSIReadOnlyIntDictionary) {
            this.refreshCache(oSIIntDictReorderEvent.getKey(), oSIIntDictReorderEvent.getSize());
        }
        this.triggerKeysReordered(oSIIntDictReorderEvent.getKey(), oSIIntDictReorderEvent.getReorderMap());
    }

    void initCache() {
        if (this.cache == null) {
            this.cache = new Object[this.cacheStart];
            this.cacheStart = this.source.getLowestKey();
            this.basicLoadCache(0, this.cache.length);
        }
    }

    void releaseCache() {
        if (this.cache != null) {
            this.basicReleaseCache(0, this.cache.length);
            this.cacheStart = this.cache.length;
            this.cache = null;
        }
    }

    boolean loadIntoCache(int n) {
        if (n < this.cacheStart) {
            return this.loadCacheStartingAt(n - this.lookAhead + 1);
        }
        if (n >= this.cacheStart + this.cache.length) {
            return this.loadCacheStartingAt(n + this.lookAhead - this.cache.length);
        }
        return true;
    }

    boolean loadCacheStartingAt(int n) {
        this.setCacheStart(n);
        return n >= this.cacheStart && n < this.cacheStart + this.cache.length;
    }

    void refreshCache(int n, int n2) {
        int n3 = n > this.cacheStart ? n : this.cacheStart;
        int n4 = n + n2;
        if (n4 > this.cacheStart + this.cache.length) {
            n4 = this.cacheStart + this.cache.length;
        }
        if (n3 < n4) {
            this.basicReleaseCache(n3 - this.cacheStart, n4 - n3);
            this.basicLoadCache(n3 - this.cacheStart, n4 - n3);
        }
    }

    void insertCache(int n, int n2) {
        if (n <= this.cacheStart) {
            this.cacheStart += n2;
            return;
        }
        int n3 = n - this.cacheStart;
        int n4 = this.cache.length - n3;
        if (n4 > 0) {
            if (n4 > n2) {
                n4 = n2;
            }
            this.basicReleaseCache(this.cache.length - n4, n4);
            System.arraycopy(this.cache, n3, this.cache, n3 + n4, this.cache.length - (n3 + n4));
            this.basicLoadCache(n3, n4);
        }
    }

    void removeCache(int n, int n2) {
        if (n + n2 <= this.cacheStart) {
            this.cacheStart -= n2;
            return;
        }
        int n3 = n - this.cacheStart;
        int n4 = this.cache.length - n3;
        if (n4 > 0) {
            if (n4 > n2) {
                n4 = n2;
            }
            if (n3 < 0) {
                n4 += n3;
                this.cacheStart += n3;
                n3 = 0;
            }
            this.basicReleaseCache(n3, n4);
            System.arraycopy(this.cache, n3 + n4, this.cache, n3, this.cache.length - (n3 + n4));
            this.basicLoadCache(this.cache.length - n4, n4);
        }
    }

    void basicLoadCache(int n, int n2) {
        if (n2 > 0) {
            Object[] objectArray = this.basicLoad(this.cacheStart + n, n2);
            System.arraycopy(objectArray, 0, this.cache, n, n2);
            if (this.source instanceof OSICachedIntDictSource) {
                ((OSICachedIntDictSource)((Object)this.source)).cached(objectArray);
            }
        }
    }

    void basicReleaseCache(int n, int n2) {
        if (n2 > 0 && this.source instanceof OSICachedIntDictSource) {
            Object[] objectArray;
            if (n == 0 && n2 == this.cache.length) {
                objectArray = this.cache;
            } else {
                objectArray = new Object[n2];
                System.arraycopy(this.cache, n, objectArray, 0, n2);
            }
            ((OSICachedIntDictSource)((Object)this.source)).uncached(objectArray);
        }
    }

    Object[] basicLoad(int n, int n2) {
        if (n2 < 1) {
            return new Object[0];
        }
        Object[] objectArray = this.source.getArray(n, n2);
        if (objectArray == null) {
            objectArray = new Object[n2];
        } else if (objectArray.length < n2) {
            Object[] objectArray2 = new Object[n2];
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
            objectArray = objectArray2;
        }
        return objectArray;
    }

    void errorNotReadWrite() {
        throw new Error("source is static - does not implement OSIReadWriteIntDictionary");
    }
}

