/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.base.example;

import com.objectshare.base.example.OSIExampleFrame;
import com.objectshare.java.osi.OSIToolkit;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.PrintJob;
import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;

public class OSIExampleApplet
extends Applet {
    protected Menu fileMenu = new Menu("File", true);
    protected MenuItem printComponentMenuItem = new MenuItem("Print Component");
    protected MenuItem printWindowMenuItem = new MenuItem("Print Window");
    protected MenuItem quitMenuItem = new MenuItem("Quit");
    protected Properties printProperties;

    public Frame getFrame() {
        Container container = this;
        while (!(container instanceof Frame)) {
            container = container.getParent();
        }
        return (Frame)container;
    }

    public URL getDocumentBase() {
        return OSIExampleApplet.normalizeURL(super.getDocumentBase());
    }

    public URL getCodeBase() {
        return OSIExampleApplet.normalizeURL(super.getCodeBase());
    }

    protected MenuBar createMenuBar() {
        MenuBar menuBar = new MenuBar();
        menuBar.add(this.createFileMenu());
        return menuBar;
    }

    protected Menu createFileMenu() {
        this.fileMenu.add(this.quitMenuItem);
        return this.fileMenu;
    }

    public boolean menuItemAction(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.printComponentMenuItem) {
            this.printExampleComponent();
            return true;
        }
        if (actionEvent.getSource() == this.printWindowMenuItem) {
            this.printExampleWindow();
            return true;
        }
        if (actionEvent.getSource() == this.quitMenuItem) {
            System.exit(0);
        }
        return false;
    }

    public Component getComponentToPrint() {
        return null;
    }

    public Component getWindowToPrint() {
        return this.getFrame();
    }

    public void printExampleComponent() {
        Component component = this.getComponentToPrint();
        if (component != null) {
            this.printExample(component);
        }
    }

    public void printExampleWindow() {
        Component component = this.getWindowToPrint();
        if (component != null) {
            this.printAllExample(component);
        }
    }

    public void printExample(Component component) {
        PrintJob printJob;
        if (this.printProperties == null) {
            this.printProperties = new Properties();
        }
        if ((printJob = OSIToolkit.getPrintJob(this.getFrame(), "Print", this.printProperties)) != null) {
            Graphics graphics = printJob.getGraphics();
            this.printExample(component, graphics);
            graphics.dispose();
            printJob.end();
        }
    }

    public void printExample(Component component, Graphics graphics) {
        component.print(graphics);
    }

    public void printAllExample(Component component) {
        PrintJob printJob;
        if (this.printProperties == null) {
            this.printProperties = new Properties();
        }
        if ((printJob = OSIToolkit.getPrintJob(this.getFrame(), "Print", this.printProperties)) != null) {
            Graphics graphics = printJob.getGraphics();
            this.printAllExample(component, graphics);
            graphics.dispose();
            printJob.end();
        }
    }

    public void printAllExample(Component component, Graphics graphics) {
        component.printAll(graphics);
    }

    public static void main(String[] stringArray) {
        OSIExampleApplet oSIExampleApplet = new OSIExampleApplet();
        new OSIExampleFrame(oSIExampleApplet, oSIExampleApplet.getClass().getName(), 350, 250);
    }

    public static URL normalizeURL(URL uRL) {
        if (uRL == null) {
            return null;
        }
        try {
            return new URL(uRL.toExternalForm().replace('\\', '/'));
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println(malformedURLException);
            return uRL;
        }
    }

    public static URL normalizeURL(String string) {
        if (string == null) {
            return null;
        }
        try {
            String string2 = string;
            if (!string2.startsWith("file:", 0)) {
                if (string2.charAt(0) != '/') {
                    string2 = "/" + string2;
                }
                string2 = "file:" + string2;
            }
            return OSIExampleApplet.normalizeURL(new URL(string2));
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println(malformedURLException);
            return null;
        }
    }
}

