/*
 * (c) Copyright 1996, KL GROUP INC.  
 * ALL RIGHTS RESERVED 
 *
 * This file is provided for demonstration and educational uses only.
 * Permission to use, copy, modify and distribute this file for
 * any purpose and without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies, and that the name of KL Group not be used in advertising
 * or publicity pertaining to this material without the specific,
 * prior written permission of an authorized representative of
 * KL Group.
 *
 * KL GROUP MAKES NO REPRESENTATIONS AND EXTENDS NO WARRANTIES, EX-
 * PRESS OR IMPLIED, WITH RESPECT TO THE SOFTWARE, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR ANY PARTICULAR PURPOSE, AND THE WARRANTY AGAINST IN-
 * FRINGEMENT OF PATENTS OR OTHER INTELLECTUAL PROPERTY RIGHTS.  THE
 * SOFTWARE IS PROVIDED "AS IS", AND IN NO EVENT SHALL KL GROUP OR
 * ANY OF ITS AFFILIATES BE LIABLE FOR ANY DAMAGES, INCLUDING ANY
 * LOST PROFITS OR OTHER INCIDENTAL OR CONSEQUENTIAL DAMAGES 
 * RELATING TO THE USE OF THIS SOFTWARE.
 */
//   RCSID -- $RCSfile: ContribFrame.java $ $Revision: 2.0 $  $Date: 1997/06/09 18:22:35 $ $Locker: $  KL Group Inc.

package jclass.contrib;
import java.awt.*;

/**
 * ContribFrame is a Frame subclass which responds to WINDOW_CLOSE events,
 * and sets the focus to its first child.
 * A Frame is a top-level window with a title.
 * The default layout for a frame is BorderLayout.
 */
public class ContribFrame extends Frame {

boolean exit = true;

/** Creates a frame. */
public ContribFrame() {
	super();
}

/** Creates a Frame with the specified title. */
public ContribFrame(String title) {
	super(title);
}

/** Gets the ExitOnClose value. 
 * @see setExitOnClose
 */
public boolean getExitOnClose() { return exit; }

/** Determines whether the application should exit when the user closes
 * the frame or when close() is called (default: true). 
 * If set to false, the frame is hidden; it can be made visible later 
 * by calling show().
 * @see close
 * @see show
 */
public void setExitOnClose(boolean v) { exit = v; }

/** 
 * Adds the specified component to this frame in the "Center" position.
 */
public Component add(Component comp) {
	Component c = super.add(comp);
	if (getLayout() instanceof BorderLayout)
	    getLayout().addLayoutComponent("Center", comp);
	return c;
}

/** Returns true if the component is traversable. */
private static boolean isTraversable(Component comp) {
	if (comp instanceof Scrollbar)
		return false;
	else if (comp instanceof Container) {
		Component[] child = ((Container)comp).getComponents();
		for (int i=0; i < child.length; i++)
			if (isTraversable(child[i])) 
				return true;
		return false;
	}
	else 
		return comp.isShowing() && comp.isEnabled();
}

/** Returns the first child which can accept keyboard focus. */
public Component getFirstChild() {
	return getFirstChild(this);
}

/** Returns the first child which can accept keyboard focus. */
private static Component getFirstChild(Container comp) {
	if (!comp.isVisible())
		return null;
	Component[] child = comp.getComponents();
	for (int i=0; i < child.length; i++) {
		if (child[i] instanceof Container) {
			Component c = getFirstChild((Container)child[i]);
			if (c != null) return c;
		}
		else
			if (isTraversable(child[i])) return child[i];
	}
	return null;
}

/** Sets the focus to the first child. */
public synchronized void show() {
    super.show();
	Component child = getFirstChild(this);
	if (child != null)
		child.requestFocus();
}

/** Closes the window. If ExitOnClose is true, the application is exited 
 * via System.exit().
 * @see setExitOnClose
 */
public void close(Event ev) {
	hide();
	if (exit) {
		dispose();
		System.exit(0); 
	}
}

/** Calls close if a WINDOW_DESTROY event is passed.
 * @see close
 */
public boolean handleEvent(Event ev) {
	if (ev.id == Event.WINDOW_DESTROY) {
		close(ev);
		return true;
	}
	return super.handleEvent(ev);
}

}
