/*
 * (c) Copyright 1997, KL GROUP INC.  
 * ALL RIGHTS RESERVED 
 *
 * This file is provided for demonstration and educational uses only.
 * Permission to use, copy, modify and distribute this file for
 * any purpose and without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies, and that the name of KL Group not be used in advertising
 * or publicity pertaining to this material without the specific,
 * prior written permission of an authorized representative of
 * KL Group.
 *
 * KL GROUP MAKES NO REPRESENTATIONS AND EXTENDS NO WARRANTIES, EX-
 * PRESS OR IMPLIED, WITH RESPECT TO THE SOFTWARE, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR ANY PARTICULAR PURPOSE, AND THE WARRANTY AGAINST IN-
 * FRINGEMENT OF PATENTS OR OTHER INTELLECTUAL PROPERTY RIGHTS.  THE
 * SOFTWARE IS PROVIDED "AS IS", AND IN NO EVENT SHALL KL GROUP OR
 * ANY OF ITS AFFILIATES BE LIABLE FOR ANY DAMAGES, INCLUDING ANY
 * LOST PROFITS OR OTHER INCIDENTAL OR CONSEQUENTIAL DAMAGES 
 * RELATING TO THE USE OF THIS SOFTWARE.
 */
// RCSID -- $RCSfile: splitterWindow.java $ $Revision: 2.0 $ $Date: 1997/06/09 19:09:01 $ $Locker: $  KL Group Inc.

package jclass.bwt.examples;
import jclass.bwt.BWTEnum;
import jclass.bwt.JCItemEvent;
import jclass.bwt.JCMultiColumnList;
import jclass.bwt.JCOutliner;
import jclass.bwt.JCOutlinerEvent;
import jclass.bwt.JCOutlinerFolderNode;
import jclass.bwt.JCOutlinerListener;
import jclass.bwt.JCOutlinerNode;
import jclass.bwt.JCOutlinerNodeStyle;
import jclass.bwt.JCSplitterWindow;
import jclass.contrib.ContribFrame;
import jclass.util.JCUtilConverter;
import jclass.util.JCVector;
import java.awt.*;

/**
 * This example demonstrates a several components in a JCSplitterWindow.
 */
public class splitterWindow extends java.applet.Applet 
implements JCOutlinerListener {

final static String[] column_labels = { 
	"Name", "Title", "Address", "Phone", "Salary" 
};

final static String dept[] = { "Management", "Accounting", "R&D" };

final static String mgmt_items[] = {
"John Kricfalusi|President|983 Nickelodeon Street, Rexdale Ontario|(414) 999-9876|$10,000",
"Hikaru Takei|VP|134 Adelaide Street, Suite 204, Toronto Ontario|(416) 594-1026|$23K",
"James Q. Doohan|Director|1701 Planetia Blvd., Anytown, U.S.A.||$245,000"
};

final static String accounting_items[] = {
"Hikaru I. Takei|Payroll|134 Adelaide Street E., Suite 204, Anytown, U.S.A.|(999) 594-1026",
"Melissa A. Truman|Receivable|475 Woodview Line, Anytown, U.S.A.|(999) 555-9030|$50,250",
"Stephanie L. Truman|Payroll|388 Appleby Road, Anytown, U.S.A.|(999) 555-2642|$85,750"
};

final static String rd_items[] = {
"James Q. Doohan|Engineer|1701 Planetia Blvd., Anytown, U.S.A.||$245,000",
"John F. Kricfalusi|Physicist|983 Nickelodeon Street, Anytown, U.S.A.|(999) 555-9876|$10,000",
"Marc Lenard|Engineer|6 Gene Crescent, Anytown, U.S.A.|(999) 555-1212|$10/hr.",
"Hikaru I. Takei|Musician|134 Adelaide Street E., Suite 204, Anytown, U.S.A.|(999) 594-1026|50%",
"Melissa A. Truman|QA|475 Woodview Line, Anytown, U.S.A.|(999) 555-9030|$50,250",
"Stephanie L. Truman|Technical Writer|388 Appleby Road, Anytown, U.S.A.|(999) 555-2642|$85,750",
"Bill West|System Analyst|1001 Spumco Way, Anytown, U.S.A.|(999) 555-9966|$17,500"
};

final static String[][] item_data = { mgmt_items, accounting_items, rd_items };

JCMultiColumnList list;

/** 
 * JCOutlinerListener methods
 */

/*
 * Writes a folder's items to the list when it is selected
 * It simulates the reading of the data from a database.
 */
public void itemStateChanged(JCItemEvent item_ev) {
	JCOutlinerEvent ev = (JCOutlinerEvent) item_ev;
	JCOutlinerFolderNode folder = (JCOutlinerFolderNode) ev.getNode();
	JCOutliner outliner = (JCOutliner) ev.getSource();

	// Ignore root node
	if (folder == outliner.getRootNode()) {
		list.clear();
		return;
	}

	// Add children to list
	if (ev.getStateChange() == JCItemEvent.SELECTED) {
		list.setBatched(true);
		list.clear();
		int pos = ((Integer)folder.getUserData()).intValue();
		String[] items = item_data[pos];

		for (int i=0; i < items.length; i++) {
			JCVector label = outliner.getConverter()
				.toVector(this, items[i], '|', false);
			list.addItem(label);
		}
		list.setBatched(false);
	}
}

public void outlinerFolderStateChangeBegin(JCOutlinerEvent ev) {}
public void outlinerFolderStateChangeEnd(JCOutlinerEvent ev) {}
public void outlinerNodeSelectBegin(JCOutlinerEvent ev) {}
public void outlinerNodeSelectEnd(JCOutlinerEvent ev) {}

public void init() {
	Image folder_closed = JCUtilConverter.toImage(this, "../images/folderc.gif");
	Image top = JCUtilConverter.toImage(this, "../images/top.gif");
	
	// Force contents to be the same size as the applet
	setLayout(new GridLayout(1,1));
	setBackground(Color.lightGray);

	JCOutlinerNodeStyle style = new JCOutlinerNodeStyle();
	style.setFolderOpenIcon(top);
	style.setFolderClosedIcon(top);

	JCOutlinerFolderNode root = new JCOutlinerFolderNode(null, "Personnel");
	root.setStyle(style);

	JCOutlinerNodeStyle folder_style = new JCOutlinerNodeStyle();
	folder_style.setFolderClosedIcon(folder_closed);
	folder_style.setFolderOpenIcon(folder_closed);

	JCOutlinerFolderNode f = null;
	for (int i=0; i < dept.length; i++) {
		f = new JCOutlinerFolderNode(null, BWTEnum.FOLDER_CLOSED, dept[i]);
		f.setUserData(new Integer(i));
		f.setStyle(folder_style);
		root.addNode(f);
	}

	JCOutliner outliner = new JCOutliner(root);
	outliner.getOutliner().setBackground(Color.white);
	outliner.setPreferredSize(150, 300);
	outliner.addItemListener(this);

	list = new JCMultiColumnList();
	list.getList().setBackground(Color.white);
	list.setColumnLabels(column_labels);
	list.setPreferredSize(500, 300);

	// Open last folder
	outliner.selectNode(f, null);
	outliner.setNodeState(f, BWTEnum.FOLDER_OPEN_ALL, true);

	JCSplitterWindow window = new JCSplitterWindow(BWTEnum.HORIZONTAL);
	window.add(outliner);
	window.add(list);

	add(window);
}

// Change the list's column widths from VARIABLE to the current widths
public void start() {
	super.start();
	for (int i=0; i < list.getNumColumns(); i++)
		list.setColumnWidth(i, list.getColumnWidth(i));
}

public static void main(String args[]) {
	ContribFrame frame = new ContribFrame("SplitterWindow");
	splitterWindow s = new splitterWindow();

	s.init();
	frame.add(s);
	frame.pack();
	frame.show();
	s.start();
}
}

