/*
 * (c) Copyright 1997, KL GROUP INC.  
 * ALL RIGHTS RESERVED 
 *
 * This file is provided for demonstration and educational uses only.
 * Permission to use, copy, modify and distribute this file for
 * any purpose and without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies, and that the name of KL Group not be used in advertising
 * or publicity pertaining to this material without the specific,
 * prior written permission of an authorized representative of
 * KL Group.
 *
 * KL GROUP MAKES NO REPRESENTATIONS AND EXTENDS NO WARRANTIES, EX-
 * PRESS OR IMPLIED, WITH RESPECT TO THE SOFTWARE, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR ANY PARTICULAR PURPOSE, AND THE WARRANTY AGAINST IN-
 * FRINGEMENT OF PATENTS OR OTHER INTELLECTUAL PROPERTY RIGHTS.  THE
 * SOFTWARE IS PROVIDED "AS IS", AND IN NO EVENT SHALL KL GROUP OR
 * ANY OF ITS AFFILIATES BE LIABLE FOR ANY DAMAGES, INCLUDING ANY
 * LOST PROFITS OR OTHER INCIDENTAL OR CONSEQUENTIAL DAMAGES 
 * RELATING TO THE USE OF THIS SOFTWARE.
 */
// RCSID -- $RCSfile: alignerLayout.java $ $Revision: 2.0 $ $Date: 1997/06/09 19:08:53 $ $Locker: $  KL Group Inc.

package jclass.bwt.examples;
import jclass.bwt.BWTEnum;
import jclass.bwt.JCAlignerLayout;
import jclass.bwt.JCLabel;
import jclass.bwt.JCTextArea;
import jclass.bwt.JCTextField;
import jclass.contrib.ContribFrame;
import java.awt.*;

/**
 * This example demonstrates the use of a JCAlignerLayout
 */
public class alignerLayout extends java.applet.Applet {

public void init() {
	JCAlignerLayout layout = new JCAlignerLayout(2, 5, 5);
	JCLabel label;
	JCTextField text;

	setBackground(Color.lightGray);
	setLayout(layout);
	add(new JCLabel("Name"));
	add(new JCTextField("", 10));
	add(new JCLabel("Zip Code"));
	add(new JCTextField("", 10));
	add(new JCLabel("Phone"));
	add(text = new JCTextField("555-1212", 8));
	text.setMaximumLength(8);
	layout.setResizeWidth(text, true);
	add(label = new JCLabel("Address"));
	add(new JCTextArea(""));
	layout.setLabelVerticalAlignment(label, BWTEnum.TOP);
}

public static void main(String args[]) {
	ContribFrame frame = new ContribFrame("AlignerLayout");
	alignerLayout s = new alignerLayout();

	s.init();
	frame.add(s);
	frame.pack();
	frame.show();
}
}
