/*
 * (c) Copyright 1997, KL GROUP INC.  
 * ALL RIGHTS RESERVED 
 *
 * This file is provided for demonstration and educational uses only.
 * Permission to use, copy, modify and distribute this file for
 * any purpose and without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies, and that the name of KL Group not be used in advertising
 * or publicity pertaining to this material without the specific,
 * prior written permission of an authorized representative of
 * KL Group.
 *
 * KL GROUP MAKES NO REPRESENTATIONS AND EXTENDS NO WARRANTIES, EX-
 * PRESS OR IMPLIED, WITH RESPECT TO THE SOFTWARE, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR ANY PARTICULAR PURPOSE, AND THE WARRANTY AGAINST IN-
 * FRINGEMENT OF PATENTS OR OTHER INTELLECTUAL PROPERTY RIGHTS.  THE
 * SOFTWARE IS PROVIDED "AS IS", AND IN NO EVENT SHALL KL GROUP OR
 * ANY OF ITS AFFILIATES BE LIABLE FOR ANY DAMAGES, INCLUDING ANY
 * LOST PROFITS OR OTHER INCIDENTAL OR CONSEQUENTIAL DAMAGES 
 * RELATING TO THE USE OF THIS SOFTWARE.
 */
// RCSID -- $RCSfile: awtgui.java $ $Revision: 2.0 $ $Date: 1997/06/09 19:09:57 $ $Locker: $  KL Group Inc.

package jclass.bwt.demos.awt_vs_bwt;
import jclass.contrib.ContribFrame;
import java.awt.*;

public class awtgui extends java.applet.Applet {

final static String column_labels = 
"Title                                   " +
"Author                  " + 
" Price "+
"Qty "+ 
"Pages "+ 
"Stk "+ 
"Publisher"
;

final static int titlePos = 0;
final static int titleLength = 40;
final static int qtyPos = 72;
final static int qtyLength = 3;
final static int pricePos = 65;
final static int priceLength = 6;

final static String[] data = {
"Presenting Java                          "+            // 41 chars
"John December           "+                 			// 24 chars
"$25.00 "+                                              // 7 chars
"    " +                                                // 4 chars
" 207  "+                                               // 6 chars
" Y  "+                                                 // 2 chars
"Sams.net                ",                             // 24 chars

"60 Minute Guide to Java                  "+
"Tittel and Gaither      "+
"$19.99 "+
"    "+
" 256  "+
" N  "+
"IDG Books               ",

"Hooked on Java                           "+
"Van Hoff, Shaio ...     "+
"$29.95 "+
"    "+
"      "+
" Y  "+
"Addison-Wesley          ",

"Teach Yourself Java in 21 Days           "+
"Lemay and Perkins       "+
"$39.99 "+
"    "+
" 527  "+
" Y  "+
"Sams.net                ",

"Programming with Java!                   "+
"Tim Ritchey             "+
"$35.00 "+
"    "+
" 389  "+
" N  "+
"New Riders              ",

"Java in a Nutshell                       "+
"David Flanagan          "+
"$14.95 "+
"    "+
" 450  "+
" Y  "+
"O'Reilly                ",

"Java Primer Plus                         "+
"Tyma, Torok and Downing "+
"$39.99 "+
"    "+
" 600  "+
" Y  "+
"Waite Group Press       ",

"Web Site Programming With Java           "+
"Harms, Fiske and Rice   "+
"$39.95 "+
"    "+
" 578  "+
" Y  "+
"McGraw-Hill             ",

"Java for C/C++ Programmers               "+
"Michael C. Daconta      "+
"$39.95 "+
"    "+
" 500  "+
" Y  "+
"John Wiley & Sons, Inc. ",

"The Java Sourcebook                      "+
"Ed Anuff                "+
"       "+
"    "+
" 450  "+
" Y  "+
"John Wiley & Sons, Inc. ",

"Active Java                              "+
"Freeman and Ince        "+
"$25.95 "+
"    "+
" 235  "+
" N  "+
"Addison-Wesley          ",

"Essential Java                           "+
"Jason Manger            "+
"$39.95 "+
"    "+
" 352  "+
" Y  "+
"McGraw-Hill             ",

"Java By Example                          "+
"Jackson and McClellan   "+
"$34.95 "+
"    "+
" 345  "+
" Y  "+
"SunSoft Press           ",

"Instant Java                             "+
"John A. Pew             "+
"$29.95 "+
"    "+
" 340  "+
" Y  "+
"SunSoft Press           ",

"Just Java                                "+
"Peter van der Linden    "+
"       "+
"    "+
"      "+
" Y  "+
"SunSoft Press           ",

"The Java Handbook                        "+
"Patrick Naughton        "+
"$27.95 "+
"    "+
" 450  "+
" Y  "+
"Osborne/McGraw-Hill     ",

"Core Java                                "+
"Cornell and Horstmann   "+
"$39.95 "+
"    "+
" 600  "+
" Y  "+
"SunSoft Press           ",

"Programming JavaScript for Netscape 2.0  "+
"Tim Ritchey             "+
"$35.00 "+
"    "+
" 300  "+
" Y  "+
"New Riders              ",

"Teach Yourself Java for Macintosh ...    "+
"Lemay, Perkins, ...     "+
"$40.00 "+
"    "+
" 500  "+
" Y  "+
"Hayden                  ",

"Java Programming EXplorer                "+
"Bartlett, Leslie ...    "+
"$39.99 "+
"    "+
" 848  "+
" N  "+
"Coriolis Group Books    ",

"Java Unleashed                           "+
"Michael Morrison et al  "+
"$49.99 "+
"    "+
"1000  "+
" Y  "+
"Sams.net                ",

"Java Programmer's Library                "+
"Lalani and Jamsa        "+
"$49.95 "+
"    "+
" 556  "+
" Y  "+
"Jamsa Press             ",

"The Complete Idiot's Guide to JavaScript "+
"Weiss and Walter        "+
"$19.99 "+
"    "+
"      "+
" Y  "+
"Que                     ",

"The Java Programming Language            "+
"Arnold and Gosling      "+
"$34.50 "+
"    "+
" 334  "+
" Y  "+
"Addison-Wesley          ",

"Special Edition: Using Java              "+
"Alex Newman, et al.     "+
"$49.99 "+
"    "+
" 869  "+
" Y  "+
"Que                     ",

"Java Programming Basics                  "+
"Au, Makower and Pencom  "+
"$34.95 "+
"    "+
" 352  "+
" Y  "+
"MIS:Press/M&T Books     ",

"Java Manual of Style                     "+
"Gurewich and Gurewich   "+
"$24.99 "+
"    "+
"      "+
" Y  "+
"Ziff-Davis              ",

"Teach Yourself JavaScript In A Week      "+
"Arman Damesh            "+
"$35.99 "+
"    "+
"      "+
" N  "+
"Sams.net                ",

"Java Essentials For C & C++ Programmers  "+
"Boone Barry             "+
"$29.95 "+
"    "+
"      "+
" N  "+
"Addison-Wesley          ",

"The Java Programming Language            "+
"Friedel Jr. and Potts   "+
"$24.99 "+
"    "+
" 300  "+
" Y  "+
"Coriolis Group Books    ",

"Java Programming for the Internet        "+
"Thomas, Patel, ...      "+
"$49.95 "+
"    "+
" 760  "+
" Y  "+
"Ventana Press           ",

"Writing Java Applets                     "+
"John Rodley             "+
"$39.99 "+
"    "+
" 450  "+
" Y  "+
"Coriolis Group Books    ",

"Making Sense of Java                     "+
"Simpson, Mitchell, ...  "+
"$29.95 "+
"    "+
"      "+
" Y  "+
"Prentice Hall           ",

"Danny Goodman's JavaScript Handbook      "+
"Danny Goodman           "+
"$34.99 "+
"    "+
" 544  "+
" Y  "+
"IDG Books               ",

"JavaScript for the Macintosh             "+
"Shobe and Ritchey       "+
"$40.00 "+
"    "+
" 300  "+
" Y  "+
"Hayden                  ",

"Creating Cool Web Applets with Java      "+
"Paul J. Perry           "+
"$29.99 "+
"    "+
" 300  "+
" Y  "+
"IDG Books               ",

"JavaScript & Netscape 2 Wizardry         "+
"Dan Shafer              "+
"$34.99 "+
"    "+
" 500  "+
" Y  "+
"Coriolis Group Books    ",
};

// Important components in the gui
List list = new List(11, false);
TextField qty_text;
TextField price_text;
TextField total_text;
Button add_button;
List sw;
Button order_button;
Panel tabman;
Button pay_card_button, mail_card_button, ship_card_button, send_card_button;
CardLayout card_layout;
Panel send_pan;

public void init() 
{
	setLayout(new BorderLayout());
	setBackground(Color.lightGray);

	// The Book List

	Panel label_pan = new Panel();
	label_pan.setLayout(new GridLayout(1,1));

	Panel l_pan = new Panel();
	l_pan.setLayout(new BorderLayout());
	l_pan.setBackground(Color.lightGray);

	Label list_label = new Label(column_labels, Label.LEFT);
	list_label.setFont(new Font("Courier", Font.PLAIN, 12));
	l_pan.add("North", list_label);

	list.setBackground(Color.white);
	list.setFont(new Font("Courier", Font.PLAIN, 12));
	for (int i=0; i < data.length; i++) 
		list.addItem(data[i]);
	l_pan.add("Center", list);

	add("North", l_pan);

	// The Quantity Price Line

	Panel q_pan = new Panel();
	q_pan.setLayout(new FlowLayout());

	q_pan.add(new Label("Qty"));
	q_pan.add(qty_text = new TextField("", 3));
	q_pan.add(new Label("@ Price "));
	q_pan.add(price_text = new TextField("", 7));
	price_text.setEditable(false);
	q_pan.add(new Label(" = "));
	q_pan.add(total_text = new TextField("", 9));
	total_text.setEditable(false);
	q_pan.add(add_button = new Button("Add To Order"));

	add("Center", q_pan);

	// The Card Section

	Panel tm_pan = new Panel();
	tm_pan.setLayout(new BorderLayout());
	tm_pan.setBackground(Color.lightGray);

	Panel tabman_buttons = new Panel();
	tabman_buttons.setLayout(new GridLayout(1, 4));
	tabman_buttons.add(pay_card_button = new Button("Payment"));
	tabman_buttons.add(mail_card_button = new Button("Mailing"));
	tabman_buttons.add(ship_card_button = new Button("Shipping"));
	tabman_buttons.add(send_card_button = new Button("Send"));
	tm_pan.add("North", tabman_buttons);

	tabman = new Panel();
	tabman.setLayout(card_layout = new CardLayout());


	// The Payment Card

	Panel pay_pan = new Panel();

	Label pay_label;
	pay_pan.setLayout(null);
	pay_pan.add(pay_label = new Label("Credit Card", Label.LEFT));
	pay_label.reshape(0,0,200,20);
	CheckboxGroup card_grp = new CheckboxGroup();
	Checkbox cb;
	cb = new Checkbox("Visa");
	cb.setCheckboxGroup(card_grp);
	pay_pan.add(cb);
	cb.reshape(0, 30, 200, 20);
	cb = new Checkbox("Mastercard");
	cb.setCheckboxGroup(card_grp);
	pay_pan.add(cb);
	cb.reshape(0, 60, 200, 20);
	cb = new Checkbox("American Express");
	cb.setCheckboxGroup(card_grp);
	pay_pan.add(cb);
	cb.reshape(0, 90, 200, 20);

	Panel pay_topright_pan = new Panel();
	pay_topright_pan.setLayout(new BorderLayout());
	pay_topright_pan.reshape(225, 30, 250, 150);
	Panel pay_right_pan = new Panel();
	pay_right_pan.setLayout(new GridBagLayout());

	Label p_label;
	pay_right_pan.add(p_label = new Label("Number :"));
	p_label.setAlignment(Label.RIGHT);
	gbconstrain(pay_right_pan, p_label, 0, 0, 1, 1, 
		GridBagConstraints.HORIZONTAL, GridBagConstraints.CENTER, 0.0, 0.0);
		
	pay_right_pan.add(p_label = new Label("Expiry :"));
	p_label.setAlignment(Label.RIGHT);
	gbconstrain(pay_right_pan, p_label, 0, 1, 1, 1, 
		GridBagConstraints.HORIZONTAL, GridBagConstraints.CENTER, 0.0, 0.0);

	TextField pay_tf;
	pay_right_pan.add(pay_tf = new TextField(20));
	gbconstrain(pay_right_pan, pay_tf, 1, 0, 1, 1, 
		GridBagConstraints.HORIZONTAL, GridBagConstraints.CENTER, 0.0, 0.0);
	pay_right_pan.add(pay_tf = new TextField(20));
	gbconstrain(pay_right_pan, pay_tf, 1, 1, 1, 1, 
		GridBagConstraints.HORIZONTAL, GridBagConstraints.CENTER, 0.0, 0.0);

	pay_topright_pan.add("North", pay_right_pan);
	pay_pan.add(pay_topright_pan);

	Button pay_button;
	pay_pan.add(pay_button = new Button("Prev"));
	pay_button.reshape(175, 200, 50, 20);
	pay_pan.add(pay_button = new Button("Next"));
	pay_button.reshape(275, 200, 50, 20);
	

	// The Mailing Card

	Panel mail_pan = new Panel();
	mail_pan.setLayout(null);

	Panel mail_top_pan = new Panel();
	mail_top_pan.reshape(0, 0, 485, 200);
	mail_top_pan.setLayout(new BorderLayout());
	Panel mail_sub_pan = new Panel();
	mail_sub_pan.setLayout(new GridBagLayout());

	Label m_label;
	mail_sub_pan.add(m_label = new Label("Name :"));
	m_label.setAlignment(Label.RIGHT);
	gbconstrain(mail_sub_pan, m_label, 0, 0, 1, 1,GridBagConstraints.HORIZONTAL,
		GridBagConstraints.NORTH, 0.0, 0.0);
	mail_sub_pan.add(m_label = new Label("Company :"));
	m_label.setAlignment(Label.RIGHT);
	gbconstrain(mail_sub_pan, m_label, 0, 1, 1, 1,GridBagConstraints.HORIZONTAL,
		GridBagConstraints.NORTH, 0.0, 0.0);
	mail_sub_pan.add(m_label = new Label("Mailing Address :"));
	m_label.setAlignment(Label.RIGHT);
	gbconstrain(mail_sub_pan, m_label, 0, 2, 1, 1,GridBagConstraints.HORIZONTAL,
		GridBagConstraints.NORTH, 0.0, 0.0);
	mail_sub_pan.add(m_label = new Label("Comments :"));
	m_label.setAlignment(Label.RIGHT);
	gbconstrain(mail_sub_pan, m_label, 0, 3, 1, 1,GridBagConstraints.HORIZONTAL,
		GridBagConstraints.NORTH, 0.0, 0.0);

	TextField mail_tf;
	TextArea mail_ta;
	mail_sub_pan.add(mail_tf = new TextField());
	gbconstrain(mail_sub_pan, mail_tf, 1, 0, 1, 1,GridBagConstraints.HORIZONTAL,
		GridBagConstraints.CENTER, 0.0, 0.0);
	mail_sub_pan.add(mail_tf = new TextField());
	gbconstrain(mail_sub_pan, mail_tf, 1, 1, 1, 1,GridBagConstraints.HORIZONTAL,
		GridBagConstraints.CENTER, 0.0, 0.0);
	mail_sub_pan.add(mail_ta = new TextArea(3, 45));
	gbconstrain(mail_sub_pan, mail_ta, 1, 2, 1, 1,GridBagConstraints.BOTH,
		GridBagConstraints.CENTER, 0.0, 0.0);
	mail_sub_pan.add(mail_ta = new TextArea(3, 45));
	gbconstrain(mail_sub_pan, mail_ta, 1, 3, 1, 1,GridBagConstraints.BOTH,
		GridBagConstraints.CENTER, 0.0, 0.0);

	mail_top_pan.add("North", mail_sub_pan);
	mail_pan.add(mail_top_pan);

	Button mail_button;
	mail_pan.add(mail_button = new Button("Prev"));
	mail_button.reshape(175, 200, 50, 20);
	mail_pan.add(mail_button = new Button("Next"));
	mail_button.reshape(275, 200, 50, 20);

	mail_pan.resize(485, 225);


	// The Shipping Card

	Panel ship_pan = new Panel();

	ship_pan.setLayout(null);
	
	Label ship_label;
	ship_pan.add(ship_label = new Label("Shipping Methods", Label.LEFT));
	ship_label.reshape(0, 0, 200, 20);
	CheckboxGroup ship_grp = new CheckboxGroup();
	Checkbox c;
	c = new Checkbox("UPS");
	c.setCheckboxGroup(ship_grp);
	c.reshape(0, 30, 150, 20);
	ship_pan.add(c);
	c = new Checkbox("Air Mail");
	c.setCheckboxGroup(ship_grp);
	c.reshape(150, 30, 150, 20);
	ship_pan.add(c);
	c = new Checkbox("Surface Mail");
	c.setCheckboxGroup(ship_grp);
	c.reshape(300, 30, 150, 20);
	ship_pan.add(c);

	Label ship_opt_label;
	ship_pan.add(ship_opt_label = new Label("Shipping Options", Label.LEFT));
	ship_opt_label.reshape(0, 70, 200, 20);
	Checkbox c2;
	c2 = new Checkbox("Insurance ($5.00)");
	c2.reshape(0, 100, 225, 20);
	ship_pan.add(c2);
	c2 = new Checkbox("Extra Padding ($5.00)");
	c2.reshape(225, 100, 225, 20);
	ship_pan.add(c2);

	Button ship_button;
	ship_pan.add(ship_button = new Button("Prev"));
	ship_button.reshape(175, 200, 50, 20);
	ship_pan.add(ship_button = new Button("Next"));
	ship_button.reshape(275, 200, 50, 20);


	// The Send Card
	
	send_pan = new Panel();
	send_pan.setLayout(null);

	Panel send_list_pan = new Panel();
	send_list_pan.setLayout(new GridLayout(1, 1));
	send_list_pan.resize(485, 150);
	send_list_pan.add(sw = new List(4, false));
	sw.setBackground(Color.white);
	sw.setFont(new Font("Courier", Font.PLAIN, 12));
	send_pan.add(send_list_pan);
	send_pan.add(order_button = new Button("Send Order"));
	order_button.reshape(200, 160, 100, 20);
	
	Button send_button;
	send_pan.add(send_button = new Button("Prev"));
	send_button.reshape(175, 200, 50, 20);
	send_pan.add(send_button = new Button("Next"));
	send_button.reshape(275, 200, 50, 20);


	// Finish setting up the cards

	tabman.add("Payment", pay_pan);
	tabman.add("Mailing", mail_pan);
	tabman.add("Shipping", ship_pan);
	tabman.add("Send", send_pan);

	tm_pan.add("Center", tabman);

	add("South", tm_pan);
}

// Set the constraints on a component in a GridBag Layout.
private void gbconstrain(Container container, Component component,
		int x, int y, int w, int h, int fill, int anchor,
		double wx, double wy)
{
	GridBagConstraints gbc = new GridBagConstraints();

	gbc.gridx = x;
	gbc.gridy = y;
	gbc.gridwidth = w;
	gbc.gridheight = h;
	gbc.fill = fill;
	gbc.anchor = anchor;
	gbc.weightx = wx;
	gbc.weighty = wy;

	((GridBagLayout)container.getLayout()).setConstraints(component, gbc);
}

// Strip the leading spaces from a string
private String stripLead(String s)
{
	int i = 0;
	while ((i < s.length()) && (s.charAt(i) == ' ')) {
		i++;
	}

	if (i < s.length()) {
		return (s.substring(i));
	} else {
		return "";
	}
}

// Convert the quantity string to an integer
private int qtyStringToInt(String qtyString)
{
	qtyString = stripLead(qtyString);

	int qty = 0;
	try {
		qty = Integer.valueOf(qtyString).intValue();
	} catch (NumberFormatException e) {}

	return qty;
}

// Convert the price string to a float
private float priceStringToFloat(String priceString)
{
	priceString = stripLead(priceString);

	float price = 0;
	try {
		price = Float.valueOf(priceString.substring(1)).floatValue();
	} catch (Exception e) {}

	return price;
}

// Update the price text field from a list selection
private void updatePriceFieldFromList()
{
	String v = list.getSelectedItem();
	if (v != null) {
		qty_text.setText(v.substring(qtyPos, qtyPos + qtyLength));
		price_text.setText(v.substring(pricePos, pricePos + priceLength));

		updatePriceField(v.substring(qtyPos, qtyPos + qtyLength), 
						v.substring(pricePos, pricePos + priceLength));
	}
}

// Update the price text field from an entry in the quantity text field
private void updatePriceFieldFromField()
{
	String v = list.getSelectedItem();
	if (v != null) {
		updatePriceField(qty_text.getText(), v.substring(pricePos, 
												pricePos + priceLength));
	}
}

// Update the price text field with new data
private void updatePriceField(String qtyString, String priceString) 
{
	int qty = qtyStringToInt(qtyString);

	float price = priceStringToFloat(priceString);

	total_text.setText("$" + (price * qty));
}

// Replace the quantity field in the list
private void replaceListQty(int qty, String v, int index)
{
	String newString = new String(v.substring(0, qtyPos));
	String qtyString = String.valueOf(qty);
	newString += padFront(qtyString, qtyLength) + " ";
	newString += v.substring(qtyPos + qtyLength + 1);
	list.replaceItem(newString, index);
	list.select(index);
}

// Pad the end of a string to the given length
private String padBack(String s, int len)
{
	for (int i = s.length(); i < len; i++) {
		s += " ";
	}
	return s;
}

// Pad the beginning of a string to the given length
private String padFront(String s, int len)
{
	String pad_string = new String("");

	for (int i = 0; i < len - s.length(); i++) {
		pad_string += " ";
	}
	return (pad_string + s);
}

// Total up the order and place in the send list
private void totalOrder()
{
	float totalPrice = 0;
	boolean orderExists = false;
	sw.clear();
	for (int i = 0; i < list.countItems(); i++) {
		String thisItem = list.getItem(i);
		String qtyString = 
			thisItem.substring(qtyPos, qtyPos + qtyLength);
		int qty = qtyStringToInt(qtyString);

		if (qty > 0) {
			orderExists = true;
			String oneOrder = new String("");

			oneOrder +=
				thisItem.substring(titlePos, 
								titlePos + titleLength) + " ";
			oneOrder += qtyString + " ";
			String priceString =
				thisItem.substring(pricePos, 
								pricePos + priceLength);
			float price = priceStringToFloat(priceString);
			oneOrder += "@ " + priceString;
			oneOrder += " = ";
			oneOrder += "$ " + (qty * price);
			totalPrice += (qty * price);

			sw.addItem(oneOrder);
		}
	}
	if (orderExists) {
		sw.addItem("");
		String sumLine = new String("");
		sumLine += padBack("Order Total", titleLength) + " ";
		sumLine += padFront("", qtyLength) + " ";
		sumLine += "  ";
		sumLine += padFront("", priceLength);
		sumLine += "   ";
		sumLine += "$ " + totalPrice;
		sw.addItem(sumLine);
	}
}

public boolean handleEvent(Event event)
{
	switch (event.id) {
		case Event.KEY_RELEASE :
		{
			if (event.target == qty_text) {
				updatePriceFieldFromField();
				return true;
			}
			break;
		}
		case Event.ACTION_EVENT :
		{
			if (event.target == pay_card_button) {
				card_layout.show(tabman, "Payment");
				return true;
			} else if (event.target == mail_card_button) {
				card_layout.show(tabman, "Mailing");
				return true;
			} else if (event.target == ship_card_button) {
				card_layout.show(tabman, "Shipping");
				return true;
			} else if (event.target == send_card_button) {
				card_layout.show(tabman, "Send");

				totalOrder();

				return true;
			} else if (event.target == list) {
				String v = null;
				int index = list.getSelectedIndex();
		
				if (index >= 0)
					v = list.getItem(index);
				if (v != null) {
					int qty = qtyStringToInt(v.substring(qtyPos, qtyPos + 3));
					replaceListQty(qty + 1, v, index);
				}
				updatePriceFieldFromList();
				return true;
			} else if (event.target == add_button) {
				String v = null;
				int index = list.getSelectedIndex();
		
				if (index >= 0)
					v = list.getItem(index);

				if (v != null) {
					int qty = qtyStringToInt(qty_text.getText());

					replaceListQty(qty, v, index);
				}
				return true;
			} else if (event.target == order_button) {
				return true;
			} else if ((event.target instanceof Button) &&
				(((Button)event.target).getLabel().compareTo("Prev") == 0)) {
				card_layout.previous(tabman);
			} else if ((event.target instanceof Button) &&
				(((Button)event.target).getLabel().compareTo("Next") == 0)) {
				card_layout.next(tabman);
				if (send_pan.isShowing()) {
					totalOrder();
				}
			}
			break;
		}
		case Event.LIST_SELECT :
		{
			if (event.target == list) {
				updatePriceFieldFromList();
				return true;
			}
			break;
		}
	}

	return super.handleEvent(event);
}

public Insets insets() {
	return new Insets(5,5,5,5);
}

public static void main(String args[]) {
	ContribFrame frame = new ContribFrame("AWT Demo");
	awtgui g = new awtgui();
	g.init();

	frame.add(g);
	frame.pack();
	frame.show();
}
}

