/*-----------------------------------------------------------*/
/* PROGRAM NAME:  SOFTDIST.C                                 */
/* IBM TeamConnection Packaging Tool Build Script            */
/* for Tivoli Software Distribution                          */
/*-----------------------------------------------------------*/
/*                 IBM VisualAge TeamConnection              */
/*                 Version 3 Release 0                       */
/*                    5622-717                               */
/*                                                           */
/* (C) Copyright, IBM Corp., 1998. All Rights Reserved.      */
/*          Licensed Materials - Property of IBM             */
/*         US Government Users Restricted Rights             */
/*  - Use, duplication or disclosure restricted by           */
/*      GSA ADP Schedule Contract with IBM Corp.             */
/*                                                           */
/*          IBM is a registered trademark of                 */
/*     International Business Machines Corporation           */
/*                                                           */
/* DISCLAIMER OF WARRANTIES:                                 */
/*  The following enclosed code is sample code created       */
/*  by IBM Corporation.  This sample code is not part of     */
/*  any standard product and is provided to you solely       */
/*  for the purpose of assisting you in the development      */
/*  of your applications.  The code is provide "AS IS",      */
/*  without warranty of any kind. IBM shall not be           */
/*  liable for any damages arising out of your use           */
/*  of the sample code                                       */
/*-----------------------------------------------------------*/
/*                                                           */
/* Usage:                                                    */
/*  TeamConnection functional improvements include special   */
/*  packaging tools to help with the automation of           */
/*  preparing and electronically distributing TeamConnection */
/*  built deliverables.  This build script is the SOFTDIST   */
/*  build script to be used to invoke the SOFTDIST           */
/*  packaging support (provided by teamcpak) when            */
/*  it is being invoked from a TeamConnection translate      */
/*  definition associated with a build object.               */
/*-----------------------------------------------------------*/
/* Inputs from the environment                               */
/*      TC_INPUT                                             */
/*                                                           */
/* Inputs from the argument list                             */
/*      PARMS                                                */
/*                                                           */
/*  TC_INPUT contains inputs stored in the library that      */
/*   are input to the translator build step.                 */
/*  PARMS are translator options that are specified          */
/*   on the TeamConnection builder definition.               */
/*                                                           */
/* Returns:                                                  */
/*  return code from the translator execution                */
/*-----------------------------------------------------------*/

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

/* Modify the next line to change the translator to invoke */
#define TRANSLATOR      "teamcpak"

/*------------------------------------------------------*/
/* Routine: buildInputFile                              */
/*                                                      */
/* Function:                                            */
/*  This function parses TC_INPUT and writes the inputs */
/*  to a temporary file which is passed to the          */
/*  translator.                                         */
/*                                                      */
/* Returns:                                             */
/*  return code from file processing                    */
/*------------------------------------------------------*/
int buildInputFile(char *tc_input,
                   char **fileName)
{
  FILE     *target;
  char     *string;
  char     *elem;

  /* get a unique temporary file name */
  *fileName = tempnam("", "soft");
  if (!fileName)
  {
    printf("Cannot create a temporary file name for input list.\n");
    return 4;
  }

  /* open file to write tc_input list */
  if ((target = fopen(*fileName, "w")) == NULL )
  {
    printf("Open failed for %s\n",fileName);
    return 1;
  }

  /* make a copy of the input file list */
  string = strdup(tc_input);

  /* process each token in the string */
  elem = strtok(string, " ");
  while (elem != NULL)
  {
    if (fprintf(target,"%s\n",elem) < 0) {
      printf("Write failed for \n",fileName);
      fclose(target);
      return 2;
    }
    elem = strtok(NULL, " ");
  }


  if (fclose(target)) {
    printf("Close failed for \n",fileName);
    return 3;
  }

  return 0;
}



int main (int argc, char *argv[])
{

  int     count, rc=0;
  char   *tc_input;
  char    parms[1025];
  char   *cmd=NULL;
  char    cmdString[100]= " ";
  char   *inputFile=NULL;

  parms[0]='\0';

  /* get the TeamConnection parameters from the environment       */
  tc_input  = getenv("TC_INPUT");
  if (!tc_input) {
    printf("ERROR - TC_INPUT has no value");
    return 20;
  }

  /* collect the parameters passed in when            */
  /* the build script is executed                     */
  for (count = 1; count < argc; count++)
  {
     strcat(parms,argv[count]);
     strcat(parms," ");
  }

  strcpy(cmdString, TRANSLATOR);

  if ( (strlen(cmdString) + strlen(parms)
      + strlen("softdist") + strlen(tc_input) + 9) > 1023)
  {
    strcat(cmdString, " -i ");

    if ( !(rc == buildInputFile(tc_input,&inputFile)) ) {
      if (inputFile) {
        remove(inputFile);
        free(inputFile);
      }
      inputFile = NULL;
      return rc;
    }
  }

  strcat(cmdString, " -o ");
  strcat(cmdString, "\" ");
  strcat(cmdString, parms);
  strcat(cmdString, " \" ");
  strcat(cmdString, "softdist ");

  if (inputFile) {
     /* build the command to be executed */
    cmd  = (char *) malloc((strlen(cmdString)+strlen(inputFile)+100) *sizeof(char));
    sprintf(cmd,"%s %s",cmdString,inputFile);
  }
  else {
     /* build the command to be executed */
     cmd  = (char *) malloc((strlen(cmdString)+strlen(tc_input)+100) *sizeof(char));
     sprintf(cmd,"%s %s",cmdString,tc_input);
  }

  printf("Cmd = %s\n",cmd);
  fflush(stdout);

  /* invoke the translator */
  rc = system(cmd);
 
#if defined(__UNIX__)
  rc = rc >> 8;  /*For UNIX you must shift bits to get a return code the shell can
use */
#endif 
  free(cmd);
  if (inputFile) {
    remove(inputFile);
    free(inputFile);
  }

  /* return the rc from the command invocation */
  return rc;
}
