/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vatc.reuse.awt;

import com.ibm.vatc.reuse.awt.HotSpot;
import com.ibm.vatc.reuse.awt.PageVerifier;
import com.ibm.vatc.reuse.awt.support.NBBoundLook;
import com.ibm.vatc.reuse.awt.support.NBOS2Look;
import com.ibm.vatc.reuse.awt.support.NBRenderer;
import com.ibm.vatc.reuse.awt.support.NBSimpleLook;
import com.ibm.vatc.reuse.awt.support.NBSpiralLook;
import java.awt.AWTEventMulticaster;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Vector;

public class Notebook
extends Panel
implements Serializable,
MouseListener {
    private static String Copyright = "\r\n\r\nLicensed Materials - Property of IBM.\r\n(C) Copyright IBM Corporation 1997.\r\nAll Rights Reserved US Government Users Restricted Rights -\r\nUse, duplication or disclosure\r\nrestricted by GSA ADP Schedule Contract\r\nwith IBM Corp.\r\n\r\n";
    private Vector tabs;
    private Vector bgColors;
    private Vector fgColors;
    private Vector counts;
    private Vector verifierList;
    private Vector pageNames;
    private Vector components;
    private NBRenderer renderer;
    private int pageCounter;
    private int currentTab;
    private int currentPage;
    private CardLayout layout = new CardLayout();
    private int side;
    private int look;
    private int lastTop = -1;
    private HotSpot hsList;
    private ActionListener actionListener;
    public static final int Tab_Click = 0;
    public static final int Up_Click = 1;
    public static final int Down_Click = 2;
    public static final int Page_Backward = 3;
    public static final int Page_Forward = 4;
    public static final int Top = 0;
    public static final int Left = 1;
    public static final int Right = 2;
    public static final int Bottom = 3;
    public static final int Simple = 0;
    public static final int Spiral = 1;
    public static final int Bound = 2;
    public static final String Separator = ".";
    public static final String New_Top_Page = "New Top Page";

    public Notebook() {
        this(0, 0);
    }

    public Notebook(int n, int n2) {
        this.setLayout(this.layout);
        this.tabs = new Vector(10, 5);
        this.bgColors = new Vector(10, 5);
        this.fgColors = new Vector(10, 5);
        this.counts = new Vector(10, 5);
        this.verifierList = new Vector(10, 5);
        this.pageNames = new Vector(10, 5);
        this.components = new Vector(10, 5);
        this.currentTab = 0;
        this.pageCounter = 0;
        this.setOrientationAndStyle(n, n2);
        this.hsList = null;
        this.enableEvents(128L);
        this.addMouseListener(this);
    }

    public void setOrientation(int n) {
        this.setOrientationAndStyle(n, this.look);
    }

    public int getOrientation() {
        return this.side;
    }

    public void setStyle(int n) {
        this.setOrientationAndStyle(this.side, n);
    }

    public int getStyle() {
        return this.look;
    }

    public void setOrientationAndStyle(int n, int n2) {
        this.setSideAndLook(n, n2);
        switch (n2) {
            case 0: {
                this.renderer = new NBSimpleLook(this);
                break;
            }
            case 1: {
                this.renderer = new NBSpiralLook(this);
                break;
            }
            case 2: {
                this.renderer = new NBBoundLook(this);
                break;
            }
        }
        this.currentPage = 1;
        this.showPage();
    }

    private void setSideAndLook(int n, int n2) {
        switch (n2) {
            case 0: {
                if (NBSimpleLook.isSideSupportedForTabs(n)) break;
                throw new IllegalArgumentException("Invalid position for Simple style");
            }
            case 1: {
                if (NBOS2Look.isSideSupportedForTabs(n)) break;
                throw new IllegalArgumentException("Invalid position for Spiral style");
            }
            case 2: {
                if (NBOS2Look.isSideSupportedForTabs(n)) break;
                throw new IllegalArgumentException("Invalid position for Bound style");
            }
            default: {
                throw new IllegalArgumentException("Invalid notebook style");
            }
        }
        this.side = n;
        this.look = n2;
    }

    public void addPage(Object object, Component component, PageVerifier pageVerifier) {
        this.addPage(object, Color.lightGray, Color.black, component, pageVerifier);
    }

    public void addPage(Object object, Color color, Component component, PageVerifier pageVerifier) {
        this.addPage(object, color, Color.black, component, pageVerifier);
    }

    public void addPage(Object object, Color color, Color color2, Component component, PageVerifier pageVerifier) {
        int n = this.tabs.indexOf(object);
        int n2 = 0;
        int n3 = 0;
        if (n < 0) {
            this.tabs.addElement(object);
            this.bgColors.addElement(color);
            this.fgColors.addElement(color2);
            this.counts.addElement(new Integer(0));
            n = this.tabs.size() - 1;
            n2 = 1;
        } else {
            n2 = (Integer)this.counts.elementAt(n) + 1;
        }
        this.counts.setElementAt(new Integer(n2), n);
        n3 = this.linearIndex(n, n2);
        ++this.pageCounter;
        if (n3 > this.components.size() - 1) {
            this.verifierList.addElement(pageVerifier);
            this.pageNames.addElement(new Integer(this.pageCounter));
            this.components.addElement(component);
        } else {
            this.verifierList.insertElementAt(pageVerifier, n3);
            this.pageNames.insertElementAt(new Integer(this.pageCounter), n3);
            this.components.insertElementAt(component, n3);
        }
        super.add(String.valueOf(this.pageCounter), component);
        component.setBackground(Color.lightGray);
        this.showPage();
    }

    public void insertPage(Object object, int n, Object object2, Component component, PageVerifier pageVerifier) {
        this.insertPage(object, n, object2, Color.lightGray, Color.black, component, pageVerifier);
    }

    public void insertPage(Object object, int n, Object object2, Color color, Component component, PageVerifier pageVerifier) {
        this.insertPage(object, n, object2, color, Color.black, component, pageVerifier);
    }

    public void insertPage(Object object, int n, Object object2, Color color, Color color2, Component component, PageVerifier pageVerifier) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        if (object == null) {
            bl = true;
        } else {
            n2 = this.tabs.indexOf(object);
            n4 = this.tabs.indexOf(object2);
            if (n2 < 0) {
                throw new IllegalArgumentException("Invalid notebook page requested.");
            }
            if (n4 >= 0 && n4 != n2) {
                throw new IllegalArgumentException("Tab to insert already exists elsewhere.");
            }
            if (n4 == n2 && (n > (Integer)this.counts.elementAt(n2) || n < 0)) {
                throw new IllegalArgumentException("Invalid notebook page requested.");
            }
            if (n4 < 0) {
                ++n2;
                bl = true;
            } else {
                n5 = n + 1;
                n3 = this.linearIndex(n4, n5);
            }
        }
        if (bl) {
            if (n2 < this.tabs.size()) {
                this.tabs.insertElementAt(object2, n2);
                this.bgColors.insertElementAt(color, n2);
                this.fgColors.insertElementAt(color2, n2);
                this.counts.insertElementAt(new Integer(0), n2);
            } else {
                this.tabs.addElement(object2);
                this.bgColors.addElement(color);
                this.fgColors.addElement(color2);
                this.counts.addElement(new Integer(0));
            }
            n3 = this.linearIndex(n2, 1);
            n5 = 1;
        }
        this.counts.setElementAt(new Integer(n5), n2);
        ++this.pageCounter;
        this.verifierList.insertElementAt(pageVerifier, n3);
        this.pageNames.insertElementAt(new Integer(this.pageCounter), n3);
        this.components.insertElementAt(component, n3);
        super.add(String.valueOf(this.pageCounter), component);
        component.setBackground(Color.lightGray);
        this.showPage();
    }

    public Object getTab() {
        Object var1_1 = null;
        if (this.currentTab < this.tabs.size()) {
            var1_1 = this.tabs.elementAt(this.currentTab);
        }
        return var1_1;
    }

    public Object getTab(int n) {
        if (n < 0 || n >= this.tabs.size()) {
            throw new IllegalArgumentException("Invalid notebook tab requested.");
        }
        return this.tabs.elementAt(n);
    }

    public int getPageInTab() {
        return this.currentPage;
    }

    private int linearIndex() {
        return this.linearIndex(this.currentTab, this.currentPage);
    }

    private int linearIndex(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            n3 += ((Integer)this.counts.elementAt(n4)).intValue();
            ++n4;
        }
        return n3 + n2 - 1;
    }

    private PageVerifier pageVerifier() {
        return (PageVerifier)this.verifierList.elementAt(this.linearIndex());
    }

    private boolean okToFlip(Object object, int n) {
        PageVerifier pageVerifier = this.pageVerifier();
        boolean bl = true;
        if (pageVerifier != null) {
            bl = pageVerifier.isPageChangeAllowed(object, n);
        }
        return bl;
    }

    public Insets getInsets() {
        Insets insets = null;
        insets = this.getFont() == null ? new Insets(0, 0, 0, 0) : this.renderer.getInsets(this.getFontMetrics(this.getFont()));
        return insets;
    }

    public void doLayout() {
        Component[] componentArray = this.getComponents();
        if (componentArray != null) {
            int n = 0;
            while (n < componentArray.length) {
                componentArray[n].doLayout();
                componentArray[n].repaint();
                ++n;
            }
        }
        super.doLayout();
    }

    public void paint(Graphics graphics) {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        Dimension dimension = this.getSize();
        this.hsList = null;
        this.renderer.paintTheLook(graphics, fontMetrics, dimension);
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        boolean bl = super.imageUpdate(image, n, n2, n3, n4, n5);
        if ((n & 0xA0) != 0) {
            this.repaint();
        }
        return bl;
    }

    public void addHotSpot(int n, int n2, int n3, int n4, int n5, Object object) {
        HotSpot hotSpot = new HotSpot(new Rectangle(n, n2, n3, n4), object, n5);
        if (this.hsList == null) {
            this.hsList = hotSpot;
            return;
        }
        hotSpot.addLast(this.hsList);
    }

    public Object[] getTabList() {
        Object[] objectArray;
        Object[] objectArray2 = objectArray = this.tabs.size() == 0 ? null : new Object[this.tabs.size()];
        if (objectArray != null) {
            this.tabs.copyInto(objectArray);
        }
        return objectArray;
    }

    public Color[] getBackgroundColors() {
        Object[] objectArray;
        Object[] objectArray2 = objectArray = this.bgColors.size() == 0 ? null : new Color[this.bgColors.size()];
        if (objectArray != null) {
            this.bgColors.copyInto(objectArray);
        }
        return objectArray;
    }

    public Color[] getForegroundColors() {
        Object[] objectArray;
        Object[] objectArray2 = objectArray = this.fgColors.size() == 0 ? null : new Color[this.fgColors.size()];
        if (objectArray != null) {
            this.fgColors.copyInto(objectArray);
        }
        return objectArray;
    }

    public int getCurrentTab() {
        return this.currentTab;
    }

    public void setStatusText(String string) {
        this.renderer.setStatusText(string);
    }

    public String getStatusText() {
        return this.renderer.getStatusText();
    }

    private void buildStatusBar() {
        if (this.counts.size() > 0 && this.renderer.isStatusLineSupported()) {
            boolean bl = false;
            boolean bl2 = false;
            int n = (Integer)this.counts.elementAt(this.currentTab);
            if (n > 1) {
                this.renderer.setPagingText("Page " + this.currentPage + " of " + n);
            } else {
                this.renderer.setPagingText(null);
            }
            if (n > 1 || this.currentTab < this.tabs.size() - 1) {
                bl2 = true;
            }
            if (this.currentPage > 1 || this.currentTab > 0) {
                bl = true;
            }
            this.renderer.setButtonState(1, bl);
            this.renderer.setButtonState(2, bl2);
        }
    }

    private void showPage() {
        this.buildStatusBar();
        if (this.tabs.size() != 0) {
            int n = this.linearIndex();
            this.layout.show(this, this.pageNames.elementAt(n).toString());
            if (this.lastTop >= 0 && this.lastTop != n) {
                this.processActionEvent(new ActionEvent(this, 1001, New_Top_Page));
            }
            this.lastTop = n;
        }
        this.doLayout();
        this.repaint();
    }

    public String pageShowing() {
        return String.valueOf(this.tabs.elementAt(this.currentTab).toString()) + Separator + this.currentPage;
    }

    public void verifyPage() {
        this.okToFlip(this.tabs.elementAt(this.currentTab), this.currentPage);
    }

    private int verifiedPageRequest(Object object, int n) {
        int n2 = this.tabs.indexOf(object);
        if (n2 >= 0 && (n < 1 || n > (Integer)this.counts.elementAt(n2))) {
            n2 = -1;
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Invalid notebook page requested.");
        }
        return n2;
    }

    public void turnToPage(Object object, int n) {
        int n2 = this.verifiedPageRequest(object, n);
        if (this.okToFlip(object, n)) {
            this.currentTab = n2;
            this.currentPage = n;
            this.showPage();
        }
    }

    public void removePage() {
        this.removePage(this.tabs.elementAt(this.currentTab), this.currentPage);
    }

    public void removePage(Object object, int n) {
        int n2 = this.verifiedPageRequest(object, n);
        int n3 = this.linearIndex(n2, n);
        this.remove((Component)this.components.elementAt(n3));
        if (this.components.size() == 1) {
            this.verifierList.removeAllElements();
            this.pageNames.removeAllElements();
            this.components.removeAllElements();
            this.tabs.removeAllElements();
            this.fgColors.removeAllElements();
            this.bgColors.removeAllElements();
            this.counts.removeAllElements();
            this.currentTab = 0;
            this.currentPage = 1;
            return;
        }
        int n4 = (Integer)this.counts.elementAt(n2) - 1;
        this.verifierList.removeElementAt(n3);
        this.pageNames.removeElementAt(n3);
        this.components.removeElementAt(n3);
        if (n4 == 0) {
            this.tabs.removeElementAt(n2);
            this.bgColors.removeElementAt(n2);
            this.fgColors.removeElementAt(n2);
            this.counts.removeElementAt(n2);
            if (this.currentTab == this.tabs.size()) {
                --this.currentTab;
            }
            this.currentPage = 1;
        } else {
            this.counts.setElementAt(new Integer(n4), n2);
        }
        while (this.currentPage > (Integer)this.counts.elementAt(this.currentTab)) {
            --this.currentPage;
        }
        this.showPage();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        HotSpot hotSpot = this.hsList == null ? null : this.hsList.getTarget(mouseEvent.getPoint());
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        if (hotSpot != null) {
            switch (hotSpot.getType()) {
                case 0: {
                    n = (Integer)hotSpot.getData();
                    n2 = 1;
                    bl = this.okToFlip(this.tabs.elementAt(n), n2);
                    break;
                }
                case 1: {
                    this.renderer.doTabScroll(-1);
                    this.repaint();
                    break;
                }
                case 2: {
                    this.renderer.doTabScroll(1);
                    this.repaint();
                    break;
                }
                case 3: {
                    n = this.currentTab;
                    n2 = this.currentPage;
                    if (n2 == 1) {
                        if (n > 0) {
                            n2 = (Integer)this.counts.elementAt(--n);
                        }
                    } else {
                        --n2;
                    }
                    bl = this.okToFlip(this.tabs.elementAt(n), n2);
                    break;
                }
                case 4: {
                    n = this.currentTab;
                    n2 = this.currentPage;
                    if (n2 == (Integer)this.counts.elementAt(this.currentTab)) {
                        if (n < this.tabs.size() - 1) {
                            ++n;
                            n2 = 1;
                        }
                    } else {
                        ++n2;
                    }
                    bl = this.okToFlip(this.tabs.elementAt(n), n2);
                    break;
                }
            }
            if (bl) {
                this.currentTab = n;
                this.currentPage = n2;
                this.showPage();
                this.repaint();
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(actionEvent);
        }
    }
}

