CREATE TABLE FHCAccess 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     authorityName             VarChar(31)   ,
     authorityType             VarChar(15)   ,
     osrelUserId               DBOID   ,
     osrelCompId               DBOID   ,
     constraint PKFHCAccess Primary Key( OID ) )
     IN AUTH ;

CREATE TABLE FHCApproval 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     state                     VarChar(15)   ,
     addDate                   VarChar(32)   ,
     lastUpdate                VarChar(32)   ,
     osrelUserId               DBOID   ,
     osrelTrackId              DBOID   ,
     constraint PKFHCApproval Primary Key( OID ) )
     IN MODEL ;

CREATE TABLE FHCApprover 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     osrelReleaseId            DBOID   ,
     osrelUserId               DBOID   ,
     constraint PKFHCApprover Primary Key( OID ) )
     IN MODEL ;

CREATE TABLE FHCAuthority 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     name                      VarChar(31)   ,
     action                    VarChar(15)   ,
     constraint PKFHCAuthority Primary Key( OID ) )
     IN AUTH ;

CREATE TABLE FHCBecome 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     addDate                   VarChar(32)   ,
     osrelUserId               DBOID   ,
     osrelBecomeUserId         DBOID   ,
     constraint PKFHCBecome Primary Key( OID ) )
     IN AUTH ;

CREATE TABLE FHCBuilder 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     sequenceId                Int   ,
     description               VarChar(127)   ,
     parameters                VarChar(1025)   ,
     rebuildTimeStamp          VarChar(32)   ,
     addDate                   VarChar(32)   ,
     dropDate                  VarChar(32)   ,
     lastUpdate                VarChar(32)   ,
     buildScript               VarChar(259)   ,
     billOfMaterials           Int   ,
     goodRCEvaluator           VarChar(5)   ,
     rcValue                   VarChar(9)   ,
     bulkType                  Int   ,
     bulkTypeText              VarChar(7)   ,
     environment               VarChar(31)   ,
     timeout                   Int   ,
     processorOptions          VarChar(259)   ,
     pBulkContents             DBOID   ,
     osrelReleaseId            DBOID   ,
     sqlText                   VarChar(259)   ,
     constraint PKFHCBuilder Primary Key( OID ) )
     IN KERNEL ;

CREATE TABLE FHCChange 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     type                      VarChar(11)   ,
     osrelPathId               DBOID   ,
     osrelTrackId              DBOID   ,
     osrelFileId               DBOID   ,
     osrelLevelId              DBOID   ,
     osrelUserId               DBOID   ,
     versionId                 Int   ,
     osrelVersionId            DBOIDC   ,
     constraint PKFHCChange Primary Key( OID ) )
     IN MODEL ;

CREATE TABLE FHCCollision 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     state                     VarChar(15)   ,
     addDate                   VarChar(32)   ,
     lastUpdate                VarChar(32)   ,
     localVersionDate          VarChar(32)   ,
     altVersionDate            VarChar(32)   ,
     osrelFileId               DBOID   ,
     osrelWorkAreaId           DBOID   ,
     osrelAltWorkAreaId        DBOID   ,
     osrelLocalVersinId        DBOID   ,
     osrelAltVersionId         DBOID   ,
     localPartVersionId        DBOIDC   ,
     altPartVersionId          DBOIDC   ,
     resolvedPartVrsnId        DBOIDC   ,
     constraint PKFHCCollision Primary Key( OID ) )
     IN MODEL ;

CREATE TABLE FHCFresh 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     currentOVer               DBOID   ,
     alternateOVer             DBOID   ,
     currentBranchOVer         DBOID   ,
     alternateBranchOVr        DBOID   ,
     osrelFreshWorkArId        DBOID   ,
     osrlAltFrshWrkArId        DBOID   ,
     constraint PKFHCFresh Primary Key( OID ) )
     IN MODEL ;

CREATE TABLE FHCComp 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     name                      VarChar(63)   ,
     description               VarChar(127)   ,
     addDate                   VarChar(32)   ,
     dropDate                  VarChar(32)   ,
     lastUpdate                VarChar(32)   ,
     process                   VarChar(31)   ,
     featureDSR                VarChar(3)   ,
     featureVerify             VarChar(3)   ,
     defectDSR                 VarChar(3)   ,
     defectVerify              VarChar(3)   ,
     osrelUserId               DBOID   ,
     constraint PKFHCComp Primary Key( OID ) )
     IN AUTH ;

CREATE TABLE FHCCompMember 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     rank                      Int   ,
     reference                 Int   ,
     osrelParentId             DBOID   ,
     osrelChildId              DBOID   ,
     constraint PKFHCCompMember Primary Key( OID ) )
     IN AUTH ;

CREATE TABLE FHCCfgComProc 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     name                      VarChar(31)   ,
     config                    VarChar(15)   ,
     constraint PKFHCCfgComProc Primary Key( OID ) )
     IN MODEL ;

CREATE TABLE FHCConfig 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     type                      VarChar(15)   ,
     name                      VarChar(31)   ,
     dflt                      VarChar(3)   ,
     value1                    Int   ,
     value2                    Int   ,
     description               VarChar(127)   ,
     kind                      Int   ,
     driverId                  Int   ,
     driverSeq                 Int   ,
     dependent                 Int   ,
     dependSeq                 Int   ,
     choiceOrder               Int   ,
     helpText                  VarChar(1999)   ,
     constraint PKFHCConfig Primary Key( OID ) )
     IN MODEL ;

CREATE TABLE FHCCoreq 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     groupId                   Int   ,
     osrelTrackId              DBOID   ,
     constraint PKFHCCoreq Primary Key( OID ) )
     IN MODEL ;

CREATE TABLE FHCDefect 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     type                      VarChar(9)   ,
     prefix                    VarChar(31)   ,
     name                      VarChar(31)   ,
     envName                   VarChar(31)   ,
     state                     VarChar(15)   ,
     severity                  VarChar(31)   ,
     abstract                  VarChar(127)   ,
     reference                 VarChar(31)   ,
     answer                    VarChar(31)   ,
     levelName                 VarChar(31)   ,
     notesDB                   VarChar(260)   ,
     notesID                   VarChar(256)   ,
     lastUpdate                VarChar(32)   ,
     addDate                   VarChar(32)   ,
     assignDate                VarChar(32)   ,
     responseDate              VarChar(32)   ,
     endDate                   VarChar(32)   ,
     age                       Int   ,
     duplicate                 VarChar(31)   ,
     osrelCompId               DBOID   ,
     osrelReleaseId            DBOID   ,
     osrelOwnerId              DBOID   ,
     osrelOriginId             DBOID   ,
     constraint PKFHCDefect Primary Key( OID ) )
     IN MODEL ;

CREATE TABLE FHCEnvironment 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     name                      VarChar(31)   ,
     osrelReleaseId            DBOID   ,
     osrelUserId               DBOID   ,
     constraint PKFHCEnvironment Primary Key( OID ) )
     IN MODEL ;

CREATE TABLE FHCFile 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     addDate                   VarChar(32)   ,
     dropDate                  VarChar(32)   ,
     lastUpdate                VarChar(32)   ,
     translation               VarChar(31)   ,
     restricted                VarChar(4)   ,
     osrelCompId               DBOID   ,
     osrelReleaseId            DBOID   ,
     osrelPathId               DBOID   ,
     osrelFilesOutId           DBOID   ,
     osrelCollectorId          DBOID   ,
     osrelTipVersionId         DBOIDC   ,
     constraint PKFHCFile Primary Key( OID ) )
     IN AUTH ;

CREATE TABLE FHCFix 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     state                     VarChar(15)   ,
     addDate                   VarChar(32)   ,
     lastUpdate                VarChar(32)   ,
     osrelTrackId              DBOID   ,
     osrelUserId               DBOID   ,
     osrelCompId               DBOID   ,
     constraint PKFHCFix Primary Key( OID ) )
     IN MODEL ;

CREATE TABLE FHCFilesOut 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     userId                    Int   ,
     checkOutDate              VarChar(32)   ,
     osrelFileId               DBOID   ,
     osrelSeqFileId            DBOID   ,
     osrelUserId               DBOID   ,
     osrelOVersionId           DBOID   ,
     constraint PKFHCFilesOut Primary Key( OID ) )
     IN MODEL ;

CREATE TABLE FHCHistory 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     action                    VarChar(16)   ,
     addDate                   VarChar(26)   ,
     osrelDefectId             DBOID   ,
     osrelUserId               DBOID   ,
     constraint PKFHCHistory Primary Key( OID ) )
     IN MODEL ;

CREATE TABLE FHCHost 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     name                      VarChar(127)   ,
     loginType                 VarChar(15)   ,
     login                     VarChar(31)   ,
     address                   Int   ,
     osrelUserId               DBOID   ,
     constraint PKFHCHost Primary Key( OID ) )
     IN AUTH ;

CREATE TABLE FHCInterest 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     name                      VarChar(31)   ,
     action                    VarChar(15)   ,
     constraint PKFHCInterest Primary Key( OID ) )
     IN MODEL ;

CREATE TABLE FHCLevel 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     name                      VarChar(31)   ,
     addDate                   VarChar(32)   ,
     commitDate                VarChar(32)   ,
     lastUpdate                VarChar(32)   ,
     state                     VarChar(15)   ,
     type                      VarChar(31)   ,
     levelSize                 Int   ,
     osrelWorkAreaId           DBOID   ,
     osrelOVersionId           DBOID   ,
     osrelUserId               DBOID   ,
     osrelReleaseId            DBOID   ,
     constraint PKFHCLevel Primary Key( OID ) )
     IN MODEL ;

CREATE TABLE FHCLevelMember 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     osrelLevelId              DBOID   ,
     osrelTrackId              DBOID   ,
     osrelOVersionId           DBOID   ,
     workAreaOVersionId        DBOID   ,
     constraint PKFHCLevelMember Primary Key( OID ) )
     IN MODEL ;

CREATE TABLE FHCNote 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     action                    VarChar(15)   ,
     addDate                   VarChar(32)   ,
     remarks                   Long VarChar   ,
     osrelDefectId             DBOID   ,
     osrelUserId               DBOID   ,
     constraint PKFHCNote Primary Key( OID ) )
     IN MODEL ;

CREATE TABLE FHCNotify 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     interestName              VarChar(31)   ,
     osrelCompId               DBOID   ,
     osrelUserId               DBOID   ,
     constraint PKFHCNotify Primary Key( OID ) )
     IN MODEL ;

CREATE TABLE FHCParser 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     sequenceId                Int   ,
     addDate                   VarChar(32)   ,
     dropDate                  VarChar(32)   ,
     lastUpdate                VarChar(32)   ,
     description               VarChar(127)   ,
     parserCommand             VarChar(259)   ,
     parserIncludes            VarChar(519)   ,
     osrelReleaseId            DBOID   ,
     constraint PKFHCParser Primary Key( OID ) )
     IN KERNEL ;

CREATE TABLE FHCPath 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     name                      VarChar(196)   ,
     baseName                  VarChar(128)   ,
     constraint PKFHCPath Primary Key( OID ) )
     IN KERNEL ;

CREATE TABLE FHCPrereq 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     osrelTrackId              DBOID   ,
     osrelPrereqId             DBOID   ,
     constraint PKFHCPrereq Primary Key( OID ) )
     IN MODEL ;

CREATE TABLE FHCRelease 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     name                      VarChar(32)   ,
     binding                   VarChar(4)   ,
     description               VarChar(128)   ,
     addDate                   VarChar(32)   ,
     dropDate                  VarChar(32)   ,
     lastUpdate                VarChar(32)   ,
     relSize                   Int   ,
     process                   VarChar(32)   ,
     track                     VarChar(4)   ,
     approve                   VarChar(4)   ,
     fix                       VarChar(4)   ,
     lvl                       VarChar(4)   ,
     test                      VarChar(4)   ,
     developmentMode           VarChar(16)   ,
     autoPrune                 VarChar(4)   ,
     coupling                  VarChar(32)   ,
     outputVersions            VarChar(16)   ,
     versionSequence           Int   ,
     pVRootAnchor              DBOID   ,
     pTipOVer                  DBOID   ,
     osrelUserId               DBOID   ,
     osrelCompId               DBOID   ,
     osrelShadows              DBOID   ,
     constraint PKFHCRelease Primary Key( OID ) )
     IN KERNEL ;

CREATE TABLE FHCCfgRelProc 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     name                      VarChar(31)   ,
     config                    VarChar(15)   ,
     constraint PKFHCCfgRelProc Primary Key( OID ) )
     IN MODEL ;

CREATE TABLE FHCProcess 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     name                      VarChar(32)   ,
     config                    VarChar(16)   ,
     constraint PKFHCProcess Primary Key( OID ) )
     IN MODEL ;

CREATE TABLE FHCSequence 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     name                      VarChar(15)   ,
     lastSerial                Int   ,
     constraint PKFHCSequence Primary Key( OID ) )
     IN MODEL ;

CREATE TABLE FHCShadow 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     name                      VarChar(31)   ,
     osrelReleaseId            DBOID   ,
     osrelShadowTypeId         DBOID   ,
     mode                      VarChar(15)   ,
     priority                  Int   ,
     state                     VarChar(15)   ,
     location                  VarChar(511)   ,
     drivers                   VarChar(3)   ,
     workareas                 VarChar(3)   ,
     release                   VarChar(3)   ,
     crlf                      VarChar(3)   ,
     keys                      VarChar(3)   ,
     timestamp                 VarChar(15)   ,
     parameters                VarChar(511)   ,
     constraint PKFHCShadow Primary Key( OID ) )
     IN MODEL ;

CREATE TABLE FHCShadowPart 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     osrelShadowId             DBOID   ,
     osrelCollectorId          DBOID   ,
     osrelWorkAreaId           DBOID   ,
     osrelPathId               DBOID   ,
     pBulk                     DBOID   ,
     SID                       VarChar(47)   ,
     shadowTimeStamp           VarChar(32)   ,
     fmode                     VarChar(4)   ,
     lastUpdate                VarChar(32)   ,
     constraint PKFHCShadowPart Primary Key( OID ) )
     IN MODEL ;

CREATE TABLE FHCShadowType 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     name                      VarChar(31)   ,
     description               VarChar(127)   ,
     program                   VarChar(255)   ,
     constraint PKFHCShadowType Primary Key( OID ) )
     IN MODEL ;

CREATE TABLE FHCSize 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     addDate                   VarChar(32)   ,
     lastUpdate                VarChar(32)   ,
     state                     VarChar(7)   ,
     sizing                    VarChar(127)   ,
     osrelDefectId             DBOID   ,
     osrelUserId               DBOID   ,
     osrelCompId               DBOID   ,
     osrelReleaseId            DBOID   ,
     constraint PKFHCSize Primary Key( OID ) )
     IN MODEL ;

CREATE TABLE FHCTest 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     envName                   VarChar(31)   ,
     state                     VarChar(15)   ,
     addDate                   VarChar(32)   ,
     lastUpdate                VarChar(32)   ,
     osrelTrackId              DBOID   ,
     osrelUserId               DBOID   ,
     constraint PKFHCTest Primary Key( OID ) )
     IN MODEL ;

CREATE TABLE FHCTrack 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     state                     VarChar(15)   ,
     target                    VarChar(31)   ,
     actual                    VarChar(31)   ,
     addDate                   VarChar(32)   ,
     lastUpdate                VarChar(32)   ,
     osrelWorkAreaId           DBOID   ,
     osrelDefectId             DBOID   ,
     osrelReleaseId            DBOID   ,
     osrelUserId               DBOID   ,
     constraint PKFHCTrack Primary Key( OID ) )
     IN MODEL ;

CREATE TABLE FHCUser 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     login                     VarChar(32)   ,
     name                      VarChar(64)   ,
     superUser                 VarChar(4)   ,
     area                      VarChar(32)   ,
     address                   VarChar(160)   ,
     addressType               VarChar(16)   ,
     addDate                   VarChar(32)   ,
     dropDate                  VarChar(32)   ,
     lastUpdate                VarChar(32)   ,
     AuthType                  VarChar(16)   ,
     pswStatus                 VarChar(16)   ,
     pswModifyTime             VarChar(64)   ,
     pswCreateTime             VarChar(64)   ,
     pswFailCount              Int   ,
     pswBlock                  Blob(64) COMPACT    ,
     crc                       Int   ,
     constraint PKFHCUser Primary Key( OID ) )
     IN AUTH ;

CREATE TABLE FHCVerify 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     type                      VarChar(15)   ,
     state                     VarChar(15)   ,
     addDate                   VarChar(32)   ,
     lastUpdate                VarChar(32)   ,
     osrelDefectId             DBOID   ,
     osrelUserId               DBOID   ,
     constraint PKFHCVerify Primary Key( OID ) )
     IN MODEL ;

CREATE TABLE FHCWorkArea 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     name                      VarChar(32)   ,
     versionSequence           Int   ,
     osrelReleaseId            DBOID   ,
     osrelBranchPointId        DBOID   ,
     osrelTrackId              DBOID   ,
     osrelLevelId              DBOID   ,
     pTipOVer                  DBOID   ,
     constraint PKFHCWorkArea Primary Key( OID ) )
     IN KERNEL ;

CREATE TABLE FHCFileOverrideR 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     osrelFileId               DBOID   ,
     osrelReleaseId            DBOID   ,
     osrelWorkAreaId           DBOID   ,
     osrelUserId               DBOID   ,
     constraint PKFHCFileOverrideR Primary Key( OID ) )
     IN MODEL ;

CREATE TABLE fdcOIDMapEntry 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     aName                     VarChar(196)   ,
     aOIDPattern               Int   ,
     constraint PKfdcOIDMapEntry Primary Key( OID ) )
     IN KERNEL ;

CREATE TABLE FHCSecurity 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     osrelUserId               DBOID   ,
     sessionId                 Int   ,
     constraint PKFHCSecurity Primary Key( OID ) )
     IN MODEL ;

CREATE TABLE TCTarget 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     targetName                VarChar(110)   ,
     status                    VarChar(110)   ,
     active                    VarChar(110)   ,
     targetDate                VarChar(32)   ,
     osrelSourceObjctId        DBOID   ,
     constraint PKTCTarget Primary Key( OID ) )
     IN MODEL ;

