CREATE TABLE TCSubsystem_versin   -- TCSubsystem_version
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     subsystemDll              VarChar(254)   ,
     viewCDLFiles              VarChar(600)   ,
     constraint PKTCSubsystem_vrsn Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE TABLE TCMetaClass_versin   -- TCMetaClass_version
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     attrMask                  Int   ,
     cHppPassText              VarChar(254)   ,
     cCppPassText              VarChar(254)   ,
     sHppPassText              VarChar(254)   ,
     sCppPassText              VarChar(254)   ,
     pMetaToSys                DBOID   ,
     pParent                   DBOID   ,
     constraint PKTCMetaClass_vrsn Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE TABLE TCAttribute 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     adName                    VarChar(254)   ,
     attribType                VarChar(254)   ,
     attrMask                  Int   ,
     attrTypeLen               Int   ,
     pAttribsMClass            DBOID   ,
     constraint PKTCAttribute Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_TCAttribute AS --Plasma for TCAttribute
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    TCAttribute a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE TCRelationship 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     relRetClass               VarChar(254)   ,
     relInvRel                 VarChar(254)   ,
     relClass                  VarChar(254)   ,
     minValue                  Int   ,
     maxValue                  Int   ,
     relCard                   Int   ,
     relSubsysName             VarChar(254)   ,
     invRelClassSbsysNm        VarChar(254)   ,
     pRelsMClass               DBOID   ,
     pRelSrcTgt                DBOID   ,
     constraint PKTCRelationship Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_TCRelationship AS --Plasma for TCRelationship
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    TCRelationship a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE TCMethod 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     adName                    VarChar(254)   ,
     methodRetType             VarChar(254)   ,
     methodParms               VarChar(254)   ,
     attrMask                  Int   ,
     pMethodsMClass            DBOID   ,
     constraint PKTCMethod Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_TCMethod AS --Plasma for TCMethod
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    TCMethod a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE TCSrcTgtAttr 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     attribSrcTgt              VarChar(254)   ,
     pRelMetaClass             DBOID   ,
     pSrcTgtRel                DBOID   ,
     constraint PKTCSrcTgtAttr Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_TCSrcTgtAttr AS --Plasma for TCSrcTgtAttr
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    TCSrcTgtAttr a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE TCClassConstraint 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     methodNames               VarChar(254)   ,
     constraintMask            Int   ,
     pConstrainedClass         DBOID   ,
     constraint PKTCClassConstrant Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_TCClassConstrnt AS --Plasma for TCClassConstraint
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    TCClassConstraint a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE TCAttrConstraint 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     methodNames               VarChar(254)   ,
     pConstrainingClass        DBOID   ,
     pConstraintAttr           DBOID   ,
     constraint PKTCAttrConstraint Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_TCAttrConstrant AS --Plasma for TCAttrConstraint
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    TCAttrConstraint a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

