/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vatc.tcmerge;

import com.ibm.vatc.tcmerge.MergeGui;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;

class ScrollPanel
extends Panel
implements AdjustmentListener {
    protected Scrollbar vAdj;
    protected Scrollbar hAdj;
    protected Component paintArea;
    MergeGui mergeGui;

    public ScrollPanel(MergeGui mergeGui) {
        this.mergeGui = mergeGui;
        BorderLayout borderLayout = new BorderLayout(0, 0);
        this.setLayout(borderLayout);
        this.hAdj = new Scrollbar();
        this.hAdj.setOrientation(0);
        this.vAdj = new Scrollbar();
        this.vAdj.setOrientation(1);
        this.hAdj.setValue(0);
        this.vAdj.setValue(0);
        this.add("East", this.vAdj);
        this.add("South", this.hAdj);
        this.vAdj.addAdjustmentListener(this);
        this.hAdj.addAdjustmentListener(this);
    }

    public void requestFocus() {
        this.paintArea.requestFocus();
    }

    public void setPaintArea(Canvas canvas) {
        this.paintArea = canvas;
    }

    public Scrollbar getVAdjustable() {
        return this.vAdj;
    }

    public Scrollbar getHAdjustable() {
        return this.hAdj;
    }

    public Point getScrollPosition() {
        return new Point(this.hAdj.getValue(), this.vAdj.getValue());
    }

    public void setScrollPosition(int n, int n2) {
        this.hAdj.setValue(n);
        this.vAdj.setValue(n2);
    }

    public int getVVisibleAmount() {
        return this.paintArea.getSize().height;
    }

    public int getHVisibleAmount() {
        return this.paintArea.getSize().width;
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent.getAdjustable() == this.vAdj) {
            switch (adjustmentEvent.getAdjustmentType()) {
                case 3: {
                    int n = this.vAdj.getValue();
                    this.vAdj.setValue(n);
                    this.paintArea.repaint();
                    return;
                }
                case 4: {
                    int n = this.vAdj.getValue();
                    this.vAdj.setValue(n);
                    this.paintArea.repaint();
                    return;
                }
                case 2: {
                    int n = this.vAdj.getValue();
                    this.vAdj.setValue(n);
                    this.paintArea.repaint();
                    return;
                }
                case 1: {
                    int n = this.vAdj.getValue();
                    this.vAdj.setValue(n);
                    this.paintArea.repaint();
                    return;
                }
                case 5: {
                    int n = this.vAdj.getValue();
                    this.vAdj.setValue(n);
                    this.paintArea.repaint();
                    return;
                }
                default: {
                    return;
                }
            }
        }
        if (adjustmentEvent.getAdjustable() == this.hAdj) {
            switch (adjustmentEvent.getAdjustmentType()) {
                case 3: {
                    int n = this.hAdj.getValue();
                    this.hAdj.setValue(n);
                    this.paintArea.repaint();
                    return;
                }
                case 4: {
                    int n = this.hAdj.getValue();
                    this.hAdj.setValue(n);
                    this.paintArea.repaint();
                    return;
                }
                case 2: {
                    int n = this.hAdj.getValue();
                    this.hAdj.setValue(n);
                    this.paintArea.repaint();
                    return;
                }
                case 1: {
                    int n = this.hAdj.getValue();
                    this.hAdj.setValue(n);
                    this.paintArea.repaint();
                    return;
                }
                case 5: {
                    int n = this.hAdj.getValue();
                    this.hAdj.setValue(n);
                    this.paintArea.repaint();
                    return;
                }
            }
        }
    }
}

