/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vatc.tcmerge;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.StringTokenizer;

public class MultiLineLabel
extends Canvas {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    protected String[] lines;
    protected String[] words;
    protected int num_lines;
    protected int num_words;
    protected int margin_width;
    protected int margin_height;
    protected int line_height;
    protected int line_ascent;
    protected int[] line_widths;
    protected int max_width;
    protected int alignment = 0;
    protected int comp_width;
    protected int comp_height;

    protected void newLabel(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        this.num_words = stringTokenizer.countTokens();
        this.words = new String[this.num_words];
        int n = 0;
        while (n < this.num_words) {
            this.words[n] = stringTokenizer.nextToken();
            ++n;
        }
    }

    protected void measure() {
        String string = new String("");
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if (fontMetrics == null) {
            return;
        }
        Dimension dimension = this.getSize();
        if (dimension.height == 0 || dimension.width == 0) {
            return;
        }
        this.comp_width = dimension.width;
        this.comp_height = dimension.height;
        int n = 0;
        this.line_height = fontMetrics.getHeight();
        this.line_ascent = fontMetrics.getAscent();
        this.num_lines = dimension.height / this.line_height + 1;
        this.lines = new String[this.num_lines];
        this.line_widths = new int[this.num_lines];
        this.max_width = dimension.width - 2 * this.margin_width;
        int n2 = 0;
        boolean bl = false;
        int n3 = fontMetrics.stringWidth(" ");
        int n4 = 0;
        while (n4 < this.num_words && n < this.num_lines) {
            boolean bl2 = false;
            boolean bl3 = false;
            int n5 = this.words[n4].length();
            if (this.words[n4].charAt(0) == '\n') {
                this.line_widths[n] = n2;
                this.lines[n] = string;
                ++n;
                this.words[n4] = this.words[n4].substring(1);
                string = new String(this.words[n4]);
                n2 = 0;
                bl3 = true;
            } else if (this.words[n4].charAt(n5 - 1) == '\n') {
                bl2 = true;
                this.words[n4] = this.words[n4].substring(0, n5 - 1);
            }
            int n6 = fontMetrics.stringWidth(this.words[n4]);
            n2 += n6 + n3;
            if (!bl3) {
                if (n2 - n3 > this.max_width) {
                    this.line_widths[n] = n2 - n6 - n3;
                    this.lines[n] = string;
                    ++n;
                    if (bl2) {
                        this.line_widths[n] = n6;
                        this.lines[n] = this.words[n4];
                        ++n;
                        string = new String("");
                        n2 = 0;
                        bl = true;
                    } else {
                        string = new String(this.words[n4]);
                        n2 = n6 + n3;
                    }
                } else {
                    if (n4 > 0 && !bl) {
                        string = string.concat(" ");
                    }
                    bl = false;
                    string = string.concat(this.words[n4]);
                    if (bl2) {
                        this.line_widths[n] = n2 - n3;
                        this.lines[n] = string;
                        ++n;
                        string = new String("");
                        n2 = 0;
                        bl = true;
                    }
                }
            }
            ++n4;
        }
        if (n < this.num_lines) {
            this.line_widths[n] = n2 - n3;
            this.lines[n] = string;
            this.num_lines = ++n;
        }
    }

    public MultiLineLabel(String string, int n, int n2, int n3) {
        this.newLabel(string);
        this.margin_width = n;
        this.margin_height = n2;
        this.alignment = n3;
    }

    public MultiLineLabel(String string, int n, int n2) {
        this(string, n, n2, 0);
    }

    public MultiLineLabel(String string, int n) {
        this(string, 10, 10, n);
    }

    public MultiLineLabel(String string) {
        this(string, 10, 10, 0);
    }

    public void setLabel(String string) {
        this.newLabel(string);
        this.measure();
        this.repaint();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.measure();
        this.repaint();
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.repaint();
    }

    public void setAlignment(int n) {
        this.alignment = n;
        this.repaint();
    }

    public void setMarginWidth(int n) {
        this.margin_width = n;
        this.repaint();
    }

    public void setMarginHeight(int n) {
        this.margin_height = n;
        this.repaint();
    }

    public int getAlignment() {
        return this.alignment;
    }

    public int getMarginWidth() {
        return this.margin_width;
    }

    public int getMarginHeight() {
        return this.margin_height;
    }

    public void addNotify() {
        super.addNotify();
        this.measure();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension.width != this.comp_width || dimension.height != this.comp_height) {
            this.measure();
        }
        return dimension;
    }

    public Dimension getMinimumSize() {
        return super.getMinimumSize();
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.line_ascent == 0 || this.line_height == 0) {
            this.measure();
        }
        int n = this.line_ascent + (dimension.height - this.num_lines * this.line_height) / 2;
        int n2 = 0;
        while (n2 < this.num_lines) {
            int n3;
            switch (this.alignment) {
                case 0: {
                    n3 = this.margin_width;
                    break;
                }
                default: {
                    n3 = (dimension.width - this.line_widths[n2]) / 2;
                    break;
                }
                case 2: {
                    n3 = dimension.width - this.margin_width - this.line_widths[n2];
                }
            }
            graphics.drawString(this.lines[n2], n3, n);
            ++n2;
            n += this.line_height;
        }
    }
}

