/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vatc.tcmerge;

import com.ibm.vatc.tcmerge.MergeFilesInfo;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.MouseListener;
import java.util.Vector;

class CollisionsCanvas
extends Canvas {
    int numOfFiles;
    Vector mergeInfo;
    int currentSelection;
    Font font = new Font("Dialog", 0, 14);

    public CollisionsCanvas(Vector vector, int n) {
        this.updateCollisionsCanvas(vector, n);
        this.setBackground(Color.white);
    }

    public void updateCollisionsCanvas(Vector vector, int n) {
        this.mergeInfo = vector;
        this.currentSelection = n;
        this.numOfFiles = vector.size();
        this.figureSize();
        this.repaint();
    }

    public void setCurrentSelection(int n) {
        this.currentSelection = n;
        this.repaint();
    }

    public void addCanvasListener(MouseListener mouseListener) {
        this.addMouseListener(mouseListener);
    }

    public void paint(Graphics graphics) {
        if (this.mergeInfo.size() == 0) {
            return;
        }
        Dimension dimension = this.getSize();
        int n = dimension.height / this.numOfFiles;
        graphics.setFont(this.font);
        int n2 = 0;
        while (n2 < this.numOfFiles) {
            Object object;
            int n3 = n * n2;
            MergeFilesInfo mergeFilesInfo = (MergeFilesInfo)this.mergeInfo.elementAt(n2);
            if (mergeFilesInfo.isFinished) {
                object = "!";
                graphics.drawString((String)object, 8, 12 + n3);
            }
            if (n2 == this.currentSelection) {
                object = new Font(this.font.getName(), 1, this.font.getSize() - 2);
                graphics.setFont((Font)object);
                graphics.drawString(mergeFilesInfo.outputFile, 20, 12 + n3);
                graphics.setFont(this.font);
            } else {
                graphics.drawString(mergeFilesInfo.outputFile, 20, 12 + n3);
            }
            ++n2;
        }
    }

    private void figureSize() {
        int n = 0;
        int n2 = 0;
        Toolkit toolkit = this.getToolkit();
        FontMetrics fontMetrics = toolkit.getFontMetrics(this.font);
        int n3 = fontMetrics.getHeight() + 2;
        n = this.numOfFiles * n3;
        int n4 = 0;
        while (n4 < this.numOfFiles) {
            MergeFilesInfo mergeFilesInfo = (MergeFilesInfo)this.mergeInfo.elementAt(n4);
            int n5 = fontMetrics.stringWidth(mergeFilesInfo.outputFile);
            if (n5 > n2) {
                n2 = n5;
            }
            ++n4;
        }
        if ((n2 += 40) < 200) {
            n2 = 200;
        }
        this.setSize(n2, n);
    }
}

