/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vatc.reuse.awt.support;

import com.ibm.vatc.reuse.awt.Notebook;
import com.ibm.vatc.reuse.awt.support.Utilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;

public abstract class NBRenderer {
    private static String Copyright = "\r\n\r\nLicensed Materials - Property of IBM.\r\n(C) Copyright IBM Corporation 1997.\r\nAll Rights Reserved US Government Users Restricted Rights -\r\nUse, duplication or disclosure\r\nrestricted by GSA ADP Schedule Contract\r\nwith IBM Corp.\r\n\r\n";
    public static final int Left_Button = 1;
    public static final int Right_Button = 2;
    protected int firstTab = 0;
    protected String statusText = null;
    protected String pagingText = null;
    protected boolean leftButtonEnabled = false;
    protected boolean rightButtonEnabled = false;
    protected Insets insets = null;
    protected Notebook parent;

    protected NBRenderer(Notebook notebook) {
        this.parent = notebook;
    }

    public static boolean isSideSupportedForTabs(int n) {
        return false;
    }

    public abstract Insets getInsets(FontMetrics var1);

    public abstract void paintTheLook(Graphics var1, FontMetrics var2, Dimension var3);

    protected int getMaximumWidth(FontMetrics fontMetrics) {
        Object[] objectArray = this.parent.getTabList();
        int n = 0;
        if (objectArray != null) {
            int n2 = 0;
            while (n2 < objectArray.length) {
                n = Math.max(n, Utilities.itemWidth(fontMetrics, objectArray[n2], this.parent) + fontMetrics.stringWidth("    "));
                ++n2;
            }
        }
        return n;
    }

    protected void drawArrowFrame(Graphics graphics, int n, int n2, int n3) {
        graphics.setColor(Color.lightGray);
        graphics.fillRect(n, n2, n3, n3);
        graphics.setColor(Color.white);
        graphics.drawLine(n, n2, n + n3 - 1, n2);
        graphics.drawLine(n, n2, n, n2 + n3 - 1);
        graphics.drawLine(n + 1, n2 + 1, n + n3 - 2, n2 + 1);
        graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + n3 - 2);
        graphics.setColor(Color.darkGray);
        graphics.drawLine(n + 2, n2 + n3 - 2, n + n3 - 1, n2 + n3 - 2);
        graphics.drawLine(n + 1, n2 + n3 - 1, n + n3 - 1, n2 + n3 - 1);
        graphics.drawLine(n + n3 - 2, n2 + 2, n + n3 - 2, n2 + n3 - 1);
        graphics.drawLine(n + n3 - 1, n2 + 1, n + n3 - 1, n2 + n3 - 1);
    }

    protected void drawDisabledArrowFrame(Graphics graphics, int n, int n2, int n3) {
        graphics.setColor(Color.lightGray);
        graphics.fillRect(n, n2, n3, n3);
        graphics.setColor(Color.darkGray);
        graphics.drawLine(n, n2, n + n3 - 1, n2);
        graphics.drawLine(n, n2, n, n2 + n3 - 1);
        graphics.drawLine(n + 1, n2 + n3 - 1, n + n3 - 1, n2 + n3 - 1);
        graphics.drawLine(n + n3 - 1, n2 + 1, n + n3 - 1, n2 + n3 - 1);
    }

    public void doTabScroll(int n) {
        this.firstTab += n;
    }

    public boolean isStatusLineSupported() {
        return true;
    }

    public void setStatusText(String string) {
        this.statusText = string;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public void setPagingText(String string) {
        this.pagingText = string;
    }

    public void setButtonState(int n, boolean bl) {
        switch (n) {
            case 1: {
                this.leftButtonEnabled = bl;
                return;
            }
            case 2: {
                this.rightButtonEnabled = bl;
                return;
            }
        }
        throw new IllegalArgumentException("Bad button number specified");
    }
}

