/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.OptionPaneUI;
import javax.swing.text.JTextComponent;

public class BasicOptionPaneUI
extends OptionPaneUI {
    public static final int MinimumWidth = 262;
    public static final int MinimumHeight = 90;
    protected JOptionPane optionPane;
    protected Dimension minimumSize;
    protected JComponent inputComponent;
    protected Component initialFocusComponent;
    protected boolean hasCustomComponents;
    protected PropertyChangeListener propertyChangeListener;

    protected void addButtonComponents(Container container, Object[] objectArray, int n) {
        if (objectArray != null && objectArray.length > 0) {
            Object object;
            boolean bl = this.getSizeButtonsToSameWidth();
            boolean bl2 = true;
            int n2 = objectArray.length;
            JButton[] jButtonArray = null;
            int n3 = 0;
            if (bl) {
                jButtonArray = new JButton[n2];
            }
            int n4 = 0;
            while (n4 < n2) {
                JButton jButton;
                Component component;
                object = objectArray[n4];
                if (object instanceof Component) {
                    bl2 = false;
                    component = (Component)object;
                    container.add(component);
                    this.hasCustomComponents = true;
                } else {
                    jButton = object instanceof Icon ? new JButton((Icon)object) : new JButton(object.toString());
                    container.add(jButton);
                    ActionListener actionListener = this.createButtonActionListener(n4);
                    if (actionListener != null) {
                        jButton.addActionListener(actionListener);
                    }
                    component = jButton;
                }
                if (bl && bl2 && component instanceof JButton) {
                    jButtonArray[n4] = (JButton)component;
                    n3 = Math.max(n3, component.getMinimumSize().width);
                }
                if (n4 == n) {
                    this.initialFocusComponent = component;
                    if (this.initialFocusComponent instanceof JButton) {
                        jButton = (JButton)this.initialFocusComponent;
                        jButton.addAncestorListener(new AncestorListener(){

                            public void ancestorAdded(AncestorEvent ancestorEvent) {
                                JButton jButton = (JButton)ancestorEvent.getComponent();
                                JRootPane jRootPane = SwingUtilities.getRootPane(jButton);
                                if (jRootPane != null) {
                                    jRootPane.setDefaultButton(jButton);
                                }
                            }

                            public void ancestorMoved(AncestorEvent ancestorEvent) {
                            }

                            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                            }
                        });
                    }
                }
                ++n4;
            }
            ((ButtonAreaLayout)container.getLayout()).setSyncAllWidths(bl && bl2);
            if (bl && bl2) {
                int n5 = n2 <= 2 ? 8 : 4;
                int n6 = 0;
                while (n6 < n2) {
                    object = jButtonArray[n6];
                    ((AbstractButton)object).setMargin(new Insets(2, n5, 2, n5));
                    ++n6;
                }
            }
        }
    }

    protected void addIcon(Container container) {
        Icon icon = this.getIcon();
        if (icon != null) {
            JLabel jLabel = new JLabel(icon);
            jLabel.setVerticalAlignment(1);
            container.add((Component)jLabel, "West");
        }
    }

    protected void addMessageComponents(Container container, GridBagConstraints gridBagConstraints, Object object, int n, boolean bl) {
        if (object == null) {
            return;
        }
        if (object instanceof Component) {
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            container.add((Component)object, gridBagConstraints);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            ++gridBagConstraints.gridy;
            if (!bl) {
                this.hasCustomComponents = true;
            }
        } else if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            int n2 = 0;
            while (n2 < objectArray.length) {
                this.addMessageComponents(container, gridBagConstraints, objectArray[n2], n, false);
                ++n2;
            }
        } else if (object instanceof Icon) {
            JLabel jLabel = new JLabel((Icon)object, 0);
            jLabel.setForeground(UIManager.getColor("OptionPane.messageForeground"));
            this.addMessageComponents(container, gridBagConstraints, jLabel, n, true);
        } else {
            String string = object.toString();
            int n3 = string.length();
            if (n3 <= 0) {
                return;
            }
            int n4 = string.indexOf(10);
            if (n4 >= 0) {
                if (n4 == 0) {
                    this.addMessageComponents(container, gridBagConstraints, new Component(){

                        public Dimension getPreferredSize() {
                            Font font = this.getFont();
                            if (font != null) {
                                return new Dimension(1, font.getSize() + 2);
                            }
                            return new Dimension(0, 0);
                        }
                    }, n, true);
                } else {
                    this.addMessageComponents(container, gridBagConstraints, string.substring(0, n4), n, false);
                }
                this.addMessageComponents(container, gridBagConstraints, string.substring(n4 + 1), n, false);
            } else if (n3 > n) {
                Box box = Box.createVerticalBox();
                this.burstStringInto(box, string, n);
                this.addMessageComponents(container, gridBagConstraints, box, n, true);
            } else {
                JLabel jLabel = new JLabel(string, 2);
                jLabel.setForeground(UIManager.getColor("OptionPane.messageForeground"));
                this.addMessageComponents(container, gridBagConstraints, jLabel, n, true);
            }
        }
    }

    protected void burstStringInto(Container container, String string, int n) {
        int n2 = string.length();
        if (n2 <= 0) {
            return;
        }
        if (n2 > n) {
            int n3 = string.lastIndexOf(32, n);
            if (n3 <= 0) {
                n3 = string.indexOf(32, n);
            }
            if (n3 > 0 && n3 < n2) {
                this.burstStringInto(container, string.substring(0, n3), n);
                this.burstStringInto(container, string.substring(n3 + 1), n);
                return;
            }
        }
        JLabel jLabel = new JLabel(string, 2);
        jLabel.setForeground(UIManager.getColor("OptionPane.messageForeground"));
        container.add(jLabel);
    }

    public boolean containsCustomComponents(JOptionPane jOptionPane) {
        return this.hasCustomComponents;
    }

    protected ActionListener createButtonActionListener(int n) {
        return new ButtonActionListener(n);
    }

    protected Container createButtonArea() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(UIManager.getBorder("OptionPane.buttonAreaBorder"));
        jPanel.setLayout(new ButtonAreaLayout(true, 6));
        this.addButtonComponents(jPanel, this.getButtons(), this.getInitialValueIndex());
        return jPanel;
    }

    protected LayoutManager createLayoutManager() {
        return new BoxLayout(this.optionPane, 1);
    }

    protected Container createMessageArea() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(UIManager.getBorder("OptionPane.messageAreaBorder"));
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel(){};
        JPanel jPanel3 = new JPanel(){};
        JPanel jPanel4 = new JPanel(){

            public Dimension getPreferredSize() {
                return new Dimension(15, 1);
            }
        };
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jPanel4, "West");
        jPanel3.add((Component)jPanel2, "Center");
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.addMessageComponents(jPanel2, gridBagConstraints, this.getMessage(), this.getMaxCharactersPerLineCount(), false);
        jPanel.add((Component)jPanel3, "Center");
        this.addIcon(jPanel);
        return jPanel;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected Container createSeparator() {
        return null;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicOptionPaneUI();
    }

    protected Object[] getButtons() {
        if (this.optionPane != null) {
            Object[] objectArray = this.optionPane.getOptions();
            if (objectArray == null) {
                int n = this.optionPane.getOptionType();
                Object[] objectArray2 = n == 0 ? new String[]{UIManager.get("OptionPane.yesButtonText"), UIManager.get("OptionPane.noButtonText")} : (n == 1 ? new String[]{UIManager.get("OptionPane.yesButtonText"), UIManager.get("OptionPane.noButtonText"), UIManager.get("OptionPane.cancelButtonText")} : (n == 2 ? new String[]{UIManager.get("OptionPane.okButtonText"), UIManager.get("OptionPane.cancelButtonText")} : new String[]{UIManager.get("OptionPane.okButtonText")}));
                return objectArray2;
            }
            return objectArray;
        }
        return null;
    }

    protected Icon getIcon() {
        Icon icon;
        Icon icon2 = icon = this.optionPane == null ? null : this.optionPane.getIcon();
        if (icon == null && this.optionPane != null) {
            icon = this.getIconForType(this.optionPane.getMessageType());
        }
        return icon;
    }

    protected Icon getIconForType(int n) {
        if (n < 0 || n > 3) {
            return null;
        }
        switch (n) {
            case 0: {
                return UIManager.getIcon("OptionPane.errorIcon");
            }
            case 1: {
                return UIManager.getIcon("OptionPane.informationIcon");
            }
            case 2: {
                return UIManager.getIcon("OptionPane.warningIcon");
            }
            case 3: {
                return UIManager.getIcon("OptionPane.questionIcon");
            }
        }
        return null;
    }

    protected int getInitialValueIndex() {
        if (this.optionPane != null) {
            Object object = this.optionPane.getInitialValue();
            Object[] objectArray = this.optionPane.getOptions();
            if (objectArray == null) {
                return 0;
            }
            if (object != null) {
                int n = objectArray.length - 1;
                while (n >= 0) {
                    if (objectArray[n].equals(object)) {
                        return n;
                    }
                    --n;
                }
            }
        }
        return -1;
    }

    protected int getMaxCharactersPerLineCount() {
        return this.optionPane.getMaxCharactersPerLineCount();
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    protected Object getMessage() {
        this.inputComponent = null;
        if (this.optionPane != null) {
            if (this.optionPane.getWantsInput()) {
                JComponent jComponent;
                JComponent jComponent2;
                Object object = this.optionPane.getMessage();
                Object[] objectArray = this.optionPane.getSelectionValues();
                Object object2 = this.optionPane.getInitialSelectionValue();
                if (objectArray != null) {
                    if (objectArray.length < 20) {
                        jComponent2 = new JComboBox();
                        int n = 0;
                        int n2 = objectArray.length;
                        while (n < n2) {
                            ((JComboBox)jComponent2).addItem(objectArray[n]);
                            ++n;
                        }
                        if (object2 != null) {
                            ((JComboBox)jComponent2).setSelectedItem(object2);
                        }
                        this.inputComponent = jComponent2;
                        jComponent = jComponent2;
                    } else {
                        jComponent2 = new JList(objectArray);
                        JScrollPane jScrollPane = new JScrollPane(jComponent2);
                        ((JList)jComponent2).setVisibleRowCount(10);
                        if (object2 != null) {
                            ((JList)jComponent2).setSelectedValue(object2, true);
                        }
                        jComponent2.addMouseListener(new ListSelectionListener());
                        jComponent = jScrollPane;
                        this.inputComponent = jComponent2;
                    }
                } else {
                    jComponent2 = new JTextField(20);
                    if (object2 != null) {
                        ((JTextComponent)jComponent2).setText(object2.toString());
                    }
                    ((JTextField)jComponent2).addActionListener(new TextFieldActionListener());
                    jComponent = this.inputComponent = jComponent2;
                }
                jComponent2 = object == null ? new Object[]{jComponent} : new Object[]{object, jComponent};
                return jComponent2;
            }
            return this.optionPane.getMessage();
        }
        return null;
    }

    public Dimension getMinimumOptionPaneSize() {
        if (this.minimumSize == null) {
            return new Dimension(262, 90);
        }
        return new Dimension(this.minimumSize.width, this.minimumSize.height);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        if ((JOptionPane)jComponent == this.optionPane) {
            Dimension dimension = this.getMinimumOptionPaneSize();
            LayoutManager layoutManager = jComponent.getLayout();
            if (layoutManager != null) {
                Dimension dimension2 = layoutManager.preferredLayoutSize(jComponent);
                if (dimension != null) {
                    return new Dimension(Math.max(dimension2.width, dimension.width), Math.max(dimension2.height, dimension.height));
                }
                return dimension2;
            }
            return dimension;
        }
        return null;
    }

    protected boolean getSizeButtonsToSameWidth() {
        return true;
    }

    protected void installComponents() {
        this.optionPane.add(this.createMessageArea());
        Container container = this.createSeparator();
        if (container != null) {
            this.optionPane.add(container);
        }
        this.optionPane.add(this.createButtonArea());
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.optionPane, "OptionPane.background", "OptionPane.foreground", "OptionPane.font");
        LookAndFeel.installBorder(this.optionPane, "OptionPane.border");
        this.minimumSize = UIManager.getDimension("OptionPane.minimumSize");
        this.optionPane.setOpaque(true);
    }

    protected void installKeyboardActions() {
        this.optionPane.registerKeyboardAction(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicOptionPaneUI.this.optionPane.setValue(new Integer(-1));
            }

            public boolean isEnabled() {
                return true;
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.optionPane.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    public void installUI(JComponent jComponent) {
        this.optionPane = (JOptionPane)jComponent;
        this.installDefaults();
        this.optionPane.setLayout(this.createLayoutManager());
        this.installComponents();
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void resetInputValue() {
        if (this.inputComponent != null && this.inputComponent instanceof JTextField) {
            this.optionPane.setInputValue(((JTextField)this.inputComponent).getText());
        } else if (this.inputComponent != null && this.inputComponent instanceof JComboBox) {
            this.optionPane.setInputValue(((JComboBox)this.inputComponent).getSelectedItem());
        } else if (this.inputComponent != null) {
            this.optionPane.setInputValue(((JList)this.inputComponent).getSelectedValue());
        }
    }

    public void selectInitialValue(JOptionPane jOptionPane) {
        if (this.inputComponent != null) {
            this.inputComponent.requestFocus();
        } else {
            JRootPane jRootPane;
            if (this.initialFocusComponent != null) {
                this.initialFocusComponent.requestFocus();
            }
            if (this.initialFocusComponent instanceof JButton && (jRootPane = SwingUtilities.getRootPane(this.initialFocusComponent)) != null) {
                jRootPane.setDefaultButton((JButton)this.initialFocusComponent);
            }
        }
    }

    protected void uninstallComponents() {
        this.hasCustomComponents = false;
        this.inputComponent = null;
        this.initialFocusComponent = null;
        this.optionPane.removeAll();
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.optionPane);
    }

    protected void uninstallKeyboardActions() {
        this.optionPane.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
    }

    protected void uninstallListeners() {
        if (this.propertyChangeListener != null) {
            this.optionPane.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallComponents();
        this.optionPane.setLayout(null);
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.optionPane = null;
    }

    public static class ButtonAreaLayout
    implements LayoutManager {
        protected boolean syncAllWidths;
        protected int padding;
        protected boolean centersChildren;

        public ButtonAreaLayout(boolean bl, int n) {
            this.syncAllWidths = bl;
            this.padding = n;
            this.centersChildren = true;
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public boolean getCentersChildren() {
            return this.centersChildren;
        }

        public int getPadding() {
            return this.padding;
        }

        public boolean getSyncAllWidths() {
            return this.syncAllWidths;
        }

        public void layoutContainer(Container container) {
            block14: {
                Component[] componentArray = container.getComponents();
                if (componentArray == null || componentArray.length <= 0) break block14;
                int n = componentArray.length;
                Dimension[] dimensionArray = new Dimension[n];
                int n2 = container.getInsets().top;
                if (this.syncAllWidths) {
                    int n3;
                    int n4;
                    int n5 = 0;
                    int n6 = 0;
                    while (n6 < n) {
                        dimensionArray[n6] = componentArray[n6].getPreferredSize();
                        n5 = Math.max(n5, dimensionArray[n6].width);
                        ++n6;
                    }
                    if (this.getCentersChildren()) {
                        n4 = (container.getSize().width - (n5 * n + (n - 1) * this.padding)) / 2;
                        n3 = this.padding + n5;
                    } else if (n > 1) {
                        n4 = 0;
                        n3 = (container.getSize().width - n5 * n) / (n - 1) + n5;
                    } else {
                        n4 = (container.getSize().width - n5) / 2;
                        n3 = 0;
                    }
                    n6 = 0;
                    while (n6 < n) {
                        componentArray[n6].setBounds(n4, n2, n5, dimensionArray[n6].height);
                        n4 += n3;
                        ++n6;
                    }
                } else {
                    int n7;
                    int n8;
                    int n9 = 0;
                    int n10 = 0;
                    while (n10 < n) {
                        dimensionArray[n10] = componentArray[n10].getPreferredSize();
                        n9 += dimensionArray[n10].width;
                        ++n10;
                    }
                    n9 += (n - 1) * this.padding;
                    boolean bl = this.getCentersChildren();
                    if (bl) {
                        n8 = (container.getSize().width - n9) / 2;
                        n7 = this.padding;
                    } else if (n > 1) {
                        n7 = (container.getSize().width - n9) / (n - 1);
                        n8 = 0;
                    } else {
                        n8 = (container.getSize().width - n9) / 2;
                        n7 = 0;
                    }
                    n10 = 0;
                    while (n10 < n) {
                        componentArray[n10].setBounds(n8, n2, dimensionArray[n10].width, dimensionArray[n10].height);
                        n8 += n7 + dimensionArray[n10].width;
                        ++n10;
                    }
                }
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            Component[] componentArray;
            if (container != null && (componentArray = container.getComponents()) != null && componentArray.length > 0) {
                int n = componentArray.length;
                int n2 = 0;
                Insets insets = container.getInsets();
                int n3 = insets.top + insets.bottom;
                if (this.syncAllWidths) {
                    int n4 = 0;
                    int n5 = 0;
                    while (n5 < n) {
                        Dimension dimension = componentArray[n5].getPreferredSize();
                        n2 = Math.max(n2, dimension.height);
                        n4 = Math.max(n4, dimension.width);
                        ++n5;
                    }
                    return new Dimension(n4 * n + (n - 1) * this.padding, n3 + n2);
                }
                int n6 = 0;
                int n7 = 0;
                while (n7 < n) {
                    Dimension dimension = componentArray[n7].getPreferredSize();
                    n2 = Math.max(n2, dimension.height);
                    n6 += dimension.width;
                    ++n7;
                }
                return new Dimension(n6 += (n - 1) * this.padding, n3 + n2);
            }
            return new Dimension(0, 0);
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.minimumLayoutSize(container);
        }

        public void removeLayoutComponent(Component component) {
        }

        public void setCentersChildren(boolean bl) {
            this.centersChildren = bl;
        }

        public void setPadding(int n) {
            this.padding = n;
        }

        public void setSyncAllWidths(boolean bl) {
            this.syncAllWidths = bl;
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string;
            if (propertyChangeEvent.getSource() == BasicOptionPaneUI.this.optionPane && ((string = propertyChangeEvent.getPropertyName()).equals("options") || string.equals("initialValue") || string.equals("icon") || string.equals("messageType") || string.equals("optionType") || string.equals("message") || string.equals("selectionValues") || string.equals("initialSelectionValue") || string.equals("wantsInput"))) {
                BasicOptionPaneUI.this.uninstallComponents();
                BasicOptionPaneUI.this.installComponents();
                BasicOptionPaneUI.this.optionPane.validate();
            }
        }
    }

    public class ButtonActionListener
    implements ActionListener {
        protected int buttonIndex;

        public ButtonActionListener(int n) {
            this.buttonIndex = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicOptionPaneUI.this.optionPane != null) {
                Object[] objectArray;
                int n = BasicOptionPaneUI.this.optionPane.getOptionType();
                if (BasicOptionPaneUI.this.inputComponent != null && (n == 0 || n == 1 || n == 2) && this.buttonIndex == 0) {
                    BasicOptionPaneUI.this.resetInputValue();
                }
                if ((objectArray = BasicOptionPaneUI.this.optionPane.getOptions()) == null) {
                    if (n == 2 && this.buttonIndex == 1) {
                        BasicOptionPaneUI.this.optionPane.setValue(new Integer(2));
                    } else {
                        BasicOptionPaneUI.this.optionPane.setValue(new Integer(this.buttonIndex));
                    }
                } else {
                    BasicOptionPaneUI.this.optionPane.setValue(objectArray[this.buttonIndex]);
                }
            }
        }
    }

    private class ListSelectionListener
    extends MouseAdapter {
        ListSelectionListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                JList jList = (JList)mouseEvent.getSource();
                int n = jList.locationToIndex(mouseEvent.getPoint());
                BasicOptionPaneUI.this.optionPane.setInputValue(jList.getModel().getElementAt(n));
            }
        }
    }

    private class TextFieldActionListener
    implements ActionListener {
        TextFieldActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BasicOptionPaneUI.this.optionPane.setInputValue(((JTextField)actionEvent.getSource()).getText());
        }
    }
}

