/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.WindowConstants;

public class JFrame
extends Frame
implements WindowConstants,
Accessible,
RootPaneContainer {
    private int defaultCloseOperation = 1;
    protected JRootPane rootPane;
    protected boolean rootPaneCheckingEnabled = false;
    protected AccessibleContext accessibleContext = null;

    public JFrame() {
        this.frameInit();
    }

    public JFrame(String string) {
        super(string);
        this.frameInit();
    }

    protected void addImpl(Component component, Object object, int n) {
        if (this.isRootPaneCheckingEnabled()) {
            throw this.createRootPaneException("add");
        }
        super.addImpl(component, object, n);
    }

    protected JRootPane createRootPane() {
        return new JRootPane();
    }

    private Error createRootPaneException(String string) {
        String string2 = this.getClass().getName();
        return new Error("Do not use " + string2 + "." + string + "() use " + string2 + ".getContentPane()." + string + "() instead");
    }

    protected void frameInit() {
        this.enableEvents(72L);
        this.setRootPane(this.createRootPane());
        ((Component)this).setBackground(UIManager.getColor("control"));
        this.setRootPaneCheckingEnabled(true);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJFrame();
        }
        return this.accessibleContext;
    }

    public Container getContentPane() {
        return this.getRootPane().getContentPane();
    }

    public int getDefaultCloseOperation() {
        return this.defaultCloseOperation;
    }

    public Component getGlassPane() {
        return this.getRootPane().getGlassPane();
    }

    public JMenuBar getJMenuBar() {
        return this.getRootPane().getMenuBar();
    }

    public JLayeredPane getLayeredPane() {
        return this.getRootPane().getLayeredPane();
    }

    public JRootPane getRootPane() {
        return this.rootPane;
    }

    protected boolean isRootPaneCheckingEnabled() {
        return this.rootPaneCheckingEnabled;
    }

    protected String paramString() {
        String string = this.defaultCloseOperation == 1 ? "HIDE_ON_CLOSE" : (this.defaultCloseOperation == 2 ? "DISPOSE_ON_CLOSE" : (this.defaultCloseOperation == 0 ? "DO_NOTHING_ON_CLOSE" : ""));
        String string2 = this.rootPane != null ? this.rootPane.toString() : "";
        String string3 = this.rootPaneCheckingEnabled ? "true" : "false";
        return String.valueOf(super.paramString()) + ",defaultCloseOperation=" + string + ",rootPane=" + string2 + ",rootPaneCheckingEnabled=" + string3;
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (!keyEvent.isConsumed()) {
            JComponent.processKeyBindingsForAllComponents(keyEvent, this, keyEvent.getID() == 401);
        }
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            switch (this.defaultCloseOperation) {
                case 1: {
                    ((Component)this).setVisible(false);
                    break;
                }
                case 2: {
                    ((Component)this).setVisible(false);
                    this.dispose();
                    break;
                }
            }
        }
    }

    public void setContentPane(Container container) {
        this.getRootPane().setContentPane(container);
    }

    public void setDefaultCloseOperation(int n) {
        this.defaultCloseOperation = n;
    }

    public void setGlassPane(Component component) {
        this.getRootPane().setGlassPane(component);
    }

    public void setJMenuBar(JMenuBar jMenuBar) {
        this.getRootPane().setMenuBar(jMenuBar);
    }

    public void setLayeredPane(JLayeredPane jLayeredPane) {
        this.getRootPane().setLayeredPane(jLayeredPane);
    }

    public void setLayout(LayoutManager layoutManager) {
        if (this.isRootPaneCheckingEnabled()) {
            throw this.createRootPaneException("setLayout");
        }
        super.setLayout(layoutManager);
    }

    protected void setRootPane(JRootPane jRootPane) {
        if (this.rootPane != null) {
            this.remove(this.rootPane);
        }
        this.rootPane = jRootPane;
        if (this.rootPane != null) {
            boolean bl = this.isRootPaneCheckingEnabled();
            try {
                this.setRootPaneCheckingEnabled(false);
                this.add((Component)this.rootPane, "Center");
            }
            finally {
                Object var4_3 = null;
                this.setRootPaneCheckingEnabled(bl);
            }
        }
    }

    protected void setRootPaneCheckingEnabled(boolean bl) {
        this.rootPaneCheckingEnabled = bl;
    }

    public void update(Graphics graphics) {
        ((Container)this).paint(graphics);
    }

    protected class AccessibleJFrame
    extends AccessibleContext
    implements Serializable,
    AccessibleComponent {
        protected AccessibleJFrame() {
        }

        public void addFocusListener(FocusListener focusListener) {
            JFrame.this.addFocusListener(focusListener);
        }

        public boolean contains(Point point) {
            return JFrame.this.contains(point);
        }

        public Accessible getAccessibleAt(Point point) {
            int n = this.getAccessibleChildrenCount();
            int n2 = 0;
            while (n2 < n) {
                AccessibleComponent accessibleComponent;
                AccessibleContext accessibleContext;
                Accessible accessible = this.getAccessibleChild(n2);
                if (accessible != null && (accessibleContext = accessible.getAccessibleContext()) != null && (accessibleComponent = accessibleContext.getAccessibleComponent()) != null && accessibleComponent.isShowing()) {
                    Point point2 = accessibleComponent.getLocation();
                    Point point3 = new Point(point.x - point2.x, point.y - point2.y);
                    if (accessibleComponent.contains(point3)) {
                        return accessible;
                    }
                }
                ++n2;
            }
            return JFrame.this;
        }

        public Accessible getAccessibleChild(int n) {
            return SwingUtilities.getAccessibleChild(JFrame.this, n);
        }

        public int getAccessibleChildrenCount() {
            return SwingUtilities.getAccessibleChildrenCount(JFrame.this);
        }

        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        public int getAccessibleIndexInParent() {
            return SwingUtilities.getAccessibleIndexInParent(JFrame.this);
        }

        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            if (JFrame.this.getTitle() == null) {
                return super.getAccessibleName();
            }
            return JFrame.this.getTitle();
        }

        public Accessible getAccessibleParent() {
            if (this.accessibleParent != null) {
                return this.accessibleParent;
            }
            Container container = JFrame.this.getParent();
            if (container instanceof Accessible) {
                return (Accessible)((Object)container);
            }
            return null;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.FRAME;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = SwingUtilities.getAccessibleStateSet(JFrame.this);
            if (JFrame.this.isResizable()) {
                accessibleStateSet.add(AccessibleState.RESIZABLE);
            }
            if (JFrame.this.getFocusOwner() != null) {
                accessibleStateSet.add(AccessibleState.ACTIVE);
            }
            return accessibleStateSet;
        }

        public Color getBackground() {
            return ((Component)JFrame.this).getBackground();
        }

        public Rectangle getBounds() {
            return JFrame.this.getBounds();
        }

        public Cursor getCursor() {
            return JFrame.this.getCursor();
        }

        public Font getFont() {
            return JFrame.this.getFont();
        }

        public FontMetrics getFontMetrics(Font font) {
            return JFrame.this.getFontMetrics(font);
        }

        public Color getForeground() {
            return JFrame.this.getForeground();
        }

        public Locale getLocale() {
            return JFrame.this.getLocale();
        }

        public Point getLocation() {
            return JFrame.this.getLocation();
        }

        public Point getLocationOnScreen() {
            return JFrame.this.getLocationOnScreen();
        }

        public Dimension getSize() {
            return JFrame.this.getSize();
        }

        public boolean isEnabled() {
            return JFrame.this.isEnabled();
        }

        public boolean isFocusTraversable() {
            return JFrame.this.isFocusTraversable();
        }

        public boolean isShowing() {
            return JFrame.this.isShowing();
        }

        public boolean isVisible() {
            return JFrame.this.isVisible();
        }

        public void removeFocusListener(FocusListener focusListener) {
            JFrame.this.removeFocusListener(focusListener);
        }

        public void requestFocus() {
            JFrame.this.requestFocus();
        }

        public void setBackground(Color color) {
            ((Component)JFrame.this).setBackground(color);
        }

        public void setBounds(Rectangle rectangle) {
            ((Component)JFrame.this).setBounds(rectangle);
        }

        public void setCursor(Cursor cursor) {
            ((Component)JFrame.this).setCursor(cursor);
        }

        public void setEnabled(boolean bl) {
            JFrame.this.setEnabled(bl);
        }

        public void setFont(Font font) {
            ((Component)JFrame.this).setFont(font);
        }

        public void setForeground(Color color) {
            JFrame.this.setForeground(color);
        }

        public void setLocation(Point point) {
            ((Component)JFrame.this).setLocation(point);
        }

        public void setSize(Dimension dimension) {
            ((Component)JFrame.this).setSize(dimension);
        }

        public void setVisible(boolean bl) {
            ((Component)JFrame.this).setVisible(bl);
        }
    }
}

