CREATE TABLE DSIncludeComponent 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     pIncludedSource           DBOID   ,
     constraint PKDSIncludeCompnnt Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DSIncludeCmpnnt AS --Plasma for DSIncludeComponent
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSIncludeComponent a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE DSDataDefinition 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     dataItems                 DBOID   ,
     isConstant                Int   ,
     pArrayDef                 DBOID   ,
     pPointerDef               DBOID   ,
     constraint PKDSDataDefinition Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DSDataDefinitin AS --Plasma for DSDataDefinition
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSDataDefinition a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE DSSimpleTypeDef 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     asBitData                 Int   ,
     genericPicture            VarChar(254)   ,
     isComplex                 Int   ,
     isSigned                  Int   ,
     pForLocalColDef           DBOID   ,
     precision                 Int   ,
     pSharedElement            DBOID   ,
     pSizeVariable             DBOID   ,
     pVGDataDef                DBOID   ,
     scale                     Int   ,
     strLength                 Int   ,
     strVaryingFlag            Int   ,
     typeCode                  Int   ,
     vgEvenPackSQL             Int   ,
     vgSignFormat              Int   ,
     isLOB                     Int   ,
     constraint PKDSSimpleTypeDef Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DSSimpleTypeDef AS --Plasma for DSSimpleTypeDef
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSSimpleTypeDef a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE DSStructureDef 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     pSharedStructure          DBOID   ,
     constraint PKDSStructureDef Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DSStructureDef AS --Plasma for DSStructureDef
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSStructureDef a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE DSDataElement_vrsn   -- DSDataElement_version
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     pCMPDomain                DBOID   ,
     pMMDomain                 DBOID   ,
     pSimpleTypeDef            DBOID   ,
     constraint PKDSDataElmnt_vrsn Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE TABLE DSDataStructr_vrsn   -- DSDataStructure_version
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     pStructureDef             DBOID   ,
     constraint PKDSDatStrctr_vrsn Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE TABLE DSDataComponent 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     pStructureDef             DBOID   ,
     constraint PKDSDataComponent Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DSDataComponent AS --Plasma for DSDataComponent
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSDataComponent a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE DSDataItem 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     alignmentFlag             Int   ,
     cobolDefinition           DBOID   ,
     cobolName                 VarChar(254)   ,
     comment                   VarChar(254)   ,
     defaultName               VarChar(254)   ,
     independentDCLFlag        Int   ,
     initialValue              VarChar(254)   ,
     pDataDefinition           DBOID   ,
     pHasKeyRelSource          DBOID   ,
     pIsLikeRelTarget          DBOID   ,
     pliDefinition             DBOID   ,
     pliName                   VarChar(254)   ,
     pRedefinesRelTargt        DBOID   ,
     pSDDAliasAsCobolNm        DBOID   ,
     pSDDAliasAsLocalNm        DBOID   ,
     pSDDAliasAsPLIName        DBOID   ,
     pSDDAliasAsVGName         DBOID   ,
     pSharedDataDef            DBOID   ,
     pStorageBasdRlTrgt        DBOID   ,
     pUnion                    DBOID   ,
     scope                     Int   ,
     vgName                    VarChar(254)   ,
     offsetFromLevel01         Int   ,
     isExternal                Int   ,
     pImplicitlyDefByDI        DBOID   ,
     constraint PKDSDataItem Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DSDataItem AS --Plasma for DSDataItem
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSDataItem a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

CREATE TABLE DSDatElmntAls_vrsn   -- DSDataElementAlias_version
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     pDataElement              DBOID   ,
     constraint PKDStlnAsvs Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE TABLE DSDtStrctrAls_vrsn   -- DSDataStructureAlias_version
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     pDataStructure            DBOID   ,
     constraint PKDDSrtAsvs Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE TABLE DSLnkDtItmRdfnsItm   -- DSLinkDataItmRedefinesItem
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     position                  VarChar(254)   ,
     constraint PKDLkttRfst Primary Key( OID, OVer ) )
     IN TOOLS ;

CREATE VIEW Pl_DLkttRfst AS --Plasma for DSLinkDataItmRedefinesItem
  SELECT
    a.*,
    m.sourceOID,
    m.sourceOVer
  FROM
    DSLnkDtItmRdfnsItm a, ManyPtrTable m
  WHERE
    m.targetOID=a.OID AND m.targetOVer=a.OVer AND
      m.classAttrib='ADViewRoot.plasma';

