/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.metal;

import com.sun.java.swing.AbstractButton;
import com.sun.java.swing.ButtonModel;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JToggleButton;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.basic.BasicGraphicsUtils;
import com.sun.java.swing.plaf.basic.BasicToggleButtonUI;
import com.sun.java.swing.plaf.metal.MetalButtonBorder;
import com.sun.java.swing.plaf.metal.MetalUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;

public class MetalToggleButtonUI
extends BasicToggleButtonUI {
    private static Color selectedColor;
    private static Color disabledTextColor;
    private static Color focusColor;
    protected static final Insets defaultMargin;
    private static final MetalToggleButtonUI metalToggleButtonUI;

    public static ComponentUI createUI(JComponent jComponent) {
        return metalToggleButtonUI;
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        selectedColor = UIManager.getColor("ToggleButton.selected");
        disabledTextColor = UIManager.getColor("ToggleButton.disabledText");
        focusColor = UIManager.getColor("ToggleButton.focus");
    }

    protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
        Dimension dimension = abstractButton.getSize();
        graphics.setColor(selectedColor);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
    }

    public Insets getDefaultMargin(AbstractButton abstractButton) {
        return defaultMargin;
    }

    protected void paintText(Graphics graphics, JComponent jComponent, Rectangle rectangle, String string) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (buttonModel.isEnabled()) {
            graphics.setColor(abstractButton.getForeground());
            BasicGraphicsUtils.drawString(graphics, string, buttonModel.getMnemonic(), rectangle.x, rectangle.y + fontMetrics.getAscent());
            return;
        }
        if (buttonModel.isSelected()) {
            graphics.setColor(UIManager.getColor("Button.background"));
        } else {
            graphics.setColor(UIManager.getColor("Button.disabledText"));
        }
        BasicGraphicsUtils.drawString(graphics, string, buttonModel.getMnemonic(), rectangle.x, rectangle.y + fontMetrics.getAscent());
    }

    protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        Rectangle rectangle4 = new Rectangle();
        String string = abstractButton.getText();
        boolean bl = abstractButton.getIcon() != null;
        if (string != null & !string.equals("")) {
            if (!bl) {
                rectangle4.setBounds(rectangle2);
            } else {
                rectangle4.setBounds(rectangle3.union(rectangle2));
            }
        } else if (bl) {
            rectangle4.setBounds(rectangle3);
        }
        graphics.setColor(focusColor);
        graphics.drawRect(rectangle4.x - 1, rectangle4.y - 1, rectangle4.width + 1, rectangle4.height + 1);
    }

    static {
        defaultMargin = new Insets(2, 14, 2, 14);
        metalToggleButtonUI = new MetalToggleButtonUI();
    }

    static class MetalToggleButtonBorder
    extends MetalButtonBorder {
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            JToggleButton jToggleButton = (JToggleButton)component;
            ButtonModel buttonModel = jToggleButton.getModel();
            if (!component.isEnabled()) {
                MetalUtils.drawDisabledBorder(graphics, n, n2, n3, n4);
                return;
            }
            if (buttonModel.isPressed() && buttonModel.isArmed()) {
                MetalUtils.drawPressed3DBorder(graphics, n, n2, n3, n4);
                return;
            }
            if (buttonModel.isSelected()) {
                MetalUtils.drawDark3DBorder(graphics, n, n2, n3, n4);
                return;
            }
            MetalUtils.drawFlush3DBorder(graphics, n, n2, n3, n4);
        }

        MetalToggleButtonBorder() {
        }
    }
}

