/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.metal;

import com.sun.java.swing.ButtonModel;
import com.sun.java.swing.Icon;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JMenu;
import com.sun.java.swing.JMenuItem;
import com.sun.java.swing.JRadioButton;
import com.sun.java.swing.JSlider;
import com.sun.java.swing.plaf.UIResource;
import com.sun.java.swing.plaf.metal.MetalBumps;
import com.sun.java.swing.plaf.metal.MetalLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.Serializable;

public class MetalIconFactory
implements Serializable {
    private static Icon fileChooserDetailViewIcon;
    private static Icon fileChooserHomeFolderIcon;
    private static Icon fileChooserListViewIcon;
    private static Icon fileChooserNewFolderIcon;
    private static Icon fileChooserUpFolderIcon;
    private static Icon internalFrameAltMaximizeIcon;
    private static Icon internalFrameCloseIcon;
    private static Icon internalFrameDefaultMenuIcon;
    private static Icon internalFrameMaximizeIcon;
    private static Icon internalFrameMinimizeIcon;
    private static Icon radioButtonIcon;
    private static Icon treeComputerIcon;
    private static Icon treeFloppyDriveIcon;
    private static Icon treeFolderIcon;
    private static Icon treeHardDriveIcon;
    private static Icon treeLeafIcon;
    private static Icon treeDarkControlIcon;
    private static Icon treeLightControlIcon;
    private static Icon menuArrowIcon;
    private static Icon menuItemCheckIcon;
    private static Icon menuItemArrowIcon;
    private static Icon checkBoxMenuItemIcon;
    private static Icon radioButtonMenuItemIcon;
    public static final boolean DARK = false;
    public static final boolean LIGHT = true;
    private static final Dimension folderIcon16Size;
    private static final Dimension fileIcon16Size;
    private static final Dimension treeControlSize;
    private static final Dimension menuArrowIconSize;
    private static final Dimension menuCheckIconSize;
    private static final int xOff = 4;

    public static Icon getFileChooserDetailViewIcon() {
        if (fileChooserDetailViewIcon == null) {
            fileChooserDetailViewIcon = new FileChooserDetailViewIcon();
        }
        return fileChooserDetailViewIcon;
    }

    public static Icon getFileChooserHomeFolderIcon() {
        if (fileChooserHomeFolderIcon == null) {
            fileChooserHomeFolderIcon = new FileChooserHomeFolderIcon();
        }
        return fileChooserHomeFolderIcon;
    }

    public static Icon getFileChooserListViewIcon() {
        if (fileChooserListViewIcon == null) {
            fileChooserListViewIcon = new FileChooserListViewIcon();
        }
        return fileChooserListViewIcon;
    }

    public static Icon getFileChooserNewFolderIcon() {
        if (fileChooserNewFolderIcon == null) {
            fileChooserNewFolderIcon = new FileChooserNewFolderIcon();
        }
        return fileChooserNewFolderIcon;
    }

    public static Icon getFileChooserUpFolderIcon() {
        if (fileChooserUpFolderIcon == null) {
            fileChooserUpFolderIcon = new FileChooserUpFolderIcon();
        }
        return fileChooserUpFolderIcon;
    }

    public static Icon getInternalFrameAltMaximizeIcon(int n) {
        return new InternalFrameAltMaximizeIcon(n);
    }

    public static Icon getInternalFrameCloseIcon(int n) {
        return new InternalFrameCloseIcon(n);
    }

    public static Icon getInternalFrameDefaultMenuIcon() {
        if (internalFrameDefaultMenuIcon == null) {
            internalFrameDefaultMenuIcon = new InternalFrameDefaultMenuIcon();
        }
        return internalFrameDefaultMenuIcon;
    }

    public static Icon getInternalFrameMaximizeIcon(int n) {
        return new InternalFrameMaximizeIcon(n);
    }

    public static Icon getInternalFrameMinimizeIcon(int n) {
        return new InternalFrameMinimizeIcon(n);
    }

    public static Icon getRadioButtonIcon() {
        if (radioButtonIcon == null) {
            radioButtonIcon = new RadioButtonIcon();
        }
        return radioButtonIcon;
    }

    public static Icon getTreeComputerIcon() {
        if (treeComputerIcon == null) {
            treeComputerIcon = new TreeComputerIcon();
        }
        return treeComputerIcon;
    }

    public static Icon getTreeFloppyDriveIcon() {
        if (treeFloppyDriveIcon == null) {
            treeFloppyDriveIcon = new TreeFloppyDriveIcon();
        }
        return treeFloppyDriveIcon;
    }

    public static Icon getTreeFolderIcon() {
        if (treeFolderIcon == null) {
            treeFolderIcon = new TreeFolderIcon();
        }
        return treeFolderIcon;
    }

    public static Icon getTreeHardDriveIcon() {
        if (treeHardDriveIcon == null) {
            treeHardDriveIcon = new TreeHardDriveIcon();
        }
        return treeHardDriveIcon;
    }

    public static Icon getTreeLeafIcon() {
        if (treeLeafIcon == null) {
            treeLeafIcon = new TreeLeafIcon();
        }
        return treeLeafIcon;
    }

    public static Icon getTreeControlIcon(boolean bl) {
        if (bl) {
            if (treeLightControlIcon == null) {
                treeLightControlIcon = new TreeControlIcon(true);
            }
            return treeLightControlIcon;
        }
        if (treeDarkControlIcon == null) {
            treeDarkControlIcon = new TreeControlIcon(false);
        }
        return treeDarkControlIcon;
    }

    public static Icon getMenuArrowIcon() {
        if (menuArrowIcon == null) {
            menuArrowIcon = new MenuArrowIcon();
        }
        return menuArrowIcon;
    }

    public static Icon getMenuItemCheckIcon() {
        if (menuItemCheckIcon == null) {
            menuItemCheckIcon = new MenuItemCheckIcon();
        }
        return menuItemCheckIcon;
    }

    public static Icon getMenuItemArrowIcon() {
        if (menuItemArrowIcon == null) {
            menuItemArrowIcon = new MenuItemArrowIcon();
        }
        return menuItemArrowIcon;
    }

    public static Icon getCheckBoxMenuItemIcon() {
        if (checkBoxMenuItemIcon == null) {
            checkBoxMenuItemIcon = new CheckBoxMenuItemIcon();
        }
        return checkBoxMenuItemIcon;
    }

    public static Icon getRadioButtonMenuItemIcon() {
        if (radioButtonMenuItemIcon == null) {
            radioButtonMenuItemIcon = new RadioButtonMenuItemIcon();
        }
        return radioButtonMenuItemIcon;
    }

    public static Icon getHorizontalSliderThumbIcon() {
        return new HorizontalSliderThumbIcon();
    }

    public static Icon getVerticalSliderThumbIcon() {
        return new VerticalSliderThumbIcon();
    }

    static /* synthetic */ int access$5() {
        return 4;
    }

    static {
        folderIcon16Size = new Dimension(16, 16);
        fileIcon16Size = new Dimension(16, 16);
        treeControlSize = new Dimension(8, 8);
        menuArrowIconSize = new Dimension(4, 8);
        menuCheckIconSize = new Dimension(12, 10);
    }

    private static class InternalFrameCloseIcon
    extends InternalFrameMaximizeIcon {
        Color slashColor;

        public InternalFrameCloseIcon(int n) {
            super(n);
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            super.paintIcon(component, graphics, n, n2);
            this.slashColor = MetalLookAndFeel.getPrimaryControlDarkShadow();
            if (this.parentButton.getClientProperty("paintActive") != Boolean.TRUE) {
                this.slashColor = MetalLookAndFeel.getControlDarkShadow();
            } else if (this.buttonModel.isPressed() && this.buttonModel.isArmed()) {
                this.slashColor = MetalLookAndFeel.getPrimaryControlInfo();
            }
            graphics.translate(n, n2);
            graphics.setColor(this.slashColor);
            int n3 = 2;
            while (this.iconSize >= n3 + 4) {
                graphics.fillRect(n3, this.iconSize - n3 - 2, 2, 2);
                ++n3;
            }
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return this.iconSize;
        }

        public int getIconHeight() {
            return this.iconSize;
        }
    }

    private static class FileChooserDetailViewIcon
    implements Icon,
    UIResource,
    Serializable {
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.translate(n, n2);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            graphics.drawLine(2, 2, 5, 2);
            graphics.drawLine(2, 3, 2, 7);
            graphics.drawLine(3, 7, 6, 7);
            graphics.drawLine(6, 6, 6, 3);
            graphics.drawLine(2, 10, 5, 10);
            graphics.drawLine(2, 11, 2, 15);
            graphics.drawLine(3, 15, 6, 15);
            graphics.drawLine(6, 14, 6, 11);
            graphics.drawLine(8, 5, 15, 5);
            graphics.drawLine(8, 13, 15, 13);
            graphics.setColor(MetalLookAndFeel.getPrimaryControl());
            graphics.drawRect(3, 3, 2, 3);
            graphics.drawRect(3, 11, 2, 3);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
            graphics.drawLine(4, 4, 4, 5);
            graphics.drawLine(4, 12, 4, 13);
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return 18;
        }

        public int getIconHeight() {
            return 18;
        }

        FileChooserDetailViewIcon() {
        }
    }

    private static class FileChooserHomeFolderIcon
    implements Icon,
    UIResource,
    Serializable {
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.translate(n, n2);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            graphics.drawLine(8, 1, 1, 8);
            graphics.drawLine(8, 1, 15, 8);
            graphics.drawLine(11, 2, 11, 3);
            graphics.drawLine(12, 2, 12, 4);
            graphics.drawLine(3, 7, 3, 15);
            graphics.drawLine(13, 7, 13, 15);
            graphics.drawLine(4, 15, 12, 15);
            graphics.drawLine(6, 9, 6, 14);
            graphics.drawLine(10, 9, 10, 14);
            graphics.drawLine(7, 9, 9, 9);
            graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
            graphics.fillRect(8, 2, 1, 1);
            graphics.fillRect(7, 3, 3, 1);
            graphics.fillRect(6, 4, 5, 1);
            graphics.fillRect(5, 5, 7, 1);
            graphics.fillRect(4, 6, 9, 2);
            graphics.drawLine(9, 12, 9, 12);
            graphics.setColor(MetalLookAndFeel.getPrimaryControl());
            graphics.drawLine(4, 8, 12, 8);
            graphics.fillRect(4, 9, 2, 6);
            graphics.fillRect(11, 9, 2, 6);
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return 18;
        }

        public int getIconHeight() {
            return 18;
        }

        FileChooserHomeFolderIcon() {
        }
    }

    private static class FileChooserListViewIcon
    implements Icon,
    UIResource,
    Serializable {
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.translate(n, n2);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            graphics.drawLine(2, 2, 5, 2);
            graphics.drawLine(2, 3, 2, 7);
            graphics.drawLine(3, 7, 6, 7);
            graphics.drawLine(6, 6, 6, 3);
            graphics.drawLine(10, 2, 13, 2);
            graphics.drawLine(10, 3, 10, 7);
            graphics.drawLine(11, 7, 14, 7);
            graphics.drawLine(14, 6, 14, 3);
            graphics.drawLine(2, 10, 5, 10);
            graphics.drawLine(2, 11, 2, 15);
            graphics.drawLine(3, 15, 6, 15);
            graphics.drawLine(6, 14, 6, 11);
            graphics.drawLine(10, 10, 13, 10);
            graphics.drawLine(10, 11, 10, 15);
            graphics.drawLine(11, 15, 14, 15);
            graphics.drawLine(14, 14, 14, 11);
            graphics.drawLine(8, 5, 8, 5);
            graphics.drawLine(16, 5, 16, 5);
            graphics.drawLine(8, 13, 8, 13);
            graphics.drawLine(16, 13, 16, 13);
            graphics.setColor(MetalLookAndFeel.getPrimaryControl());
            graphics.drawRect(3, 3, 2, 3);
            graphics.drawRect(11, 3, 2, 3);
            graphics.drawRect(3, 11, 2, 3);
            graphics.drawRect(11, 11, 2, 3);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
            graphics.drawLine(4, 4, 4, 5);
            graphics.drawLine(12, 4, 12, 5);
            graphics.drawLine(4, 12, 4, 13);
            graphics.drawLine(12, 12, 12, 13);
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return 18;
        }

        public int getIconHeight() {
            return 18;
        }

        FileChooserListViewIcon() {
        }
    }

    private static class FileChooserNewFolderIcon
    implements Icon,
    UIResource,
    Serializable {
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.translate(n, n2);
            graphics.setColor(MetalLookAndFeel.getPrimaryControl());
            graphics.fillRect(3, 5, 12, 9);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            graphics.drawLine(1, 6, 1, 14);
            graphics.drawLine(2, 14, 15, 14);
            graphics.drawLine(15, 13, 15, 5);
            graphics.drawLine(2, 5, 9, 5);
            graphics.drawLine(10, 6, 14, 6);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
            graphics.drawLine(2, 6, 2, 13);
            graphics.drawLine(3, 6, 9, 6);
            graphics.drawLine(10, 7, 14, 7);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            graphics.drawLine(11, 3, 15, 3);
            graphics.drawLine(10, 4, 15, 4);
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return 18;
        }

        public int getIconHeight() {
            return 18;
        }

        FileChooserNewFolderIcon() {
        }
    }

    private static class FileChooserUpFolderIcon
    implements Icon,
    UIResource,
    Serializable {
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.translate(n, n2);
            graphics.setColor(MetalLookAndFeel.getPrimaryControl());
            graphics.fillRect(3, 5, 12, 9);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            graphics.drawLine(1, 6, 1, 14);
            graphics.drawLine(2, 14, 15, 14);
            graphics.drawLine(15, 13, 15, 5);
            graphics.drawLine(2, 5, 9, 5);
            graphics.drawLine(10, 6, 14, 6);
            graphics.drawLine(8, 13, 8, 16);
            graphics.drawLine(8, 9, 8, 9);
            graphics.drawLine(7, 10, 9, 10);
            graphics.drawLine(6, 11, 10, 11);
            graphics.drawLine(5, 12, 11, 12);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
            graphics.drawLine(2, 6, 2, 13);
            graphics.drawLine(3, 6, 9, 6);
            graphics.drawLine(10, 7, 14, 7);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            graphics.drawLine(11, 3, 15, 3);
            graphics.drawLine(10, 4, 15, 4);
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return 18;
        }

        public int getIconHeight() {
            return 18;
        }

        FileChooserUpFolderIcon() {
        }
    }

    private static class InternalFrameAltMaximizeIcon
    implements Icon,
    UIResource,
    Serializable {
        JButton parentButton;
        ButtonModel buttonModel;
        Color backgroundColor;
        Color titleColor;
        Color titleHighlight;
        Color edgeColor;
        Color smallEdgeColor;
        Color downRightHighlight;
        Color upLeftHighlight;
        int iconSize = 12;

        public InternalFrameAltMaximizeIcon(int n) {
            this.iconSize = n;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            this.parentButton = (JButton)component;
            this.buttonModel = this.parentButton.getModel();
            this.downRightHighlight = MetalLookAndFeel.getPrimaryControlHighlight();
            this.upLeftHighlight = MetalLookAndFeel.getPrimaryControlShadow();
            this.backgroundColor = MetalLookAndFeel.getPrimaryControl();
            this.titleColor = MetalLookAndFeel.getPrimaryControlShadow();
            this.titleHighlight = MetalLookAndFeel.getPrimaryControlDarkShadow();
            this.edgeColor = MetalLookAndFeel.getPrimaryControlShadow();
            this.smallEdgeColor = MetalLookAndFeel.getPrimaryControlInfo();
            if (this.parentButton.getClientProperty("paintActive") != Boolean.TRUE) {
                this.downRightHighlight = MetalLookAndFeel.getControlHighlight();
                this.upLeftHighlight = MetalLookAndFeel.getControlShadow();
                this.backgroundColor = MetalLookAndFeel.getControl();
                this.titleColor = MetalLookAndFeel.getControlShadow();
                this.titleHighlight = MetalLookAndFeel.getControlDarkShadow();
                this.edgeColor = MetalLookAndFeel.getControlShadow();
            } else if (this.buttonModel.isPressed() && this.buttonModel.isArmed()) {
                this.backgroundColor = MetalLookAndFeel.getPrimaryControlShadow();
                this.titleColor = MetalLookAndFeel.getPrimaryControlDarkShadow();
                this.titleHighlight = MetalLookAndFeel.getPrimaryControlInfo();
                this.edgeColor = MetalLookAndFeel.getPrimaryControlDarkShadow();
            }
            int n3 = this.iconSize / 3;
            int n4 = this.iconSize / 2;
            graphics.translate(n, n2);
            graphics.setColor(this.backgroundColor);
            graphics.fillRect(0, 0, this.iconSize, this.iconSize);
            graphics.setColor(this.downRightHighlight);
            graphics.drawLine(1, this.iconSize - 1, this.iconSize - 1, this.iconSize - 1);
            graphics.drawLine(this.iconSize - 1, 1, this.iconSize - 1, this.iconSize - 1);
            graphics.setColor(this.upLeftHighlight);
            graphics.drawLine(0, 0, 0, this.iconSize - 2);
            graphics.drawLine(0, 0, this.iconSize - 2, 0);
            graphics.setColor(this.edgeColor);
            graphics.drawRect(1, 1, this.iconSize - 3, this.iconSize - 3);
            graphics.setColor(this.smallEdgeColor);
            graphics.drawRect(1, n3, n4, n4);
            graphics.setColor(this.titleColor);
            graphics.fillRect(2, n3 + 1, n4 - 1, n4 - n3);
            graphics.setColor(this.titleHighlight);
            graphics.drawLine(2, n4 + 1, n3, n4 + 1);
            graphics.drawLine(n3 + 1, n4, n4, n4);
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return this.iconSize;
        }

        public int getIconHeight() {
            return this.iconSize;
        }
    }

    private static class InternalFrameDefaultMenuIcon
    implements Icon,
    UIResource,
    Serializable {
        Color backgroundColor;
        Color titleColor;
        Color edgeColor;
        Color slashColor;

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            this.backgroundColor = MetalLookAndFeel.getWindowBackground();
            this.titleColor = MetalLookAndFeel.getPrimaryControl();
            this.edgeColor = MetalLookAndFeel.getPrimaryControlDarkShadow();
            graphics.translate(n, n2);
            graphics.setColor(this.backgroundColor);
            graphics.fillRect(0, 0, 16, 16);
            graphics.setColor(this.titleColor);
            graphics.fillRect(2, 2, 12, 2);
            graphics.drawLine(2, 4, 10, 4);
            graphics.drawLine(2, 5, 9, 5);
            graphics.setColor(this.edgeColor);
            graphics.drawRect(0, 0, 15, 15);
            graphics.drawRect(1, 1, 13, 13);
            graphics.drawLine(2, 6, 9, 6);
            graphics.drawLine(10, 5, 10, 5);
            graphics.drawLine(11, 4, 13, 4);
            graphics.drawLine(4, 4, 4, 4);
            graphics.drawLine(7, 4, 7, 4);
            graphics.setColor(this.backgroundColor);
            graphics.drawLine(3, 3, 3, 3);
            graphics.drawLine(6, 3, 6, 3);
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }

        InternalFrameDefaultMenuIcon() {
        }
    }

    private static class InternalFrameMaximizeIcon
    implements Icon,
    UIResource,
    Serializable {
        protected JButton parentButton;
        protected ButtonModel buttonModel;
        protected Color backgroundColor;
        protected Color titleColor;
        protected Color titleHighlight;
        protected Color edgeColor;
        protected Color downRightHighlight;
        protected Color upLeftHighlight;
        protected int iconSize = 12;

        public InternalFrameMaximizeIcon(int n) {
            this.iconSize = n;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            this.parentButton = (JButton)component;
            this.buttonModel = this.parentButton.getModel();
            this.downRightHighlight = MetalLookAndFeel.getPrimaryControlHighlight();
            this.upLeftHighlight = MetalLookAndFeel.getPrimaryControlShadow();
            this.backgroundColor = MetalLookAndFeel.getPrimaryControl();
            this.titleColor = MetalLookAndFeel.getPrimaryControlShadow();
            this.titleHighlight = MetalLookAndFeel.getPrimaryControlDarkShadow();
            this.edgeColor = MetalLookAndFeel.getPrimaryControlInfo();
            if (this.parentButton.getClientProperty("paintActive") != Boolean.TRUE) {
                this.downRightHighlight = MetalLookAndFeel.getControlHighlight();
                this.upLeftHighlight = MetalLookAndFeel.getControlShadow();
                this.backgroundColor = MetalLookAndFeel.getControl();
                this.titleColor = MetalLookAndFeel.getControlShadow();
                this.titleHighlight = MetalLookAndFeel.getControlDarkShadow();
            } else if (this.buttonModel.isPressed() && this.buttonModel.isArmed()) {
                this.backgroundColor = MetalLookAndFeel.getPrimaryControlShadow();
                this.titleColor = MetalLookAndFeel.getPrimaryControlDarkShadow();
                this.titleHighlight = MetalLookAndFeel.getPrimaryControlInfo();
            }
            int n3 = this.iconSize / 3;
            int n4 = this.iconSize / 2;
            graphics.translate(n, n2);
            graphics.setColor(this.backgroundColor);
            graphics.fillRect(0, 0, this.iconSize, this.iconSize);
            graphics.setColor(this.downRightHighlight);
            graphics.drawLine(1, this.iconSize - 1, this.iconSize - 1, this.iconSize - 1);
            graphics.drawLine(this.iconSize - 1, 1, this.iconSize - 1, this.iconSize - 1);
            graphics.setColor(this.upLeftHighlight);
            graphics.drawLine(0, 0, 0, this.iconSize - 2);
            graphics.drawLine(0, 0, this.iconSize - 2, 0);
            graphics.setColor(this.titleColor);
            graphics.fillRect(2, 2, this.iconSize - 3, n3 - 2);
            graphics.setColor(this.edgeColor);
            graphics.drawRect(1, 1, this.iconSize - 3, this.iconSize - 3);
            graphics.setColor(this.titleHighlight);
            graphics.drawLine(2, n3, n4, n3);
            graphics.drawLine(n4 + 1, n3 - 1, this.iconSize - 3, n3 - 1);
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return this.iconSize;
        }

        public int getIconHeight() {
            return this.iconSize;
        }
    }

    private static class InternalFrameMinimizeIcon
    implements Icon,
    UIResource,
    Serializable {
        JButton parentButton;
        ButtonModel buttonModel;
        Color backgroundColor;
        Color titleColor;
        Color edgeColor;
        Color highlightColor;
        Color downRightHighlight;
        Color upLeftHighlight;
        int iconSize = 12;

        public InternalFrameMinimizeIcon(int n) {
            this.iconSize = n;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            this.parentButton = (JButton)component;
            this.buttonModel = this.parentButton.getModel();
            this.downRightHighlight = MetalLookAndFeel.getPrimaryControlHighlight();
            this.upLeftHighlight = MetalLookAndFeel.getPrimaryControlShadow();
            this.backgroundColor = MetalLookAndFeel.getPrimaryControl();
            this.titleColor = MetalLookAndFeel.getPrimaryControlShadow();
            this.edgeColor = MetalLookAndFeel.getPrimaryControlShadow();
            this.highlightColor = MetalLookAndFeel.getPrimaryControlInfo();
            if (this.parentButton.getClientProperty("paintActive") != Boolean.TRUE) {
                this.downRightHighlight = MetalLookAndFeel.getControlHighlight();
                this.upLeftHighlight = MetalLookAndFeel.getControlShadow();
                this.backgroundColor = MetalLookAndFeel.getControl();
                this.titleColor = MetalLookAndFeel.getControlShadow();
                this.edgeColor = MetalLookAndFeel.getControlShadow();
            } else if (this.buttonModel.isPressed() && this.buttonModel.isArmed()) {
                this.backgroundColor = MetalLookAndFeel.getPrimaryControlShadow();
                this.titleColor = MetalLookAndFeel.getPrimaryControlDarkShadow();
                this.edgeColor = MetalLookAndFeel.getPrimaryControlInfo();
            }
            int n3 = this.iconSize * 2 / 3;
            graphics.translate(n, n2);
            graphics.setColor(this.backgroundColor);
            graphics.fillRect(0, 0, this.iconSize, this.iconSize);
            graphics.setColor(this.downRightHighlight);
            graphics.drawLine(1, this.iconSize - 1, this.iconSize - 1, this.iconSize - 1);
            graphics.drawLine(this.iconSize - 1, 1, this.iconSize - 1, this.iconSize - 1);
            graphics.setColor(this.upLeftHighlight);
            graphics.drawLine(0, 0, 0, this.iconSize - 2);
            graphics.drawLine(0, 0, this.iconSize - 2, 0);
            graphics.setColor(this.edgeColor);
            graphics.drawRect(1, 1, this.iconSize - 3, this.iconSize - 3);
            graphics.setColor(this.titleColor);
            graphics.fillRect(1, n3, this.iconSize - 3, this.iconSize - n3 - 2);
            graphics.setColor(this.highlightColor);
            graphics.drawRect(1, n3, this.iconSize - 3, this.iconSize - n3 - 2);
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return this.iconSize;
        }

        public int getIconHeight() {
            return this.iconSize;
        }
    }

    private static class RadioButtonIcon
    implements Icon,
    UIResource,
    Serializable {
        JRadioButton rb;
        ButtonModel model;
        boolean drawDot;
        Color background;
        Color shadow;
        Color darkCircle;
        Color dotColor;
        Color interiorColor;
        Color whiteInnerLeftArc;
        Color whiteOuterRightArc;

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            this.rb = (JRadioButton)component;
            this.model = this.rb.getModel();
            this.drawDot = this.model.isSelected();
            this.background = component.getBackground();
            this.dotColor = component.getForeground();
            this.shadow = MetalLookAndFeel.getControlShadow();
            this.darkCircle = MetalLookAndFeel.getControlDarkShadow();
            this.whiteInnerLeftArc = MetalLookAndFeel.getControlHighlight();
            this.whiteOuterRightArc = MetalLookAndFeel.getControlHighlight();
            this.interiorColor = this.background;
            if (!this.model.isEnabled()) {
                this.whiteInnerLeftArc = this.whiteOuterRightArc = this.background;
                this.darkCircle = this.dotColor = this.shadow;
            } else if (this.model.isPressed() && this.model.isArmed()) {
                this.whiteInnerLeftArc = this.interiorColor = this.shadow;
            }
            graphics.translate(n, n2);
            graphics.setColor(this.interiorColor);
            graphics.fillRect(2, 2, 9, 9);
            graphics.setColor(this.darkCircle);
            graphics.drawLine(4, 0, 7, 0);
            graphics.drawLine(8, 1, 9, 1);
            graphics.drawLine(10, 2, 10, 3);
            graphics.drawLine(11, 4, 11, 7);
            graphics.drawLine(10, 8, 10, 9);
            graphics.drawLine(9, 10, 8, 10);
            graphics.drawLine(7, 11, 4, 11);
            graphics.drawLine(3, 10, 2, 10);
            graphics.drawLine(1, 9, 1, 8);
            graphics.drawLine(0, 7, 0, 4);
            graphics.drawLine(1, 3, 1, 2);
            graphics.drawLine(2, 1, 3, 1);
            graphics.setColor(this.whiteInnerLeftArc);
            graphics.drawLine(2, 9, 2, 8);
            graphics.drawLine(1, 7, 1, 4);
            graphics.drawLine(2, 2, 2, 3);
            graphics.drawLine(2, 2, 3, 2);
            graphics.drawLine(4, 1, 7, 1);
            graphics.drawLine(8, 2, 9, 2);
            graphics.setColor(this.whiteOuterRightArc);
            graphics.drawLine(10, 1, 10, 1);
            graphics.drawLine(11, 2, 11, 3);
            graphics.drawLine(12, 4, 12, 7);
            graphics.drawLine(11, 8, 11, 9);
            graphics.drawLine(10, 10, 10, 10);
            graphics.drawLine(9, 11, 8, 11);
            graphics.drawLine(7, 12, 4, 12);
            graphics.drawLine(3, 11, 2, 11);
            if (this.drawDot) {
                graphics.setColor(this.dotColor);
                graphics.fillRect(4, 4, 4, 4);
                graphics.drawLine(4, 3, 7, 3);
                graphics.drawLine(8, 4, 8, 7);
                graphics.drawLine(7, 8, 4, 8);
                graphics.drawLine(3, 7, 3, 4);
            }
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return 13;
        }

        public int getIconHeight() {
            return 13;
        }

        RadioButtonIcon() {
        }
    }

    private static class TreeComputerIcon
    implements Icon,
    UIResource,
    Serializable {
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.translate(n, n2);
            graphics.setColor(MetalLookAndFeel.getPrimaryControl());
            graphics.fillRect(5, 4, 6, 4);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            graphics.drawLine(2, 2, 2, 8);
            graphics.drawLine(13, 2, 13, 8);
            graphics.drawLine(3, 1, 12, 1);
            graphics.drawLine(12, 9, 12, 9);
            graphics.drawLine(3, 9, 3, 9);
            graphics.drawLine(4, 4, 4, 7);
            graphics.drawLine(5, 3, 10, 3);
            graphics.drawLine(11, 4, 11, 7);
            graphics.drawLine(5, 8, 10, 8);
            graphics.drawLine(1, 10, 14, 10);
            graphics.drawLine(14, 10, 14, 14);
            graphics.drawLine(1, 14, 14, 14);
            graphics.drawLine(1, 10, 1, 14);
            graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
            graphics.drawLine(6, 12, 8, 12);
            graphics.drawLine(10, 12, 12, 12);
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }

        TreeComputerIcon() {
        }
    }

    private static class TreeHardDriveIcon
    implements Icon,
    UIResource,
    Serializable {
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.translate(n, n2);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            graphics.drawLine(1, 4, 1, 5);
            graphics.drawLine(2, 3, 3, 3);
            graphics.drawLine(4, 2, 11, 2);
            graphics.drawLine(12, 3, 13, 3);
            graphics.drawLine(14, 4, 14, 5);
            graphics.drawLine(12, 6, 13, 6);
            graphics.drawLine(4, 7, 11, 7);
            graphics.drawLine(2, 6, 3, 6);
            graphics.drawLine(1, 7, 1, 8);
            graphics.drawLine(2, 9, 3, 9);
            graphics.drawLine(4, 10, 11, 10);
            graphics.drawLine(12, 9, 13, 9);
            graphics.drawLine(14, 7, 14, 8);
            graphics.drawLine(1, 10, 1, 11);
            graphics.drawLine(2, 12, 3, 12);
            graphics.drawLine(4, 13, 11, 13);
            graphics.drawLine(12, 12, 13, 12);
            graphics.drawLine(14, 10, 14, 11);
            graphics.setColor(MetalLookAndFeel.getControlShadow());
            graphics.drawLine(7, 6, 7, 6);
            graphics.drawLine(9, 6, 9, 6);
            graphics.drawLine(10, 5, 10, 5);
            graphics.drawLine(11, 6, 11, 6);
            graphics.drawLine(12, 5, 13, 5);
            graphics.drawLine(13, 4, 13, 4);
            graphics.drawLine(7, 9, 7, 9);
            graphics.drawLine(9, 9, 9, 9);
            graphics.drawLine(10, 8, 10, 8);
            graphics.drawLine(11, 9, 11, 9);
            graphics.drawLine(12, 8, 13, 8);
            graphics.drawLine(13, 7, 13, 7);
            graphics.drawLine(7, 12, 7, 12);
            graphics.drawLine(9, 12, 9, 12);
            graphics.drawLine(10, 11, 10, 11);
            graphics.drawLine(11, 12, 11, 12);
            graphics.drawLine(12, 11, 13, 11);
            graphics.drawLine(13, 10, 13, 10);
            graphics.setColor(MetalLookAndFeel.getControlHighlight());
            graphics.drawLine(4, 3, 5, 3);
            graphics.drawLine(7, 3, 9, 3);
            graphics.drawLine(11, 3, 11, 3);
            graphics.drawLine(2, 4, 6, 4);
            graphics.drawLine(8, 4, 8, 4);
            graphics.drawLine(2, 5, 3, 5);
            graphics.drawLine(4, 6, 4, 6);
            graphics.drawLine(2, 7, 3, 7);
            graphics.drawLine(2, 8, 3, 8);
            graphics.drawLine(4, 9, 4, 9);
            graphics.drawLine(2, 10, 3, 10);
            graphics.drawLine(2, 11, 3, 11);
            graphics.drawLine(4, 12, 4, 12);
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }

        TreeHardDriveIcon() {
        }
    }

    private static class TreeFloppyDriveIcon
    implements Icon,
    UIResource,
    Serializable {
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.translate(n, n2);
            graphics.setColor(MetalLookAndFeel.getPrimaryControl());
            graphics.fillRect(2, 2, 12, 12);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            graphics.drawLine(1, 1, 13, 1);
            graphics.drawLine(14, 2, 14, 14);
            graphics.drawLine(1, 14, 14, 14);
            graphics.drawLine(1, 1, 1, 14);
            graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
            graphics.fillRect(5, 2, 6, 5);
            graphics.drawLine(4, 8, 11, 8);
            graphics.drawLine(3, 9, 3, 13);
            graphics.drawLine(12, 9, 12, 13);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
            graphics.fillRect(8, 3, 2, 3);
            graphics.fillRect(4, 9, 8, 5);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlShadow());
            graphics.drawLine(5, 10, 9, 10);
            graphics.drawLine(5, 12, 8, 12);
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }

        TreeFloppyDriveIcon() {
        }
    }

    public static class FolderIcon16
    implements Icon,
    Serializable {
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.translate(n, n2 + this.getShift());
            int n3 = folderIcon16Size.width - 1;
            int n4 = folderIcon16Size.height - 1;
            graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            graphics.drawLine(n3 - 5, 3, n3, 3);
            graphics.drawLine(n3 - 6, 4, n3, 4);
            graphics.setColor(MetalLookAndFeel.getPrimaryControl());
            graphics.fillRect(2, 7, 13, 8);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlShadow());
            graphics.drawLine(n3 - 6, 5, n3 - 1, 5);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            graphics.drawLine(0, 6, 0, n4);
            graphics.drawLine(1, 5, n3 - 7, 5);
            graphics.drawLine(n3 - 6, 6, n3 - 1, 6);
            graphics.drawLine(n3, 5, n3, n4);
            graphics.drawLine(0, n4, n3, n4);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
            graphics.drawLine(1, 6, 1, n4 - 1);
            graphics.drawLine(1, 6, n3 - 7, 6);
            graphics.drawLine(n3 - 6, 7, n3 - 1, 7);
            graphics.translate(-n, -(n2 + this.getShift()));
        }

        public int getShift() {
            return 0;
        }

        public int getAdditionalHeight() {
            return 0;
        }

        public int getIconWidth() {
            return folderIcon16Size.width;
        }

        public int getIconHeight() {
            return folderIcon16Size.height + this.getAdditionalHeight();
        }
    }

    public static class TreeFolderIcon
    extends FolderIcon16 {
        public int getShift() {
            return -1;
        }

        public int getAdditionalHeight() {
            return 2;
        }
    }

    public static class FileIcon16
    implements Icon,
    Serializable {
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.translate(n, n2 + this.getShift());
            int n3 = fileIcon16Size.width - 1;
            int n4 = fileIcon16Size.height - 1;
            graphics.setColor(MetalLookAndFeel.getWindowBackground());
            graphics.fillRect(4, 2, 9, 12);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            graphics.drawLine(2, 0, 2, n4);
            graphics.drawLine(2, 0, n3 - 4, 0);
            graphics.drawLine(2, n4, n3 - 1, n4);
            graphics.drawLine(n3 - 1, 6, n3 - 1, n4);
            graphics.drawLine(n3 - 6, 2, n3 - 2, 6);
            graphics.drawLine(n3 - 5, 1, n3 - 4, 1);
            graphics.drawLine(n3 - 3, 2, n3 - 3, 3);
            graphics.drawLine(n3 - 2, 4, n3 - 2, 5);
            graphics.setColor(MetalLookAndFeel.getPrimaryControl());
            graphics.drawLine(3, 1, 3, n4 - 1);
            graphics.drawLine(3, 1, n3 - 6, 1);
            graphics.drawLine(n3 - 2, 7, n3 - 2, n4 - 1);
            graphics.drawLine(n3 - 5, 2, n3 - 3, 4);
            graphics.drawLine(3, n4 - 1, n3 - 2, n4 - 1);
            graphics.translate(-n, -(n2 + this.getShift()));
        }

        public int getShift() {
            return 0;
        }

        public int getAdditionalHeight() {
            return 0;
        }

        public int getIconWidth() {
            return fileIcon16Size.width;
        }

        public int getIconHeight() {
            return fileIcon16Size.height + this.getAdditionalHeight();
        }
    }

    public static class TreeLeafIcon
    extends FileIcon16 {
        public int getShift() {
            return 2;
        }

        public int getAdditionalHeight() {
            return 4;
        }
    }

    public static class TreeControlIcon
    implements Icon,
    Serializable {
        protected boolean isLight;

        public TreeControlIcon(boolean bl) {
            this.isLight = bl;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.translate(n, n2);
            graphics.setColor(this.isLight ? MetalLookAndFeel.getPrimaryControl() : MetalLookAndFeel.getPrimaryControlDarkShadow());
            graphics.fillRect(1, 1, 6, 6);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            graphics.drawLine(0, 2, 0, 5);
            graphics.drawLine(1, 1, 1, 1);
            graphics.drawLine(2, 0, 5, 0);
            graphics.drawLine(6, 1, 6, 1);
            graphics.drawLine(7, 2, 7, 5);
            graphics.drawLine(6, 6, 6, 6);
            graphics.drawLine(2, 7, 5, 7);
            graphics.drawLine(1, 6, 1, 6);
            graphics.setColor(this.isLight ? MetalLookAndFeel.getPrimaryControlHighlight() : MetalLookAndFeel.getPrimaryControlShadow());
            graphics.drawLine(1, 2, 1, 5);
            graphics.drawLine(2, 1, 5, 1);
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return treeControlSize.width;
        }

        public int getIconHeight() {
            return treeControlSize.height;
        }
    }

    private static class MenuArrowIcon
    implements Icon,
    UIResource,
    Serializable {
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            JMenuItem jMenuItem = (JMenuItem)component;
            ButtonModel buttonModel = jMenuItem.getModel();
            graphics.translate(n, n2);
            if (!buttonModel.isEnabled()) {
                graphics.setColor(MetalLookAndFeel.getMenuDisabledForeground());
            } else if (buttonModel.isArmed() || component instanceof JMenu && buttonModel.isSelected()) {
                graphics.setColor(MetalLookAndFeel.getMenuSelectedForeground());
            } else {
                graphics.setColor(jMenuItem.getForeground());
            }
            graphics.drawLine(0, 0, 0, 7);
            graphics.drawLine(1, 1, 1, 6);
            graphics.drawLine(2, 2, 2, 5);
            graphics.drawLine(3, 3, 3, 4);
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return menuArrowIconSize.width;
        }

        public int getIconHeight() {
            return menuArrowIconSize.height;
        }

        MenuArrowIcon() {
        }
    }

    private static class MenuItemCheckIcon
    implements Icon,
    UIResource,
    Serializable {
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }

        public int getIconWidth() {
            return menuCheckIconSize.width;
        }

        public int getIconHeight() {
            return menuCheckIconSize.height;
        }

        MenuItemCheckIcon() {
        }
    }

    private static class MenuItemArrowIcon
    implements Icon,
    UIResource,
    Serializable {
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }

        public int getIconWidth() {
            return menuArrowIconSize.width;
        }

        public int getIconHeight() {
            return menuArrowIconSize.height;
        }

        MenuItemArrowIcon() {
        }
    }

    private static class CheckBoxMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            JMenuItem jMenuItem = (JMenuItem)component;
            ButtonModel buttonModel = jMenuItem.getModel();
            boolean bl = buttonModel.isSelected();
            boolean bl2 = buttonModel.isEnabled();
            boolean bl3 = buttonModel.isPressed();
            boolean bl4 = buttonModel.isArmed();
            graphics.translate(n + MetalIconFactory.access$5(), n2);
            if (bl2) {
                if (bl3 || bl4) {
                    graphics.setColor(MetalLookAndFeel.getControlInfo());
                    graphics.drawLine(0, 0, 8, 0);
                    graphics.drawLine(0, 0, 0, 8);
                    graphics.drawLine(8, 2, 8, 8);
                    graphics.drawLine(2, 8, 8, 8);
                    graphics.setColor(MetalLookAndFeel.getPrimaryControl());
                    graphics.drawLine(1, 1, 7, 1);
                    graphics.drawLine(1, 1, 1, 7);
                    graphics.drawLine(9, 1, 9, 9);
                    graphics.drawLine(1, 9, 9, 9);
                } else {
                    graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
                    graphics.drawLine(0, 0, 8, 0);
                    graphics.drawLine(0, 0, 0, 8);
                    graphics.drawLine(8, 2, 8, 8);
                    graphics.drawLine(2, 8, 8, 8);
                    graphics.setColor(MetalLookAndFeel.getControlHighlight());
                    graphics.drawLine(1, 1, 7, 1);
                    graphics.drawLine(1, 1, 1, 7);
                    graphics.drawLine(9, 1, 9, 9);
                    graphics.drawLine(1, 9, 9, 9);
                }
            } else {
                graphics.setColor(MetalLookAndFeel.getMenuDisabledForeground());
                graphics.drawRect(0, 0, 8, 8);
            }
            if (bl) {
                if (bl2) {
                    if (buttonModel.isArmed() || component instanceof JMenu && buttonModel.isSelected()) {
                        graphics.setColor(MetalLookAndFeel.getMenuSelectedForeground());
                    } else {
                        graphics.setColor(jMenuItem.getForeground());
                    }
                } else {
                    graphics.setColor(MetalLookAndFeel.getMenuDisabledForeground());
                }
                graphics.drawLine(2, 2, 2, 6);
                graphics.drawLine(3, 2, 3, 6);
                graphics.drawLine(4, 4, 8, 0);
                graphics.drawLine(4, 5, 9, 0);
            }
            graphics.translate(-(n + MetalIconFactory.access$5()), -n2);
        }

        public int getIconWidth() {
            return menuCheckIconSize.width;
        }

        public int getIconHeight() {
            return menuCheckIconSize.height;
        }

        CheckBoxMenuItemIcon() {
        }
    }

    private static class RadioButtonMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            JMenuItem jMenuItem = (JMenuItem)component;
            ButtonModel buttonModel = jMenuItem.getModel();
            boolean bl = buttonModel.isSelected();
            boolean bl2 = buttonModel.isEnabled();
            boolean bl3 = buttonModel.isPressed();
            boolean bl4 = buttonModel.isArmed();
            graphics.translate(n + MetalIconFactory.access$5(), n2);
            if (bl2) {
                if (bl3 || bl4) {
                    graphics.setColor(MetalLookAndFeel.getPrimaryControl());
                    graphics.drawLine(3, 1, 8, 1);
                    graphics.drawLine(2, 9, 7, 9);
                    graphics.drawLine(1, 3, 1, 8);
                    graphics.drawLine(9, 2, 9, 7);
                    graphics.drawLine(2, 2, 2, 2);
                    graphics.drawLine(8, 8, 8, 8);
                    graphics.setColor(MetalLookAndFeel.getControlInfo());
                    graphics.drawLine(2, 0, 6, 0);
                    graphics.drawLine(2, 8, 6, 8);
                    graphics.drawLine(0, 2, 0, 6);
                    graphics.drawLine(8, 2, 8, 6);
                    graphics.drawLine(1, 1, 1, 1);
                    graphics.drawLine(7, 1, 7, 1);
                    graphics.drawLine(1, 7, 1, 7);
                    graphics.drawLine(7, 7, 7, 7);
                } else {
                    graphics.setColor(MetalLookAndFeel.getControlHighlight());
                    graphics.drawLine(3, 1, 8, 1);
                    graphics.drawLine(2, 9, 7, 9);
                    graphics.drawLine(1, 3, 1, 8);
                    graphics.drawLine(9, 2, 9, 7);
                    graphics.drawLine(2, 2, 2, 2);
                    graphics.drawLine(8, 8, 8, 8);
                    graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
                    graphics.drawLine(2, 0, 6, 0);
                    graphics.drawLine(2, 8, 6, 8);
                    graphics.drawLine(0, 2, 0, 6);
                    graphics.drawLine(8, 2, 8, 6);
                    graphics.drawLine(1, 1, 1, 1);
                    graphics.drawLine(7, 1, 7, 1);
                    graphics.drawLine(1, 7, 1, 7);
                    graphics.drawLine(7, 7, 7, 7);
                }
            } else {
                graphics.setColor(MetalLookAndFeel.getMenuDisabledForeground());
                graphics.drawLine(2, 0, 6, 0);
                graphics.drawLine(2, 8, 6, 8);
                graphics.drawLine(0, 2, 0, 6);
                graphics.drawLine(8, 2, 8, 6);
                graphics.drawLine(1, 1, 1, 1);
                graphics.drawLine(7, 1, 7, 1);
                graphics.drawLine(1, 7, 1, 7);
                graphics.drawLine(7, 7, 7, 7);
            }
            if (bl) {
                if (bl2) {
                    if (buttonModel.isArmed() || component instanceof JMenu && buttonModel.isSelected()) {
                        graphics.setColor(MetalLookAndFeel.getMenuSelectedForeground());
                    } else {
                        graphics.setColor(jMenuItem.getForeground());
                    }
                } else {
                    graphics.setColor(MetalLookAndFeel.getMenuDisabledForeground());
                }
                graphics.drawLine(3, 2, 5, 2);
                graphics.drawLine(2, 3, 6, 3);
                graphics.drawLine(2, 4, 6, 4);
                graphics.drawLine(2, 5, 6, 5);
                graphics.drawLine(3, 6, 5, 6);
            }
            graphics.translate(-(n + MetalIconFactory.access$5()), -n2);
        }

        public int getIconWidth() {
            return menuCheckIconSize.width;
        }

        public int getIconHeight() {
            return menuCheckIconSize.height;
        }

        RadioButtonMenuItemIcon() {
        }
    }

    private static class VerticalSliderThumbIcon
    implements Icon,
    Serializable,
    UIResource {
        protected static MetalBumps bumps;

        public VerticalSliderThumbIcon() {
            bumps = new MetalBumps(6, 10, MetalLookAndFeel.getPrimaryControl(), MetalLookAndFeel.getPrimaryControlDarkShadow(), MetalLookAndFeel.getPrimaryControlShadow());
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            JSlider jSlider = (JSlider)component;
            graphics.translate(n, n2);
            graphics.setColor(jSlider.isEnabled() ? MetalLookAndFeel.getPrimaryControlInfo() : MetalLookAndFeel.getControlDarkShadow());
            graphics.drawLine(1, 0, 8, 0);
            graphics.drawLine(0, 1, 0, 13);
            graphics.drawLine(1, 14, 8, 14);
            graphics.drawLine(9, 1, 15, 7);
            graphics.drawLine(9, 13, 15, 7);
            graphics.setColor(jSlider.isEnabled() ? component.getForeground() : MetalLookAndFeel.getControlShadow());
            graphics.fillRect(1, 1, 8, 13);
            graphics.drawLine(9, 2, 9, 12);
            graphics.drawLine(10, 3, 10, 11);
            graphics.drawLine(11, 4, 11, 10);
            graphics.drawLine(12, 5, 12, 9);
            graphics.drawLine(13, 6, 13, 8);
            graphics.drawLine(14, 7, 14, 7);
            if (jSlider.isEnabled()) {
                bumps.paintIcon(component, graphics, 3, 3);
            }
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 15;
        }
    }

    private static class HorizontalSliderThumbIcon
    implements Icon,
    Serializable,
    UIResource {
        protected static MetalBumps bumps;

        public HorizontalSliderThumbIcon() {
            bumps = new MetalBumps(10, 6, MetalLookAndFeel.getPrimaryControl(), MetalLookAndFeel.getPrimaryControlDarkShadow(), MetalLookAndFeel.getPrimaryControlShadow());
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            JSlider jSlider = (JSlider)component;
            graphics.translate(n, n2);
            graphics.setColor(jSlider.isEnabled() ? MetalLookAndFeel.getPrimaryControlInfo() : MetalLookAndFeel.getControlDarkShadow());
            graphics.drawLine(1, 0, 13, 0);
            graphics.drawLine(0, 1, 0, 8);
            graphics.drawLine(14, 1, 14, 8);
            graphics.drawLine(1, 9, 7, 15);
            graphics.drawLine(7, 15, 14, 8);
            graphics.setColor(jSlider.isEnabled() ? component.getForeground() : MetalLookAndFeel.getControlShadow());
            graphics.fillRect(1, 1, 13, 8);
            graphics.drawLine(2, 9, 12, 9);
            graphics.drawLine(3, 10, 11, 10);
            graphics.drawLine(4, 11, 10, 11);
            graphics.drawLine(5, 12, 9, 12);
            graphics.drawLine(6, 13, 8, 13);
            graphics.drawLine(7, 14, 7, 14);
            if (jSlider.isEnabled()) {
                bumps.paintIcon(component, graphics, 3, 3);
            }
            graphics.translate(-n, -n2);
        }

        public int getIconWidth() {
            return 15;
        }

        public int getIconHeight() {
            return 16;
        }
    }
}

