/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.plaf.basic.AbstractTreeUI;
import com.sun.java.swing.tree.DefaultMutableTreeNode;
import com.sun.java.swing.tree.TreeModel;
import com.sun.java.swing.tree.TreePath;
import com.sun.java.swing.tree.TreeSelectionModel;

public class LargeTreeModelNode
extends DefaultMutableTreeNode {
    protected AbstractTreeUI treeUI;
    protected boolean isExpanded;
    protected int childIndex;

    public LargeTreeModelNode(AbstractTreeUI abstractTreeUI, Object object, int n) {
        super(object);
        this.treeUI = abstractTreeUI;
        this.childIndex = n;
    }

    public TreeModel getModel() {
        return this.treeUI.getModel();
    }

    public int getChildIndex() {
        return this.childIndex;
    }

    public LargeTreeModelNode childAtModelIndex(int n) {
        int n2 = this.getChildCount() - 1;
        while (n2 >= 0) {
            if (((LargeTreeModelNode)this.getChildAt((int)n2)).childIndex == n) {
                return (LargeTreeModelNode)this.getChildAt(n2);
            }
            --n2;
        }
        return null;
    }

    public boolean isVisible() {
        LargeTreeModelNode largeTreeModelNode = (LargeTreeModelNode)this.getParent();
        if (largeTreeModelNode == null) {
            return true;
        }
        return largeTreeModelNode.isExpanded() && largeTreeModelNode.isVisible();
    }

    public int getRow() {
        LargeTreeModelNode largeTreeModelNode = (LargeTreeModelNode)this.getParent();
        if (largeTreeModelNode == null) {
            if (this.treeUI.isRootVisible()) {
                return 0;
            }
            return -1;
        }
        return largeTreeModelNode.getCountTo(this.childIndex);
    }

    public void expand(boolean bl) {
        if (!this.isExpanded) {
            boolean bl2 = this.isVisible();
            this.isExpanded = true;
            if (bl2) {
                this.adjustLargeRowCountBy(this.getTotalChildCount());
            }
            if (bl) {
                this.didAdjustTree();
                this.treeUI.visibleNodesChanged();
            }
            this.treeUI.pathWasExpanded(new TreePath(this.getUserObjectPath()));
            if (this.treeUI != null && bl2) {
                int n;
                int n2 = this.getRow();
                TreeSelectionModel treeSelectionModel = this.treeUI.getSelectionModel();
                if (treeSelectionModel != null && (n = this.getTotalChildCount()) > 0 && treeSelectionModel.isRowSelected(n2) && treeSelectionModel.isRowSelected(n2 + 1)) {
                    TreePath[] treePathArray = new TreePath[n];
                    int n3 = 0;
                    while (n3 < n) {
                        treePathArray[n3] = this.treeUI.getPathForRow(n3 + n2 + 1);
                        ++n3;
                    }
                    treeSelectionModel.addSelectionPaths(treePathArray);
                    return;
                }
                if (treeSelectionModel != null) {
                    treeSelectionModel.resetRowSelection();
                }
            }
        }
    }

    public void collapse(boolean bl) {
        if (this.isExpanded) {
            TreeSelectionModel treeSelectionModel = null;
            TreePath[] treePathArray = this.treeUI != null && (treeSelectionModel = this.treeUI.getSelectionModel()) != null ? treeSelectionModel.getSelectionPaths() : null;
            if (this.isVisible()) {
                this.adjustLargeRowCountBy(-this.getTotalChildCount());
            }
            this.isExpanded = false;
            if (bl) {
                this.didAdjustTree();
                this.treeUI.visibleNodesChanged();
            }
            this.treeUI.pathWasCollapsed(new TreePath(this.getUserObjectPath()));
            if (treePathArray != null) {
                boolean bl2 = false;
                TreePath treePath = new TreePath(this.getUserObjectPath());
                int n = treePathArray.length - 1;
                while (n >= 0) {
                    if (treePathArray[n] != null && treePath.isDescendant(treePathArray[n]) && !treePath.equals(treePathArray[n])) {
                        bl2 = true;
                    } else {
                        treePathArray[n] = null;
                    }
                    --n;
                }
                if (bl2) {
                    treeSelectionModel.removeSelectionPaths(treePathArray);
                }
            }
        }
    }

    public int getTotalChildCount() {
        if (this.isExpanded()) {
            int n = this.getModel().getChildCount(this.getUserObject());
            int n2 = this.getChildCount() - 1;
            while (n2 >= 0) {
                n += ((LargeTreeModelNode)this.getChildAt(n2)).getTotalChildCount();
                --n2;
            }
            return n;
        }
        return 0;
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public void modelChildCountChanged() {
    }

    public int getVisibleLevel() {
        if (this.treeUI.isRootVisible()) {
            return this.getLevel();
        }
        return this.getLevel() - 1;
    }

    public void toggleExpanded() {
        if (this.isExpanded()) {
            this.collapse(true);
            return;
        }
        this.expand(true);
    }

    protected void adjustLargeRowCountBy(int n) {
        this.treeUI.largeRowCount += n;
    }

    protected void addLargeTreeModelNode(LargeTreeModelNode largeTreeModelNode) {
        boolean bl = false;
        int n = largeTreeModelNode.getChildIndex();
        int n2 = 0;
        int n3 = this.getChildCount();
        while (n2 < n3) {
            if (((LargeTreeModelNode)this.getChildAt(n2)).getChildIndex() > n) {
                bl = true;
                this.insert(largeTreeModelNode, n2);
                n2 = n3;
            }
            ++n2;
        }
        if (!bl) {
            this.add(largeTreeModelNode);
        }
    }

    protected void childRemovedAtModelIndex(int n) {
        int n2 = 0;
        int n3 = this.getChildCount();
        while (n2 < n3) {
            LargeTreeModelNode largeTreeModelNode = (LargeTreeModelNode)this.getChildAt(n2);
            if (largeTreeModelNode.childIndex >= n) {
                while (n2 < n3) {
                    --((LargeTreeModelNode)this.getChildAt((int)n2)).childIndex;
                    ++n2;
                }
            }
            ++n2;
        }
    }

    protected void childInsertedAtModelIndex(int n) {
        int n2 = 0;
        int n3 = this.getChildCount();
        while (n2 < n3) {
            LargeTreeModelNode largeTreeModelNode = (LargeTreeModelNode)this.getChildAt(n2);
            if (largeTreeModelNode.childIndex >= n) {
                while (n2 < n3) {
                    ++((LargeTreeModelNode)this.getChildAt((int)n2)).childIndex;
                    ++n2;
                }
            }
            ++n2;
        }
    }

    protected boolean getPathForRow(int n, int[] nArray, TreePath[] treePathArray, LargeTreeModelNode[] largeTreeModelNodeArray, boolean[] blArray, int[] nArray2) {
        if (n == nArray[0]) {
            if (nArray2 != null) {
                nArray2[0] = this.getChildIndex();
            }
            if (largeTreeModelNodeArray != null) {
                largeTreeModelNodeArray[0] = this;
                blArray[0] = false;
            }
            if (treePathArray != null) {
                treePathArray[0] = new TreePath(this.getUserObjectPath());
            }
            return true;
        }
        nArray[0] = nArray[0] + 1;
        if (this.isExpanded) {
            int n2;
            int n3 = 0;
            TreeModel treeModel = this.getModel();
            int n4 = 0;
            int n5 = this.getChildCount();
            while (n4 < n5) {
                LargeTreeModelNode largeTreeModelNode = (LargeTreeModelNode)this.getChildAt(n4);
                n2 = largeTreeModelNode.childIndex;
                if (nArray[0] + (n2 - n3) > n) {
                    if (nArray2 != null) {
                        nArray2[0] = n - nArray[0] + n3;
                    }
                    if (treePathArray != null) {
                        Object[] objectArray = this.getUserObjectPath();
                        int n6 = objectArray.length;
                        Object[] objectArray2 = new Object[n6 + 1];
                        Object object = treeModel.getChild(this.userObject, n - nArray[0] + n3);
                        System.arraycopy(objectArray, 0, objectArray2, 0, n6);
                        objectArray2[n6] = object;
                        treePathArray[0] = new TreePath(objectArray2);
                    }
                    if (largeTreeModelNodeArray != null) {
                        largeTreeModelNodeArray[0] = this;
                        blArray[0] = true;
                    }
                    return true;
                }
                nArray[0] = nArray[0] + (n2 - n3);
                n3 = n2 + 1;
                if (largeTreeModelNode.getPathForRow(n, nArray, treePathArray, largeTreeModelNodeArray, blArray, nArray2)) {
                    return true;
                }
                ++n4;
            }
            n2 = treeModel.getChildCount(this.userObject) - 1;
            if (n2 - n3 >= 0) {
                if (nArray[0] + (n2 - n3) >= n) {
                    if (nArray2 != null) {
                        nArray2[0] = n - nArray[0] + n3;
                    }
                    if (treePathArray != null) {
                        Object[] objectArray = this.getUserObjectPath();
                        int n7 = objectArray.length;
                        Object[] objectArray3 = new Object[n7 + 1];
                        Object object = treeModel.getChild(this.userObject, n - nArray[0] + n3);
                        System.arraycopy(objectArray, 0, objectArray3, 0, n7);
                        objectArray3[n7] = object;
                        treePathArray[0] = new TreePath(objectArray3);
                    }
                    if (largeTreeModelNodeArray != null) {
                        largeTreeModelNodeArray[0] = this;
                        blArray[0] = true;
                    }
                    return true;
                }
                nArray[0] = nArray[0] + (n2 - n3 + 1);
            }
        }
        return false;
    }

    protected int getCountTo(int n) {
        int n2 = n + 1;
        int n3 = 0;
        int n4 = this.getChildCount();
        while (n3 < n4) {
            LargeTreeModelNode largeTreeModelNode = (LargeTreeModelNode)this.getChildAt(n3);
            if (largeTreeModelNode.childIndex >= n) {
                n3 = n4;
            } else {
                n2 += largeTreeModelNode.getTotalChildCount();
            }
            ++n3;
        }
        if (this.parent != null) {
            return n2 + ((LargeTreeModelNode)this.getParent()).getCountTo(this.childIndex);
        }
        if (!this.treeUI.isRootVisible()) {
            return n2 - 1;
        }
        return n2;
    }

    protected boolean getRow(Object[] objectArray, int n, int n2, boolean bl, int[] nArray) {
        boolean bl2 = bl = bl && objectArray[n].equals(this.userObject);
        if (bl && ++n == n2) {
            return true;
        }
        nArray[0] = nArray[0] + 1;
        if (this.isExpanded) {
            int n3;
            TreeModel treeModel = this.getModel();
            int n4 = bl && n + 1 == n2 ? treeModel.getIndexOfChild(this.userObject, objectArray[n2 - 1]) : Integer.MAX_VALUE;
            int n5 = 0;
            int n6 = nArray[0];
            int n7 = 0;
            int n8 = this.getChildCount();
            while (n7 < n8) {
                LargeTreeModelNode largeTreeModelNode = (LargeTreeModelNode)this.getChildAt(n7);
                n3 = largeTreeModelNode.childIndex;
                if (n3 >= n4) {
                    nArray[0] = n6 + (n4 - n5);
                    return true;
                }
                n5 = n3 + 1;
                nArray[0] = n6 += n3 - n5;
                if (largeTreeModelNode.getRow(objectArray, n, n2, bl, nArray)) {
                    return true;
                }
                n6 = nArray[0];
                ++n7;
            }
            n3 = treeModel.getChildCount(this.userObject) - 1;
            if (n3 >= 0) {
                if (n3 >= n4) {
                    nArray[0] = n6 + (n4 - n5);
                    return true;
                }
                nArray[0] = nArray[0] + (n3 - n5 + 1);
            }
        }
        return false;
    }

    protected void didAdjustTree() {
    }
}

