/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vatc.tcmerge;

import com.ibm.vatc.reuse.awt.ButtonPanel;
import com.ibm.vatc.reuse.awt.EButton;
import com.ibm.vatc.reuse.awt.GridTools;
import com.ibm.vatc.tcmerge.DiffInput;
import com.ibm.vatc.tcmerge.DirectoryDialog;
import com.ibm.vatc.tcmerge.Location;
import com.ibm.vatc.tcmerge.MergeOptionsDialog;
import com.ibm.vatc.tcmerge.SingleLineCanvas;
import com.ibm.vatc.tcmerge.TCMergeException;
import com.ibm.vatc.tcmerge.TCMergeHelp;
import com.ibm.vatc.tcmerge.WarningDialog;
import com.ibm.vatc.tcmerge.tcmerge;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.IllegalComponentStateException;
import java.awt.Label;
import java.awt.Point;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;

class MergeDirectoriesDialog
extends Dialog {
    Frame parentFrame;
    TextField dir1TextField;
    TextField dir2TextField;
    TextField dir3TextField;
    TextField includeFilesTextField;
    TextField outputDirTextField;
    Checkbox replaceCheckbox;
    String action;
    DiffInput diffInput;
    boolean recalculate;
    boolean modalOn;
    MergeOptionsDialog mergeOptionsDialog;
    Location fileLocators;
    String CWD;

    public MergeDirectoriesDialog(Frame frame, DiffInput diffInput, Location location) {
        super(frame, tcmerge.locResource.getString("TITLE_MERGE_DIRECTORY"), true);
        this.parentFrame = frame;
        this.diffInput = diffInput;
        this.fileLocators = location;
        ((Component)this).setSize(355, 410);
        this.setResizable(false);
        this.setLayout(new GridBagLayout());
        this.CWD = System.getProperty("user.dir");
        DialogListener dialogListener = new DialogListener();
        this.addWindowListener(dialogListener);
        KeyboardListener keyboardListener = new KeyboardListener();
        this.addKeyListener(keyboardListener);
        GridTools.constrain((Container)this, (Component)new Label(tcmerge.locResource.getString("STR_Input")), (int)1, (int)1, (int)1, (int)1);
        GridTools.constrain((Container)this, (Component)new SingleLineCanvas(270), (int)2, (int)1, (int)4, (int)1);
        GridTools.constrain((Container)this, (Component)new Label(tcmerge.locResource.getString("STR_Directory1")), (int)2, (int)2, (int)1, (int)1, (int)0, (int)0, (int)17, (int)0);
        this.dir1TextField = diffInput.numInputDirectories() >= 1 ? new TextField(diffInput.getInputDirectoryAt(0), 20) : new TextField(20);
        this.dir1TextField.addKeyListener(keyboardListener);
        GridTools.constrain((Container)this, (Component)this.dir1TextField, (int)2, (int)3, (int)2, (int)1);
        EButton eButton = new EButton(tcmerge.locResource.getString("STR_BROWSE"));
        eButton.setActionCommand("browse1");
        eButton.addActionListener(new ButtonListener());
        eButton.addKeyListener(keyboardListener);
        GridTools.constrain((Container)this, (Component)eButton, (int)5, (int)3, (int)1, (int)1);
        GridTools.constrain((Container)this, (Component)new Label(tcmerge.locResource.getString("STR_Directory2")), (int)2, (int)4, (int)1, (int)1, (int)0, (int)0, (int)17, (int)0);
        this.dir2TextField = diffInput.numInputDirectories() >= 2 ? new TextField(diffInput.getInputDirectoryAt(1), 20) : new TextField(20);
        this.dir2TextField.addKeyListener(keyboardListener);
        GridTools.constrain((Container)this, (Component)this.dir2TextField, (int)2, (int)5, (int)2, (int)1);
        EButton eButton2 = new EButton(tcmerge.locResource.getString("STR_BROWSE"));
        eButton2.setActionCommand("browse2");
        eButton2.addActionListener(new ButtonListener());
        eButton2.addKeyListener(keyboardListener);
        GridTools.constrain((Container)this, (Component)eButton2, (int)5, (int)5, (int)1, (int)1);
        GridTools.constrain((Container)this, (Component)new Label(tcmerge.locResource.getString("STR_Directory3")), (int)2, (int)6, (int)1, (int)1, (int)0, (int)0, (int)17, (int)0);
        this.dir3TextField = diffInput.numInputDirectories() >= 3 ? new TextField(diffInput.getInputDirectoryAt(2), 20) : new TextField(20);
        this.dir3TextField.addKeyListener(keyboardListener);
        GridTools.constrain((Container)this, (Component)this.dir3TextField, (int)2, (int)7, (int)2, (int)1);
        EButton eButton3 = new EButton(tcmerge.locResource.getString("STR_BROWSE"));
        eButton3.setActionCommand("browse3");
        eButton3.addActionListener(new ButtonListener());
        eButton3.addKeyListener(keyboardListener);
        GridTools.constrain((Container)this, (Component)eButton3, (int)5, (int)7, (int)1, (int)1);
        EButton eButton4 = new EButton(tcmerge.locResource.getString("STR_MERGE_OPTIONS"));
        eButton4.setActionCommand("mergeOptions");
        eButton4.addActionListener(new ButtonListener());
        eButton4.addKeyListener(keyboardListener);
        GridTools.constrain((Container)this, (Component)eButton4, (int)2, (int)11, (int)1, (int)1, (int)0, (int)0, (int)17, (int)0);
        GridTools.constrain((Container)this, (Component)new Label(tcmerge.locResource.getString("STR_Output")), (int)1, (int)13, (int)1, (int)1);
        GridTools.constrain((Container)this, (Component)new SingleLineCanvas(270), (int)2, (int)13, (int)4, (int)1);
        GridTools.constrain((Container)this, (Component)new Label(tcmerge.locResource.getString("STR_OUTPUT_DIRECTORY")), (int)2, (int)14, (int)1, (int)1, (int)0, (int)0, (int)17, (int)0);
        this.outputDirTextField = new TextField("", 20);
        GridTools.constrain((Container)this, (Component)this.outputDirTextField, (int)2, (int)15, (int)2, (int)1);
        EButton eButton5 = new EButton(tcmerge.locResource.getString("STR_BROWSE"));
        eButton5.setActionCommand("browseOutput");
        eButton5.addActionListener(new ButtonListener());
        eButton5.addKeyListener(keyboardListener);
        GridTools.constrain((Container)this, (Component)eButton5, (int)5, (int)15, (int)1, (int)1);
        this.replaceCheckbox = new Checkbox(tcmerge.locResource.getString("STR_REPLACE"), diffInput.getReplace());
        this.replaceCheckbox.addKeyListener(keyboardListener);
        GridTools.constrain((Container)this, (Component)this.replaceCheckbox, (int)2, (int)16, (int)1, (int)1, (int)0, (int)0, (int)17, (int)0);
        String[][] stringArray = new String[][]{{tcmerge.locResource.getString("STR_OK"), "OK"}, {tcmerge.locResource.getString("STR_CANCEL"), "Cancel"}, {tcmerge.locResource.getString("STR_HELP"), "Help"}};
        ButtonPanel buttonPanel = new ButtonPanel(stringArray, (ActionListener)new ButtonListener());
        buttonPanel.addKeyListener((KeyListener)keyboardListener);
        GridTools.constrain((Container)this, (Component)buttonPanel, (int)2, (int)18, (int)4, (int)1, (int)0, (int)0, (int)13, (int)0);
        Canvas canvas = new Canvas();
        canvas.setSize(15, 15);
        GridTools.constrain((Container)this, (Component)canvas, (int)4, (int)10, (int)1, (int)1);
        Canvas canvas2 = new Canvas();
        canvas2.setSize(15, 15);
        GridTools.constrain((Container)this, (Component)canvas2, (int)6, (int)19, (int)1, (int)1);
        Canvas canvas3 = new Canvas();
        canvas3.setSize(1, 15);
        GridTools.constrain((Container)this, (Component)canvas3, (int)1, (int)17, (int)1, (int)1);
        Canvas canvas4 = new Canvas();
        canvas4.setSize(1, 10);
        GridTools.constrain((Container)this, (Component)canvas4, (int)1, (int)12, (int)1, (int)1);
        this.pack();
        Dimension dimension = this.parentFrame.getSize();
        Dimension dimension2 = this.getSize();
        try {
            Point point = this.parentFrame.getLocationOnScreen();
            ((Component)this).setLocation(point.x + (dimension.width - dimension2.width) / 2, point.y + (dimension.height - dimension2.height) / 2);
            return;
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            Dimension dimension3 = this.getToolkit().getScreenSize();
            ((Component)this).setLocation((dimension3.width - dimension2.width) / 2, (dimension3.height - dimension2.height) / 2);
            return;
        }
    }

    public String getAction() {
        return this.action;
    }

    public boolean recalculateNeeded() {
        return this.recalculate;
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
            MergeDirectoriesDialog.this = MergeDirectoriesDialog.this;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("browse1")) {
                String string2;
                DirectoryDialog directoryDialog = new DirectoryDialog(MergeDirectoriesDialog.this.parentFrame, tcmerge.locResource.getString("STR_Directory1"), MergeDirectoriesDialog.this.CWD);
                if (MergeDirectoriesDialog.this.fileLocators != null && (string2 = MergeDirectoriesDialog.this.fileLocators.getPrimeLocation()) != null && new File(string2).isDirectory()) {
                    directoryDialog.setLookInDirectory(string2);
                }
                directoryDialog.show();
                string2 = directoryDialog.getDirectory();
                if (string2 != null) {
                    if (string2.startsWith(MergeDirectoriesDialog.this.CWD) && (string2 = string2.substring(MergeDirectoriesDialog.this.CWD.length())).startsWith(System.getProperty("file.separator"))) {
                        string2 = string2.substring(1);
                    }
                    ((TextComponent)MergeDirectoriesDialog.this.dir1TextField).setText(string2);
                    return;
                }
            } else if (string.equals("browse2")) {
                String string3;
                DirectoryDialog directoryDialog = new DirectoryDialog(MergeDirectoriesDialog.this.parentFrame, tcmerge.locResource.getString("STR_Directory2"), MergeDirectoriesDialog.this.CWD);
                if (MergeDirectoriesDialog.this.fileLocators != null && (string3 = MergeDirectoriesDialog.this.fileLocators.getFirstLocation()) != null && new File(string3).isDirectory()) {
                    directoryDialog.setLookInDirectory(string3);
                }
                directoryDialog.show();
                string3 = directoryDialog.getDirectory();
                if (string3 != null) {
                    if (string3.startsWith(MergeDirectoriesDialog.this.CWD) && (string3 = string3.substring(MergeDirectoriesDialog.this.CWD.length())).startsWith(System.getProperty("file.separator"))) {
                        string3 = string3.substring(1);
                    }
                    ((TextComponent)MergeDirectoriesDialog.this.dir2TextField).setText(string3);
                    return;
                }
            } else if (string.equals("browse3")) {
                String string4;
                DirectoryDialog directoryDialog = new DirectoryDialog(MergeDirectoriesDialog.this.parentFrame, tcmerge.locResource.getString("STR_Directory3"), MergeDirectoriesDialog.this.CWD);
                if (MergeDirectoriesDialog.this.fileLocators != null && (string4 = MergeDirectoriesDialog.this.fileLocators.getSecondLocation()) != null && new File(string4).isDirectory()) {
                    directoryDialog.setLookInDirectory(string4);
                }
                directoryDialog.show();
                string4 = directoryDialog.getDirectory();
                if (string4 != null) {
                    if (string4.startsWith(MergeDirectoriesDialog.this.CWD) && (string4 = string4.substring(MergeDirectoriesDialog.this.CWD.length())).startsWith(System.getProperty("file.separator"))) {
                        string4 = string4.substring(1);
                    }
                    ((TextComponent)MergeDirectoriesDialog.this.dir3TextField).setText(string4);
                    return;
                }
            } else if (string.equals("browseOutput")) {
                String string5;
                DirectoryDialog directoryDialog = new DirectoryDialog(MergeDirectoriesDialog.this.parentFrame, tcmerge.locResource.getString("STR_OUTPUT_DIRECTORY"), MergeDirectoriesDialog.this.CWD);
                if (MergeDirectoriesDialog.this.fileLocators != null && (string5 = MergeDirectoriesDialog.this.fileLocators.getOutputLocation()) != null && new File(string5).isDirectory()) {
                    directoryDialog.setLookInDirectory(string5);
                }
                directoryDialog.show();
                string5 = directoryDialog.getDirectory();
                if (string5 != null) {
                    if (string5.startsWith(MergeDirectoriesDialog.this.CWD) && (string5 = string5.substring(MergeDirectoriesDialog.this.CWD.length())).startsWith(System.getProperty("file.separator"))) {
                        string5 = string5.substring(1);
                    }
                    ((TextComponent)MergeDirectoriesDialog.this.outputDirTextField).setText(string5);
                    return;
                }
            } else if (string.equals("mergeOptions")) {
                if (MergeDirectoriesDialog.this.modalOn) {
                    return;
                }
                MergeDirectoriesDialog.this.modalOn = true;
                if (MergeDirectoriesDialog.this.mergeOptionsDialog == null) {
                    MergeDirectoriesDialog.this.mergeOptionsDialog = new MergeOptionsDialog(MergeDirectoriesDialog.this.parentFrame, 3);
                    MergeDirectoriesDialog.this.mergeOptionsDialog.setIgnoreBlanksAnswer(MergeDirectoriesDialog.this.diffInput.getIgnoreBlanks());
                    MergeDirectoriesDialog.this.mergeOptionsDialog.setIgnoreUniqueDifferencesAnswer(MergeDirectoriesDialog.this.diffInput.getIgnoreDiff());
                    MergeDirectoriesDialog.this.mergeOptionsDialog.setPrimeOutputFileAnswer(MergeDirectoriesDialog.this.diffInput.getPrimeOutput());
                    MergeDirectoriesDialog.this.mergeOptionsDialog.setColumnsToIgnoreAnswer(MergeDirectoriesDialog.this.diffInput.getColsToIgnore());
                    MergeDirectoriesDialog.this.mergeOptionsDialog.setIgnoreCaseSensitiveAnswer(MergeDirectoriesDialog.this.diffInput.getIgnoreCaseSensitive());
                    MergeDirectoriesDialog.this.mergeOptionsDialog.setAutomergeAnswer(MergeDirectoriesDialog.this.diffInput.getAutomerge());
                    MergeDirectoriesDialog.this.mergeOptionsDialog.setIgnoreBlankLinesAnswer(MergeDirectoriesDialog.this.diffInput.getIgnoreBlankLines());
                    MergeDirectoriesDialog.this.mergeOptionsDialog.setTitlesAnswer(MergeDirectoriesDialog.this.diffInput.getTitles());
                    MergeDirectoriesDialog.this.mergeOptionsDialog.createDialog();
                }
                MergeDirectoriesDialog.this.mergeOptionsDialog.show();
                MergeDirectoriesDialog.this.modalOn = false;
                if (!MergeDirectoriesDialog.this.mergeOptionsDialog.getAction().equals("OK")) {
                    MergeDirectoriesDialog.this.mergeOptionsDialog.dispose();
                    MergeDirectoriesDialog.this.mergeOptionsDialog = null;
                    return;
                }
            } else {
                if (string.equals("OK")) {
                    if (MergeDirectoriesDialog.this.modalOn) {
                        return;
                    }
                    try {
                        String string6 = MergeDirectoriesDialog.this.dir1TextField.getText();
                        if (string6.equals("")) {
                            throw new TCMergeException(3, tcmerge.locResource.getString("STR_Directory1"));
                        }
                        File file = new File(string6);
                        if (file.isFile()) {
                            throw new TCMergeException(30, string6);
                        }
                        if (!file.canRead()) {
                            throw new TCMergeException(1, string6);
                        }
                        if (MergeDirectoriesDialog.this.diffInput.numInputDirectories() >= 1) {
                            if (!MergeDirectoriesDialog.this.diffInput.getInputDirectoryAt(0).equals(string6)) {
                                MergeDirectoriesDialog.this.diffInput.setInputDirectoryAt(string6, 0);
                                MergeDirectoriesDialog.this.recalculate = true;
                            }
                        } else {
                            MergeDirectoriesDialog.this.diffInput.addInputDirectory(string6);
                            MergeDirectoriesDialog.this.recalculate = true;
                        }
                        if ((string6 = MergeDirectoriesDialog.this.dir2TextField.getText()).equals("")) {
                            throw new TCMergeException(3, tcmerge.locResource.getString("STR_Directory2"));
                        }
                        file = new File(string6);
                        if (file.isFile()) {
                            throw new TCMergeException(30, string6);
                        }
                        if (!file.canRead()) {
                            throw new TCMergeException(1, string6);
                        }
                        if (MergeDirectoriesDialog.this.diffInput.numInputDirectories() >= 2) {
                            if (!MergeDirectoriesDialog.this.diffInput.getInputDirectoryAt(1).equals(string6)) {
                                MergeDirectoriesDialog.this.diffInput.setInputDirectoryAt(string6, 1);
                                MergeDirectoriesDialog.this.recalculate = true;
                            }
                        } else {
                            MergeDirectoriesDialog.this.diffInput.addInputDirectory(string6);
                            MergeDirectoriesDialog.this.recalculate = true;
                        }
                        if (!(string6 = MergeDirectoriesDialog.this.dir3TextField.getText()).equals("")) {
                            file = new File(string6);
                            if (file.isFile()) {
                                throw new TCMergeException(30, string6);
                            }
                            if (!file.canRead()) {
                                throw new TCMergeException(1, string6);
                            }
                            if (MergeDirectoriesDialog.this.diffInput.numInputDirectories() >= 3) {
                                if (!MergeDirectoriesDialog.this.diffInput.getInputDirectoryAt(2).equals(string6)) {
                                    MergeDirectoriesDialog.this.diffInput.setInputDirectoryAt(string6, 2);
                                    MergeDirectoriesDialog.this.recalculate = true;
                                }
                            } else {
                                MergeDirectoriesDialog.this.diffInput.addInputDirectory(string6);
                                MergeDirectoriesDialog.this.recalculate = true;
                            }
                        } else if (MergeDirectoriesDialog.this.diffInput.numInputDirectories() >= 3) {
                            MergeDirectoriesDialog.this.diffInput.removeInputDirectoryAt(2);
                            MergeDirectoriesDialog.this.recalculate = true;
                        }
                        if ((string6 = MergeDirectoriesDialog.this.outputDirTextField.getText()).equals("")) {
                            MergeDirectoriesDialog.this.diffInput.setOutputDirectory("");
                        } else {
                            file = new File(string6);
                            if (file.isFile()) {
                                throw new TCMergeException(30, string6);
                            }
                            if (file.exists() && !file.canWrite()) {
                                throw new TCMergeException(20, string6);
                            }
                            if (file.exists() && !MergeDirectoriesDialog.this.replaceCheckbox.getState()) {
                                throw new TCMergeException(4, string6);
                            }
                            MergeDirectoriesDialog.this.diffInput.setOutputDirectory(string6);
                            MergeDirectoriesDialog.this.diffInput.setReplace(true);
                        }
                        if (MergeDirectoriesDialog.this.mergeOptionsDialog != null) {
                            if (MergeDirectoriesDialog.this.mergeOptionsDialog.getAction().equals("OK")) {
                                if (MergeDirectoriesDialog.this.mergeOptionsDialog.recalculateNeeded()) {
                                    MergeDirectoriesDialog.this.recalculate = true;
                                }
                                MergeDirectoriesDialog.this.diffInput.setIgnoreBlanks(MergeDirectoriesDialog.this.mergeOptionsDialog.getIgnoreBlanksAnswer());
                                MergeDirectoriesDialog.this.diffInput.setPrimeOutput(MergeDirectoriesDialog.this.mergeOptionsDialog.getPrimeOutputFileAnswer());
                                MergeDirectoriesDialog.this.diffInput.setColsToIgnore(MergeDirectoriesDialog.this.mergeOptionsDialog.getColumnsToIgnoreAnswer());
                                MergeDirectoriesDialog.this.diffInput.setIgnoreCaseSensitive(MergeDirectoriesDialog.this.mergeOptionsDialog.getIgnoreCaseSensitiveAnswer());
                                MergeDirectoriesDialog.this.diffInput.setIgnoreBlankLines(MergeDirectoriesDialog.this.mergeOptionsDialog.getIgnoreBlankLinesAnswer());
                                MergeDirectoriesDialog.this.diffInput.setTitles(MergeDirectoriesDialog.this.mergeOptionsDialog.getTitlesAnswer());
                                if (MergeDirectoriesDialog.this.diffInput.numInputFiles() == 2) {
                                    MergeDirectoriesDialog.this.diffInput.setAutomerge(false);
                                    MergeDirectoriesDialog.this.diffInput.setIgnoreDiff(-1);
                                    if (MergeDirectoriesDialog.this.diffInput.getPrimeOutput() == 2) {
                                        MergeDirectoriesDialog.this.diffInput.setPrimeOutput(-1);
                                    }
                                } else {
                                    MergeDirectoriesDialog.this.diffInput.setAutomerge(MergeDirectoriesDialog.this.mergeOptionsDialog.getAutomergeAnswer());
                                    MergeDirectoriesDialog.this.diffInput.setIgnoreDiff(MergeDirectoriesDialog.this.mergeOptionsDialog.getIgnoreUniqueDifferencesAnswer());
                                }
                            }
                            MergeDirectoriesDialog.this.mergeOptionsDialog.dispose();
                        }
                        MergeDirectoriesDialog.this.action = "OK";
                        ((Component)MergeDirectoriesDialog.this).setVisible(false);
                        return;
                    }
                    catch (TCMergeException tCMergeException) {
                        WarningDialog warningDialog = new WarningDialog(MergeDirectoriesDialog.this.parentFrame, tCMergeException.toString());
                        MergeDirectoriesDialog.this.modalOn = true;
                        warningDialog.show();
                        MergeDirectoriesDialog.this.modalOn = false;
                        warningDialog.dispose();
                        return;
                    }
                }
                if (string.equals("Cancel")) {
                    if (MergeDirectoriesDialog.this.modalOn) {
                        return;
                    }
                    MergeDirectoriesDialog.this.action = "CANCEL";
                    ((Component)MergeDirectoriesDialog.this).setVisible(false);
                    return;
                }
                if (string.equals("Help")) {
                    TCMergeHelp.showHelp(MergeDirectoriesDialog.this.parentFrame, "HDRHDI0400");
                }
            }
        }
    }

    class DialogListener
    extends WindowAdapter {
        int aixkluge;

        public void windowClosing(WindowEvent windowEvent) {
            if (MergeDirectoriesDialog.this.modalOn) {
                return;
            }
            MergeDirectoriesDialog.this.action = "CANCEL";
            ((Component)MergeDirectoriesDialog.this).setVisible(false);
        }

        public void windowActivated(WindowEvent windowEvent) {
            if (this.aixkluge == 0) {
                MergeDirectoriesDialog.this.dir1TextField.requestFocus();
            }
            this.aixkluge = 1;
        }

        DialogListener() {
            MergeDirectoriesDialog.this = MergeDirectoriesDialog.this;
        }
    }

    class KeyboardListener
    extends KeyAdapter {
        KeyboardListener() {
            MergeDirectoriesDialog.this = MergeDirectoriesDialog.this;
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 27) {
                MergeDirectoriesDialog.this.action = "CANCEL";
                ((Component)MergeDirectoriesDialog.this).setVisible(false);
            }
        }
    }
}

