#!/usr/bin/ksh
#
#*********************************************************************
#
#SAMPLE NAME:  viewExit.ksh
#
#USAGE:        User Exit, see <family dir>\config\UserExit for details
#
#ENVIRONMENT VARIABLES:
#                       none
#
#DESCRIPTION:  This sample user exit displays the parameter list passed to
#              a user exit from a TeamConnection command.  This is the
#              Korn shell sample, there are equivalent samples for REXX and c.
#
#              Using a ksh array to store parameter list.
#
#*********************************************************************
#             IBM TeamConnection for OS/2
#                     Version 2 Release 0
#
#                       5622-717
#    (C) Copyright, IBM Corp., 1996. All Rights Reserved.
#             Licensed Materials - Property of IBM
#
#         US Government Users Restricted Rights
#     - Use, duplication or disclosure restricted by
#         GSA ADP Schedule Contract with IBM Corp.
#
#              IBM is a registered trademark of
#        International Business Machines Corporation
#*********************************************************************
#
#           NOTICE TO USERS OF THE SOURCE CODE EXAMPLES
#
# INTERNATIONAL BUSINESS MACHINES CORPORATION PROVIDES THE SOURCE CODE
# EXAMPLES, BOTH INDIVIDUALLY AND AS ONE OR MORE GROUPS, "AS IS" WITHOUT
# WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT
# LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
# PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE
# OF THE SOURCE CODE EXAMPLES, BOTH INDIVIDUALLY AND AS ONE OR MORE GROUPS,
# IS WITH YOU.  SHOULD ANY PART OF THE SOURCE CODE EXAMPLES PROVE
# DEFECTIVE, YOU (AND NOT IBM OR AN AUTHORIZED DEALER) ASSUME THE ENTIRE
# COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
#
#*********************************************************************

name=$0
print "UEprogram:               $name"

if (( $# < 1 ))
then
   print "Error: no parameters passed"
   return 0
fi

# Compute the number of action parameters passed at definition
let totalParms=$#-2

# Truncate to last 3 characters of parameter to check for truncation
# - Each parameter limited to 400 bytes in OS/2, Windows and Windows NT,
#   and 16000 bytes in Unix
# - Total command string limited to 1024 bytes in OS/2, Windows and 
#   Windows NT, and 32000 bytes in Unix
typeset -R3 lastThree="..."

# Display the name of the command.
param[0]=$1
if [[ ${param[0]} != "" ]]
then
   print "UEparameters string:     ${param[0]}"
else
   print "UEparameters string is NULL"
fi

# Display the name of the env file.
shift
param[1]=$1
if [[ ${param[1]} != "" ]]
then
   print "EnvFile name:            ${param[1]}"
else
   print "No environment file; string is NULL"
fi

# Extract each parameter from list into a separate variable
# - removing first parameter, then shifting list so that
#   $2 becomes $1, etc.
shift
let i=2
while (( $# > 0 ))
do
   # Assign parameters to parameter array
   param[${i}]=$1
   shift

   # Display parameters
   if [[ ${param[i]} != "" ]]
   then
      print "Action parameters [${i}]:   ${param[${i}]}"
      lastThree=${param[i]}
      # Check for truncation of string
      if [[ $lastThree = "..." ]]
      then
         print "                         parameter $i string was truncated!"
         # If last parameter truncated, then entire list truncated
         if (( $# == 0 ))
         then
            print "Parameter list was truncated!"
         fi
      fi
   else
      print "Action parameters [${i}] is NULL"
   fi

   let i=i+1
done

print "Total action parameters: $totalParms"

# If you have compiled teamcenv, you can call it here to print the
# contents of the temporary environment file
#if [[ ${param[1]} != "" ]]
#then
#   teamcenv ${param[1]}
#fi

return 0
#end of file
