 /********************************************************************/
 /*                                                                  */
 /*  PL/I Include file: PMGPI.CPY                                    */
 /*                                                                  */
 /*  NAME - PMGPI.CPY                                                */
 /*                                                                  */
 /*  DESCRIPTION                                                     */
 /*    Presentation Manager PL/I include file.                       */
 /*                                                                  */
 /*    (C) Copyright IBM Corp. 1992. All Rights Reserved.            */
 /*    US Government Users Restricted Rights-- Use, duplication or   */
 /*    disclosure restricted by GSA ADP Schedule Contract with       */
 /*    IBM Corp.                                                     */
 /*                                                                  */
 /*  DISCLAIMER OF WARRANTIES                                        */
 /*    The following enclosed code is sample code created by IBM   */
 /*    Corporation. This sample code is not part of any standard     */
 /*    IBM product and is provided to you solely for the purpose of  */
 /*    assisting you in the development of your applications.  The   */
 /*    code is provided "AS IS", without warranty of any kind.       */
 /*    IBM shall not be liable for any damages arising out of your   */
 /*    use of the sample code, even if IBM has been advised of the   */
 /*    possibility of such damages.                                  */
 /*                                                                  */
 /********************************************************************/
 /*==================================================================*/
 /*                                                                  */
 /*  The folowing symbols are used in this file for conditional      */
 /*  sections.                                                       */
 /*                                                                  */
 /*    #define:                To include:                           */
 /*                                                                  */
 /*    INCL_GPI                Include all of the GPI                */
 /*    INCL_GPIBITMAPS         Bitmaps and Pel Operations            */
 /*    INCL_GPICONTROL         Basic PS control                      */
 /*    INCL_GPICORRELATION     Picking, Boundary and Correlation     */
 /*    INCL_GPIDEFAULTS        Default Primitive Attributes          */
 /*    INCL_GPIERRORS          defined if INCL_ERRORS defined        */
 /*    INCL_GPILCIDS           Phyical and Logical Fonts with Lcids  */
 /*    INCL_GPILOGCOLORTABLE   Logical Color Tables                  */
 /*    INCL_GPIMETAFILES       MetaFiles                             */
 /*    INCL_GPIPATHS           Paths and Clipping with Paths         */
 /*    INCL_GPIPOLYGON         Polygons                              */
 /*    INCL_GPIPRIMITIVES      Drawing Primitives and Primitive      */
 /*                            Attributes                            */
 /*    INCL_GPIREGIONS         Regions and Clipping with Regions     */
 /*    INCL_GPISEGEDITING      Segment Editing via Elements          */
 /*    INCL_GPISEGMENTS        Segment Control and Drawing           */
 /*    INCL_GPITRANSFORMS      Transform and Transform Conversion    */
 /*                                                                  */
 /*  There is a symbol used in this file called INCL_DDIDEFS. This   */
 /*  is used to include only the definitions for the DDI. The        */
 /*  programmer using the GPI can ignore this symbol.                */
 /*                                                                  */
 /*  There is a symbol used in this file called INCL_SAADEFS.        */
 /*  This is used to include only the definitions for the SAA. The   */
 /*  programmer using the GPI can ignore this symbol.                */
 /*                                                                  */
 /*==================================================================*/
 %if IBMC__='Y' %then %do;
   %if CHKHDR__='Y' %then %do;
   %end;
 %end;
 %PMGPI_INCLUDED = 'Y';
 %if INCL_GPI='Y' %then %do;
   %INCL_GPIBITMAPS='Y';
   %INCL_GPICONTROL='Y';
   %INCL_GPICORRELATION='Y';
   %INCL_GPIDEFAULTS='Y';
   %INCL_GPILCIDS='Y';
   %INCL_GPILOGCOLORTABLE='Y';
   %INCL_GPIMETAFILES='Y';
   %INCL_GPIPATHS='Y';
   %INCL_GPIPOLYGON='Y';
   %INCL_GPIPRIMITIVES='Y';
   %INCL_GPIREGIONS='Y';
   %INCL_GPISEGEDITING='Y';
   %INCL_GPISEGMENTS='Y';
   %INCL_GPITRANSFORMS='Y';
 %end;
 %if INCL_ERRORS='Y' %then %do;
   %INCL_GPIERRORS='Y';
 %end;
 %if INCL_DDIDEFS='Y' %then %do;
   %INCL_GPIBITMAPS='Y';
   %INCL_GPIERRORS='Y';
   %INCL_GPILCIDS='Y';
   %INCL_GPILOGCOLORTABLE='Y';
   %INCL_GPIPATHS='Y';
   %INCL_GPIPOLYGON='Y';
   %INCL_GPIPRIMITIVES='Y';
   %INCL_GPIREGIONS='Y';
   %INCL_GPITRANSFORMS='Y';
 %end;
 %if INCL_SAADEFS='Y' %then %do;
   %INCL_GPIBITMAPS='Y';
   %INCL_GPICONTROL='Y';
   %INCL_GPICORRELATION='Y';
   %INCL_GPIERRORS='Y';
   %INCL_GPILCIDS='Y';
   %INCL_GPILOGCOLORTABLE='Y';
   %INCL_GPIMETAFILES='Y';
   %INCL_GPIPATHS='Y';
   %INCL_GPIPOLYGON='Y';
   %INCL_GPIPRIMITIVES='Y';
   %INCL_GPIREGIONS='Y';
   %INCL_GPISEGEDITING='Y';
   %INCL_GPISEGMENTS='Y';
   %INCL_GPITRANSFORMS='Y';
 %end;
 %dcl GPI_ERROR char;
 %GPI_ERROR=0;
 %dcl GPI_OK char;
 %GPI_OK=1;
 %dcl GPI_ALTERROR char;
 %GPI_ALTERROR=-1;
 %dcl FIXED_PLI char;
 %FIXED_PLI=LONG;
 %dcl PFIXED char;
 %PFIXED='pointer';
 %dcl FIXED88 char;
 %FIXED88=USHORT;
 %dcl FIXED114 char;
 %FIXED114=USHORT;
 %dcl SIZEL char;
 %SIZEL='char(stg(#SIZEL))';
 dcl 1 #SIZEL based(null()) unaligned,
       2 cx LONG,
       2 cy LONG;
 %dcl PSIZEL char;
 %PSIZEL='pointer';
 %dcl CLR_NOINDEX char;
 %CLR_NOINDEX=-254;
 %if INCL_GPICONTROL='Y' | INCL_NOCOMMON='Y' %then %do;
   dcl PU_ARBITRARY fixed bin(31) value('00_00_00_04'xn);
   dcl PU_PELS fixed bin(31) value('00_00_00_08'xn);
   dcl PU_LOMETRIC fixed bin(31) value('00_00_00_0C'xn);
   dcl PU_HIMETRIC fixed bin(31) value('00_00_00_10'xn);
   dcl PU_LOENGLISH fixed bin(31) value('00_00_00_14'xn);
   dcl PU_HIENGLISH fixed bin(31) value('00_00_00_18'xn);
   dcl PU_TWIPS fixed bin(31) value('00_00_00_1C'xn);
   %dcl GPIF_DEFAULT char;
   %GPIF_DEFAULT=0;
   dcl GPIF_SHORT fixed bin(31) value('00_00_01_00'xn);
   dcl GPIF_LONG fixed bin(31) value('00_00_02_00'xn);
   %dcl GPIT_NORMAL char;
   %GPIT_NORMAL=0;
   dcl GPIT_MICRO fixed bin(31) value('00_00_10_00'xn);
   %dcl GPIA_NOASSOC char;
   %GPIA_NOASSOC=0;
   dcl GPIA_ASSOC fixed bin(31) value('00_00_40_00'xn);
   dcl GPIM_AREAEXCL fixed bin(31) value('00_00_80_00'xn);

   %if INCL_SAADEFS='Y' %then %do;
     %dcl HDC_ERROR char;
     %HDC_ERROR=HDC;
   %end;
   dcl GpiCreatePS entry (
          HAB,
          HDC,
          PSIZEL,
          ULONG)
          returns(optional byvalue HPS)
          APIENTRY;
   dcl GpiDestroyPS entry (
          HPS)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl GpiAssociate entry (
          HPS,
          HDC)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl GpiRestorePS entry (
          HPS,
          LONG)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl GpiSavePS entry (
          HPS)
          returns(optional byvalue LONG)
          APIENTRY;
   dcl GpiErase entry (
          HPS)
          returns(optional byvalue BOOL)
          APIENTRY;
   %if INCL_SAADEFS='Y' %then %do;
     dcl GpiQueryDevice entry (
            HPS)
            returns(optional byvalue HDC)
            APIENTRY;
   %end;
 %end;
 %if INCL_GPICONTROL='Y' %then %do;
   dcl GRES_ATTRS fixed bin(31) value('00_00_00_01'xn);
   dcl GRES_SEGMENTS fixed bin(31) value('00_00_00_02'xn);
   dcl GRES_ALL fixed bin(31) value('00_00_00_04'xn);
   dcl PS_UNITS fixed bin(31) value('00_00_00_FC'xn);
   dcl PS_FORMAT fixed bin(31) value('00_00_0F_00'xn);
   dcl PS_TYPE fixed bin(31) value('00_00_10_00'xn);
   dcl PS_MODE fixed bin(31) value('00_00_20_00'xn);
   dcl PS_ASSOCIATE fixed bin(31) value('00_00_40_00'xn);
   dcl PS_NORESET fixed bin(31) value('00_00_08_00'xn);
   %dcl GPIE_SEGMENT char;
   %GPIE_SEGMENT=0;
   %dcl GPIE_ELEMENT char;
   %GPIE_ELEMENT=1;
   %dcl GPIE_DATA char;
   %GPIE_DATA=2;
   %if INCL_SAADEFS='Y' %then %do;
     %dcl DCTL_ERASE char;
     %DCTL_ERASE=1;
     %dcl DCTL_DISPLAY char;
     %DCTL_DISPLAY=2;
     %dcl DCTL_BOUNDARY char;
     %DCTL_BOUNDARY=3;
     %dcl DCTL_DYNAMIC char;
     %DCTL_DYNAMIC=4;
     %dcl DCTL_CORRELATE char;
     %DCTL_CORRELATE=5;
     %dcl DCTL_ERROR char;
     %DCTL_ERROR=-1;
     %dcl DCTL_OFF char;
     %DCTL_OFF=0;
     %dcl DCTL_ON char;
     %DCTL_ON=1;
     %dcl SDW_ERROR char;
     %SDW_ERROR=-1;
     %dcl SDW_OFF char;
     %SDW_OFF=0;
     %dcl SDW_ON char;
     %SDW_ON=1;
   %end;
   %dcl DM_ERROR char;
   %DM_ERROR=0;
   %dcl DM_DRAW char;
   %DM_DRAW=1;
   %dcl DM_RETAIN char;
   %DM_RETAIN=2;
   %dcl DM_DRAWANDRETAIN char;
   %DM_DRAWANDRETAIN=3;
   dcl GpiResetPS entry (
          HPS,
          ULONG)
          returns(optional byvalue BOOL)
          APIENTRY;
   %if INCL_SAADEFS='Y' %then %do;
     dcl GpiSetPS entry (
            HPS,
            PSIZEL,
            ULONG)
            returns(optional byvalue BOOL)
            APIENTRY;
   %end;
   dcl GpiQueryPS entry (
          HPS,
          PSIZEL)
          returns(optional byvalue ULONG)
          APIENTRY;
   dcl GpiErrorSegmentData entry (
          HPS,
          PLONG,
          PLONG)
          returns(optional byvalue LONG)
          APIENTRY;
   %if INCL_SAADEFS='Y' %then %do;
     dcl GpiQueryDrawControl entry (
            HPS,
            LONG)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiSetDrawControl entry (
            HPS,
            LONG,
            LONG)
            returns(optional byvalue BOOL)
            APIENTRY;
   %end;
   dcl GpiQueryDrawingMode entry (
          HPS)
          returns(optional byvalue LONG)
          APIENTRY;
   dcl GpiSetDrawingMode entry (
          HPS,
          LONG)
          returns(optional byvalue BOOL)
          APIENTRY;
   %if INCL_SAADEFS='Y' %then %do;
     dcl GpiQueryStopDraw entry (
            HPS)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiSetStopDraw entry (
            HPS,
            LONG)
            returns(optional byvalue BOOL)
            APIENTRY;
   %end;
 %end;
 %if INCL_GPICORRELATION='Y' %then %do;
   %dcl PICKAP_DEFAULT char;
   %PICKAP_DEFAULT=0;
   %dcl PICKAP_REC char;
   %PICKAP_REC=2;
   %dcl PICKSEL_VISIBLE char;
   %PICKSEL_VISIBLE=0;
   %dcl PICKSEL_ALL char;
   %PICKSEL_ALL=1;
   %dcl GPI_HITS char;
   %GPI_HITS=2;
   dcl GpiCorrelateChain entry (
          HPS,
          LONG,
          PPOINTL,
          LONG,
          LONG,
          PLONG)
          returns(optional byvalue LONG)
          APIENTRY;
   dcl GpiQueryTag entry (
          HPS,
          PLONG)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl GpiSetTag entry (
          HPS,
          LONG)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl GpiQueryPickApertureSize entry (
          HPS,
          PSIZEL)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl GpiSetPickApertureSize entry (
          HPS,
          LONG,
          PSIZEL)
          returns(optional byvalue BOOL)
          APIENTRY;
   %if INCL_SAADEFS='Y' %then %do;
     dcl GpiQueryPickAperturePosition entry (
            HPS,
            PPOINTL)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiSetPickAperturePosition entry (
            HPS,
            PPOINTL)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiQueryBoundaryData entry (
            HPS,
            PRECTL)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiResetBoundaryData entry (
            HPS)
            returns(optional byvalue BOOL)
            APIENTRY;
   %end;
   dcl GpiCorrelateFrom entry (
          HPS,
          LONG,
          LONG,
          LONG,
          PPOINTL,
          LONG,
          LONG,
          PLONG)
          returns(optional byvalue LONG)
          APIENTRY;
   dcl GpiCorrelateSegment entry (
          HPS,
          LONG,
          LONG,
          PPOINTL,
          LONG,
          LONG,
          PLONG)
          returns(optional byvalue LONG)
          APIENTRY;
 %end;
 %if INCL_GPISEGMENTS='Y' %then %do;
   %dcl DFORM_NOCONV char;
   %DFORM_NOCONV=0;
   %if INCL_SAADEFS='Y' %then %do;
     %dcl DFORM_S370SHORT char;
     %DFORM_S370SHORT=1;
     %dcl DFORM_PCSHORT char;
     %DFORM_PCSHORT=2;
     %dcl DFORM_PCLONG char;
     %DFORM_PCLONG=4;
   %end;
   %dcl ATTR_ERROR char;
   %ATTR_ERROR=-1;
   %dcl ATTR_DETECTABLE char;
   %ATTR_DETECTABLE=1;
   %dcl ATTR_VISIBLE char;
   %ATTR_VISIBLE=2;
   %dcl ATTR_CHAINED char;
   %ATTR_CHAINED=6;
   %if INCL_SAADEFS='Y' %then %do;
     %dcl ATTR_DYNAMIC char;
     %ATTR_DYNAMIC=8;
   %end;
   %dcl ATTR_FASTCHAIN char;
   %ATTR_FASTCHAIN=9;
   %dcl ATTR_PROP_DETECTABLE char;
   %ATTR_PROP_DETECTABLE=10;
   %dcl ATTR_PROP_VISIBLE char;
   %ATTR_PROP_VISIBLE=11;
   %dcl ATTR_OFF char;
   %ATTR_OFF=0;
   %dcl ATTR_ON char;
   %ATTR_ON=1;
   %dcl LOWER_PRI char;
   %LOWER_PRI=-1;
   %dcl HIGHER_PRI char;
   %HIGHER_PRI=1;
   dcl GpiOpenSegment entry (
          HPS,
          LONG)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl GpiCloseSegment entry (
          HPS)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl GpiDeleteSegment entry (
          HPS,
          LONG)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl GpiQueryInitialSegmentAttrs entry (
          HPS,
          LONG)
          returns(optional byvalue LONG)
          APIENTRY;
   dcl GpiSetInitialSegmentAttrs entry (
          HPS,
          LONG,
          LONG)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl GpiQuerySegmentAttrs entry (
          HPS,
          LONG,
          LONG)
          returns(optional byvalue LONG)
          APIENTRY;
   dcl GpiSetSegmentAttrs entry (
          HPS,
          LONG,
          LONG,
          LONG)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl GpiQuerySegmentPriority entry (
          HPS,
          LONG,
          LONG)
          returns(optional byvalue LONG)
          APIENTRY;
   dcl GpiSetSegmentPriority entry (
          HPS,
          LONG,
          LONG,
          LONG)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl GpiDeleteSegments entry (
          HPS,
          LONG,
          LONG)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl GpiQuerySegmentNames entry (
          HPS,
          LONG,
          LONG,
          LONG,
          PLONG)
          returns(optional byvalue LONG)
          APIENTRY;
   dcl GpiGetData entry (
          HPS,
          LONG,
          PLONG,
          LONG,
          LONG,
          PBYTE)
          returns(optional byvalue LONG)
          APIENTRY;
   dcl GpiPutData entry (
          HPS,
          LONG,
          PLONG,
          PBYTE)
          returns(optional byvalue LONG)
          APIENTRY;
   dcl GpiDrawChain entry (
          HPS)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl GpiDrawFrom entry (
          HPS,
          LONG,
          LONG)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl GpiDrawSegment entry (
          HPS,
          LONG)
          returns(optional byvalue BOOL)
          APIENTRY;
   %if INCL_SAADEFS='Y' %then %do;
     dcl GpiDrawDynamics entry (
            HPS)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiRemoveDynamics entry (
            HPS,
            LONG,
            LONG)
            returns(optional byvalue BOOL)
            APIENTRY;
   %end;
 %end;
 %if INCL_GPISEGEDITING='Y' %then %do;
   %dcl SEGEM_ERROR char;
   %SEGEM_ERROR=0;
   %dcl SEGEM_INSERT char;
   %SEGEM_INSERT=1;
   %dcl SEGEM_REPLACE char;
   %SEGEM_REPLACE=2;
   dcl GpiBeginElement entry (
          HPS,
          LONG,
          PSZ)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl GpiEndElement entry (
          HPS)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl GpiLabel entry (
          HPS,
          LONG)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl GpiElement entry (
          HPS,
          LONG,
          PSZ,
          LONG,
          PBYTE)
          returns(optional byvalue LONG)
          APIENTRY;
   dcl GpiQueryElement entry (
          HPS,
          LONG,
          LONG,
          PBYTE)
          returns(optional byvalue LONG)
          APIENTRY;
   dcl GpiDeleteElement entry (
          HPS)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl GpiDeleteElementRange entry (
          HPS,
          LONG,
          LONG)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl GpiDeleteElementsBetweenLabels entry (
          HPS,
          LONG,
          LONG)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl GpiQueryEditMode entry (
          HPS)
          returns(optional byvalue LONG)
          APIENTRY;
   dcl GpiSetEditMode entry (
          HPS,
          LONG)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl GpiQueryElementPointer entry (
          HPS)
          returns(optional byvalue LONG)
          APIENTRY;
   dcl GpiSetElementPointer entry (
          HPS,
          LONG)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl GpiOffsetElementPointer entry (
          HPS,
          LONG)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl GpiQueryElementType entry (
          HPS,
          PLONG,
          LONG,
          PSZ)
          returns(optional byvalue LONG)
          APIENTRY;
   dcl GpiSetElementPointerAtLabel entry (
          HPS,
          LONG)
          returns(optional byvalue BOOL)
          APIENTRY;
 %end;
 %if INCL_GPITRANSFORMS='Y' %then %do;
   %dcl CVTC_WORLD char;
   %CVTC_WORLD=1;
   %dcl CVTC_MODEL char;
   %CVTC_MODEL=2;
   %dcl CVTC_DEFAULTPAGE char;
   %CVTC_DEFAULTPAGE=3;
   %dcl CVTC_PAGE char;
   %CVTC_PAGE=4;
   %dcl CVTC_DEVICE char;
   %CVTC_DEVICE=5;
   %dcl TRANSFORM_REPLACE char;
   %TRANSFORM_REPLACE=0;
   %dcl TRANSFORM_ADD char;
   %TRANSFORM_ADD=1;
   %dcl TRANSFORM_PREEMPT char;
   %TRANSFORM_PREEMPT=2;
   %dcl MATRIXLF char;
   %MATRIXLF='char(stg(#MATRIXLF))';
   dcl 1 #MATRIXLF based(null()) unaligned,
         2 fxM11 FIXED bin(31,16),
         2 fxM12 FIXED bin(31,16),
         2 lM13 LONG,
         2 fxM21 FIXED bin(31,16),
         2 fxM22 FIXED bin(31,16),
         2 lM23 LONG,
         2 lM31 LONG,
         2 lM32 LONG,
         2 lM33 LONG;
   %dcl PMATRIXLF char;
   %PMATRIXLF='pointer';
   %if INCL_DDIDEFS='Y' %then %do;
     dcl GpiQuerySegmentTransformMatrix entry (
            HPS,
            LONG,
            LONG,
            PMATRIXLF)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiSetSegmentTransformMatrix entry (
            HPS,
            LONG,
            LONG,
            PMATRIXLF,
            LONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiConvert entry (
            HPS,
            LONG,
            LONG,
            LONG,
            PPOINTL)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiConvertWithMatrix entry (
            HPS,
            LONG,
            PPOINTL,
            LONG,
            PMATRIXLF)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiQueryModelTransformMatrix entry (
            HPS,
            LONG,
            PMATRIXLF)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiSetModelTransformMatrix entry (
            HPS,
            LONG,
            PMATRIXLF,
            LONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiCallSegmentMatrix entry (
            HPS,
            LONG,
            LONG,
            PMATRIXLF,
            LONG)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiQueryDefaultViewMatrix entry (
            HPS,
            LONG,
            PMATRIXLF)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiSetDefaultViewMatrix entry (
            HPS,
            LONG,
            PMATRIXLF,
            LONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiQueryPageViewport entry (
            HPS,
            PRECTL)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiSetPageViewport entry (
            HPS,
            PRECTL)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiQueryViewingTransformMatrix entry (
            HPS,
            LONG,
            PMATRIXLF)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiSetViewingTransformMatrix entry (
            HPS,
            LONG,
            PMATRIXLF,
            LONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiTranslate entry (
            HPS,
            PMATRIXLF,
            LONG,
            PPOINTL)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiScale entry (
            HPS,
            PMATRIXLF,
            LONG,
            PFIXED,
            PPOINTL)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiRotate entry (
            HPS,
            PMATRIXLF,
            LONG,
            FIXED bin(31,16),
            PPOINTL)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiSetGraphicsField entry (
            HPS,
            PRECTL)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiQueryGraphicsField entry (
            HPS,
            PRECTL)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiSetViewingLimits entry (
            HPS,
            PRECTL)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiQueryViewingLimits entry (
            HPS,
            PRECTL)
            returns(optional byvalue BOOL)
            APIENTRY;
   %end;
 %end;
 %if INCL_GPIPATHS='Y' %then %do;
   %dcl MPATH_STROKE char;
   %MPATH_STROKE=6;
   %dcl FPATH_ALTERNATE char;
   %FPATH_ALTERNATE=0;
   %dcl FPATH_WINDING char;
   %FPATH_WINDING=2;
   %dcl FPATH_INCL char;
   %FPATH_INCL=0;
   %dcl FPATH_EXCL char;
   %FPATH_EXCL=8;
   %dcl SCP_ALTERNATE char;
   %SCP_ALTERNATE=0;
   %dcl SCP_WINDING char;
   %SCP_WINDING=2;
   %dcl SCP_AND char;
   %SCP_AND=4;
   %dcl SCP_RESET char;
   %SCP_RESET=0;
   %dcl SCP_INCL char;
   %SCP_INCL=0;
   %dcl SCP_EXCL char;
   %SCP_EXCL=8;
   %if INCL_DDIDEFS='Y' %then %do;
     dcl GpiBeginPath entry (
            HPS,
            LONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiEndPath entry (
            HPS)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiCloseFigure entry (
            HPS)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiModifyPath entry (
            HPS,
            LONG,
            LONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiFillPath entry (
            HPS,
            LONG,
            LONG)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiSetClipPath entry (
            HPS,
            LONG,
            LONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiOutlinePath entry (
            HPS,
            LONG,
            LONG)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiPathToRegion entry (
            HPS,
            LONG,
            LONG)
            returns(optional byvalue HRGN)
            APIENTRY;
     %if INCL_SAADEFS='Y' %then %do;
       dcl GpiStrokePath entry (
              HPS,
              LONG,
              ULONG)
              returns(optional byvalue LONG)
              APIENTRY;
     %end;
   %end;
 %end;
 %if INCL_GPILOGCOLORTABLE='Y' %then %do;
   %if INCL_GPIBITMAPS='Y' %then %do;
     %INCL_GPIBITMAPS='Y';
   %end;
   dcl LCOL_RESET fixed bin(31) value('00_00_00_01'xn);
   dcl LCOL_REALIZABLE fixed bin(31) value('00_00_00_02'xn);
   dcl LCOL_PURECOLOR fixed bin(31) value('00_00_00_04'xn);
   dcl LCOL_OVERRIDE_DEFAULT_COLORS fixed bin(31)
                                    value('00_00_00_08'xn);
   dcl LCOL_REALIZED fixed bin(31) value('00_00_00_10'xn);
   %dcl LCOLF_DEFAULT char;
   %LCOLF_DEFAULT=0;
   %dcl LCOLF_INDRGB char;
   %LCOLF_INDRGB=1;
   %dcl LCOLF_CONSECRGB char;
   %LCOLF_CONSECRGB=2;
   %dcl LCOLF_RGB char;
   %LCOLF_RGB=3;
   %dcl LCOLF_PALETTE char;
   %LCOLF_PALETTE=4;
   dcl LCOLOPT_REALIZED fixed bin(31) value('00_00_00_01'xn);
   dcl LCOLOPT_INDEX fixed bin(31) value('00_00_00_02'xn);

   %if INCL_SAADEFS='Y' %then %do;
     %dcl QLCT_ERROR char;
     %QLCT_ERROR=-1;
     %dcl QLCT_RGB char;
     %QLCT_RGB=-2;
     %dcl QLCT_NOTLOADED char;
     %QLCT_NOTLOADED=-1;
   %end;
   %dcl QCD_LCT_FORMAT char;
   %QCD_LCT_FORMAT=0;
   %dcl QCD_LCT_LOINDEX char;
   %QCD_LCT_LOINDEX=1;
   %dcl QCD_LCT_HIINDEX char;
   %QCD_LCT_HIINDEX=2;
   %dcl QCD_LCT_OPTIONS char;
   %QCD_LCT_OPTIONS=3;
   %dcl PAL_ERROR char;
   %PAL_ERROR=-1;
   dcl PC_RESERVED bit(8) value('00_00_00_01'b);
   dcl PC_EXPLICIT bit(8) value('00_00_00_10'b);
   dcl PC_NOCOLLAPSE bit(8) value('00_00_01_00'b);
   %if INCL_DDIDEFS='Y' %then %do;
     dcl GpiCreateLogColorTable entry (
            HPS,
            ULONG,
            LONG,
            LONG,
            LONG,
            PLONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiQueryColorData entry (
            HPS,
            LONG,
            PLONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     %if INCL_SAADEFS='Y' %then %do;
       dcl GpiQueryLogColorTable entry (
              HPS,
              ULONG,
              LONG,
              LONG,
              PLONG)
              returns(optional byvalue LONG)
              APIENTRY;
     %end;
     dcl GpiQueryRealColors entry (
            HPS,
            ULONG,
            LONG,
            LONG,
            PLONG)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiQueryNearestColor entry (
            HPS,
            ULONG,
            LONG)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiQueryColorIndex entry (
            HPS,
            ULONG,
            LONG)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiQueryRGBColor entry (
            HPS,
            ULONG,
            LONG)
            returns(optional byvalue LONG)
            APIENTRY;
     %if INCL_SAADEFS='Y' %then %do;
       dcl GpiCreatePalette entry (
              HAB,
              ULONG,
              ULONG,
              ULONG,
              PULONG)
              returns(optional byvalue HPAL)
              APIENTRY;
       dcl GpiDeletePalette entry (
              HPAL)
              returns(optional byvalue BOOL)
              APIENTRY;
       dcl GpiSelectPalette entry (
              HPS,
              HPAL)
              returns(optional byvalue HPAL)
              APIENTRY;
       dcl GpiAnimatePalette entry (
              HPAL,
              ULONG,
              ULONG,
              ULONG,
              PULONG)
              returns(optional byvalue LONG)
              APIENTRY;
       dcl GpiSetPaletteEntries entry (
              HPAL,
              ULONG,
              ULONG,
              ULONG,
              PULONG)
              returns(optional byvalue BOOL)
              APIENTRY;
       dcl GpiQueryPalette entry (
              HPS)
              returns(optional byvalue HPAL)
              APIENTRY;
       dcl GpiQueryPaletteInfo entry (
              HPAL,
              HPS,
              ULONG,
              ULONG,
              ULONG,
              PULONG)
              returns(optional byvalue LONG)
              APIENTRY;
     %end;
   %end;
 %end;
 %if INCL_GPIPRIMITIVES='Y' | INCL_NOCOMMON='Y' %then %do;
   %dcl CLR_FALSE char;
   %CLR_FALSE=-5;
   %dcl CLR_TRUE char;
   %CLR_TRUE=-4;
   %dcl CLR_ERROR char;
   %CLR_ERROR=-255;
   %dcl CLR_DEFAULT char;
   %CLR_DEFAULT=-3;
   %dcl CLR_WHITE char;
   %CLR_WHITE=-2;
   %dcl CLR_BLACK char;
   %CLR_BLACK=-1;
   %dcl CLR_BACKGROUND char;
   %CLR_BACKGROUND=0;
   %dcl CLR_BLUE char;
   %CLR_BLUE=1;
   %dcl CLR_RED char;
   %CLR_RED=2;
   %dcl CLR_PINK char;
   %CLR_PINK=3;
   %dcl CLR_GREEN char;
   %CLR_GREEN=4;
   %dcl CLR_CYAN char;
   %CLR_CYAN=5;
   %dcl CLR_YELLOW char;
   %CLR_YELLOW=6;
   %dcl CLR_NEUTRAL char;
   %CLR_NEUTRAL=7;
   %dcl CLR_DARKGRAY char;
   %CLR_DARKGRAY=8;
   %dcl CLR_DARKBLUE char;
   %CLR_DARKBLUE=9;
   %dcl CLR_DARKRED char;
   %CLR_DARKRED=10;
   %dcl CLR_DARKPINK char;
   %CLR_DARKPINK=11;
   %dcl CLR_DARKGREEN char;
   %CLR_DARKGREEN=12;
   %dcl CLR_DARKCYAN char;
   %CLR_DARKCYAN=13;
   %dcl CLR_BROWN char;
   %CLR_BROWN=14;
   %dcl CLR_PALEGRAY char;
   %CLR_PALEGRAY=15;
   %dcl RGB_ERROR char;
   %RGB_ERROR=-255;

   dcl RGB_BLACK fixed bin(31) value('00_00_00_00'xn);
   dcl RGB_BLUE fixed bin(31) value('00_00_00_FF'xn);
   dcl RGB_GREEN fixed bin(31) value('00_00_FF_00'xn);
   dcl RGB_CYAN fixed bin(31) value('00_00_FF_FF'xn);
   dcl RGB_RED fixed bin(31) value('00_FF_00_00'xn);
   dcl RGB_PINK fixed bin(31) value('00_FF_00_FF'xn);
   dcl RGB_YELLOW fixed bin(31) value('00_FF_FF_00'xn);
   dcl RGB_WHITE fixed bin(31) value('00_FF_FF_FF'xn);
   %dcl BA_NOBOUNDARY char;
   %BA_NOBOUNDARY=0;
   dcl BA_BOUNDARY fixed bin(31) value('00_00_00_01'xn);
   %dcl BA_ALTERNATE char;
   %BA_ALTERNATE=0;
   %dcl BA_WINDING char;
   %BA_WINDING=2;
   %dcl BA_INCL char;
   %BA_INCL=0;
   %dcl BA_EXCL char;
   %BA_EXCL=8;
   %dcl DRO_FILL char;
   %DRO_FILL=1;
   %dcl DRO_OUTLINE char;
   %DRO_OUTLINE=2;
   %dcl DRO_OUTLINEFILL char;
   %DRO_OUTLINEFILL=3;
   %dcl PATSYM_ERROR char;
   %PATSYM_ERROR=-1;
   %dcl PATSYM_DEFAULT char;
   %PATSYM_DEFAULT=0;
   %dcl PATSYM_DENSE1 char;
   %PATSYM_DENSE1=1;
   %dcl PATSYM_DENSE2 char;
   %PATSYM_DENSE2=2;
   %dcl PATSYM_DENSE3 char;
   %PATSYM_DENSE3=3;
   %dcl PATSYM_DENSE4 char;
   %PATSYM_DENSE4=4;
   %dcl PATSYM_DENSE5 char;
   %PATSYM_DENSE5=5;
   %dcl PATSYM_DENSE6 char;
   %PATSYM_DENSE6=6;
   %dcl PATSYM_DENSE7 char;
   %PATSYM_DENSE7=7;
   %dcl PATSYM_DENSE8 char;
   %PATSYM_DENSE8=8;
   %dcl PATSYM_VERT char;
   %PATSYM_VERT=9;
   %dcl PATSYM_HORIZ char;
   %PATSYM_HORIZ=10;
   %dcl PATSYM_DIAG1 char;
   %PATSYM_DIAG1=11;
   %dcl PATSYM_DIAG2 char;
   %PATSYM_DIAG2=12;
   %dcl PATSYM_DIAG3 char;
   %PATSYM_DIAG3=13;
   %dcl PATSYM_DIAG4 char;
   %PATSYM_DIAG4=14;
   %dcl PATSYM_NOSHADE char;
   %PATSYM_NOSHADE=15;
   %dcl PATSYM_SOLID char;
   %PATSYM_SOLID=16;
   %if INCL_SAADEFS='Y' %then %do;
     %dcl PATSYM_HALFTONE char;
     %PATSYM_HALFTONE=17;
   %end;
   %dcl PATSYM_HATCH char;
   %PATSYM_HATCH=18;
   %dcl PATSYM_DIAGHATCH char;
   %PATSYM_DIAGHATCH=19;
   %dcl PATSYM_BLANK char;
   %PATSYM_BLANK=64;
   %dcl LCID_ERROR char;
   %LCID_ERROR=-1;
   %dcl LCID_DEFAULT char;
   %LCID_DEFAULT=0;
   %if INCL_DDIDEFS='Y' %then %do;
     dcl GpiSetColor entry (
            HPS,
            LONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiQueryColor entry (
            HPS)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiBox entry (
            HPS,
            LONG,
            PPOINTL,
            LONG,
            LONG)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiMove entry (
            HPS,
            PPOINTL)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiLine entry (
            HPS,
            PPOINTL)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiPolyLine entry (
            HPS,
            LONG,
            PPOINTL)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiPolyLineDisjoint entry (
            HPS,
            LONG,
            PPOINTL)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiSetPattern entry (
            HPS,
            LONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiQueryPattern entry (
            HPS)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiBeginArea entry (
            HPS,
            ULONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiEndArea entry (
            HPS)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiCharString entry (
            HPS,
            LONG,
            PCH)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiCharStringAt entry (
            HPS,
            PPOINTL,
            LONG,
            PCH)
            returns(optional byvalue LONG)
            APIENTRY;
   %end;
 %end;
 %if INCL_GPIPRIMITIVES='Y' %then %do;
   %dcl AM_ERROR char;
   %AM_ERROR=-1;
   %dcl AM_PRESERVE char;
   %AM_PRESERVE=0;
   %dcl AM_NOPRESERVE char;
   %AM_NOPRESERVE=1;
   %dcl FM_ERROR char;
   %FM_ERROR=-1;
   %dcl FM_DEFAULT char;
   %FM_DEFAULT=0;
   %dcl FM_OR char;
   %FM_OR=1;
   %dcl FM_OVERPAINT char;
   %FM_OVERPAINT=2;
   %dcl FM_LEAVEALONE char;
   %FM_LEAVEALONE=5;
   %dcl FM_XOR char;
   %FM_XOR=4;
   %dcl FM_AND char;
   %FM_AND=6;
   %dcl FM_SUBTRACT char;
   %FM_SUBTRACT=7;
   %dcl FM_MASKSRCNOT char;
   %FM_MASKSRCNOT=8;
   %dcl FM_ZERO char;
   %FM_ZERO=9;
   %dcl FM_NOTMERGESRC char;
   %FM_NOTMERGESRC=10;
   %dcl FM_NOTXORSRC char;
   %FM_NOTXORSRC=11;
   %dcl FM_INVERT char;
   %FM_INVERT=12;
   %dcl FM_MERGESRCNOT char;
   %FM_MERGESRCNOT=13;
   %dcl FM_NOTCOPYSRC char;
   %FM_NOTCOPYSRC=14;
   %dcl FM_MERGENOTSRC char;
   %FM_MERGENOTSRC=15;
   %dcl FM_NOTMASKSRC char;
   %FM_NOTMASKSRC=16;
   %dcl FM_ONE char;
   %FM_ONE=17;
   %dcl BM_ERROR char;
   %BM_ERROR=-1;
   %dcl BM_DEFAULT char;
   %BM_DEFAULT=0;
   %dcl BM_OR char;
   %BM_OR=1;
   %dcl BM_OVERPAINT char;
   %BM_OVERPAINT=2;
   %dcl BM_LEAVEALONE char;
   %BM_LEAVEALONE=5;
   %dcl BM_XOR char;
   %BM_XOR=4;
   %dcl BM_AND char;
   %BM_AND=6;
   %dcl BM_SUBTRACT char;
   %BM_SUBTRACT=7;
   %dcl BM_MASKSRCNOT char;
   %BM_MASKSRCNOT=8;
   %dcl BM_ZERO char;
   %BM_ZERO=9;
   %dcl BM_NOTMERGESRC char;
   %BM_NOTMERGESRC=10;
   %dcl BM_NOTXORSRC char;
   %BM_NOTXORSRC=11;
   %dcl BM_INVERT char;
   %BM_INVERT=12;
   %dcl BM_MERGESRCNOT char;
   %BM_MERGESRCNOT=13;
   %dcl BM_NOTCOPYSRC char;
   %BM_NOTCOPYSRC=14;
   %dcl BM_MERGENOTSRC char;
   %BM_MERGENOTSRC=15;
   %dcl BM_NOTMASKSRC char;
   %BM_NOTMASKSRC=16;
   %dcl BM_ONE char;
   %BM_ONE=17;
   %dcl BM_SRCTRANSPARENT char;
   %BM_SRCTRANSPARENT=18;
   %dcl BM_DESTTRANSPARENT char;
   %BM_DESTTRANSPARENT=19;
   %dcl LINETYPE_ERROR char;
   %LINETYPE_ERROR=-1;
   %dcl LINETYPE_DEFAULT char;
   %LINETYPE_DEFAULT=0;
   %dcl LINETYPE_DOT char;
   %LINETYPE_DOT=1;
   %dcl LINETYPE_SHORTDASH char;
   %LINETYPE_SHORTDASH=2;
   %dcl LINETYPE_DASHDOT char;
   %LINETYPE_DASHDOT=3;
   %dcl LINETYPE_DOUBLEDOT char;
   %LINETYPE_DOUBLEDOT=4;
   %dcl LINETYPE_LONGDASH char;
   %LINETYPE_LONGDASH=5;
   %dcl LINETYPE_DASHDOUBLEDOT char;
   %LINETYPE_DASHDOUBLEDOT=6;
   %dcl LINETYPE_SOLID char;
   %LINETYPE_SOLID=7;
   %dcl LINETYPE_INVISIBLE char;
   %LINETYPE_INVISIBLE=8;
   %if INCL_SAADEFS='Y' %then %do;
     %dcl LINETYPE_ALTERNATE char;
     %LINETYPE_ALTERNATE=9;
   %end;
   %dcl LINEWIDTH_ERROR char;
   %LINEWIDTH_ERROR=-1;
   %dcl LINEWIDTH_DEFAULT char;
   %LINEWIDTH_DEFAULT=0;
   dcl LINEWIDTH_NORMAL fixed bin(31,16) value(1.0);
   dcl LINEWIDTH_THICK fixed bin(31,16) value(2.0);
   %dcl LINEWIDTHGEOM_ERROR char;
   %LINEWIDTHGEOM_ERROR=-1;
   %dcl LINEEND_ERROR char;
   %LINEEND_ERROR=-1;
   %dcl LINEEND_DEFAULT char;
   %LINEEND_DEFAULT=0;
   %dcl LINEEND_FLAT char;
   %LINEEND_FLAT=1;
   %dcl LINEEND_SQUARE char;
   %LINEEND_SQUARE=2;
   %dcl LINEEND_ROUND char;
   %LINEEND_ROUND=3;
   %dcl LINEJOIN_ERROR char;
   %LINEJOIN_ERROR=-1;
   %dcl LINEJOIN_DEFAULT char;
   %LINEJOIN_DEFAULT=0;
   %dcl LINEJOIN_BEVEL char;
   %LINEJOIN_BEVEL=1;
   %dcl LINEJOIN_ROUND char;
   %LINEJOIN_ROUND=2;
   %dcl LINEJOIN_MITRE char;
   %LINEJOIN_MITRE=3;
   %dcl CHDIRN_ERROR char;
   %CHDIRN_ERROR=-1;
   %dcl CHDIRN_DEFAULT char;
   %CHDIRN_DEFAULT=0;
   %dcl CHDIRN_LEFTRIGHT char;
   %CHDIRN_LEFTRIGHT=1;
   %dcl CHDIRN_TOPBOTTOM char;
   %CHDIRN_TOPBOTTOM=2;
   %dcl CHDIRN_RIGHTLEFT char;
   %CHDIRN_RIGHTLEFT=3;
   %dcl CHDIRN_BOTTOMTOP char;
   %CHDIRN_BOTTOMTOP=4;

   dcl TA_NORMAL_HORIZ fixed bin(16) value('00_01'xn);
   dcl TA_LEFT fixed bin(16) value('00_02'xn);
   dcl TA_CENTER fixed bin(16) value('00_03'xn);
   dcl TA_RIGHT fixed bin(16) value('00_04'xn);
   dcl TA_STANDARD_HORIZ fixed bin(16) value('00_05'xn);
   dcl TA_NORMAL_VERT fixed bin(16) value('01_00'xn);
   dcl TA_TOP fixed bin(16) value('02_00'xn);
   dcl TA_HALF fixed bin(16) value('03_00'xn);
   dcl TA_BASE fixed bin(16) value('04_00'xn);
   dcl TA_BOTTOM fixed bin(16) value('05_00'xn);
   dcl TA_STANDARD_VERT fixed bin(16) value('06_00'xn);
   %dcl CM_ERROR char;
   %CM_ERROR=-1;
   %dcl CM_DEFAULT char;
   %CM_DEFAULT=0;
   %dcl CM_MODE1 char;
   %CM_MODE1=1;
   %dcl CM_MODE2 char;
   %CM_MODE2=2;
   %dcl CM_MODE3 char;
   %CM_MODE3=3;
   %dcl MARKSYM_ERROR char;
   %MARKSYM_ERROR=-1;
   %dcl MARKSYM_DEFAULT char;
   %MARKSYM_DEFAULT=0;
   %dcl MARKSYM_CROSS char;
   %MARKSYM_CROSS=1;
   %dcl MARKSYM_PLUS char;
   %MARKSYM_PLUS=2;
   %dcl MARKSYM_DIAMOND char;
   %MARKSYM_DIAMOND=3;
   %dcl MARKSYM_SQUARE char;
   %MARKSYM_SQUARE=4;
   %dcl MARKSYM_SIXPOINTSTAR char;
   %MARKSYM_SIXPOINTSTAR=5;
   %dcl MARKSYM_EIGHTPOINTSTAR char;
   %MARKSYM_EIGHTPOINTSTAR=6;
   %dcl MARKSYM_SOLIDDIAMOND char;
   %MARKSYM_SOLIDDIAMOND=7;
   %dcl MARKSYM_SOLIDSQUARE char;
   %MARKSYM_SOLIDSQUARE=8;
   %dcl MARKSYM_DOT char;
   %MARKSYM_DOT=9;
   %dcl MARKSYM_SMALLCIRCLE char;
   %MARKSYM_SMALLCIRCLE=10;
   %dcl MARKSYM_BLANK char;
   %MARKSYM_BLANK=64;

   dcl CHS_OPAQUE fixed bin(31) value('00_00_00_01'xn);
   dcl CHS_VECTOR fixed bin(31) value('00_00_00_02'xn);
   dcl CHS_LEAVEPOS fixed bin(31) value('00_00_00_08'xn);
   dcl CHS_CLIP fixed bin(31) value('00_00_00_10'xn);
   dcl CHS_UNDERSCORE fixed bin(31) value('00_00_02_00'xn);
   dcl CHS_STRIKEOUT fixed bin(31) value('00_00_04_00'xn);

   %dcl PRIM_LINE char;
   %PRIM_LINE=1;
   %dcl PRIM_CHAR char;
   %PRIM_CHAR=2;
   %dcl PRIM_MARKER char;
   %PRIM_MARKER=3;
   %dcl PRIM_AREA char;
   %PRIM_AREA=4;
   %dcl PRIM_IMAGE char;
   %PRIM_IMAGE=5;

   dcl LBB_COLOR fixed bin(31) value('00_00_00_01'xn);
   dcl LBB_BACK_COLOR fixed bin(31) value('00_00_00_02'xn);
   dcl LBB_MIX_MODE fixed bin(31) value('00_00_00_04'xn);
   dcl LBB_BACK_MIX_MODE fixed bin(31) value('00_00_00_08'xn);
   dcl LBB_WIDTH fixed bin(31) value('00_00_00_10'xn);
   dcl LBB_GEOM_WIDTH fixed bin(31) value('00_00_00_20'xn);
   dcl LBB_TYPE fixed bin(31) value('00_00_00_40'xn);
   dcl LBB_END fixed bin(31) value('00_00_00_80'xn);
   dcl LBB_JOIN fixed bin(31) value('00_00_01_00'xn);

   dcl CBB_COLOR fixed bin(31) value('00_00_00_01'xn);
   dcl CBB_BACK_COLOR fixed bin(31) value('00_00_00_02'xn);
   dcl CBB_MIX_MODE fixed bin(31) value('00_00_00_04'xn);
   dcl CBB_BACK_MIX_MODE fixed bin(31) value('00_00_00_08'xn);
   dcl CBB_SET fixed bin(31) value('00_00_00_10'xn);
   dcl CBB_MODE fixed bin(31) value('00_00_00_20'xn);
   dcl CBB_BOX fixed bin(31) value('00_00_00_40'xn);
   dcl CBB_ANGLE fixed bin(31) value('00_00_00_80'xn);
   dcl CBB_SHEAR fixed bin(31) value('00_00_01_00'xn);
   dcl CBB_DIRECTION fixed bin(31) value('00_00_02_00'xn);
   dcl CBB_TEXT_ALIGN fixed bin(31) value('00_00_04_00'xn);
   dcl CBB_EXTRA fixed bin(31) value('00_00_08_00'xn);
   dcl CBB_BREAK_EXTRA fixed bin(31) value('00_00_10_00'xn);

   dcl MBB_COLOR fixed bin(31) value('00_00_00_01'xn);
   dcl MBB_BACK_COLOR fixed bin(31) value('00_00_00_02'xn);
   dcl MBB_MIX_MODE fixed bin(31) value('00_00_00_04'xn);
   dcl MBB_BACK_MIX_MODE fixed bin(31) value('00_00_00_08'xn);
   dcl MBB_SET fixed bin(31) value('00_00_00_10'xn);
   dcl MBB_SYMBOL fixed bin(31) value('00_00_00_20'xn);
   dcl MBB_BOX fixed bin(31) value('00_00_00_40'xn);

   dcl ABB_COLOR fixed bin(31) value('00_00_00_01'xn);
   dcl ABB_BACK_COLOR fixed bin(31) value('00_00_00_02'xn);
   dcl ABB_MIX_MODE fixed bin(31) value('00_00_00_04'xn);
   dcl ABB_BACK_MIX_MODE fixed bin(31) value('00_00_00_08'xn);
   dcl ABB_SET fixed bin(31) value('00_00_00_10'xn);
   dcl ABB_SYMBOL fixed bin(31) value('00_00_00_20'xn);
   dcl ABB_REF_POINT fixed bin(31) value('00_00_00_40'xn);

   dcl IBB_COLOR fixed bin(31) value('00_00_00_01'xn);
   dcl IBB_BACK_COLOR fixed bin(31) value('00_00_00_02'xn);
   dcl IBB_MIX_MODE fixed bin(31) value('00_00_00_04'xn);
   dcl IBB_BACK_MIX_MODE fixed bin(31) value('00_00_00_08'xn);

   %dcl ARCPARAMS char;
   %ARCPARAMS='char(stg(#ARCPARAMS))';
   dcl 1 #ARCPARAMS based(null()) unaligned,
         2 lP LONG,
         2 lQ LONG,
         2 lR LONG,
         2 lS LONG;
   %dcl PARCPARAMS char;
   %PARCPARAMS='pointer';
   %dcl SIZEF char;
   %SIZEF='char(stg(#SIZEF))';
   dcl 1 #SIZEF based(null()) unaligned,
         2 cx FIXED bin(31,16),
         2 cy FIXED bin(31,16);
   %dcl PSIZEF char;
   %PSIZEF='pointer';
   %dcl GRADIENTL char;
   %GRADIENTL='char(stg(#GRADIENTL))';
   dcl 1 #GRADIENTL based(null()) unaligned,
         2 x LONG,
         2 y LONG;
   %dcl PGRADIENTL char;
   %PGRADIENTL='pointer';
   %dcl LINEBUNDLE char;
   %LINEBUNDLE='char(stg(#LINEBUNDLE))';
   dcl 1 #LINEBUNDLE based(null()) unaligned,
         2 lColor LONG,
         2 lBackColor LONG,
         2 usMixMode USHORT,
         2 usBackMixMode USHORT,
         2 fxWidth FIXED bin(31,16),
         2 lGeomWidth LONG,
         2 usType USHORT,
         2 usEnd USHORT,
         2 usJoin USHORT,
         2 usReserved USHORT;
   %dcl PLINEBUNDLE char;
   %PLINEBUNDLE='pointer';
   %dcl CHARBUNDLE char;
   %CHARBUNDLE='char(stg(#CHARBUNDLE))';
   dcl 1 #CHARBUNDLE based(null()) unaligned,
         2 lColor LONG,
         2 lBackColor LONG,
         2 usMixMode USHORT,
         2 usBackMixMode USHORT,
         2 usSet USHORT,
         2 usPrecision USHORT,
         2 sizfxCell SIZEF,
         2 ptlAngle POINTL,
         2 ptlShear POINTL,
         2 usDirection USHORT,
         2 usTextAlign USHORT,
         2 fxExtra FIXED bin(31,16),
         2 fxBreakExtra FIXED  bin(31,16);
   %dcl PCHARBUNDLE char;
   %PCHARBUNDLE='pointer';
   %dcl MARKERBUNDLE char;
   %MARKERBUNDLE='char(stg(#MARKERBUNDLE))';
   dcl 1 #MARKERBUNDLE based(null()) unaligned,
         2 lColor LONG,
         2 lBackColor LONG,
         2 usMixMode USHORT,
         2 usBackMixMode USHORT,
         2 usSet USHORT,
         2 usSymbol USHORT,
         2 sizfxCell SIZEF;
   %dcl PMARKERBUNDLE char;
   %PMARKERBUNDLE='pointer';
   %dcl AREABUNDLE char;
   %AREABUNDLE='char(stg(#AREABUNDLE))';
   dcl 1 #AREABUNDLE based(null()) unaligned,
         2 lColor LONG,
         2 lBackColor LONG,
         2 usMixMode USHORT,
         2 usBackMixMode USHORT,
         2 usSet USHORT,
         2 usSymbol USHORT,
         2 ptlRefPoint POINTL;
   %dcl PAREABUNDLE char;
   %PAREABUNDLE='pointer';
   %dcl IMAGEBUNDLE char;
   %IMAGEBUNDLE='char(stg(#IMAGEBUNDLE))';
   dcl 1 #IMAGEBUNDLE based(null()) unaligned,
         2 lColor LONG,
         2 lBackColor LONG,
         2 usMixMode USHORT,
         2 usBackMixMode USHORT;
   %dcl PIMAGEBUNDLE char;
   %PIMAGEBUNDLE='pointer';
   %dcl PBUNDLE char;
   %PBUNDLE=PVOID;
   %dcl TXTBOX_TOPLEFT char;
   %TXTBOX_TOPLEFT=0;
   %dcl TXTBOX_BOTTOMLEFT char;
   %TXTBOX_BOTTOMLEFT=1;
   %dcl TXTBOX_TOPRIGHT char;
   %TXTBOX_TOPRIGHT=2;
   %dcl TXTBOX_BOTTOMRIGHT char;
   %TXTBOX_BOTTOMRIGHT=3;
   %dcl TXTBOX_CONCAT char;
   %TXTBOX_CONCAT=4;
   %dcl TXTBOX_COUNT char;
   %TXTBOX_COUNT=5;
   %dcl PVIS_ERROR char;
   %PVIS_ERROR=0;
   %dcl PVIS_INVISIBLE char;
   %PVIS_INVISIBLE=1;
   %dcl PVIS_VISIBLE char;
   %PVIS_VISIBLE=2;
   %dcl RVIS_ERROR char;
   %RVIS_ERROR=0;
   %dcl RVIS_INVISIBLE char;
   %RVIS_INVISIBLE=1;
   %dcl RVIS_PARTIAL char;
   %RVIS_PARTIAL=2;
   %dcl RVIS_VISIBLE char;
   %RVIS_VISIBLE=3;
   %if INCL_DDIDEFS='Y' %then %do;
     dcl GpiSetAttrMode entry (
            HPS,
            LONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiQueryAttrMode entry (
            HPS)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiSetAttrs entry (
            HPS,
            LONG,
            ULONG,
            ULONG,
            PBUNDLE)
            returns(optional byvalue BOOL)
            APIENTRY;
     %if INCL_SAADEFS='Y' %then %do;
       dcl GpiQueryAttrs entry (
              HPS,
              LONG,
              ULONG,
              PBUNDLE)
              returns(optional byvalue LONG)
              APIENTRY;
     %end;
     dcl GpiSetBackColor entry (
            HPS,
            LONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiQueryBackColor entry (
            HPS)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiSetMix entry (
            HPS,
            LONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiQueryMix entry (
            HPS)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiSetBackMix entry (
            HPS,
            LONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiQueryBackMix entry (
            HPS)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiSetLineType entry (
            HPS,
            LONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiQueryLineType entry (
            HPS)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiSetLineWidth entry (
            HPS,
            FIXED bin(31,16))
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiQueryLineWidth entry (
            HPS)
            returns(optional byvalue FIXED bin(31,16))
            APIENTRY;
     dcl GpiSetLineWidthGeom entry (
            HPS,
            LONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiQueryLineWidthGeom entry (
            HPS)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiSetLineEnd entry (
            HPS,
            LONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiQueryLineEnd entry (
            HPS)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiSetLineJoin entry (
            HPS,
            LONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiQueryLineJoin entry (
            HPS)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiSetCurrentPosition entry (
            HPS,
            PPOINTL)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiQueryCurrentPosition entry (
            HPS,
            PPOINTL)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiSetArcParams entry (
            HPS,
            PARCPARAMS)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiQueryArcParams entry (
            HPS,
            PARCPARAMS)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiPointArc entry (
            HPS,
            PPOINTL)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiFullArc entry (
            HPS,
            LONG,
            FIXED bin(31,16))
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiPartialArc entry (
            HPS,
            PPOINTL,
            FIXED bin(31,16),
            FIXED bin(31,16),
            FIXED bin(31,16))
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiPolyFillet entry (
            HPS,
            LONG,
            PPOINTL)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiPolySpline entry (
            HPS,
            LONG,
            PPOINTL)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiPolyFilletSharp entry (
            HPS,
            LONG,
            PPOINTL,
            PFIXED)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiSetPatternSet entry (
            HPS,
            LONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiQueryPatternSet entry (
            HPS)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiSetPatternRefPoint entry (
            HPS,
            PPOINTL)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiQueryPatternRefPoint entry (
            HPS,
            PPOINTL)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiQueryCharStringPos entry (
            HPS,
            ULONG,
            LONG,
            PCH,
            PLONG,
            PPOINTL)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiQueryCharStringPosAt entry (
            HPS,
            PPOINTL,
            ULONG,
            LONG,
            PCH,
            PLONG,
            PPOINTL)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiQueryTextBox entry (
            HPS,
            LONG,
            PCH,
            LONG,
            PPOINTL)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiQueryDefCharBox entry (
            HPS,
            PSIZEL)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiSetCharSet entry (
            HPS,
            LONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiQueryCharSet entry (
            HPS)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiSetCharBox entry (
            HPS,
            PSIZEF)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiQueryCharBox entry (
            HPS,
            PSIZEF)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiSetCharAngle entry (
            HPS,
            PGRADIENTL)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiQueryCharAngle entry (
            HPS,
            PGRADIENTL)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiSetCharShear entry (
            HPS,
            PPOINTL)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiQueryCharShear entry (
            HPS,
            PPOINTL)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiSetCharDirection entry (
            HPS,
            LONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiQueryCharDirection entry (
            HPS)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiSetCharMode entry (
            HPS,
            LONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiQueryCharMode entry (
            HPS)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiSetTextAlignment entry (
            HPS,
            LONG,
            LONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiQueryTextAlignment entry (
            HPS,
            PLONG,
            PLONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiCharStringPos entry (
            HPS,
            PRECTL,
            ULONG,
            LONG,
            PCH,
            PLONG)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiCharStringPosAt entry (
            HPS,
            PPOINTL,
            PRECTL,
            ULONG,
            LONG,
            PCH,
            PLONG)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiSetCharExtra entry (
            HPS,
            FIXED bin(31,16))
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiSetCharBreakExtra entry (
            HPS,
            FIXED bin(31,16))
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiQueryCharExtra entry (
            HPS,
            PFIXED)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiQueryCharBreakExtra entry (
            HPS,
            PFIXED)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiMarker entry (
            HPS,
            PPOINTL)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiPolyMarker entry (
            HPS,
            LONG,
            PPOINTL)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiSetMarker entry (
            HPS,
            LONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiSetMarkerBox entry (
            HPS,
            PSIZEF)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiSetMarkerSet entry (
            HPS,
            LONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiQueryMarker entry (
            HPS)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiQueryMarkerBox entry (
            HPS,
            PSIZEF)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiQueryMarkerSet entry (
            HPS)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiImage entry (
            HPS,
            LONG,
            PSIZEL,
            LONG,
            PBYTE)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiPop entry (
            HPS,
            LONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiPtVisible entry (
            HPS,
            PPOINTL)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiRectVisible entry (
            HPS,
            PRECTL)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiComment entry (
            HPS,
            LONG,
            PBYTE)
            returns(optional byvalue BOOL)
            APIENTRY;
   %end;
 %end;
 %if INCL_GPILCIDS='Y' %then %do;
   %dcl FONT_DEFAULT char;
   %FONT_DEFAULT=1;
   %dcl FONT_MATCH char;
   %FONT_MATCH=2;
   %dcl LCIDT_FONT char;
   %LCIDT_FONT=6;
   %dcl LCIDT_BITMAP char;
   %LCIDT_BITMAP=7;
   %dcl LCID_ALL char;
   %LCID_ALL=-1;
   %dcl KERNINGPAIRS char;
   %KERNINGPAIRS='char(stg(#KERNINGPAIRS))';
   dcl 1 #KERNINGPAIRS based(null()) unaligned,
         2 sFirstChar SHORT,
         2 sSecondChar SHORT,
         2 lKerningAmount LONG;
   %dcl PKERNINGPAIRS char;
   %PKERNINGPAIRS='pointer';
   %dcl FACENAMEDESC char;
   %FACENAMEDESC='char(stg(#FACENAMEDESC))';
   dcl 1 #FACENAMEDESC based(null()) unaligned,
         2 usSize USHORT,
         2 usWeightClass USHORT,
         2 usWidthClass USHORT,
         2 usReserved USHORT,
         2 flOptions ULONG;
   %dcl PFACENAMEDESC char;
   %PFACENAMEDESC='pointer';
   %dcl FWEIGHT_DONT_CARE char;
   %FWEIGHT_DONT_CARE=0;
   %dcl FWEIGHT_ULTRA_LIGHT char;
   %FWEIGHT_ULTRA_LIGHT=1;
   %dcl FWEIGHT_EXTRA_LIGHT char;
   %FWEIGHT_EXTRA_LIGHT=2;
   %dcl FWEIGHT_LIGHT char;
   %FWEIGHT_LIGHT=3;
   %dcl FWEIGHT_SEMI_LIGHT char;
   %FWEIGHT_SEMI_LIGHT=4;
   %dcl FWEIGHT_NORMAL char;
   %FWEIGHT_NORMAL=5;
   %dcl FWEIGHT_SEMI_BOLD char;
   %FWEIGHT_SEMI_BOLD=6;
   %dcl FWEIGHT_BOLD char;
   %FWEIGHT_BOLD=7;
   %dcl FWEIGHT_EXTRA_BOLD char;
   %FWEIGHT_EXTRA_BOLD=8;
   %dcl FWEIGHT_ULTRA_BOLD char;
   %FWEIGHT_ULTRA_BOLD=9;
   %dcl FWIDTH_DONT_CARE char;
   %FWIDTH_DONT_CARE=0;
   %dcl FWIDTH_ULTRA_CONDENSED char;
   %FWIDTH_ULTRA_CONDENSED=1;
   %dcl FWIDTH_EXTRA_CONDENSED char;
   %FWIDTH_EXTRA_CONDENSED=2;
   %dcl FWIDTH_CONDENSED char;
   %FWIDTH_CONDENSED=3;
   %dcl FWIDTH_SEMI_CONDENSED char;
   %FWIDTH_SEMI_CONDENSED=4;
   %dcl FWIDTH_NORMAL char;
   %FWIDTH_NORMAL=5;
   %dcl FWIDTH_SEMI_EXPANDED char;
   %FWIDTH_SEMI_EXPANDED=6;
   %dcl FWIDTH_EXPANDED char;
   %FWIDTH_EXPANDED=7;
   %dcl FWIDTH_EXTRA_EXPANDED char;
   %FWIDTH_EXTRA_EXPANDED=8;
   %dcl FWIDTH_ULTRA_EXPANDED char;
   %FWIDTH_ULTRA_EXPANDED=9;

   dcl FTYPE_ITALIC fixed bin(16) value('00_01'xn);
   dcl FTYPE_ITALIC_DONT_CARE fixed bin(16) value('00_02'xn);
   dcl FTYPE_OBLIQUE fixed bin(16) value('00_04'xn);
   dcl FTYPE_OBLIQUE_DONT_CARE fixed bin(16) value('00_08'xn);
   dcl FTYPE_ROUNDED fixed bin(16) value('00_10'xn);
   dcl FTYPE_ROUNDED_DONT_CARE fixed bin(16) value('00_20'xn);

   %dcl QFA_PUBLIC char;
   %QFA_PUBLIC=1;
   %dcl QFA_PRIVATE char;
   %QFA_PRIVATE=2;
   %dcl QFA_ERROR char;
   %QFA_ERROR=GPI_ALTERROR;

   dcl QF_PUBLIC fixed bin(31) value('00_00_00_01'xn);
   dcl QF_PRIVATE fixed bin(31) value('00_00_00_02'xn);
   dcl QF_NO_GENERIC fixed bin(31) value('00_00_00_04'xn);
   dcl QF_NO_DEVICE fixed bin(31) value('00_00_00_08'xn);

   %if INCL_SAADEFS='Y' %then %do;
     %dcl FFDESCS char;
     %FFDESCS='char(2*FACESIZE)';
     %dcl PFFDESCS char;
     %PFFDESCS='pointer';
     %dcl FFDESCS2 char;
     %FFDESCS2='char(stg(#FFDESCS2))';
     dcl 1 #FFDESCS2 based(null()) unaligned,
           2 cbLength ULONG,
           2 cbFacenameOffset ULONG,
           2 abFamilyName(1) BYTE;
     %dcl PFFDESCS2 char;
     %PFFDESCS2='pointer';
   %end;
   %if INCL_DDIDEFS='Y' %then %do;
     dcl GpiCreateLogFont entry (
            HPS,
            PSTR8,
            LONG,
            PFATTRS)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiDeleteSetId entry (
            HPS,
            LONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiLoadFonts entry (
            HAB,
            PSZ)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiUnloadFonts entry (
            HAB,
            PSZ)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiQueryFonts entry (
            HPS,
            ULONG,
            PSZ,
            PLONG,
            LONG,
            PFONTMETRICS)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiQueryFontMetrics entry (
            HPS,
            LONG,
            PFONTMETRICS)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiQueryKerningPairs entry (
            HPS,
            LONG,
            PKERNINGPAIRS)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiQueryWidthTable entry (
            HPS,
            LONG,
            LONG,
            PLONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiQueryNumberSetIds entry (
            HPS)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiQuerySetIds entry (
            HPS,
            LONG,
            PLONG,
            PSTR8,
            PLONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiQueryFaceString entry (
            HPS,
            PSZ,
            PFACENAMEDESC,
            LONG,
            PSZ)
            returns(optional byvalue ULONG)
            APIENTRY;
     dcl GpiQueryLogicalFont entry (
            HPS,
            LONG,
            PSTR8,
            PFATTRS,
            LONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiQueryFontAction entry (
            HAB,
            ULONG)
            returns(optional byvalue ULONG)
            APIENTRY;
     dcl GpiLoadPublicFonts entry (
            HAB,,
            PSZ)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiUnloadPublicFonts entry (
            HAB,,
            PSZ)
            returns(optional byvalue BOOL)
            APIENTRY;
     %if INCL_SAADEFS='Y' %then %do;
       dcl GpiSetCp entry (
              HPS,
              ULONG)
              returns(optional byvalue BOOL)
              APIENTRY;
       dcl GpiQueryCp entry (
              HPS)
              returns(optional byvalue ULONG)
              APIENTRY;
       dcl GpiQueryFullFontFileDescs entry (
              HAB,
              PSZ,
              PLONG,
              PVOID,
              PLONG)
              returns(optional byvalue LONG)
              APIENTRY;
       dcl GpiQueryFontFileDescriptions entry (
              HAB,
              PSZ,
              PLONG,
              PFFDESCS)
              returns(optional byvalue LONG)
              APIENTRY;
     %end;
   %end;
 %end;
 %if INCL_GPIBITMAPS='Y' | INCL_NOCOMMON='Y' %then %do;
   dcl ROP_SRCCOPY fixed bin(31) value('00_00_00_CC'xn);
   dcl ROP_SRCPAINT fixed bin(31) value('00_00_00_EE'xn);
   dcl ROP_SRCAND fixed bin(31) value('00_00_00_88'xn);
   dcl ROP_SRCINVERT fixed bin(31) value('00_00_00_66'xn);
   dcl ROP_SRCERASE fixed bin(31) value('00_00_00_44'xn);
   dcl ROP_NOTSRCCOPY fixed bin(31) value('00_00_00_33'xn);
   dcl ROP_NOTSRCERASE fixed bin(31) value('00_00_00_11'xn);
   dcl ROP_MERGECOPY fixed bin(31) value('00_00_00_C0'xn);
   dcl ROP_MERGEPAINT fixed bin(31) value('00_00_00_BB'xn);
   dcl ROP_PATCOPY fixed bin(31) value('00_00_00_F0'xn);
   dcl ROP_PATPAINT fixed bin(31) value('00_00_00_FB'xn);
   dcl ROP_PATINVERT fixed bin(31) value('00_00_00_5A'xn);
   dcl ROP_DSTINVERT fixed bin(31) value('00_00_00_55'xn);
   dcl ROP_ZERO fixed bin(31) value('00_00_00_00'xn);
   dcl ROP_ONE fixed bin(31) value('00_00_00_FF'xn);

   %dcl BBO_OR char;
   %BBO_OR=0;
   %dcl BBO_AND char;
   %BBO_AND=1;
   %dcl BBO_IGNORE char;
   %BBO_IGNORE=2;
   %dcl BBO_PAL_COLORS char;
   %BBO_PAL_COLORS=4;
   %dcl BBO_NO_COLOR_INFO char;
   %BBO_NO_COLOR_INFO=8;
   %dcl FF_BOUNDARY char;
   %FF_BOUNDARY=0;
   %dcl FF_SURFACE char;
   %FF_SURFACE=1;
   %dcl HBM_ERROR char;
   %HBM_ERROR=HBITMAP;
   %if INCL_DDIDEFS='Y' %then %do;
     dcl GpiBitBlt entry (
            HPS,
            HPS,
            LONG,
            PPOINTL,
            LONG,
            ULONG)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiDeleteBitmap entry (
            HBITMAP)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiLoadBitmap entry (
            HPS,
            HMODULE,
            ULONG,
            LONG,
            LONG)
            returns(optional byvalue HBITMAP)
            APIENTRY;
     dcl GpiSetBitmap entry (
            HPS,
            HBITMAP)
            returns(optional byvalue HBITMAP)
            APIENTRY;
     dcl GpiWCBitBlt entry (
            HPS,
            HBITMAP,
            LONG,
            PPOINTL,
            LONG,
            ULONG)
            returns(optional byvalue LONG)
            APIENTRY;
   %end;
 %end;
 %if INCL_GPIBITMAPS='Y' %then %do;
   %include pmbitmap;

   dcl CBM_INIT fixed bin(31) value('00_00_00_04'xn);

   %dcl BMB_ERROR char;
   %BMB_ERROR=-1;
   %if INCL_DDIDEFS='Y' %then %do;
     dcl GpiCreateBitmap entry (
            HPS,
            PBITMAPINFOHEADER2,
            ULONG,
            PBYTE,
            PBITMAPINFO2)
            returns(optional byvalue HBITMAP)
            APIENTRY;
     dcl GpiSetBitmapBits entry (
            HPS,
            LONG,
            LONG,
            PBYTE,
            PBITMAPINFO2)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiSetBitmapDimension entry (
            HBITMAP,
            PSIZEL)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiSetBitmapId entry (
            HPS,
            HBITMAP,
            LONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiQueryBitmapBits entry (
            HPS,
            LONG,
            LONG,
            PBYTE,
            PBITMAPINFO2)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiQueryBitmapDimension entry (
            HBITMAP,
            PSIZEL)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiQueryBitmapHandle entry (
            HPS,
            LONG)
            returns(optional byvalue HBITMAP)
            APIENTRY;
     dcl GpiQueryBitmapParameters entry (
            HBITMAP,
            PBITMAPINFOHEADER)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiQueryBitmapInfoHeader entry (
            HBITMAP,
            PBITMAPINFOHEADER2)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiQueryDeviceBitmapFormats entry (
            HPS,
            LONG,
            PLONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiSetPel entry (
            HPS,
            PPOINTL)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiQueryPel entry (
            HPS,
            PPOINTL)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiFloodFill entry (
            HPS,
            LONG,
            LONG)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiDrawBits entry (
            HPS,
            PVOID,
            PBITMAPINFO2,
            LONG,
            PPOINTL,
            LONG,
            ULONG)
            returns(optional byvalue LONG)
            APIENTRY;
   %end;
 %end;
 %if INCL_GPIREGIONS='Y' %then %do;
   %dcl CRGN_OR char;
   %CRGN_OR=1;
   %dcl CRGN_COPY char;
   %CRGN_COPY=2;
   %dcl CRGN_XOR char;
   %CRGN_XOR=4;
   %dcl CRGN_AND char;
   %CRGN_AND=6;
   %dcl CRGN_DIFF char;
   %CRGN_DIFF=7;
   %dcl RECTDIR_LFRT_TOPBOT char;
   %RECTDIR_LFRT_TOPBOT=1;
   %dcl RECTDIR_RTLF_TOPBOT char;
   %RECTDIR_RTLF_TOPBOT=2;
   %dcl RECTDIR_LFRT_BOTTOP char;
   %RECTDIR_LFRT_BOTTOP=3;
   %dcl RECTDIR_RTLF_BOTTOP char;
   %RECTDIR_RTLF_BOTTOP=4;
   %dcl RGNRECT char;
   %RGNRECT='char(stg(#RGNRECT))';
   dcl 1 #RGNRECT based(null()) unaligned,
         2 ircStart ULONG,
         2 crc ULONG,
         2 crcReturned ULONG,
         2 ulDirection ULONG;
   %dcl PRGNRECT char;
   %PRGNRECT='pointer';
   %dcl RGN_ERROR char;
   %RGN_ERROR=0;
   %dcl RGN_NULL char;
   %RGN_NULL=1;
   %dcl RGN_RECT char;
   %RGN_RECT=2;
   %dcl RGN_COMPLEX char;
   %RGN_COMPLEX=3;
   %dcl PRGN_ERROR char;
   %PRGN_ERROR=0;
   %dcl PRGN_OUTSIDE char;
   %PRGN_OUTSIDE=1;
   %dcl PRGN_INSIDE char;
   %PRGN_INSIDE=2;
   %dcl RRGN_ERROR char;
   %RRGN_ERROR=0;
   %dcl RRGN_OUTSIDE char;
   %RRGN_OUTSIDE=1;
   %dcl RRGN_PARTIAL char;
   %RRGN_PARTIAL=2;
   %dcl RRGN_INSIDE char;
   %RRGN_INSIDE=3;
   %dcl EQRGN_ERROR char;
   %EQRGN_ERROR=0;
   %dcl EQRGN_NOTEQUAL char;
   %EQRGN_NOTEQUAL=1;
   %dcl EQRGN_EQUAL char;
   %EQRGN_EQUAL=2;
   %dcl HRGN_ERROR char;
   %HRGN_ERROR='ptrvalue(-1)';
   %if INCL_DDIDEFS='Y' %then %do;
     dcl GpiCombineRegion entry (
            HPS,
            HRGN,
            HRGN,
            HRGN,
            LONG)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiCreateRegion entry (
            HPS,
            LONG,
            PRECTL)
            returns(optional byvalue HRGN)
            APIENTRY;
     dcl GpiDestroyRegion entry (
            HPS,
            HRGN)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiEqualRegion entry (
            HPS,
            HRGN,
            HRGN)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiOffsetRegion entry (
            HPS,
            HRGN,
            PPOINTL)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiPaintRegion entry (
            HPS,
            HRGN)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiFrameRegion entry (
            HPS,
            HRGN,
            PSIZEL)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiPtInRegion entry (
            HPS,
            HRGN,
            PPOINTL)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiQueryRegionBox entry (
            HPS,
            HRGN,
            PRECTL)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiQueryRegionRects entry (
            HPS,
            HRGN,
            PRECTL,
            PRGNRECT,
            PRECTL)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiRectInRegion entry (
            HPS,
            HRGN,
            PRECTL)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiSetRegion entry (
            HPS,
            HRGN,
            LONG,
            PRECTL)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiSetClipRegion entry (
            HPS,
            HRGN,
            PHRGN)
            returns(optional byvalue LONG)
            APIENTRY;
     %if INCL_SAADEFS='Y' %then %do;
       dcl GpiQueryClipRegion entry (
              HPS)
              returns(optional byvalue HRGN)
              APIENTRY;
       dcl GpiQueryClipBox entry (
              HPS,
              PRECTL)
              returns(optional byvalue LONG)
              APIENTRY;
     %end;
     dcl GpiExcludeClipRectangle entry (
            HPS,
            PRECTL)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiIntersectClipRectangle entry (
            HPS,
            PRECTL)
            returns(optional byvalue LONG)
            APIENTRY;
     %if INCL_SAADEFS='Y' %then %do;
       dcl GpiOffsetClipRegion entry (
              HPS,
              PPOINTL)
              returns(optional byvalue LONG)
              APIENTRY;
     %end;
   %end;
 %end;
 %if INCL_GPIMETAFILES='Y' %then %do;
   %if INCL_DDIDEFS='Y' %then %do;
     %dcl PMF_SEGBASE char;
     %PMF_SEGBASE=0;
     %dcl PMF_LOADTYPE char;
     %PMF_LOADTYPE=1;
     %dcl PMF_RESOLVE char;
     %PMF_RESOLVE=2;
     %dcl PMF_LCIDS char;
     %PMF_LCIDS=3;
     %dcl PMF_RESET char;
     %PMF_RESET=4;
     %dcl PMF_SUPPRESS char;
     %PMF_SUPPRESS=5;
     %dcl PMF_COLORTABLES char;
     %PMF_COLORTABLES=6;
     %dcl PMF_COLORREALIZABLE char;
     %PMF_COLORREALIZABLE=7;
     %dcl PMF_DEFAULTS char;
     %PMF_DEFAULTS=8;
     %dcl PMF_DELETEOBJECTS char;
     %PMF_DELETEOBJECTS=9;
     %dcl RS_DEFAULT char;
     %RS_DEFAULT=0;
     %dcl RS_NODISCARD char;
     %RS_NODISCARD=1;
     %dcl LC_DEFAULT char;
     %LC_DEFAULT=0;
     %dcl LC_NOLOAD char;
     %LC_NOLOAD=1;
     %dcl LC_LOADDISC char;
     %LC_LOADDISC=3;
     %dcl LT_DEFAULT char;
     %LT_DEFAULT=0;
     %dcl LT_NOMODIFY char;
     %LT_NOMODIFY=1;
     %dcl LT_ORIGINALVIEW char;
     %LT_ORIGINALVIEW=4;
     %dcl RES_DEFAULT char;
     %RES_DEFAULT=0;
     %dcl RES_NORESET char;
     %RES_NORESET=1;
     %dcl RES_RESET char;
     %RES_RESET=2;
     %dcl SUP_DEFAULT char;
     %SUP_DEFAULT=0;
     %dcl SUP_NOSUPPRESS char;
     %SUP_NOSUPPRESS=1;
     %dcl SUP_SUPPRESS char;
     %SUP_SUPPRESS=2;
     %dcl CTAB_DEFAULT char;
     %CTAB_DEFAULT=0;
     %dcl CTAB_NOMODIFY char;
     %CTAB_NOMODIFY=1;
     %dcl CTAB_REPLACE char;
     %CTAB_REPLACE=3;
     %dcl CTAB_REPLACEPALETTE char;
     %CTAB_REPLACEPALETTE=4;
     %dcl CREA_DEFAULT char;
     %CREA_DEFAULT=0;
     %dcl CREA_REALIZE char;
     %CREA_REALIZE=1;
     %dcl CREA_NOREALIZE char;
     %CREA_NOREALIZE=2;
     %dcl CREA_DOREALIZE char;
     %CREA_DOREALIZE=3;
     %if INCL_SAADEFS='Y' %then %do;
       %dcl DDEF_DEFAULT char;
       %DDEF_DEFAULT=0;
       %dcl DDEF_IGNORE char;
       %DDEF_IGNORE=1;
       %dcl DDEF_LOADDISC char;
       %DDEF_LOADDISC=3;
       %dcl DOBJ_DEFAULT char;
       %DOBJ_DEFAULT=0;
       %dcl DOBJ_NODELETE char;
       %DOBJ_NODELETE=1;
       %dcl DOBJ_DELETE char;
       %DOBJ_DELETE=2;
       %dcl RSP_DEFAULT char;
       %RSP_DEFAULT=0;
       %dcl RSP_NODISCARD char;
       %RSP_NODISCARD=1;
     %end;
     dcl GpiCopyMetaFile entry (
            HMF)
            returns(optional byvalue HMF)
            APIENTRY;
     dcl GpiDeleteMetaFile entry (
            HMF)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiLoadMetaFile entry (
            HAB,
            PSZ)
            returns(optional byvalue HMF)
            APIENTRY;
     dcl GpiPlayMetaFile entry (
            HPS,
            HMF,
            LONG,
            PLONG,
            PLONG,
            LONG,
            PSZ)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiQueryMetaFileBits entry (
            HMF,
            LONG,
            LONG,
            PBYTE)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl GpiQueryMetaFileLength entry (
            HMF)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl GpiSaveMetaFile entry (
            HMF,
            PSZ)
            returns(optional byvalue BOOL)
            APIENTRY;
     %if INCL_SAADEFS='Y' %then %do;
       dcl GpiSetMetaFileBits entry (
              HMF,
              LONG,
              LONG,
              PBYTE)
              returns(optional byvalue BOOL)
              APIENTRY;
     %end;
   %end;
 %end;
 %if INCL_GPIDEFAULTS='Y' %then %do;
   dcl GpiQueryDefArcParams entry (
          HPS,
          PARCPARAMS)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl GpiQueryDefAttrs entry (
          HPS,
          LONG,
          ULONG,
          PBUNDLE)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl GpiQueryDefTag entry (
          HPS,
          PLONG)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl GpiQueryDefViewingLimits entry (
          HPS,
          PRECTL)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl GpiSetDefArcParams entry (
          HPS,
          PARCPARAMS)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl GpiSetDefAttrs entry (
          HPS,
          LONG,
          ULONG,
          PBUNDLE)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl GpiSetDefTag entry (
          HPS,
          LONG)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl GpiSetDefViewingLimits entry (
          HPS,
          PRECTL)
          returns(optional byvalue BOOL)
          APIENTRY;
 %end;
 %if INCL_GPIPOLYGON='Y' %then %do;
   %dcl POLYGON char;
   %POLYGON='char(stg(#POLYGON))';
   dcl 1 #POLYGON based(null()) unaligned,
         2 ulPoints ULONG,
         2 aPointl PPOINTL;
   %dcl PPOLYGON char;
   %PPOLYGON='pointer';
   %dcl POLYSET char;
   %POLYSET='char(stg(#POLYSET))';
   dcl 1 #POLYSET based(null()) unaligned,
         2 ulPolys ULONG,
         2 aPolygon(1) POLYGON;
   %dcl PPOLYSET char;
   %PPOLYSET='pointer';

   %dcl POLYGON_NOBOUNDARY char;
   %POLYGON_NOBOUNDARY=0;
   dcl POLYGON_BOUNDARY fixed bin(31) value('00_00_00_01'xn);
   %dcl POLYGON_ALTERNATE char;
   %POLYGON_ALTERNATE=0;
   dcl POLYGON_WINDING fixed bin(31) value('00_00_00_02'xn);
   %dcl POLYGON_INCL char;
   %POLYGON_INCL=0;
   dcl POLYGON_EXCL fixed bin(31) value('00_00_00_08'xn);

   %if INCL_DDIDEFS='Y' %then %do;
     dcl GpiPolygons entry (
            HPS,
            ULONG,
            PPOLYGON,
            ULONG,
            ULONG)
            returns(optional byvalue LONG)
            APIENTRY;
   %end;
 %end;
 %if INCL_GPIERRORS='Y' %then %do;
   %include pmerr;
 %end;
 %if IBMC__='Y' %then %do;
   %if CHKHDR__='Y' %then %do;
   %end;
 %end;
