/******************************************************************/
/*                                                                */
/*    Licensed Materials - Property of IBM                        */
/*    5639-A83, 5639-A24 (C) Copyright IBM Corp. 1992,1996.       */
/*    All Rights Reserved.                                        */
/*    US Government Users Restricted Rights-- Use, duplication or */
/*    disclosure restricted by GSA ADP Schedule Contract with     */
/*    IBM Corp.                                                   */
/*                                                                */
/*  DISCLAIMER OF WARRANTIES                                      */
/*    The following enclosed code is sample code created by IBM */
/*    Corporation. This sample code is not part of any standard   */
/*    IBM product and is provided to you solely for the purpose of*/
/*    assisting you in the development of your applications.  The */
/*    code is provided "AS IS", without warranty of any kind.     */
/*    IBM shall not be liable for any damages arising out of your */
/*    use of the sample code, even if IBM has been advised of the */
/*    possibility of such damages.                                */
/*                                                                */
/*                                                                */
/* This is the VisualAge C++ program used to call PL/I procedure  */
/* which has been compiled as object and packaged into a DLL.     */
/* The C program will first load the PL/I DLL, query its first    */
/* entry point, then call it along with any necessary arguements. */
/* It will also use printf function to print out message to       */
/* show the progress of each major step during execution.         */
/* At the end, the PL/I DLL will be freed explicitly to ensure    */
/* proper program termination.                                    */
/*                                                                */
/* Syntax:                                                        */
/*    CS2PLI [arg1] [arg2]                                        */
/*           where arg1 is the name of the PL/I DLL               */
/*           where arg2 is anything to be passed to the PL/I DLL. */
/*                                                                */
/* If no argument is supplied, CS2PLI will assume the DLL of      */
/* "HIWORLD" and will call it.                                    */
/*                                                                */
/******************************************************************/

#define INCL_DOSMODULEMGR
#include <os2.h>
#include <stdio.h>
#include <ctype.h>
void main (int argc, char *argv[])
{
   /* argv is a ptr to an array of char ptrs.  argv[0] = EXE name.  */
   /* argv[1] = 1st cmd line arguement.  argc = 1 means no argument.*/

   HMODULE mh;
   char pn[]="HIWORLD";
   PFN pa;
   APIRET rc;
   char *pc, *upc;
   char objnamebuf[16];

   /******************************************************************/
   /* Pick up the first argument from the command line string if any.*/
   /* e.g. CS2PLI arg1 arg2 and arg1 is the first argument to CS2PLI.*/
   /******************************************************************/

   if (argc > 1)
     {
       upc = argv[1];
       while ( (*upc) != '\0')
         {
           (*upc) = toupper( (*upc) );
           upc ++;
         } /* endwhile */
       pc = argv[1];    /* Pick up the optional cmd line argument.*/
     }
   else
     pc = pn;           /* Default is to pick up "HIWORLD".       */

   fprintf(stderr, "The Beginning of CS2PLI.....\n");
   fprintf(stderr,"-- First call to load the PL/I DLL--\n");

   /******************************************************************/
   /* Dosloadmodule loads the PL/I DLL and returns the module        */
   /* handle to be used later.                                       */
   /******************************************************************/

   rc = DosLoadModule(objnamebuf, sizeof(objnamebuf),
                      pc,  &mh);
   if (rc != 0)
     fprintf(stderr,"\nDosLoadModule failed with rc = %d, name = %s.\n",
              rc,objnamebuf);
   else
     fprintf(stderr,"DosLoadModule's return code = %d.\n", rc);

   /******************************************************************/
   /* Dosqueryprocaddr finds the first entry point in the loaded     */
   /* PL/I DLL and returns its address.                              */
   /******************************************************************/

   rc = DosQueryProcAddr(mh, 0, pc, &pa);

   fprintf(stderr,"Dosqueryprocaddr's return code = %d.\n", rc);
   fprintf(stderr,
          "Dosqueryprocaddr's returned function address = %d.\n", pa);
   fprintf(stderr,"Dosqueryprocaddr's returned handle = %d.\n\n", mh);

   /******************************************************************/
   /* Pick up the second argument from the command line string if    */
   /* any.  e.g. CS2PLI arg1 arg2 and arg2 is the second argument    */
   /* to CS2PLI.                                                     */
   /* Then, call the PL/I procedure using the entry point address    */
   /* returned from Dosqueryprocaddr and pass argument to it if any. */
   /******************************************************************/

   if (argc > 2)
     {
       upc = argv[2];
       while ( (*upc) != '\0')
         {
           (*upc) = toupper( (*upc) );
           upc ++;
         } /* endwhile */
      fprintf(stderr,"The command line arg2 = %s.\n", argv[2]);
      (void (* APIENTRY)(char *))pa(argv[2]);
     }
   else
     pa();

   /******************************************************************/
   /* Call the same PL/I procedure again and pass the argument to    */
   /* it if any.                                                     */
   /******************************************************************/

   fprintf(stderr,"-- Second call to the routine already loaded --\n");
   if (argc > 2)
     (void (* APIENTRY)(char *))pa(argv[2]);
   else
     pa();

   fprintf(stderr,"After 2nd call and before DosFreeModule.\n");

   /******************************************************************/
   /* Free the PL/I DLL before terminating this C program.           */
   /******************************************************************/

   rc = DosFreeModule(mh);

   fprintf(stderr,"DosFreemodule's return code = %d.\n", rc);
   fprintf(stderr,"The End of CS2PLI............\n");
}
