//====START_GENERATED_PROLOG======================================
//
//
//   COMPONENT_NAME: odtools
//
//   CLASSES: none
//
//   ORIGINS: 27
//
//
//   (C) COPYRIGHT International Business Machines Corp. 1995,1996
//   All Rights Reserved
//   Licensed Materials - Property of IBM
//   US Government Users Restricted Rights - Use, duplication or
//   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
//   	
//   IBM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
//   ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
//   PURPOSE. IN NO EVENT SHALL IBM BE LIABLE FOR ANY SPECIAL, INDIRECT OR
//   CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
//   USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
//   OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
//   OR PERFORMANCE OF THIS SOFTWARE.
//
//====END_GENERATED_PROLOG========================================
//
// @(#) 1.3 %V% 9/16/96 16:24:28 [ 11/15/96 15:53:58 ]

/** catio.h National Language Support OS2 Include File
*.
*.      (C) COPYRIGHT International Business Machines Corp. 1995
*.      All Rights Reserved
*.      Licensed Materials - Property of IBM
*.
*.      US Government Users Restricted Rights - Use, duplication or
*.      disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
*.
**/

#ifndef __H_CATIO
#define __H_CATIO

  #define  FALSE      0
  #define  TRUE       1

#include <odnltyps.h>
#include <errno.h>
#include <stdio.h>

#define PATH_FORMAT  "\\i18n\\messages\\%L\\%N\\"

struct _message {
        unsigned short  _set,
                        _msg;
        char           *_text;
        unsigned        _old;
};

struct _header {
        int             _magic;
        unsigned short  _n_sets,
                        _setmax;
        char            _filler[20];
};

struct _msgptr {
        unsigned short  _msgno,
                        _msglen;
        unsigned long   _offset;
};


struct _catset {
        unsigned short  _setno,
                        _n_msgs;
        struct _msgptr  *_mp;
        char    **_msgtxt;
};

#define PATH_MAX        1023            /* max number of bytes in a pathname.
                                          (not string length; doesn't include
                                           a terminating null */

typedef struct _catalog_descriptor CATD;

#define  F_SETFD        2               /* Set file descriptor flags    */

/* definitions for set MS_GENCAT */
#define MS_GENCAT 2

#define M_MSG_0 1
#define M_MSG_1 2
#define M_MSG_2 3
#define M_MSG_3 4
#define M_MSG_5 5
#define M_MSG_7 6
#define M_MSG_8 7
#define M_MSG_9 8
#define M_MSG_10 9
#define M_MSG_11 10
#define M_MSG_12 11
#define M_MSG_13 12
#define M_MSG_14 13
#define M_MSG_15 14
#define M_MSG_18 15
#define M_MSG_19 16
#define M_NOMSG 17
#define M_ORDER 18

/* definitions for set MS_MKCATDEFS */
#define MS_MKCATDEFS 3

#define MKCATUSAGE 1
#define MNAMTOOLONG 2
#define MKCATOPN 3
#define INVTAG 4
#define INVLDSET 5
#define ZEROINV 6
#define MULTOPN 7
#define MULTNR 8
#define NOTASC 9
#define READERRS 10
#define WRITERRS 11
#define ERRFND 12
#define HCREAT 13
#define NOSYMB 14
#define NOHDR 15
#define IMBCHD 16
#define IMBCTX 17

extern  int     _cat_do_open(nl_catd);
extern  void    _cat_hard_close(nl_catd);
extern  FILE    *_cat_openfile(char *, int);

void fcntl(int,int,int);

char *_read_msg(nl_catd catd,int setno,int msgno);  /* WPOS */
char *_do_read_msg(nl_catd catd,int setno,int msgno);

nl_catd _do_open(nl_catd, int);

nl_catd NLcatopen(char *cat, int oflag);

#define ERR             (-1)

#define QTSTR           "$quote"
#define SETSTR          "$set"

#define MSGMIN          0
#define MSGMAX          65535
#define SETMIN          1
#define SETMAX          65535

#define RETURN(s)       return((errno = errno_save), s)

#define skip_to_white(s)        while (*s && *s > ' ') s++
#define skip_to_nwhite(s)       while (*s && (*s == ' ' || *s == '\t')) s++
#define die(s)                  puts(s), exit(1)

char *NLgetamsg(char *cat, int setno, int msgno, char* def);

#define R_OK    04              /* R_ACC readable by caller */

#endif
