/********************************************************************/
/**                       IBM LAN Server                           **/
/**               Copyright(c) Microsoft Corp., 1987-1990          **/
/**                Copyright (c) IBM Corporation, 1993             **/
/********************************************************************/
/**INTERNAL_ONLY**/
/*
 *  IBM CHANGE LOG:  (This file is based off the 90jul02 MS LM2.0 build.)
 *  mark = ptr/dcr yymondd ver    who <Description.>
 *  @p01 = AZ05893 91MAR27 r500   CAJ <MS netbios$ support>
 *  @p02 = az07286 91aug07 r500   gy  <LM20C changes - FIS #1342>
 *  @f03 = f2359   93oct30 ls.r40 MBB <32-bit APIs; all char to UCHAR
 *         D06991  94Apr09 ls.r40 MBB
 *   Declare all 32-bit functions as API32_FUNCTION
 *  @f06 = F  5438 94Aug08 ls.r40 MBB <Make .h files compatible with C++>
 */
/**END_INTERNAL**/

/********************************************************************
 *                                                                  *
 *  About this file ...  NETBIOS.H                                  *
 *                                                                  *
 *  This file contains information about the NetBios APIs.          *
 *                                                                  *
 *      Function prototypes.                                        *
 *                                                                  *
 *      Data structure templates.                                   *
 *                                                                  *
 *      Definition of special values.                               *
 *                                                                  *
 *                                                                  *
 *  NOTE:  You must include NETCONS.H before this file, since this  *
 *         file depends on values defined in NETCONS.H.             *
 *                                                                  *
 ********************************************************************/

/**INTERNAL_ONLY**/
/*
 *
 *    IMPORTANT!  IMPORTANT! IMPORTANT! IMPORTANT! IMPORTANT! IMPORTANT!
 *    READ THIS FIRST BEFORE MAKING ANY CHANGES
 *
 *    This file was modified to provide support for 32-bit code.
 *
 *    Any 32-bit module that includes this header file must define
 *    the constant INCL_32.
 *
 *    It is assumed that "netcons.h" is included before this file.
 *
 *    The following contants are defined in netcons.h as shown below:
 *
 *    #ifdef INCL_32    ( defined by 32-bit apps )
 *        #define LSFAR
 *        #define LSPAS
 *        #define LSPTR  _Seg16
 *        #define LSINT  short
 *    #else                 ( for 16-bit apps )
 *        #define LSFAR  far
 *        #define LSPAS  pascal
 *        #define LSPTR
 *        #define LSINT  int
 *    #endif
 *
 *    Do not add any keywords like far, pascal, etc. which are not recognized
 *    by the 32-bit compiler. The constants defined in netcons.h (LSFAR, LSPAS)
 *    must be used to replace these keywords.
 *
 */
/**END_INTERNAL**/

/**INTERNAL_ONLY**/
/********************************************************************
 *  NOTICE:  The redirector uses this include file.  If you change  *
 *           it, you need to make sure that the redir still builds. *
 ********************************************************************/
/**END_INTERNAL**/

/*NOINC*/
#ifndef NETBIOS_INCLUDED

#define NETBIOS_INCLUDED

#ifdef  ANY_32_BIT
#pragma pack(1)
#endif
/*INC*/


/****************************************************************
 *                                                              *
 *               Function prototypes - NetBios                  *
 *                                                              *
 ****************************************************************/

/*NOINC*/

extern API_FUNCTION
  NetBiosOpen ( unsigned char LSFAR *  pszDevName,
                unsigned char LSFAR *  pszReserved,
                unsigned short         usOpenOpt,
                unsigned short LSFAR * phDevName );

extern API_FUNCTION
  NetBiosClose ( unsigned short hDevName,
                 unsigned short usReserved );

extern API_FUNCTION
  NetBiosEnum ( const unsigned char LSFAR * pszServer,
                short                       sLevel,
                unsigned char LSFAR       * pbBuffer,
                unsigned short              cbBuffer,
                unsigned short LSFAR      * pcEntriesRead,
                unsigned short LSFAR      * pcTotalAvail );

extern API_FUNCTION
  NetBiosGetInfo ( const unsigned char LSFAR *  pszServer,
                   const unsigned char LSFAR *  pszNetBiosName,
                   short                        sLevel,
                   unsigned char LSFAR       *  pbBuffer,
                   unsigned short               cbBuffer,
                   unsigned short LSFAR       * pcbTotalAvail );

extern API_FUNCTION
  NetBiosSubmit ( unsigned short     hDevName,
                  unsigned short     usNcbOpt,
                  struct ncb LSFAR * pNCB );

/**INTERNAL_ONLY**/

extern API_FUNCTION
  I_NetBiosRegDialIn ( unsigned short );

/**END_INTERNAL**/

/*INC*/

/****************************************************************
 *                                                              *
 *              Data structure templates                        *
 *                                                              *
 ****************************************************************/


struct netbios_info_0 {
    unsigned char  nb0_net_name[NETBIOS_NAME_LEN+1];
};      /* netbios_info_0 */

struct netbios_info_1 {
    unsigned char  nb1_net_name[NETBIOS_NAME_LEN+1];
    unsigned char  nb1_driver_name[DEVLEN+1];/* OS/2 device driver name        */
    unsigned char  nb1_lana_num;             /* LAN adapter number of this net */
    unsigned char  nb1_pad_1;
/**INTERNAL_ONLY**/
/*NOINC*/
#if (((DEVLEN+1+NETBIOS_NAME_LEN+1+1)%2) == 0)
# error  "PAD BYTE NOT NEEDED"
#endif
/*INC*/
/**END_INTERNAL**/
    unsigned short nb1_driver_type;
    unsigned short nb1_net_status;
    unsigned long  nb1_net_bandwidth;     /* Network bandwidth, bits/second */
    unsigned short nb1_max_sess;          /* Max number of sessions         */
    unsigned short nb1_max_ncbs;          /* Max number of outstanding NCBs */
    unsigned short nb1_max_names;         /* Max number of names            */
};      /* netbios_info_1 */


/**INTERNAL_ONLY**/
#ifdef IBMTHUNK      /* Define PURE_32 temporarily */
#define PURE_32
#endif
/**END_INTERNAL**/

#ifdef PURE_32
/****************************************************************
 *                                                              *
 *               Function prototypes - NetBios                  *
 *                                                              *
 ****************************************************************/

extern API32_FUNCTION
NetBios32Open ( unsigned char  * pszDevName,
                unsigned char  * pszReserved,
                unsigned long    ulOpenOpt,       /* was USHORT*/
                unsigned long  * phDevName );     /* was PUSHORT*/

extern API32_FUNCTION
NetBios32Close ( unsigned long  hDevName,         /* was USHORT*/
                 unsigned long  ulReserved );     /* was USHORT*/

extern API32_FUNCTION
NetBios32Enum ( const unsigned char    * pszServer,
                unsigned long    ulLevel,          /* was signed short*/
                unsigned char  * pbBuffer,
                unsigned long    ulBuffer,         /* was USHORT*/
                unsigned long  * pulEntriesRead,   /* was PUSHORT*/
                unsigned long  * pulTotalAvail );  /* was PUSHORT*/

extern API32_FUNCTION
NetBios32GetInfo ( const unsigned char    * pszServer,
                   const unsigned char    * pszNetBiosName,
                   unsigned long    ulLevel,          /* was signed short*/
                   unsigned char  * pbBuffer,
                   unsigned long    ulBuffer,         /* was USHORT*/
                   unsigned long  * pulTotalAvail );  /* was PUSHORT*/

extern API32_FUNCTION
NetBios32Submit ( unsigned long    hDevName,          /* was USHORT*/
                  unsigned long    ulNcbOpt,          /* was USHORT*/
                  struct ncb     * pNCB );
#endif /* PURE_32 */

/**INTERNAL_ONLY**/
#ifdef IBMTHUNK      /* Undefine PURE_32; no data structures to pick up */
#undef PURE_32
#endif /* IBMTHUNK */
/**END_INTERNAL**/

/****************************************************************
 *                                                              *
 *              Special values and constants                    *
 *                                                              *
 ****************************************************************/

/**INTERNAL_ONLY**/
#define MAXNETBIOS      18              /* Should be same as redir's max @p02*/
/**END_INTERNAL**/

/*
 *      Driver types (nb1_driver_type).
 */

#define NB_TYPE_NCB     1
#define NB_TYPE_MCB     2

/*
 *      Bits defined in nb1_net_status.
 */

#define NB_LAN_FLAGS_MASK       0x3FFF  /* Mask for LAN Flags */
#define NB_LAN_MANAGED          0x0001  /* LAN is managed by redirector */
#define NB_LAN_LOOPBACK         0x0002  /* LAN is a loopback driver */
#define NB_LAN_SENDNOACK        0x0004  /* LAN allows SendNoAck NCBs */
#define NB_LAN_LMEXT            0x0008  /* LAN supports LAN Manager extended NCBs */
#define NB_LAN_INTNCB           0x0010  /* LAN allows NCB submission at */
                                        /* interrupt time (from NCBDone) */
#define NB_LAN_NORESET          0x0040  /*  @p01a  */

#define NB_OPEN_MODE_MASK       0xC000  /* Mask for NetBios Open Modes */
#define NB_OPEN_REGULAR         0x4000  /* NetBios opened in Regular mode */
#define NB_OPEN_PRIVILEGED      0x8000  /* NetBios opened in Privileged mode */
#define NB_OPEN_EXCLUSIVE       0xC000  /* NetBios opened in Exclusive mode */

/*
 *      Open modes for NetBiosOpen.
 */

#define NB_REGULAR      1
#define NB_PRIVILEGED   2
#define NB_EXCLUSIVE    3

/**INTERNAL_ONLY**/

/* BIOSOP_MDSHIFT shifts the open type up so that it can be stored */
/* in the nbi_nb1.nb1_net_status field */
#define BIOSOP_MDSHIFT 14

/* WARNING NetBiosOpen Modes must match values as below (see biosiocs.asm) */
/* .errnz       ((NB_REGULAR SHL BIOSOP_MDSHIFT) - NB_OPEN_REGULAR)        */
/* .errnz       ((NB_PRIVILEGED SHL BIOSOP_MDSHIFT) - NB_OPEN_PRIVILEGED)  */
/* .errnz       ((NB_EXCLUSIVE SHL BIOSOP_MDSHIFT) - NB_OPEN_EXCLUSIVE)    */

/**END_INTERNAL**/

/*NOINC*/
#ifdef ANY_32_BIT
#pragma pack()
#endif

#endif /* NETBIOS_INCLUDED */
/*INC*/
