import java.awt.*;
import java.awt.event.*;
import java.lang.*;
import java.util.*;
import java.text.*;


 /*******************************************************************/
 /*                                                                  */
 /*  NAME - javaVars.java                                            */
 /*                                                                  */
 /*  DESCRIPTION                                                     */
 /*    Sample Java and PL/I program.                                 */
 /*                                                                  */
 /*    These sample programs demonstrate two different ways that     */
 /*    Java and PL/I can exchange values of variables.               */
 /*    In the first way PL/I calls a 'getter' and 'setter' method    */
 /*    in the Java Object it wishes to update by using the JNI       */
 /*    function CallObjectMethod.                                    */
 /*    In the second way PL/I gets the Field ID of the Field it      */
 /*    wishes to update in the Java Object then calls the JNI        */
 /*    functions GetObjectField and SetObjectField to get and update */
 /*    the contents of the field.                                    */
 /*                                                                  */
 /*  DEPENDENCIES                                                    */
 /*    Calls pliVars.pli sample program.                             */
 /*    Requires JDK 1.1.7 or later be installed.                     */
 /*                                                                  */
 /********************************************************************/
 /*                                                                  */
 /*    Licensed Materials - Property of IBM                          */
 /*    5639-A83, 5639-A24 (C) Copyright IBM Corp. 1992,2000.         */
 /*    All Rights Reserved.                                          */
 /*    US Government Users Restricted Rights-- Use, duplication or   */
 /*    disclosure restricted by GSA ADP Schedule Contract with       */
 /*    IBM Corp.                                                     */
 /*                                                                  */
 /*  DISCLAIMER OF WARRANTIES                                        */
 /*    The following enclosed code is sample code created by IBM   */
 /*    Corporation. This sample code is not part of any standard     */
 /*    IBM product and is provided to you solely for the purpose of  */
 /*    assisting you in the development of your applications.  The   */
 /*    code is provided "AS IS", without warranty of any kind.       */
 /*    IBM shall not be liable for any damages arising out of your   */
 /*    use of the sample code, even if IBM has been advised of the   */
 /*    possibility of such damages.                                  */
 /*                                                                  */
 /********************************************************************/
/* Main class definition */

public class javaVars  extends java.applet.Applet
                       implements ActionListener
  {

    /* PL/I Native DLL load  */
    static {
                System.loadLibrary("pliVars");
        }

    /* PL/I Native Method declaration */
    public static native Void pliVar( VarObject vObj );

    private static Frame myFrame;
    private Label strlabel;
    private Label label1;
    private TextField field1;
    private Label label2;
    private TextField field2;
    private Label label3;
    private TextField field3;
    private Label label4;
    private TextField field4;
    private Integer   field4Int;

    private Button DoitButton;
    private Button QuitButton;


    public void init()
      {
       /* Creates a GridBagLayout for setting objects pos. on the panel */

       GridBagLayout gridbag = new GridBagLayout();
       GridBagConstraints c =  new GridBagConstraints();
       setLayout( gridbag );
       c.fill = GridBagConstraints.HORIZONTAL;
       c.insets = new Insets( 10,20,10,20 );
       c.weightx = 100;
       c.weighty = 100;

       /* Please choose a wine type */
       strlabel = new Label( "Please enter some values: " );
       c.gridx = 0;
       c.gridy = 0;
       c.gridwidth = 2;
       c.gridheight = 1;
       gridbag.setConstraints( strlabel,c );
       add(strlabel);

       /* Label 1  */
       label1 = new Label( "Field 1 (Char): " );
       c.gridx = 0;
       c.gridy = 1;
       c.gridwidth = 1;
       c.gridheight = 1;
       gridbag.setConstraints( label1,c );
       add(label1);

       /* Field 1  */
       field1 = new TextField( 2 );
       c.gridx = 1;
       c.gridy = 1;
       c.gridwidth = 1;
       c.gridheight = 1;
       field1.setColumns(2);
       gridbag.setConstraints( field1,c );
       add(field1);

       /* Label 2  */
       label2 = new Label( "Field 2 (Char): " );
       c.gridx = 0;
       c.gridy = 2;
       c.gridwidth = 1;
       c.gridheight = 1;
       gridbag.setConstraints( label2,c );
       add(label2);

       /* Field 2  */
       field2 = new TextField( "", 15 );
       c.gridx = 1;
       c.gridy = 2;
       c.gridwidth = 1;
       c.gridheight = 1;
       gridbag.setConstraints( field2,c );
       add(field2);
       field2.setColumns(15);

       /* Label 3  */
       label3 = new Label( "Field 3 (Char): " );
       c.gridx = 0;
       c.gridy = 3;
       c.gridwidth = 1;
       c.gridheight = 1;
       gridbag.setConstraints( label3,c );
       add(label3);

       /* Field 3  */
       field3 = new TextField( "", 5 );
       c.gridx = 1;
       c.gridy = 3;
       c.gridwidth = 1;
       c.gridheight = 1;
       gridbag.setConstraints( field3,c );
       add(field3);
       field3.setColumns(5);

       /* Label 4  */
       label4 = new Label( "Field 4 (Numeric): " );
       c.gridx = 0;
       c.gridy = 4;
       c.gridwidth = 1;
       c.gridheight = 1;
       gridbag.setConstraints( label4,c );
       add(label4);

       /* Field 4  */
       field4 = new TextField( "", 5 );
       c.gridx = 1;
       c.gridy = 4;
       c.gridwidth = 1;
       c.gridheight = 1;
       gridbag.setConstraints( field4,c );
       add(field4);



       /* Change Values */
       c.gridx = 0;
       c.gridy = 5;
       c.gridwidth = 1;
       c.gridheight = 1;
       DoitButton = new Button( "Make Changes" );
       gridbag.setConstraints( DoitButton,c );
       add( DoitButton );
       DoitButton.addActionListener( this );


       /* Quit button */
       c.gridx = 1;
       c.gridy = 5;
       c.gridwidth = 1;
       c.gridheight = 1;
       c.gridwidth=GridBagConstraints.REMAINDER;
       QuitButton = new Button( "Quit" );
       gridbag.setConstraints( QuitButton,c );
       add( QuitButton );
       QuitButton.addActionListener( this );


      }


  public void actionPerformed( ActionEvent evt )
    {
      if ( evt.getSource() == DoitButton ) {
          changeTheVars();
      }
      else if ( evt.getSource() == QuitButton ) {
          System.exit( 0 );
    }

    } /*end method*/



  public void changeTheVars()
    {

     /* Create and fill a new VarObject with field values */

     VarObject myVO = new VarObject();

     try {

     myVO.setField1( myVO, field1.getText() );

     myVO.setField2( myVO, field2.getText() );

     myVO.setField3( myVO, field3.getText() );

     field4Int = Integer.valueOf( field4.getText() );
     myVO.setField4( myVO, field4Int );

     /* Call the PL/I Native Method and pass reference to Object  */
     /* Upon return the variable values have been updated by PL/I */
     pliVar( myVO );

         } catch ( NumberFormatException e ) {
              EntryError myEE = new EntryError(myFrame,true,
                      "Please enter a Numeric for Field 4");
              field4.setText("");
              myEE.setBounds(50,50,500,100);
              myEE.show();
              System.out.println("Must be numeric!");
         }

     /* reset GUI with updated values */
     field1.setText( myVO.getField1(myVO) );
     field2.setText( myVO.getField2(myVO) );
     field3.setText( myVO.getField3(myVO) );

     try {

         field4Int = myVO.getField4( myVO );
         field4.setText( field4Int.toString() );

         } catch ( NullPointerException e ) {
         }


   } /*end method*/

   public static void main( String args[])
     {
      javaVars myApp = new javaVars();
      myFrame = new Frame( "Call PL/I to Update Variables" );

      // run the app
      myApp.init();
      myApp.start();

      //  add app to frame
      myFrame.add( "Center", myApp );

      //  resize and make it visible
      myFrame.setSize( 300, 300 );
      myFrame.show();
     }


} /*end class */



/* Java Class to hold variables */
class VarObject {

        String  voField1;
        String  voField2;
        String  voField3;
        Integer voField4;

        VarObject ( String inField1, String inField2, String inField3, Integer inField4 ) {

                voField1 = inField1;
                voField2 = inField2;
                voField3 = inField3;
                voField4 = inField4;
        }

        void setField1(VarObject myVO, String setField1) {
                myVO.voField1 = setField1 ;
        }

        void setField2(VarObject myVO, String setField2) {
                myVO.voField2 = setField2 ;
        }

        void setField3(VarObject myVO, String setField3) {
                myVO.voField3 = setField3 ;
        }

        void setField4(VarObject myVO, Integer setField4) {
                myVO.voField4 = setField4 ;
        }


        String getField1(VarObject myVO) {
                return(myVO.voField1);
        }

        String getField2(VarObject myVO) {
                return(myVO.voField2);
        }

        String getField3(VarObject myVO) {
                return(myVO.voField3);
        }

        Integer getField4(VarObject myVO) {
                return(myVO.voField4);
        }


        VarObject () {
        }


}  /* end class */



/* Java Class for entry error */
class EntryError  extends  java.awt.Dialog
                  implements ActionListener
 {

    Button okButton = new Button( "OK" );

   public EntryError(Frame parent, boolean modal, String errStr) {

    super(parent,true);
    setTitle( "Entry Error!" );
    Panel p1 = new Panel();
    p1.add(new Label(errStr));
    Panel p2 = new Panel();
    p2.add(okButton);
    okButton.addActionListener(this);

    add(p1,"North");
    add(p2,"South");

   }

  public void actionPerformed(ActionEvent evt){

    if (evt.getSource() == okButton) {
       dispose();
      }
  }


} /*end class */
