/**********************************************************************/
/*  DISCLAIMER                                                        */
/*                                                                    */
/*  THIS SAMPLE PROGRAM IS PROVIDED FOR TUTORIAL PURPOSES ONLY.  A    */
/*  COMPLETE HANDLING OF ERROR CONDITIONS HAS NOT BEEN SHOWN OR       */
/*  ATTEMPTED, AND THIS PROGRAM HAS NOT BEEN SUBMITTED TO FORMAL IBM  */
/*  TESTING.  THIS PROGRAM IS DISTRIBUTED ON AN 'AS IS' BASIS         */
/*  WITHOUT ANY WARRANTIES EITHER EXPRESSED OR IMPLIED.               */
/*                                                                    */
/**********************************************************************/
/**********************************************************************/
/*    This module contains sample SAA CPIC outbound transaction       */
/*    subroutines which illustrate the use of CPIC Callable Service   */
/**********************************************************************/

/**********************************************************************/
/*   Includes                                                         */
/**********************************************************************/
/* #define __ON_OS2__ */  /* uncomment this line if running on OS/2   */
#define __ON_MVS__   /* uncomment this line if running on MVS    */
#ifdef __ON_OS2__
#include <os2.h>
#include <acssvcc.h>
#include <cmc.h>
#endif
#ifdef __ON_MVS__
#include <atbcmc.h>
#endif
#include <doims.h>
#include <stdio.h>
#include <stdlib.h>
#include <stddef.h>
#include <string.h>

#define MAXSIZE        1024
#define MaxTPNameLength  64      /* Maximum length for TP name        */
#define FQLULEN          17      /* Fully qualified LU length         */
#define MODELEN           8      /* Mode name length                  */
#define CONVIDLEN         8      /* Conv ID length                    */
#define DESTLEN           8      /* Symbolic Destination name length  */
#define MSG_Length       60      /* Message length                    */

/**********************************************************************/
/*   Global Variables                                                 */
/**********************************************************************/

char destName[DESTLEN+1] = "SIDEINFO";      /* Dest name              */
char mode[MODELEN+1]     = "APPCSNA";       /* Mode name              */
char partLUName[FQLULEN+1] = "USIBMSL.IMSLU62";  /* partner LU name   */


/**********************************************************************/
/*   Funciton    : doIMS                                              */
/*   Description : This function converts data string between ASCII   */
/*                 and EBCDIC with OS/2 predefined character set.     */
/*                 It also prepares data for goims subroutine         */
/*   Input       : indata  - pointer of input data string             */
/*                 outdata - pointer of output data string            */
/*   Output      : int     - length of the output data                */
/**********************************************************************/
int
doIMS (char *indata, char *outdata)
{
  inIMSData *in;
  outIMSData *out;
  long rc,convert;
  long length, i;
  HRD1 *hr;


  in  = (inIMSData *)malloc(MAXSIZE);
  out = (outIMSData *)malloc(MAXSIZE);

  length = sizeof(HRD1);

  memcpy(&in->tran,indata,length+4);
  memmove (out->tran, in->tran, 4);
  memmove (out->data, in->data, length);
  out->rc = '0';

#ifdef __ON_OS2__
  Convert ("A","E","G",length,&out->data);
#endif

  convert = 0;
  rc = goims (out->tran,
              out->data,
              length,
              MAXSIZE - offsetof (outIMSData, data));
  if (rc < 0)
  {
    out->rc = '1';
    rc = strlen (out->data);
  }
  else {
    convert = 1;
  }

  if (convert) {
#ifdef __ON_OS2__
    Convert ("E","A","G",rc,&out->data);
#endif
  }
  memcpy(outdata, &out->data, rc);
  outdata[rc] = '\0';

  for (i=0;i<rc;i++)
  free(in);
  free(out);

  return (rc);
}




/**********************************************************************/


/**********************************************************************/
/*    Initialize Conversation                                         */
/*    This funciton issues the Initialize_Conversation call to        */
/*    initialize values for the conversation identifier and           */
/*    symbolic destination name of the partner LU and program.        */
/**********************************************************************/

int
Conv_Init(char *convId, char *destName, char *errMsg)
{
  long rc;
  char symDestName[8];

  memset (symDestName, ' ', sizeof (symDestName));
  strncpy (symDestName, destName, strlen (destName));
#ifdef __ON_OS2__
  cminit (convId,
#endif
#ifdef __ON_MVS__
  CMINIT (convId,
#endif
          symDestName,
          &rc);
  if (rc != 0)
    sprintf (errMsg, "CMINIT - rc = %d\n", rc);
  return (rc);
}


/**********************************************************************/
/*     Set Conversation Type                                          */
/*     This funciton issues a Set_Conversation_Type call to specify   */
/*     the type of conversation to be allocated with the partner      */
/*     TP, which is either basic or mapped.                           */
/**********************************************************************/

int
Set_Conv_Type(char * convId, long convType, char *errMsg)
{
  long rc;

#ifdef __ON_OS2__
  cmsct (convId,
#endif
#ifdef __ON_MVS__
  CMSCT (convId,
#endif
         &convType,
         &rc);
  if (rc != 0)
    sprintf (errMsg, "CMSCT - rc = %d\n", rc);
  return (rc);
}


/**********************************************************************/
/*    Set Mode Name                                                   */
/*    This funciton issues a Set_Mode_Name call to specify the mode   */
/*    name for the conversation.  The mode name indicates the         */
/*    characteristics of the session on which the conversation        */
/*    will take place.                                                */
/**********************************************************************/

int
Set_Mode_Name(char * convId, char *mode, char *errMsg)
{
  long rc;
  long length;

  length = strlen (mode);
#ifdef __ON_OS2__
  cmsmn (convId,
#endif
#ifdef __ON_MVS__
  CMSMN (convId,
#endif
         mode,
         &length,
         &rc);
  if (rc != 0)
    sprintf (errMsg, "CMSMN - rc = %d\n", rc);
  return (rc);
}


/**********************************************************************/
/*    Set Partner LU Name                                             */
/*    This funciton issues a Set_Partner_LU_Name call to specify the  */
/*    name of the remote LU on which the partner TP is running        */
/**********************************************************************/

int
Set_Part_LUName(char * convId, char *pLUName, char *errMsg)
{
  long rc;
  long length;

  length = strlen (pLUName);

#ifdef __ON_OS2__
  cmspln (convId,
#endif
#ifdef __ON_MVS__
  CMSPLN (convId,
#endif
          pLUName,
          &length,
          &rc);
  if (rc != 0)
    sprintf (errMsg, "CMSPLN - rc = %d\n", rc);
  return (rc);
}


/**********************************************************************/
/*    Set Return Control                                              */
/*    This funciton issues a Set_Return_Control call to specify       */
/*    one of the following:                                           */
/*                                                                    */
/*      - CM_WHEN_SESSION_ALLOCATED - This program receives           */
/*           control back after allocating a session for the          */
/*           conversation                                             */
/*      - CM_IMMEDIATE - The system allocates a session for the       */
/*           conversation if one is immediately available, and        */
/*           sends a return code to this program indicating           */
/*           whether or not the session was allocated                 */
/**********************************************************************/

int
Set_Ret_Cntl(char * convId, long retCtrl, char *errMsg)
{
  long rc;

#ifdef __ON_OS2__
  cmsrc (convId,
#endif
#ifdef __ON_MVS__
  CMSRC (convId,
#endif
         &retCtrl,
         &rc);
  if (rc != 0)
    sprintf (errMsg, "CMSRC - rc = %d\n", rc);
  return (rc);
}


/**********************************************************************/
/*    Set Sync Level                                                  */
/*    This funciton issues a Set_Sync_Level call to specify the       */
/*    synchronization level that the local and partner TPs will       */
/*    use on this conversation.                                       */
/**********************************************************************/

int
Set_Sync_Level(char * convId, long syncLev, char *errMsg)
{
  long rc;

#ifdef __ON_OS2__
  cmssl (convId,
#endif
#ifdef __ON_MVS__
  CMSSL (convId,
#endif
         &syncLev,
         &rc);
  if (rc != 0)
    sprintf (errMsg, "CMSSL - rc = %d\n", rc);
  return (rc);
}


/**********************************************************************/
/*    Set TP Name                                                     */
/*    This function issues a Set_TP_Name call to specify the name     */
/*    of the partner TP.                                              */
/**********************************************************************/

int
Set_TP_Name(char * convId, char *tpn, char *errMsg)
{
  long rc;
  long length;

  length = 4;
#ifdef __ON_OS2__
  cmstpn (convId,
#endif
#ifdef __ON_MVS__
  CMSTPN (convId,
#endif
          tpn,
          &length,
          &rc);
  if (rc != 0)
    sprintf (errMsg, "CMSTPN - rc = %d\n", rc);
  return (rc);
}


/**********************************************************************/
/*    Allocate Conversation                                           */
/*    This function issues an Allocate call to establish a            */
/*    conversation with partner TP                                    */
/**********************************************************************/

int
Alloc(char * convId, char *errMsg)
{
  long rc;

#ifdef __ON_OS2__
  cmallc (convId,
#endif
#ifdef __ON_MVS__
  CMALLC (convId,
#endif
          &rc);
  if (rc != 0)
    sprintf (errMsg, "CMALLC - rc = %d\n", rc);
  return (rc);
}



/**********************************************************************/
/*    Set Send Type                                                   */
/*    This function issues a Set_Send_Type call to specify the        */
/*    information (if any) to be sent to the partner TP in            */
/*    addition to the data sent on the Send_Data call.                */
/**********************************************************************/

int
Set_Send_Type(char * convId, long sendType, char *errMsg)
{
  long rc;

#ifdef __ON_OS2__
  cmsst (convId,
#endif
#ifdef __ON_MVS__
  CMSST (convId,
#endif
         &sendType,
         &rc);
  if (rc != 0)
    sprintf (errMsg, "CMSST - rc = %d\n", rc);
  return (rc);
}


/**********************************************************************/
/*    Send Data                                                       */
/*    This function issues a Send_Data call to send data to the       */
/*    partner TP.                                                     */
/**********************************************************************/

int
Send_Data(char * convId,
          char *buff,
          long bufLen,
          long *reqSendRec,
          char *errMsg)
{
  long rc;

#ifdef __ON_OS2__
  cmsend (convId,
#endif
#ifdef __ON_MVS__
  CMSEND (convId,
#endif
          buff,
          &bufLen,
          reqSendRec,
          &rc);
  if (rc != 0)
    sprintf (errMsg, "CMSEND - rc = %d\n", rc);
  return (rc);
}


/**********************************************************************/
/*    Flush                                                           */
/*    This function issues a Flush call to tell the local LU to       */
/*    send the information in the local LU's send buffer to the       */
/*    partner LU.  The information in the buffer comes from the       */
/*    Allocate, Send_Data, or Send_Error calls.                       */
/**********************************************************************/

int
Flush(char * convId, char *errMsg)
{
  long rc;

#ifdef __ON_OS2__
  cmflus (convId,
#endif
#ifdef __ON_MVS__
  CMFLUS (convId,
#endif
          &rc);
  if (rc != 0)
    sprintf (errMsg, "CMFLUS - rc = %d\n", rc);
  return (rc);
}


/**********************************************************************/
/*     Test Request to Send Received                                  */
/*     This function issues a Test_Request_To_Send_Received call to   */
/*     check if a request to send data was received by this program   */
/*     TP.                                                            */
/**********************************************************************/

int
Test_Req_To_Send_Recd(char * convId, long *reqSendRec, char *errMsg)
{
  long rc;

#ifdef __ON_OS2__
  cmtrts (convId,
#endif
#ifdef __ON_MVS__
  CMTRTS (convId,
#endif
          reqSendRec,
          &rc);
  if (rc != 0)
    sprintf (errMsg, "CMTRTS - rc = %d\n", rc);
  return (rc);
}


/**********************************************************************/
/*    Set Prepare to Receive Type                                     */
/*    This function issues a Set_Prepare_To_Receive_Type call to      */
/*    specify the way that the program will process the               */
/*    Prepare_To_Receive call.                                        */
/**********************************************************************/

int
Set_Prep_To_Rec_Type(char * convId, long prepRecType, char *errMsg)
{
  long rc;

#ifdef __ON_OS2__
  cmsptr (convId,
#endif
#ifdef __ON_MVS__
  CMSPTR (convId,
#endif
          &prepRecType,
          &rc);
  if (rc != 0)
    sprintf (errMsg, "CMSPTR - rc = %d\n", rc);
  return (rc);
}

/**********************************************************************/
/*    Prepare To Receive                                              */
/*    This function issues a Prepare_to_Receive call to change the    */
/*    conversation from SEND to RECEIVE state in preparation to       */
/*    receive data.                                                   */
/**********************************************************************/

int
Prep_To_Rec(char * convId, char *errMsg)
{
  long rc;

#ifdef __ON_OS2__
  cmptr (convId,
#endif
#ifdef __ON_MVS__
  CMPTR (convId,
#endif
         &rc);
  if (rc != 0)
    sprintf (errMsg, "CMPTR - rc = %d\n", rc);
  return (rc);
}

/**********************************************************************/
/*    Confirm                                                         */
/*    This function issues a Confirm call to indicate to the          */
/*    partner TP that a confirmation is expected.                     */
/**********************************************************************/

int
ConfirmSend(char * convId, long *reqSendRec, char *errMsg)
{
  long rc;

#ifdef __ON_OS2__
  cmcfm (convId,
#endif
#ifdef __ON_MVS__
  CMCFM (convId,
#endif
         reqSendRec,
         &rc);
  if (rc != 0)
    sprintf (errMsg, "CMCFM - rc = %d\n", rc);
  return (rc);
}

/**********************************************************************/
/*    Confirmed                                                       */
/*    This function issues a Confirmed call to respond to the         */
/*    partner TP's Confirm call.                                      */
/**********************************************************************/
int
ConfirmRecv(char * convId)
{
  long rc;

#ifdef __ON_OS2__
  cmcfmd (convId,
#endif
#ifdef __ON_MVS__
  CMCFMD (convId,
#endif
          &rc);
  if (rc != 0)
    printf ("CMCFMD - rc = %d\n", rc);
  return (rc);
}

/**********************************************************************/
/*    Receive                                                         */
/*    This function issues a Receive call to receive data from the    */
/*    partner TP                                                      */
/**********************************************************************/

int
Receive(char * convId,
        char *buff,
        long buffLen,
        long *dataRec,
        long *recLen,
        long *statRec,
        long *reqSendRec,
        char *errMsg)
{
  long rc;

#ifdef __ON_OS2__
  cmrcv (convId,
#endif
#ifdef __ON_MVS__
  CMRCV (convId,
#endif
         buff,
         &buffLen,
         dataRec,
         recLen,
         statRec,
         reqSendRec,
         &rc);
  if (rc != 0)
    sprintf (errMsg,"CMRCV - rc = %d\n", rc);
  return (rc);
}


/**********************************************************************/
/*    Set Deallocate Type                                             */
/*    This function issues a Set_Deallocate_Type call to specify      */
/*    the type of deallocation that this program will perform         */
/*    when the conversation ends.                                     */
/**********************************************************************/

int
Set_Dealloc_Type(char * convId, long deallocType)
{
  long rc;

#ifdef __ON_OS2__
  cmsdt (convId,
#endif
#ifdef __ON_MVS__
  CMSDT (convId,
#endif
         &deallocType,
         &rc);
  if (rc != 0)
    printf ("CMSDT - rc = %d\n", rc);
  return (rc);
}

/**********************************************************************/
/*     Deallocate                                                     */
/*     This function issues a Deallocate call to end the              */
/*     conversation with partner TP.                                  */
/**********************************************************************/

int
Deallocate(char * convId)
{
  long rc;

#ifdef __ON_OS2__
  cmdeal (convId,
#endif
#ifdef __ON_MVS__
  CMDEAL (convId,
#endif
          &rc);
  if (rc != 0)
    printf ("CMDEAL - rc = %d\n", rc);

  return (rc);
}


/**********************************************************************/
/*   Function    : goims                                              */
/*                                                                    */
/*   Description : This function allocate conversation to partner TP  */
/*                 send input data and receive the output             */
/*   Input       : tpName  - Pointer to partner TP name               */
/*                 buff    - Input buffer                             */
/*                 bufflen - Length of input buffer                   */
/*                 maxLen  - Length of receiving buffer               */
/*   Output      : int  -  negative value of CPIC error code          */
/*                         or the length of data string received      */
/**********************************************************************/

int
goims(char *tpName, char *buff, int buffLen, int maxLen)
{
  long rc;
  char *convId;
  long reqSendRec;
  long dataRec;
  long recLen = 0;
  long rl;
  long statRec;
  long recRc = 0;

  convId = (char *)malloc(CONVIDLEN+1);
  rc = Conv_Init(convId, destName, buff);
  if (rc != 0)
    goto initErr;

  rc = Set_Conv_Type(convId, CM_MAPPED_CONVERSATION, buff);
  if (rc != 0)
    goto notAllocErr;

  rc = Set_Mode_Name(convId, mode, buff);   /* Set Mode Name
                                          This is an example of how to
                                          invoke the Set Mode Name
                                          subroutine to override the
                                          information contained in the
                                          Side Information profile.   */
  if (rc != 0)
    goto notAllocErr;

  rc = Set_Part_LUName(convId, partLUName, buff); /* Set Partner LU Name
                                          This is an example of how to
                                          invoke the Set Partner LU Name
                                          subroutine to override the
                                          information contained in the
                                          Side Information profile.   */
  if (rc != 0)
    goto notAllocErr;

  rc = Set_Ret_Cntl(convId, CM_WHEN_SESSION_ALLOCATED, buff);
  /* Set Return Control
                                          This is an example of how to
                                          invoke the Set Return Control
                                          subroutine. In this case,
                                          CM_WHEN_SESSION_ALLOCATED is
                                          the default value.          */
  if (rc != 0)
    goto notAllocErr;

  rc = Set_Sync_Level(convId, CM_CONFIRM, buff);
  /* Set Sync Level
                                          CM_CONFIRM                  */
  if (rc != 0)
    goto notAllocErr;

  rc = Set_TP_Name(convId, tpName, buff);
  /* Set TP Name
                                          This is an example of how to
                                          invoke the Set TP Name
                                          subroutine to override the
                                          information contained in the
                                          Side Information profile.   */
  if (rc != 0)
    goto notAllocErr;

  rc = Alloc(convId, buff);     /* Allocate conversation              */
  if (rc != 0)
    goto allocErr;

  if (rc != 0)
    goto allocErr;

  rc = Set_Send_Type(convId, CM_BUFFER_DATA, buff);
  /* Set Send Type
                                          This is an example of how to
                                          invoke the Set Send Type
                                          subroutine. In this case,
                                          CM_BUFFER_DATA is the default
                                          value.                      */
  if (rc != 0)
    goto allocErr;

      rc = Send_Data(convId, buff, buffLen, &reqSendRec, buff);
      if (rc != 0)
        goto allocErr;

      rc = Flush(convId, buff);
      if (rc != 0)
        goto allocErr;

      rc = ConfirmSend(convId, &reqSendRec, buff);
      if (rc == CM_PROGRAM_ERROR_PURGING)
        goto doRecv;
      if (rc != 0)
        goto allocErr;

      rc = Test_Req_To_Send_Recd(convId, &reqSendRec, buff);
      if (rc != 0)
        goto allocErr;


  rc = Set_Prep_To_Rec_Type(convId, CM_PREP_TO_RECEIVE_FLUSH, buff);
  /* Set Prepare To Receive Type
                                          CM_PREP_TO_RECEIVE_FLUSH    */
  if (rc != 0)
    goto allocErr;

  rc = Prep_To_Rec(convId, buff);         /* Prepare To Receive       */
  if (rc != 0)
    goto allocErr;

 doRecv:
  do
  {
    recRc = Receive(convId,
                 &buff[recLen],
                 maxLen,
                 &dataRec,
                 &rl,
                 &statRec,
                 &reqSendRec,
                 buff);
    recLen += rl;
    /* Receive with the default
       Receive Type
       RECEIVE_AND_WAIT            */
    if (recRc != 0)
    {
      if (rc == 0)
        rc = recRc;
      goto allocErr;
    }
  }
  while (statRec != CM_SEND_RECEIVED &&
         statRec != CM_CONFIRM_SEND_RECEIVED &&
         statRec != CM_CONFIRM_RECEIVED);

  if (statRec == CM_CONFIRM_SEND_RECEIVED ||
      statRec == CM_CONFIRM_RECEIVED)
    (void)ConfirmRecv(convId);

#ifdef __ON_OS2__
  cmrts (convId, &recRc);     /* Request to Send                      */
#endif
#ifdef __ON_MVS__
  CMRTS (convId, &recRc);     /* Request to Send                      */
#endif
  if (recRc != 0)
    goto allocErr;


 allocErr:
  (void)Set_Dealloc_Type(convId, CM_DEALLOCATE_ABEND);
  /* Set Deallocate Type
                                          CM_DEALLOCATE_ABEND         */

  (void)Deallocate(convId);

 notAllocErr:
 initErr:

  free(convId);
  if (rc)
    return (-rc);
  else
    return (recLen);               /* Return with last return code    */
}


#ifdef __ON_OS2__
/**********************************************************************/
/*   Funciton    : Convert                                            */
/*   Description : This function covert data string between ASCII and */
/*                 EBCDIC with OS/2 predefined character set          */
/*   Input       : From - Original data string                        */
/*                 To   - Target data string                          */
/*                 CS   - Character set                               */
/*                 Size - Length of data string                       */
/*                 Buf  - Pointer of data string                      */
/*   Output      : int  - -1  data string error                       */
/*                        -2  character set error                     */
/*                        -3  OS/2 convert call error                 */
/*                         0  ok                                      */
/**********************************************************************/
int Convert (char* From, char* To, char* CS, int Size, char* Buf)
{
  struct convert cnvt;
  PVOID cnvtptr;
  char buf[200];
  long  length;
  int rc;

  cnvtptr = (PVOID)&cnvt;

  /* set conversion opcode                                            */
  cnvt.opcode = SV_CONVERT;

  /* set conversion dircetion                                         */
  if ((!stricmp(From,"A")) && (!stricmp(To,"E"))) {
    cnvt.direction = SV_ASCII_TO_EBCDIC;
  }
  else {
    if ((!stricmp(From,"E")) && (!stricmp(To,"A"))) {
      cnvt.direction = SV_EBCDIC_TO_ASCII;
    }
    else {
      printf("Convert Error : converting %s ",From);
      printf("to  %s\n",To);
      rc = -1;
      goto convert_done;
    }
  }

  /* set conversion character set                                     */
  if (!stricmp(CS,"AE")){
    cnvt.char_set = SV_AE;
  }
  else {
    if (!stricmp(CS,"A")){
    cnvt.char_set = SV_A;
    }
    else {
      if (!stricmp(CS,"G")){
        cnvt.char_set = SV_G;
      }
      else {
        printf("Convert Error : converting char set %s\n",CS);
        rc = -2;
        goto convert_done;
      }
    }
  }

  /* set conversion length                                            */
  cnvt.len = Size;

  /* set conversion buffer                                            */
  cnvt.source = cnvt.target = (UCHAR *)Buf;

  /* pass to conversion routine                                       */
  ACSSVC (cnvtptr);

  if (cnvt.primary_rc) {
    printf("Convert Error : primary rc = %.4x\n",cnvt.primary_rc);
    printf("secondary rc = %.8x\n",cnvt.secondary_rc);
    rc = -3;
  } else {
    rc = 0;
  }

  convert_done:

  return(rc);
}
#endif
