/*
 * Decompiled with CFR 0.152.
 */
import java.beans.PropertyVetoException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.PrintWriter;
import java.util.BitSet;

class ATraceFile {
    private static PipedReader pipeReader = null;
    private static PrintWriter pipeWriter = null;
    private static ASwingWorker worker1;
    private static Object lockObject;
    private static BufferedWriter traceWriter;
    private static File traceFile;
    private static boolean traceActive;
    private static boolean traceValid;
    private Object callerObject;
    private String callerClassName;
    private ATraceWindow frame = null;
    public static final int maxTraceLevels = 32;
    private static BitSet traceSettings;
    public static String[] traceNames;

    public static String getTraceFileName() {
        return traceFile.getAbsolutePath();
    }

    private static void buildPipes() {
        if (pipeReader != null) {
            try {
                pipeReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (pipeWriter != null) {
            pipeWriter.close();
        }
        pipeReader = new PipedReader();
        try {
            pipeWriter = new PrintWriter(new PipedWriter(pipeReader));
        }
        catch (IOException iOException) {
            System.out.println("IOX 1" + iOException);
        }
    }

    public static void close() {
        if (!ATraceFile.isActive()) {
            return;
        }
        pipeWriter.flush();
        pipeWriter.close();
        Thread thread = worker1.getThread();
        worker1.interrupt();
        try {
            thread.join();
            pipeReader.close();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            traceWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ATraceFile.setActive(false);
        System.out.println("Tracing to \"" + ATraceFile.getTraceFileName() + "\" stopped.");
    }

    public static synchronized boolean isLevelActive(int n) {
        return traceSettings.get(n);
    }

    public static synchronized boolean isValid() {
        return traceValid;
    }

    public static void open() {
        ATraceFile.open(false);
    }

    public static void open(boolean bl) {
        lockObject = new Object();
        if (ATraceFile.isActive()) {
            return;
        }
        if (traceFile == null) {
            traceFile = new File("trace.txt");
        }
        try {
            traceWriter = new BufferedWriter(new FileWriter(ATraceFile.getTraceFileName(), bl));
        }
        catch (IOException iOException) {
            System.out.println("Could not open trace file " + ATraceFile.getTraceFileName());
            ATraceFile.setValid(false);
            return;
        }
        ATraceFile.setValid(true);
        ATraceFile.setActive(true);
        ATraceFile.setLevelActive(0, true);
        ATraceFile.buildPipes();
        worker1 = new ASwingWorker("WriteTrace"){

            public Object construct() {
                ATraceFile.readPipeLoop();
                return null;
            }
        };
        System.out.println("Tracing to \"" + ATraceFile.getTraceFileName() + "\" started");
    }

    /*
     * Exception decompiling
     */
    private static void readPipeLoop() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static synchronized void setActive(boolean bl) {
        traceActive = false;
        if (bl && ATraceFile.isValid()) {
            traceActive = true;
        }
    }

    public static synchronized boolean isActive() {
        return traceActive;
    }

    public static synchronized void setLevelActive(int n, boolean bl) {
        if (bl) {
            traceSettings.set(n);
        } else {
            traceSettings.clear(n);
        }
    }

    public static synchronized void setValid(boolean bl) {
        if (!bl) {
            ATraceFile.setActive(false);
        }
        traceValid = bl;
    }

    public void showTraceWindow(AMainWindow aMainWindow) {
        if (this.frame == null) {
            this.frame = new ATraceWindow(aMainWindow, this);
            try {
                this.frame.moveToFront();
                this.frame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                this.write("showTraceWindow()", 0, "Exception:" + propertyVetoException.toString());
            }
        } else {
            try {
                this.frame.setIcon(false);
                this.frame.moveToFront();
                this.frame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                this.write("showTraceWindow()", 0, "Exception:" + propertyVetoException.toString());
            }
        }
    }

    public void setTracePanelClosed() {
        this.frame = null;
    }

    public synchronized void write(String string, String string2) {
        this.write(string, 0, string2);
    }

    public synchronized void write(String string, int n, String string2) {
        if (!ATraceFile.isActive() || !ATraceFile.isLevelActive(n)) {
            return;
        }
        String string3 = System.currentTimeMillis() % 10000000L + " " + Thread.currentThread().getName() + " " + this.callerClassName + string + " " + string2;
        System.out.println(string3);
        Object object = lockObject;
        synchronized (object) {
            pipeWriter.println(string3);
        }
    }

    public ATraceFile(Object object) {
        this.callerObject = object;
        this.callerClassName = object.getClass().getName() + "::";
    }

    static {
        traceFile = null;
        traceActive = false;
        traceValid = false;
        traceSettings = new BitSet(32);
        traceNames = new String[]{" 0 Basics", " 1 FTP basics", " 2 FTP details", " 3 Not used", " 4 Not used", " 5 Not used", " 6 Not used", " 7 Not used", " 8 Not used", " 9 Not used", "10 Catalog basics", "11 Catalog details", "12 Repository basics", "13 Repository details", "14 Source basics", "15 Source details", "16 Setup basics", "17 Setup details", "18 Other Panels basics", "19 Other Panels details", "20 Proxy basics", "21 Proxy details", "22 Book Case details", "23 Object Parse details", "24 BaseObject details", "25 FileObject details", "26 GroupObject details", "27 Data Models basics", "28 Data Models details", "29 Not used", "30 Not used", "31 Not used"};
    }
}

