/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.io.File;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class ASetupWindow
extends ABaseInternalFrame
implements Runnable,
ActionListener {
    public AMainWindow mainWindow;
    protected ARepository aRepository;
    protected ARepository orgRepository;
    private JTabbedPane tabbedPane;
    private MyInternalFrameListener aMyInternalFrameListener1;
    private ASetupPanelDefinition aSetupPanelDefinition;
    private ASetupPanelLogon aSetupPanelLogon;
    private ASetupPanelOS390FileTypes aSetupPanelOS390FileTypes;
    private ASetupPanelHFSFileTypes aSetupPanelHFSFileTypes;
    private ASetupPanelLocalFileTypes aSetupPanelLocalFileTypes;
    private JPanel buttonPanel;
    private JButton prevButton;
    private JButton nextButton;
    private JButton okButton;
    private JButton cancelButton;
    private ATraceFile tf;
    private Thread setupThread = null;
    private JScrollPane setupPanelDefinitionScrollpane;
    private JScrollPane setupPanelLogonScrollpane;
    private JScrollPane setupPanelProxyScrollpane;
    private JScrollPane setupPanelOS390FileTypesScrollpane;
    private JScrollPane setupPanelHFSFileTypesScrollpane;
    private JScrollPane setupPanelLocalFileTypesScrollpane;
    private JMenuItem itemWindow_Setup;
    private String title;
    public boolean isNewRepository = false;
    protected static String LABEL_OS390OE = new String("z/OS or OS/390 - Unix System Services HFS via FTP");
    protected static String LABEL_OS390 = new String("z/OS or OS/390 - Sequential datasets via FTP");
    protected static String LABEL_UNIX = new String("AIX, LINUX, or Other UNIX-like via FTP");
    protected static String LABEL_PC = new String("Local or Network drive via Copy commands");
    static /* synthetic */ Class class$ASetupPanelDefinition;
    static /* synthetic */ Class class$ASetupPanelLogon;
    static /* synthetic */ Class class$ASetupPanelOS390FileTypes;
    static /* synthetic */ Class class$ASetupPanelHFSFileTypes;
    static /* synthetic */ Class class$ASetupPanelLocalFileTypes;

    public ASetupWindow(AMainWindow aMainWindow, ARepository aRepository, ARepository aRepository2) {
        super("", true, true, true, true);
        if (aRepository.repositoryTitle().length() == 0) {
            this.title = "Repository Properties - New Repository";
            this.isNewRepository = true;
        } else {
            this.title = "Repository Properties - " + aRepository.repositoryTitle();
        }
        this.mainWindow = aMainWindow;
        this.aRepository = aRepository;
        this.orgRepository = aRepository2;
        this.itemWindow_Setup = aMainWindow.windowMenu.add(new JMenuItem(this.title));
        this.itemWindow_Setup.addActionListener(aMainWindow);
        this.tf = new ATraceFile(this);
        APropertyObject aPropertyObject = null;
        if (AMainWindow.userIniFlag) {
            aPropertyObject = AMainWindow.userProperties.getObject(this.title);
            if (aPropertyObject == null) {
                aPropertyObject = new APropertyObject();
                aPropertyObject.setTitle(this.title);
                aPropertyObject.setSize(new Dimension(600, 400));
                aPropertyObject.setLocation(new Point(80, 80));
            }
        } else {
            aPropertyObject = new APropertyObject();
            aPropertyObject.setTitle(this.title);
            aPropertyObject.setSize(new Dimension(600, 400));
            aPropertyObject.setLocation(new Point(80, 80));
        }
        this.setTitle(aPropertyObject.title());
        this.setSize(aPropertyObject.size());
        this.setLocation(aPropertyObject.location());
        this.setupThread = new Thread(this);
        this.setupThread.start();
        this.setVisible(true);
        try {
            this.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void run() {
        this.aMyInternalFrameListener1 = new MyInternalFrameListener();
        this.addInternalFrameListener(this.aMyInternalFrameListener1);
        JPanel jPanel = new JPanel();
        this.tabbedPane = new JTabbedPane();
        this.aSetupPanelDefinition = new ASetupPanelDefinition(this);
        this.aSetupPanelLogon = new ASetupPanelLogon(this);
        this.aSetupPanelOS390FileTypes = new ASetupPanelOS390FileTypes(this);
        this.aSetupPanelHFSFileTypes = new ASetupPanelHFSFileTypes(this);
        this.aSetupPanelLocalFileTypes = new ASetupPanelLocalFileTypes(this);
        this.setupPanelDefinitionScrollpane = new JScrollPane();
        this.setupPanelLogonScrollpane = new JScrollPane();
        this.setupPanelOS390FileTypesScrollpane = new JScrollPane();
        this.setupPanelHFSFileTypesScrollpane = new JScrollPane();
        this.setupPanelLocalFileTypesScrollpane = new JScrollPane();
        this.setupPanelDefinitionScrollpane.getViewport().add(this.aSetupPanelDefinition);
        this.setupPanelLogonScrollpane.getViewport().add(this.aSetupPanelLogon);
        this.setupPanelOS390FileTypesScrollpane.getViewport().add(this.aSetupPanelOS390FileTypes);
        this.setupPanelHFSFileTypesScrollpane.getViewport().add(this.aSetupPanelHFSFileTypes);
        this.setupPanelLocalFileTypesScrollpane.getViewport().add(this.aSetupPanelLocalFileTypes);
        JScrollBar jScrollBar = this.setupPanelLogonScrollpane.getVerticalScrollBar();
        jScrollBar.setUnitIncrement(40);
        JScrollBar jScrollBar2 = this.setupPanelOS390FileTypesScrollpane.getVerticalScrollBar();
        jScrollBar2.setUnitIncrement(40);
        JScrollBar jScrollBar3 = this.setupPanelHFSFileTypesScrollpane.getVerticalScrollBar();
        jScrollBar3.setUnitIncrement(40);
        JScrollBar jScrollBar4 = this.setupPanelLocalFileTypesScrollpane.getVerticalScrollBar();
        jScrollBar4.setUnitIncrement(40);
        this.tabbedPane.addTab("Definition", this.setupPanelDefinitionScrollpane);
        this.tabbedPane.addTab("FTP Logon Information", this.setupPanelLogonScrollpane);
        this.tabbedPane.addTab("Filetype options", this.setupPanelOS390FileTypesScrollpane);
        MyChangeListener myChangeListener = new MyChangeListener();
        this.tabbedPane.addChangeListener(myChangeListener);
        JPanel jPanel2 = this.buttonPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel2.setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        Dimension dimension = new Dimension(20, 20);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(new Box.Filler(dimension, dimension, dimension), gridBagConstraints);
        jPanel2.add(new Box.Filler(dimension, dimension, dimension));
        this.okButton = new JButton("OK");
        this.okButton.setMnemonic('O');
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 0, 10, 10);
        gridBagLayout.setConstraints(this.okButton, gridBagConstraints);
        jPanel2.add(this.okButton);
        this.prevButton = new JButton("Previous");
        this.prevButton.setMnemonic('P');
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 0, 10, 10);
        gridBagLayout.setConstraints(this.prevButton, gridBagConstraints);
        jPanel2.add(this.prevButton);
        this.prevButton.setEnabled(false);
        this.nextButton = new JButton("Next");
        this.nextButton.setMnemonic('N');
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 0, 10, 10);
        gridBagLayout.setConstraints(this.nextButton, gridBagConstraints);
        jPanel2.add(this.nextButton);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setMnemonic('C');
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 0, 10, 10);
        gridBagLayout.setConstraints(this.cancelButton, gridBagConstraints);
        jPanel2.add(this.cancelButton);
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.getContentPane().add((Component)jPanel2, "South");
        this.cancelButton.addActionListener(this);
        this.okButton.addActionListener(this);
        this.prevButton.addActionListener(this);
        this.nextButton.addActionListener(this);
        this.loadRepositorySettings();
        this.updateUI();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.tf.write("actionPerformed() : ", 16, actionEvent.paramString());
        if (actionEvent.getActionCommand().equals("OK")) {
            this.saveRepositorySettings();
        } else if (actionEvent.getActionCommand().equals("Cancel")) {
            if (!this.isNewRepository) {
                this.mainWindow.listWindow.cancelSetup(this.orgRepository);
            }
            this.dispose();
        } else if (actionEvent.getActionCommand().equals("Previous")) {
            this.processPrevious();
        } else if (actionEvent.getActionCommand().equals("Next")) {
            this.processNext();
        } else if (actionEvent.getActionCommand().equals(LABEL_OS390OE)) {
            this.hostOS390OE();
        } else if (actionEvent.getActionCommand().equals(LABEL_OS390)) {
            this.hostOS390();
        } else if (actionEvent.getActionCommand().equals(LABEL_UNIX)) {
            this.hostOS390OE();
        } else if (actionEvent.getActionCommand().equals(LABEL_PC)) {
            this.hostLocal();
        }
    }

    public void setPage(ASetupPanel aSetupPanel) {
        if (aSetupPanel.getClass() == (class$ASetupPanelDefinition == null ? (class$ASetupPanelDefinition = ASetupWindow.class$("ASetupPanelDefinition")) : class$ASetupPanelDefinition)) {
            if (this.tabbedPane.getSelectedComponent() != this.setupPanelDefinitionScrollpane) {
                this.tabbedPane.setSelectedComponent(this.setupPanelDefinitionScrollpane);
            }
        } else if (aSetupPanel.getClass() == (class$ASetupPanelLogon == null ? (class$ASetupPanelLogon = ASetupWindow.class$("ASetupPanelLogon")) : class$ASetupPanelLogon)) {
            if (this.tabbedPane.getSelectedComponent() != this.setupPanelLogonScrollpane) {
                this.tabbedPane.setSelectedComponent(this.setupPanelLogonScrollpane);
            }
        } else if (aSetupPanel.getClass() == (class$ASetupPanelOS390FileTypes == null ? (class$ASetupPanelOS390FileTypes = ASetupWindow.class$("ASetupPanelOS390FileTypes")) : class$ASetupPanelOS390FileTypes)) {
            if (this.tabbedPane.getSelectedComponent() != this.setupPanelOS390FileTypesScrollpane) {
                this.tabbedPane.setSelectedComponent(this.setupPanelOS390FileTypesScrollpane);
            }
        } else if (aSetupPanel.getClass() == (class$ASetupPanelHFSFileTypes == null ? (class$ASetupPanelHFSFileTypes = ASetupWindow.class$("ASetupPanelHFSFileTypes")) : class$ASetupPanelHFSFileTypes)) {
            if (this.tabbedPane.getSelectedComponent() != this.setupPanelHFSFileTypesScrollpane) {
                this.tabbedPane.setSelectedComponent(this.setupPanelHFSFileTypesScrollpane);
            }
        } else if (aSetupPanel.getClass() == (class$ASetupPanelLocalFileTypes == null ? (class$ASetupPanelLocalFileTypes = ASetupWindow.class$("ASetupPanelLocalFileTypes")) : class$ASetupPanelLocalFileTypes) && this.tabbedPane.getSelectedComponent() != this.setupPanelLocalFileTypesScrollpane) {
            this.tabbedPane.setSelectedComponent(this.setupPanelLocalFileTypesScrollpane);
        }
    }

    public JScrollPane scrollPane(ASetupPanel aSetupPanel) {
        JScrollPane jScrollPane = null;
        if (aSetupPanel.getClass() == (class$ASetupPanelDefinition == null ? (class$ASetupPanelDefinition = ASetupWindow.class$("ASetupPanelDefinition")) : class$ASetupPanelDefinition)) {
            jScrollPane = this.setupPanelDefinitionScrollpane;
        } else if (aSetupPanel.getClass() == (class$ASetupPanelLogon == null ? (class$ASetupPanelLogon = ASetupWindow.class$("ASetupPanelLogon")) : class$ASetupPanelLogon)) {
            jScrollPane = this.setupPanelLogonScrollpane;
        } else if (aSetupPanel.getClass() == (class$ASetupPanelOS390FileTypes == null ? (class$ASetupPanelOS390FileTypes = ASetupWindow.class$("ASetupPanelOS390FileTypes")) : class$ASetupPanelOS390FileTypes)) {
            jScrollPane = this.setupPanelOS390FileTypesScrollpane;
        } else if (aSetupPanel.getClass() == (class$ASetupPanelHFSFileTypes == null ? (class$ASetupPanelHFSFileTypes = ASetupWindow.class$("ASetupPanelHFSFileTypes")) : class$ASetupPanelHFSFileTypes)) {
            jScrollPane = this.setupPanelHFSFileTypesScrollpane;
        } else if (aSetupPanel.getClass() == (class$ASetupPanelLocalFileTypes == null ? (class$ASetupPanelLocalFileTypes = ASetupWindow.class$("ASetupPanelLocalFileTypes")) : class$ASetupPanelLocalFileTypes)) {
            jScrollPane = this.setupPanelLocalFileTypesScrollpane;
        }
        return jScrollPane;
    }

    public ASetupPanel getSelectedSetupPanel(Component component) {
        ASetupPanel aSetupPanel = null;
        if (component == this.setupPanelOS390FileTypesScrollpane) {
            aSetupPanel = this.aSetupPanelOS390FileTypes;
        } else if (component == this.setupPanelHFSFileTypesScrollpane) {
            aSetupPanel = this.aSetupPanelHFSFileTypes;
        } else if (component == this.setupPanelLocalFileTypesScrollpane) {
            aSetupPanel = this.aSetupPanelLocalFileTypes;
        }
        return aSetupPanel;
    }

    public void processNext() {
        Component component = this.tabbedPane.getSelectedComponent();
        if (component == this.setupPanelOS390FileTypesScrollpane || component == this.setupPanelHFSFileTypesScrollpane || component == this.setupPanelLocalFileTypesScrollpane) {
            ASetupPanel aSetupPanel = this.getSelectedSetupPanel(component);
            int n = 0;
            int n2 = 0;
            if (aSetupPanel.getClass() == (class$ASetupPanelOS390FileTypes == null ? (class$ASetupPanelOS390FileTypes = ASetupWindow.class$("ASetupPanelOS390FileTypes")) : class$ASetupPanelOS390FileTypes)) {
                n = this.aSetupPanelOS390FileTypes.setNext();
                n2 = this.aSetupPanelOS390FileTypes.fileTypeList.getModel().getSize();
            } else if (aSetupPanel.getClass() == (class$ASetupPanelHFSFileTypes == null ? (class$ASetupPanelHFSFileTypes = ASetupWindow.class$("ASetupPanelHFSFileTypes")) : class$ASetupPanelHFSFileTypes)) {
                n = this.aSetupPanelHFSFileTypes.setNext();
                n2 = this.aSetupPanelHFSFileTypes.fileTypeList.getModel().getSize();
            } else if (aSetupPanel.getClass() == (class$ASetupPanelLocalFileTypes == null ? (class$ASetupPanelLocalFileTypes = ASetupWindow.class$("ASetupPanelLocalFileTypes")) : class$ASetupPanelLocalFileTypes)) {
                n = this.aSetupPanelLocalFileTypes.setNext();
                n2 = this.aSetupPanelLocalFileTypes.fileTypeList.getModel().getSize();
            }
            if (n + 1 == n2) {
                this.nextButton.setEnabled(false);
            }
        } else {
            int n = this.tabbedPane.getSelectedIndex();
            if (++n < this.tabbedPane.getTabCount()) {
                this.tabbedPane.setSelectedIndex(n);
            }
            if (n == 0) {
                this.prevButton.setEnabled(false);
            } else {
                this.prevButton.setEnabled(true);
            }
            this.tf.write("actionPerformed()", 17, "nextButton, selected index is:" + this.tabbedPane.getSelectedIndex());
        }
    }

    public void processPrevious() {
        Component component = this.tabbedPane.getSelectedComponent();
        if (component == this.setupPanelOS390FileTypesScrollpane || component == this.setupPanelHFSFileTypesScrollpane || component == this.setupPanelLocalFileTypesScrollpane) {
            ASetupPanel aSetupPanel = this.getSelectedSetupPanel(component);
            int n = 0;
            int n2 = 0;
            if (aSetupPanel.getClass() == (class$ASetupPanelOS390FileTypes == null ? (class$ASetupPanelOS390FileTypes = ASetupWindow.class$("ASetupPanelOS390FileTypes")) : class$ASetupPanelOS390FileTypes)) {
                n = this.aSetupPanelOS390FileTypes.setPrevious();
                n2 = this.aSetupPanelOS390FileTypes.fileTypeList.getModel().getSize();
            } else if (aSetupPanel.getClass() == (class$ASetupPanelHFSFileTypes == null ? (class$ASetupPanelHFSFileTypes = ASetupWindow.class$("ASetupPanelHFSFileTypes")) : class$ASetupPanelHFSFileTypes)) {
                n = this.aSetupPanelHFSFileTypes.setPrevious();
                n2 = this.aSetupPanelHFSFileTypes.fileTypeList.getModel().getSize();
            } else if (aSetupPanel.getClass() == (class$ASetupPanelLocalFileTypes == null ? (class$ASetupPanelLocalFileTypes = ASetupWindow.class$("ASetupPanelLocalFileTypes")) : class$ASetupPanelLocalFileTypes)) {
                n = this.aSetupPanelLocalFileTypes.setPrevious();
                n2 = this.aSetupPanelLocalFileTypes.fileTypeList.getModel().getSize();
            }
            if (n == -1) {
                n = this.tabbedPane.getSelectedIndex();
                if (--n >= 0) {
                    this.tabbedPane.setSelectedIndex(n);
                }
                if (n == 0) {
                    this.prevButton.setEnabled(false);
                }
            } else if (n <= n2) {
                this.nextButton.setEnabled(true);
            }
        } else {
            int n = this.tabbedPane.getSelectedIndex();
            if (--n >= 0) {
                this.tabbedPane.setSelectedIndex(n);
            }
            if (n == 0) {
                this.prevButton.setEnabled(false);
            }
            this.tf.write("actionPerformed()", 17, "prevButton, selected index is:" + this.tabbedPane.getSelectedIndex());
        }
    }

    public void setEnabledPrevButton(boolean bl) {
        this.prevButton.setEnabled(bl);
    }

    public void setEnabledNextButton(boolean bl) {
        this.nextButton.setEnabled(bl);
    }

    private void saveRepositorySettings() {
        if (!this.aSetupPanelDefinition.saveSettings()) {
            return;
        }
        if (this.aRepository.hostType() == 1) {
            if (!this.aSetupPanelLogon.saveSettings()) {
                return;
            }
            if (!this.aSetupPanelOS390FileTypes.saveSettings()) {
                return;
            }
        } else if (this.aRepository.hostType() == 3 || this.aRepository.hostType() == 4) {
            if (!this.aSetupPanelLogon.saveSettings()) {
                return;
            }
            if (!this.aSetupPanelHFSFileTypes.saveSettings()) {
                return;
            }
        } else if (this.aRepository.hostType() == 5 && !this.aSetupPanelLocalFileTypes.saveSettings()) {
            return;
        }
        if (this.isNewRepository) {
            this.mainWindow.listWindow.addNewRepository(this.aRepository);
        } else {
            File file = new File(this.aRepository.catalogFileName());
            if (!this.aRepository.isCatalogValid() && file.exists()) {
                Object[] objectArray = new Object[]{"OK", "Cancel"};
                String string = "The repository definition has changed significantly.<br>If you continue, the catalog file will be deleted, and then you should re-create the catalog.";
                int n = JOptionPane.showOptionDialog(this, "<html>" + string + "</html>", "Confirm Dialog", 2, 3, null, objectArray, objectArray[1]);
                if (n == 0) {
                    if (file.delete()) {
                        AUtilities.removeDirectory(this.aRepository.cacheDirectory());
                        new File(this.aRepository.cacheDirectory()).mkdir();
                    }
                } else {
                    return;
                }
            }
            this.mainWindow.listWindow.updateExistingRepository(this.aRepository, this.orgRepository);
        }
        this.dispose();
    }

    private void loadRepositorySettings() {
        this.aSetupPanelDefinition.preparePanel();
        int n = this.aRepository.hostType();
        if (n == 1) {
            this.hostOS390();
        } else if (n == 3) {
            this.hostOS390OE();
        } else if (n == 5) {
            this.hostLocal();
        } else if (n == 4) {
            this.hostOS390OE();
        }
    }

    private void hostLocal() {
        this.tf.write("hostLocal()", 17, "Entry");
        this.tabbedPane.remove(this.setupPanelLogonScrollpane);
        this.tabbedPane.remove(this.setupPanelOS390FileTypesScrollpane);
        this.tabbedPane.remove(this.setupPanelHFSFileTypesScrollpane);
        if (this.tabbedPane.indexOfComponent(this.setupPanelLocalFileTypesScrollpane) == -1) {
            this.tabbedPane.addTab("File types ", this.setupPanelLocalFileTypesScrollpane);
        }
    }

    private void hostOS390() {
        this.tf.write("hostOS390()", 17, "Entry");
        this.tabbedPane.remove(this.setupPanelHFSFileTypesScrollpane);
        this.tabbedPane.remove(this.setupPanelLocalFileTypesScrollpane);
        if (this.tabbedPane.indexOfComponent(this.setupPanelLogonScrollpane) == -1) {
            this.tabbedPane.addTab("Logon Information", this.setupPanelLogonScrollpane);
        }
        if (this.tabbedPane.indexOfComponent(this.setupPanelOS390FileTypesScrollpane) == -1) {
            this.tabbedPane.addTab("File types ", this.setupPanelOS390FileTypesScrollpane);
        }
    }

    private void hostOS390OE() {
        this.tf.write("hostOS390OE()", 17, "Entry");
        this.tabbedPane.remove(this.setupPanelOS390FileTypesScrollpane);
        this.tabbedPane.remove(this.setupPanelLocalFileTypesScrollpane);
        if (this.tabbedPane.indexOfComponent(this.setupPanelLogonScrollpane) == -1) {
            this.tabbedPane.addTab("Logon Information", this.setupPanelLogonScrollpane);
        }
        if (this.tabbedPane.indexOfComponent(this.setupPanelHFSFileTypesScrollpane) == -1) {
            this.tabbedPane.addTab("File types ", this.setupPanelHFSFileTypesScrollpane);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class MyChangeListener
    implements ChangeListener {
        MyChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Component component = ASetupWindow.this.tabbedPane.getSelectedComponent();
            if (component == ASetupWindow.this.setupPanelDefinitionScrollpane) {
                ASetupWindow.this.setEnabledPrevButton(false);
                ASetupWindow.this.setEnabledNextButton(true);
            } else if (component == ASetupWindow.this.setupPanelLogonScrollpane) {
                ASetupWindow.this.setEnabledPrevButton(true);
                ASetupWindow.this.setEnabledNextButton(true);
            }
        }
    }

    class MyInternalFrameListener
    extends InternalFrameAdapter {
        MyInternalFrameListener() {
        }

        public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
            ASetupWindow.this.mainWindow.getWindowMenu().remove(ASetupWindow.this.itemWindow_Setup);
            ASetupWindow.this.aRepository.setSetupWindow(null);
            if (ASetupWindow.this.isNewRepository) {
                ASetupWindow.this.mainWindow.SetupWindowClosed();
            }
        }
    }
}

