/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.StringTokenizer;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class ASetupPanelHFSFileTypes
extends ASetupPanel
implements FocusListener {
    private JLabel booksPathLabel;
    private JLabel shelvesPathLabel;
    private JLabel booksInfoLabel;
    private JLabel shelvesInfoLabel;
    private JLabel pdfPathLabel;
    private JLabel pdfInfoLabel;
    private JLabel indexPathLabel;
    private JLabel indexInfoLabel;
    private JTextArea booksPathTextArea;
    private JTextField indexPathField;
    private JTextField shelvesPathField;
    private JTextField pdfPathField;
    private JScrollPane booksPathScrollpane;
    protected JList fileTypeList;
    private DefaultListModel listModel;
    private static String BOOK = "BOO";
    private static String BKINDEX = "BKI";
    private static String BKSHELF = "BKS";
    private static String PDF = "PDF";

    ASetupPanelHFSFileTypes(ASetupWindow aSetupWindow) {
        super(aSetupWindow);
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3 = jPanel2 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel3.setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        this.listModel = new DefaultListModel();
        this.listModel.addElement(BOOK);
        this.listModel.addElement(BKINDEX);
        this.listModel.addElement(BKSHELF);
        this.fileTypeList = new JList(this.listModel);
        JScrollPane jScrollPane = new JScrollPane(){

            public Dimension getPreferredSize() {
                return new Dimension(60, 80);
            }
        };
        jScrollPane.getViewport().add(this.fileTypeList);
        jScrollPane.setAlignmentX(0.5f);
        this.fileTypeList.setSelectedValue(BOOK, true);
        ListSelectionModel listSelectionModel = this.fileTypeList.getSelectionModel();
        final ASetupWindow aSetupWindow2 = aSetupWindow;
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                Object e = ASetupPanelHFSFileTypes.this.fileTypeList.getSelectedValue();
                ASetupPanelHFSFileTypes.this.tf.write("valueChanged()", 17, "Value selected is:" + e);
                if (e.equals(BOOK)) {
                    ASetupPanelHFSFileTypes.this.bookTypeSelected();
                    aSetupWindow2.setEnabledPrevButton(true);
                    aSetupWindow2.setEnabledNextButton(true);
                } else if (e.equals(BKINDEX)) {
                    ASetupPanelHFSFileTypes.this.bkindexTypeSelected();
                    aSetupWindow2.setEnabledPrevButton(true);
                    aSetupWindow2.setEnabledNextButton(true);
                } else if (e.equals(BKSHELF)) {
                    ASetupPanelHFSFileTypes.this.bkshelfTypeSelected();
                    aSetupWindow2.setEnabledPrevButton(true);
                    aSetupWindow2.setEnabledNextButton(false);
                }
            }
        });
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(10, 60, 0, 60);
        gridBagConstraints.gridwidth = 3;
        this.addToGrid(gridBagConstraints, gridBagLayout, jPanel3, jScrollPane);
        JPanel jPanel4 = jPanel = new JPanel();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        jPanel4.setLayout(gridBagLayout2);
        gridBagConstraints2.fill = 2;
        this.booksPathLabel = new JLabel("Directories containing books:");
        this.booksPathLabel.setAlignmentX(0.0f);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.insets = new Insets(30, 30, 0, 0);
        this.addToGrid(gridBagConstraints2, gridBagLayout2, jPanel4, this.booksPathLabel);
        this.booksPathTextArea = new JTextArea();
        this.booksPathTextArea.setText("");
        this.booksPathTextArea.setAlignmentX(0.0f);
        this.booksPathTextArea.addFocusListener(this);
        this.booksPathScrollpane = new JScrollPane();
        this.booksPathScrollpane.setPreferredSize(new Dimension(100, 40));
        this.booksPathScrollpane.getViewport().add(this.booksPathTextArea);
        gridBagConstraints2.ipady = 40;
        gridBagConstraints2.weightx = 0.1;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 3;
        gridBagConstraints2.insets = new Insets(0, 30, 0, 80);
        this.addToGrid(gridBagConstraints2, gridBagLayout2, jPanel4, this.booksPathScrollpane);
        this.booksInfoLabel = new JLabel("<html><left><p>These directories will contain the book files.<br>When you transfer softcopy to the repository, you will be<br>able to specify any one of these directories as the<br>destination for the books. Enter one per line.</left></html>");
        this.booksInfoLabel.setAlignmentX(0.0f);
        gridBagConstraints2.ipady = 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 4;
        gridBagConstraints2.insets = new Insets(0, 30, 30, 0);
        this.addToGrid(gridBagConstraints2, gridBagLayout2, jPanel4, this.booksInfoLabel);
        this.indexPathLabel = new JLabel("Directory containing indexes:");
        this.indexPathLabel.setAlignmentX(0.0f);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 6;
        gridBagConstraints2.insets = new Insets(30, 30, 0, 0);
        this.addToGrid(gridBagConstraints2, gridBagLayout2, jPanel4, this.indexPathLabel);
        this.indexPathField = new JTextField(25);
        this.indexPathField.setText("");
        this.indexPathField.setAlignmentX(0.0f);
        this.indexPathField.addFocusListener(this);
        gridBagConstraints2.weightx = 0.1;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 7;
        gridBagConstraints2.insets = new Insets(0, 30, 0, 10);
        this.addToGrid(gridBagConstraints2, gridBagLayout2, jPanel4, this.indexPathField);
        this.indexInfoLabel = new JLabel("<html><left><p>This directory will contain the indexes. When you transfer <br>softcopy to the repository, indexes will be placed into this <br>directory.</left></html>");
        this.indexInfoLabel.setAlignmentX(0.0f);
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 8;
        gridBagConstraints2.insets = new Insets(0, 30, 30, 0);
        this.addToGrid(gridBagConstraints2, gridBagLayout2, jPanel4, this.indexInfoLabel);
        this.shelvesPathLabel = new JLabel("Directory containing shelves:");
        this.shelvesPathLabel.setAlignmentX(0.0f);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 10;
        gridBagConstraints2.insets = new Insets(30, 30, 0, 0);
        this.addToGrid(gridBagConstraints2, gridBagLayout2, jPanel4, this.shelvesPathLabel);
        this.shelvesPathField = new JTextField(25);
        this.shelvesPathField.setText("");
        this.shelvesPathField.setAlignmentX(0.0f);
        this.shelvesPathField.addFocusListener(this);
        gridBagConstraints2.weightx = 0.1;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 11;
        gridBagConstraints2.insets = new Insets(0, 30, 0, 80);
        this.addToGrid(gridBagConstraints2, gridBagLayout2, jPanel4, this.shelvesPathField);
        this.shelvesInfoLabel = new JLabel("<html><left><p>This directory will contain the shelves. When you transfer<br>softcopy to the repository, shelves will be placed into this<br>directory.</left></html>");
        this.shelvesInfoLabel.setAlignmentX(0.0f);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 12;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.insets = new Insets(0, 30, 30, 0);
        this.addToGrid(gridBagConstraints2, gridBagLayout2, jPanel4, this.shelvesInfoLabel);
        this.pdfPathLabel = new JLabel("Directory containing PDF's:");
        this.pdfPathLabel.setAlignmentX(0.0f);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 14;
        gridBagConstraints2.insets = new Insets(30, 30, 0, 0);
        this.addToGrid(gridBagConstraints2, gridBagLayout2, jPanel4, this.pdfPathLabel);
        this.pdfPathField = new JTextField(25);
        this.pdfPathField.setText("");
        this.pdfPathField.setAlignmentX(0.0f);
        this.pdfPathField.addFocusListener(this);
        gridBagConstraints2.weightx = 0.1;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 15;
        gridBagConstraints2.insets = new Insets(0, 30, 0, 80);
        this.addToGrid(gridBagConstraints2, gridBagLayout2, jPanel4, this.pdfPathField);
        this.pdfInfoLabel = new JLabel("<html><left><p>This directory will contain the pdf's. When you transfer<br>softcopy to the repository, pdf's will be placed into this<br>directory.</left></html>");
        this.pdfInfoLabel.setAlignmentX(0.0f);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 16;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.insets = new Insets(0, 30, 30, 0);
        this.addToGrid(gridBagConstraints2, gridBagLayout2, jPanel4, this.pdfInfoLabel);
        this.pdfPathLabel.setVisible(false);
        this.pdfPathField.setVisible(false);
        this.pdfInfoLabel.setVisible(false);
        this.preparePanel();
        this.add(jPanel2);
        this.add(jPanel);
    }

    public void preparePanel() {
        ARepository aRepository = this.setupWindow.aRepository;
        this.booksPathTextArea.setText(aRepository.softcopyDirectories());
        this.indexPathField.setText(aRepository.indexDirectories());
        this.shelvesPathField.setText(aRepository.shelvesDirectories());
        this.pdfPathField.setText(aRepository.pdfDirectories());
        this.bookTypeSelected();
    }

    private void bookTypeSelected() {
        this.booksPathLabel.setVisible(true);
        this.booksPathScrollpane.setVisible(true);
        this.booksInfoLabel.setVisible(true);
        this.indexPathLabel.setVisible(false);
        this.indexPathField.setVisible(false);
        this.indexInfoLabel.setVisible(false);
        this.shelvesPathLabel.setVisible(false);
        this.shelvesPathField.setVisible(false);
        this.shelvesInfoLabel.setVisible(false);
        this.pdfPathLabel.setVisible(false);
        this.pdfPathField.setVisible(false);
    }

    private void bkindexTypeSelected() {
        this.indexPathLabel.setVisible(true);
        this.indexPathField.setVisible(true);
        this.indexInfoLabel.setVisible(true);
        this.booksPathLabel.setVisible(false);
        this.booksPathScrollpane.setVisible(false);
        this.booksInfoLabel.setVisible(false);
        this.shelvesPathLabel.setVisible(false);
        this.shelvesPathField.setVisible(false);
        this.shelvesInfoLabel.setVisible(false);
        this.pdfPathLabel.setVisible(false);
        this.pdfPathField.setVisible(false);
    }

    private void bkshelfTypeSelected() {
        this.shelvesPathLabel.setVisible(true);
        this.shelvesPathField.setVisible(true);
        this.shelvesInfoLabel.setVisible(true);
        this.booksPathLabel.setVisible(false);
        this.booksPathScrollpane.setVisible(false);
        this.booksInfoLabel.setVisible(false);
        this.indexPathLabel.setVisible(false);
        this.indexPathField.setVisible(false);
        this.indexInfoLabel.setVisible(false);
        this.pdfPathLabel.setVisible(false);
        this.pdfPathField.setVisible(false);
    }

    private void pdfTypeSelected() {
        this.pdfPathLabel.setVisible(true);
        this.pdfPathField.setVisible(true);
        this.booksPathLabel.setVisible(false);
        this.booksPathScrollpane.setVisible(false);
        this.booksInfoLabel.setVisible(false);
        this.indexPathLabel.setVisible(false);
        this.indexPathField.setVisible(false);
        this.indexInfoLabel.setVisible(false);
        this.shelvesPathLabel.setVisible(false);
        this.shelvesPathField.setVisible(false);
        this.shelvesInfoLabel.setVisible(false);
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        Component component = focusEvent.getComponent();
        if (component == this.booksPathTextArea) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.booksPathTextArea.getText().trim().length() == 0) {
                return;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(this.booksPathTextArea.getText().trim(), "\n");
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                string = string.substring(0, 1).equals("/") ? "/" + AUtilities.strip(string, '/') + "/" : AUtilities.strip(string, '/') + "/";
                if (string.length() <= 0) continue;
                stringBuffer.append(string + "\n");
            }
            String string = stringBuffer.toString();
            string = AUtilities.strip(stringBuffer.toString(), '\n');
            this.booksPathTextArea.setText(string);
        } else if (component == this.indexPathField) {
            String string = this.indexPathField.getText().trim();
            if (string.length() == 0) {
                return;
            }
            string = string.substring(0, 1).equals("/") ? "/" + AUtilities.strip(string, '/') + "/" : AUtilities.strip(string, '/') + "/";
            this.indexPathField.setText(string);
        } else if (component == this.shelvesPathField) {
            String string = this.shelvesPathField.getText().trim();
            if (string.length() == 0) {
                return;
            }
            string = string.substring(0, 1).equals("/") ? "/" + AUtilities.strip(string, '/') + "/" : AUtilities.strip(string, '/') + "/";
            this.shelvesPathField.setText(string);
        } else if (component == this.pdfPathField) {
            String string = this.pdfPathField.getText().trim();
            if (string.length() == 0) {
                return;
            }
            string = string.substring(0, 1).equals("/") ? "/" + AUtilities.strip(string, '/') + "/" : AUtilities.strip(string, '/') + "/";
            this.pdfPathField.setText(string);
        }
    }

    public boolean saveSettings() {
        ARepository aRepository = this.setupWindow.aRepository;
        if (this.booksPathTextArea.getText().trim().length() == 0) {
            this.setupWindow.setPage(this);
            this.fileTypeList.setSelectedValue(BOOK, true);
            Rectangle rectangle = new Rectangle(this.booksPathTextArea.getX(), this.booksPathTextArea.getY(), this.booksPathTextArea.getWidth(), this.booksPathTextArea.getHeight());
            this.setupWindow.scrollPane(this).getViewport().scrollRectToVisible(rectangle);
            this.booksPathTextArea.requestFocus();
            AUtilities.showInfoMessage("Enter softcopy path");
            return false;
        }
        if (this.indexPathField.getText().trim().length() == 0) {
            this.setupWindow.setPage(this);
            this.fileTypeList.setSelectedValue(BKINDEX, true);
            Rectangle rectangle = new Rectangle(this.indexPathField.getX(), this.indexPathField.getY(), this.indexPathField.getWidth(), this.indexPathField.getHeight());
            this.setupWindow.scrollPane(this).getViewport().scrollRectToVisible(rectangle);
            this.indexPathField.requestFocus();
            AUtilities.showInfoMessage("Enter index path");
            return false;
        }
        if (this.shelvesPathField.getText().trim().length() == 0) {
            this.setupWindow.setPage(this);
            this.fileTypeList.setSelectedValue(BKSHELF, true);
            Rectangle rectangle = new Rectangle(this.shelvesPathField.getX(), this.shelvesPathField.getY(), this.shelvesPathField.getWidth(), this.shelvesPathField.getHeight());
            this.setupWindow.scrollPane(this).getViewport().scrollRectToVisible(rectangle);
            this.shelvesPathField.requestFocus();
            AUtilities.showInfoMessage("Enter shelves path");
            return false;
        }
        aRepository.setSoftcopyDirectories(this.booksPathTextArea.getText());
        aRepository.setIndexDirectories(this.indexPathField.getText());
        aRepository.setShelvesDirectories(this.shelvesPathField.getText());
        aRepository.setPDFDirectories(this.pdfPathField.getText());
        if (!(this.setupWindow.isNewRepository || aRepository.softcopyDirectories().equals(this.setupWindow.orgRepository.softcopyDirectories()) && aRepository.shelvesDirectories().equals(this.setupWindow.orgRepository.shelvesDirectories()) && aRepository.indexDirectories().equals(this.setupWindow.orgRepository.indexDirectories()) && aRepository.pdfDirectories().equals(this.setupWindow.orgRepository.pdfDirectories()))) {
            aRepository.setCatalogValid(false);
        }
        return true;
    }

    protected int setNext() {
        int n = this.fileTypeList.getSelectedIndex();
        if (++n < this.fileTypeList.getModel().getSize()) {
            this.fileTypeList.setSelectedIndex(n);
        }
        return n;
    }

    protected int setPrevious() {
        int n = this.fileTypeList.getSelectedIndex();
        if (--n >= 0) {
            this.fileTypeList.setSelectedIndex(n);
        }
        return n;
    }
}

