/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;

class AFtp {
    private static final String HTML_BREAK = "<br>";
    private static final String HTML_PARAGRAPH = "<P>";
    private static final String HTML_BEGIN = "<HTML>";
    private static final String HTML_END = "</HTML>";
    public static final int FTP_PRELIM = 1;
    public static final int FTP_COMPLETE = 2;
    public static final int FTP_CONTINUE = 3;
    public static final int FTP_ERRORA = 4;
    public static final int FTP_ERROR = 5;
    private final String FTP_ASCII = "A";
    private final String FTP_BINARY = "I";
    private final String FTP_STREAM = "S";
    private final String FTP_BLOCK = "B";
    private final String FTP_FILE = "F";
    private final int CONTROL_SOCKET_TIMEOUT = 30000;
    private final int DATA_SOCKET_TIMEOUT = 30000;
    private final int SERVER_SOCKET_TIMEOUT = 30000;
    private static final byte MARKER_EOR = -128;
    private static final byte MARKER_EOF = 64;
    private static final byte MARKER_RESTART = 16;
    private static final int CONNECT_LOW = 0;
    public static final int NO_PROXY = 1;
    public static final int SOCKS_SERVER = 2;
    public static final int CLASSIC_PROXY = 3;
    private static final int CONNECT_HIGH = 4;
    private String proxyHost;
    private String proxyPort;
    private String localRestartMarker;
    private String remoteRestartMarker;
    private ServerSocket serverSocket;
    private Socket controlSocket;
    private Socket dataSocket;
    private BufferedReader controlStreamReader;
    private PrintWriter controlStreamWriter;
    public InputStream dataStreamReader;
    public OutputStream dataStreamWriter;
    private boolean useActive = false;
    private String currentTransferType;
    private String currentTransferMode;
    private String currentTransferWorkingDirectory;
    private int currentTransferBytesSent;
    private AFtpLogonParameters aFtpLogonParameters;
    private String lastCommandIssued = null;
    private Thread ftpThread;
    private ATraceFile tf = new ATraceFile(this);
    private boolean currentlyConnected;

    private void setConnected(boolean bl) {
        this.currentlyConnected = bl;
    }

    public boolean isConnected() {
        return this.currentlyConnected;
    }

    public AFtpReturnCode verifyConnection() {
        return this.verifyConnection(false);
    }

    public AFtpReturnCode verifyConnection(boolean bl) {
        AFtpReturnCode aFtpReturnCode = this.noop();
        if (aFtpReturnCode.getProcessCode() == 0) {
            this.setConnected(true);
            return aFtpReturnCode;
        }
        return this.logon();
    }

    public AFtp() {
        this.tf.write("AFtp()", 1, "entry");
        this.ftpThread = Thread.currentThread();
        this.setConnected(false);
        this.tf.write("AFtp()", 1, "exit");
    }

    private String addBlank(String string) {
        String string2 = "";
        if (string != null && !(string = string.trim()).equals("")) {
            string2 = " " + string;
        }
        return string2;
    }

    public AFtpReturnCode abor() {
        this.tf.write("abor()", 1, "entry");
        byte[] byArray = new byte[]{-1, -12, -1, -14, 0, 65, 66, 79, 82, 13, 10};
        AFtpReturnCode aFtpReturnCode = this.sendCommandToServer(new String(byArray));
        if (aFtpReturnCode.getProcessCode() == 0) {
            aFtpReturnCode = this.getResponseFromServer();
        }
        this.tf.write("abor()", 1, "exit");
        return aFtpReturnCode;
    }

    public AFtpReturnCode acct(String string) {
        return this.issueStandardCommand("ACCT" + this.addBlank(string));
    }

    public AFtpReturnCode allo(String string) {
        AFtpReturnCode aFtpReturnCode = new AFtpReturnCode();
        aFtpReturnCode.setProcessCode(1);
        aFtpReturnCode.setMessage("Command not implemented");
        return aFtpReturnCode;
    }

    public AFtpReturnCode appe(String string) {
        AFtpReturnCode aFtpReturnCode = new AFtpReturnCode();
        aFtpReturnCode.setProcessCode(1);
        aFtpReturnCode.setMessage("Command not implemented");
        return aFtpReturnCode;
    }

    public AFtpReturnCode cdup() {
        AFtpReturnCode aFtpReturnCode = this.issueStandardCommand("CDUP");
        if (aFtpReturnCode.getCommandCode() == 2) {
            this.currentTransferWorkingDirectory = this.getCurrentWorkingDirectory();
        }
        return aFtpReturnCode;
    }

    public AFtpReturnCode cwd(String string) {
        AFtpReturnCode aFtpReturnCode;
        if (string.length() == 0) {
            aFtpReturnCode = new AFtpReturnCode();
            aFtpReturnCode.setMessage("200 No directory specified");
            aFtpReturnCode.setCommandCode(2);
        } else {
            aFtpReturnCode = this.issueStandardCommand("CWD" + this.addBlank(string));
            if (aFtpReturnCode.getCommandCode() == 2) {
                this.currentTransferWorkingDirectory = this.getCurrentWorkingDirectory();
            }
        }
        return aFtpReturnCode;
    }

    public AFtpReturnCode dele(String string) {
        return this.issueStandardCommand("DELE" + this.addBlank(string));
    }

    public AFtpReturnCode help(String string) {
        return this.issueStandardCommand("HELP" + this.addBlank(string));
    }

    private AFtpReturnCode list(String string) {
        return this.issueStandardCommand("LIST" + this.addBlank(string));
    }

    public AFtpReturnCode mkd(String string) {
        return this.issueStandardCommand("MKD" + this.addBlank(string));
    }

    public AFtpReturnCode mode(String string) {
        this.currentTransferMode = string;
        return this.issueStandardCommand("MODE" + this.addBlank(string));
    }

    private AFtpReturnCode nlst(String string) {
        return this.issueStandardCommand("NLST" + this.addBlank(string));
    }

    public AFtpReturnCode noop() {
        return this.issueStandardCommand("NOOP");
    }

    private AFtpReturnCode pass(String string) {
        this.tf.write("pass()", 1, "entry");
        int n = string.length();
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = 42;
            ++n2;
        }
        String string2 = "PASS " + new String(cArray).substring(0, string.length());
        this.tf.write("pass", 1, string2);
        AStatusWindow.write(string2);
        AFtpReturnCode aFtpReturnCode = this.sendCommandToServer("PASS" + this.addBlank(string));
        if (aFtpReturnCode.getProcessCode() == 0) {
            aFtpReturnCode = this.getResponseFromServer();
        }
        if (aFtpReturnCode.getProcessCode() == 0) {
            Vector vector = aFtpReturnCode.getServerResponse();
            vector.insertElementAt(string2, 0);
            aFtpReturnCode.setServerResponse(vector);
        }
        this.tf.write("pass()", 1, "exit");
        return aFtpReturnCode;
    }

    public AFtpReturnCode port() {
        this.tf.write("port()", 2, "entry");
        AFtpReturnCode aFtpReturnCode = new AFtpReturnCode();
        try {
            this.serverSocket = new ServerSocket(0);
            this.serverSocket.setSoTimeout(30000);
            StringBuffer stringBuffer = new StringBuffer();
            this.serverSocket.getInetAddress();
            String string = stringBuffer.append(InetAddress.getLocalHost().getHostAddress().replace('.', ',')).append(",").append(Integer.toString(this.serverSocket.getLocalPort() / 256)).append(",").append(Integer.toString(this.serverSocket.getLocalPort() % 256)).toString();
            aFtpReturnCode = this.issueStandardCommand("PORT " + string);
        }
        catch (UnknownHostException unknownHostException) {
            this.tf.write("get", 0, unknownHostException.toString());
            aFtpReturnCode.setException(unknownHostException);
            aFtpReturnCode.setProcessCode(229);
            aFtpReturnCode.setMessage("Socket error.  Cannot identify local host.");
            this.serverSocket = null;
        }
        catch (IOException iOException) {
            this.tf.write("get", 0, iOException.toString());
            aFtpReturnCode.setException(iOException);
            aFtpReturnCode.setProcessCode(228);
            aFtpReturnCode.setMessage("Could not obtain a local socket.  Try again later");
            this.serverSocket = null;
        }
        this.tf.write("port()", 2, "exit");
        return aFtpReturnCode;
    }

    public AFtpReturnCode pwd() {
        return this.issueStandardCommand("PWD");
    }

    public AFtpReturnCode quote(String string) {
        return this.issueStandardCommand(string);
    }

    public AFtpReturnCode quit() {
        AFtpReturnCode aFtpReturnCode = this.issueStandardCommand("QUIT");
        this.setConnected(false);
        return aFtpReturnCode;
    }

    private AFtpReturnCode rein(String string) {
        AFtpReturnCode aFtpReturnCode = new AFtpReturnCode();
        aFtpReturnCode.setProcessCode(1);
        aFtpReturnCode.setMessage("Command not implemented");
        return aFtpReturnCode;
    }

    private AFtpReturnCode rest(String string) {
        return this.issueStandardCommand("REST" + this.addBlank(string));
    }

    private AFtpReturnCode retr(String string) {
        return this.issueStandardCommand("RETR" + this.addBlank(string));
    }

    public AFtpReturnCode rmd(String string) {
        return this.issueStandardCommand("RMD" + this.addBlank(string));
    }

    private AFtpReturnCode rnfr(String string) {
        return this.issueStandardCommand("RNFR" + this.addBlank(string));
    }

    private AFtpReturnCode rnto(String string) {
        return this.issueStandardCommand("RNTO" + this.addBlank(string));
    }

    public AFtpReturnCode smnt(String string) {
        return this.issueStandardCommand("SMNT" + this.addBlank(string));
    }

    public AFtpReturnCode stat() {
        return this.issueStandardCommand("STAT");
    }

    private AFtpReturnCode stor(String string) {
        return this.issueStandardCommand("STOR" + this.addBlank(string));
    }

    private AFtpReturnCode stou(String string) {
        return this.issueStandardCommand("STOU" + this.addBlank(string));
    }

    public AFtpReturnCode stru(String string) {
        return this.issueStandardCommand("STRU" + this.addBlank(string));
    }

    public AFtpReturnCode syst(String string) {
        return this.issueStandardCommand("SYST" + this.addBlank(string));
    }

    private AFtpReturnCode type(String string) {
        return this.issueStandardCommand("TYPE" + this.addBlank(string));
    }

    private AFtpReturnCode user(String string) {
        return this.issueStandardCommand("USER" + this.addBlank(string));
    }

    public AFtpReturnCode ascii() {
        this.tf.write("ascii()", 1, "entry");
        AFtpReturnCode aFtpReturnCode = this.type("A");
        if (aFtpReturnCode.getCommandCode() == 2) {
            this.currentTransferType = "A";
        }
        this.tf.write("ascii()", 1, "exit");
        return aFtpReturnCode;
    }

    public AFtpReturnCode binary() {
        this.tf.write("binary()", 1, "entry");
        AFtpReturnCode aFtpReturnCode = this.type("I");
        if (aFtpReturnCode.getCommandCode() == 2) {
            this.currentTransferType = "I";
        }
        this.tf.write("binary()", 1, "exit");
        return aFtpReturnCode;
    }

    public AFtpReturnCode closeSourceFile() {
        this.tf.write("closeSourceFile()", 1, "entry");
        try {
            this.dataSocket.close();
        }
        catch (Exception exception) {
            this.tf.write("closeSourceFile()", 0, exception.toString());
        }
        AFtpReturnCode aFtpReturnCode = this.getResponseFromServer();
        this.tf.write("closeSourceFile()", 1, "exit");
        return aFtpReturnCode;
    }

    public AFtpReturnCode closeTargetFile(String string, String string2) {
        this.tf.write("closeTargetFile()", 1, "entry");
        try {
            this.dataSocket.close();
        }
        catch (Exception exception) {
            this.tf.write("closeTargetFile()", 0, exception.toString());
        }
        AFtpReturnCode aFtpReturnCode = this.getResponseFromServer();
        if (!(aFtpReturnCode.getCommandCode() != 2 || string2.equals("") || (aFtpReturnCode = this.dele(string2)).getCommandCode() != 2 && aFtpReturnCode.getCommandCode() != 5 || (aFtpReturnCode = this.rnfr(string)).getCommandCode() != 3)) {
            aFtpReturnCode = this.rnto(string2);
        }
        this.tf.write("closeTargetFile()", 1, "exit");
        return aFtpReturnCode;
    }

    public AFtpReturnCode dir(String string, ByteArrayOutputStream byteArrayOutputStream) {
        return this.dir(string, byteArrayOutputStream, true);
    }

    public AFtpReturnCode dir(String string, ByteArrayOutputStream byteArrayOutputStream, boolean bl) {
        this.tf.write("dir()", 1, "entry");
        this.tf.write("dir()", 0, "parameters = \"" + string + "\"");
        this.useActive = false;
        AFtpReturnCode aFtpReturnCode = this.ascii();
        if (aFtpReturnCode.getCommandCode() == 2) {
            aFtpReturnCode = this.useActive ? this.port() : this.pasv();
        }
        if (aFtpReturnCode.getCommandCode() == 2) {
            AFtpReturnCode aFtpReturnCode2 = aFtpReturnCode = bl ? this.list(string) : this.nlst(string);
        }
        if (aFtpReturnCode.getCommandCode() == 1) {
            if (this.useActive) {
                aFtpReturnCode = this.openActiveDataConnectionNoProxy();
            }
            if (aFtpReturnCode.getProcessCode() == 0) {
                aFtpReturnCode = this.getDataFromServer(byteArrayOutputStream, 1, "Listing directory " + string);
            }
        } else {
            if (!this.useActive) {
                try {
                    this.dataSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return aFtpReturnCode;
        }
        aFtpReturnCode = this.getResponseFromServer();
        this.tf.write("dir()", 1, "exit");
        return aFtpReturnCode;
    }

    public AFtpReturnCode get(String string, String string2) {
        return this.get(string, string2, 0);
    }

    public AFtpReturnCode get(String string, String string2, int n) {
        boolean bl = true;
        this.tf.write("get()", 1, "entry");
        this.tf.write("get()", 1, "remoteFile = \"" + string2 + "\"");
        this.tf.write("get()", 1, "localFile = \"" + string + "\"");
        AFtpReturnCode aFtpReturnCode = new AFtpReturnCode();
        this.useActive = false;
        this.tf.write("get()", 1, "mode = " + (this.useActive ? "active" : "passive"));
        AStatusWindow.write("#Get \"" + string + "\" from \"" + string2 + "\"");
        int n2 = this.currentTransferType.equals("I") ? 3 : 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n3 = 0;
        if (!this.currentTransferMode.equals("S")) {
            aFtpReturnCode = this.mode("S");
        }
        if (aFtpReturnCode.getProcessCode() == 0 && aFtpReturnCode.getCommandCode() == 0) {
            aFtpReturnCode.setCommandCode(2);
        }
        int n4 = 0;
        while (n4 <= n2 && !Thread.currentThread().isInterrupted()) {
            if (aFtpReturnCode.getCommandCode() == 2) {
                aFtpReturnCode = this.useActive ? this.port() : this.pasv();
            }
            if (aFtpReturnCode.getCommandCode() == 2 && n4 > 0) {
                if (this.rest(String.valueOf(byteArrayOutputStream.size())).getCommandCode() == 3) {
                    n3 = byteArrayOutputStream.size();
                    this.tf.write("get", 0, "Re-starting transfer in middle of file...");
                } else {
                    byteArrayOutputStream.reset();
                    this.tf.write("get", 0, "Re-starting transfer from beginning of file...");
                }
            }
            if (aFtpReturnCode.getCommandCode() == 2 || aFtpReturnCode.getCommandCode() == 3) {
                aFtpReturnCode = this.retr(string2);
            }
            if (aFtpReturnCode.getCommandCode() != 1 || this.useActive && (aFtpReturnCode = this.openActiveDataConnectionNoProxy()).getProcessCode() != 0) break;
            AFtpReturnCode aFtpReturnCode2 = this.getDataFromServer(byteArrayOutputStream, n, "Source: " + string2 + HTML_BREAK + "Target: " + string);
            if (Thread.currentThread().isInterrupted()) break;
            aFtpReturnCode = this.getResponseFromServer();
            if (aFtpReturnCode2.getProcessCode() == 0) {
                File file = new File(string);
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    fileOutputStream.write(byteArrayOutputStream.toByteArray());
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    this.tf.write("get", 0, iOException.toString());
                    aFtpReturnCode.setException(iOException);
                    aFtpReturnCode.setProcessCode(227);
                    aFtpReturnCode.setMessage("Error writing file: " + file.getAbsolutePath());
                }
                break;
            }
            if (aFtpReturnCode.getProcessCode() == 0) {
                this.tf.write("get", 0, "Server returned error.  Stop transfer");
                break;
            }
            if (n3 > 0) {
                if (n3 == byteArrayOutputStream.size()) {
                    this.tf.write("get", 0, "No more data being received.  Stop transfer");
                    break;
                }
                n4 = 0;
            } else if (n4 >= n2) {
                this.tf.write("get", 0, "Exceeded maximum number of retries.  Stop transfer");
                break;
            }
            this.tf.write("get", 0, "Internet error during download...");
            aFtpReturnCode = this.noop();
            if (aFtpReturnCode.getProcessCode() != 0) {
                this.tf.write("get", 0, "Attempting re-connect to host...");
                aFtpReturnCode = this.logon();
                if (aFtpReturnCode.getCommandCode() != 2) {
                    if (aFtpReturnCode.getCommandCode() != 1) {
                        this.tf.write("get", 0, "User canceled logon.  Stop transfer.");
                    } else {
                        this.tf.write("get", 0, "Unrecoverable error during logon.  Stop transfer.");
                    }
                    aFtpReturnCode = aFtpReturnCode2;
                    break;
                }
                if (!this.currentTransferWorkingDirectory.equals("")) {
                    aFtpReturnCode = this.cwd(this.currentTransferWorkingDirectory);
                }
                if (aFtpReturnCode.getCommandCode() == 2) {
                    aFtpReturnCode = this.type(this.currentTransferType);
                }
                if (aFtpReturnCode.getCommandCode() != 2) break;
            }
            ++n4;
        }
        try {
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.tf.write("get()", 1, "exit");
        return aFtpReturnCode;
    }

    private String getCurrentWorkingDirectory() {
        String string = "";
        AFtpReturnCode aFtpReturnCode = this.pwd();
        if (aFtpReturnCode.getCommandCode() == 2) {
            int n = -1;
            int n2 = -1;
            String string2 = (String)aFtpReturnCode.getServerResponse().elementAt(1);
            n = string2.indexOf(34);
            if (n >= 0 && (n2 = string2.indexOf(34, n + 1)) >= 0) {
                string = string2.substring(n + 1, n2);
            }
        }
        return string;
    }

    private AFtpReturnCode getDataFromServer(ByteArrayOutputStream byteArrayOutputStream) {
        return this.getDataFromServer(byteArrayOutputStream, 0, null);
    }

    private AFtpReturnCode getDataFromServer(ByteArrayOutputStream byteArrayOutputStream, int n, String string) {
        long l;
        this.tf.write("getDataFromServer()", 2, "entry");
        boolean bl = true;
        AFtpReturnCode aFtpReturnCode = new AFtpReturnCode();
        int n2 = 0;
        int n3 = byteArrayOutputStream.size();
        int n4 = 0;
        int n5 = 0;
        byte[] byArray = new byte[65536];
        long l2 = l = System.currentTimeMillis();
        AProgressObject aProgressObject = null;
        String string2 = null;
        String string3 = null;
        if (n > 0) {
            aProgressObject = new AProgressObject((AMainWindow)AUtilities.mainWindow, 1, false, true);
            string2 = string + HTML_BREAK + HTML_BREAK;
            string3 = " bytes received";
            aProgressObject.setText(string2 + String.valueOf(0) + string3);
        }
        try {
            if (bl) {
                int n6 = 65536;
                int n7 = 65536;
                while ((n2 = this.dataStreamReader.read(byArray, n4, n6 - n4)) != -1 && !Thread.currentThread().isInterrupted()) {
                    String string4;
                    int n8;
                    long l3;
                    n4 += n2;
                    if (n == 1) {
                        n5 += n2;
                        l3 = System.currentTimeMillis();
                        int n9 = (int)(l3 - l2);
                        if (n9 == 0) {
                            n9 = 1;
                        }
                        n8 = n5 / n9;
                        string4 = string + HTML_BREAK + HTML_BREAK + String.valueOf(n3 + n4) + " bytes at " + String.valueOf(n8) + "KBps";
                        this.tf.write("getDataFromServer()", 2, string4);
                        aProgressObject.setText(string4);
                    }
                    if (n4 != n6) continue;
                    this.tf.write("getDataFromServer()", 2, "Bytes received: " + Integer.toString(n3 += n6));
                    byteArrayOutputStream.write(byArray, 0, n6);
                    n4 = 0;
                    if (n3 % n7 != 0) continue;
                    l3 = System.currentTimeMillis();
                    n8 = n7 / (l3 == l ? 1 : (int)(l3 - l));
                    this.tf.write("getDataFromServer()", 2, Integer.toString(n3) + " bytes at " + Integer.toString(n8) + "KBps");
                    if (n == 2) {
                        string4 = string + HTML_BREAK + HTML_BREAK + String.valueOf(n3) + " bytes at " + String.valueOf(n8) + "KBps";
                        aProgressObject.setText(string4);
                    }
                    l = l3;
                }
                if (!Thread.currentThread().isInterrupted()) {
                    byteArrayOutputStream.write(byArray, 0, n4);
                    this.tf.write("getDataFromServer", 1, "Total data bytes: " + Integer.toString(byteArrayOutputStream.size()));
                }
            }
        }
        catch (IOException iOException) {
            this.tf.write("getDataFromServer", 0, iOException.toString());
            aFtpReturnCode.setException(iOException);
            aFtpReturnCode.setProcessCode(224);
            aFtpReturnCode.setMessage("Socket error reading data from host");
        }
        try {
            this.dataSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (n > 0) {
            aProgressObject.removeProgressObject();
        }
        this.tf.write("getDataFromServer()", 2, "exit");
        return aFtpReturnCode;
    }

    public AFtpReturnCode getResponseFromServer() {
        AFtpReturnCode aFtpReturnCode;
        block8: {
            String string;
            this.tf.write("getResponseFromServer()", 2, "entry");
            aFtpReturnCode = new AFtpReturnCode();
            Vector<String> vector = new Vector<String>(1, 1);
            while (true) {
                try {
                    string = this.controlStreamReader.readLine();
                }
                catch (Exception exception) {
                    this.tf.write("getResponseFromServer()", 0, exception.toString());
                    aFtpReturnCode.setException(exception);
                    String string2 = exception.getClass().getName();
                    if (string2.equals("java.io.InterruptedException")) {
                        String string3;
                        if (!vector.isEmpty() && (string3 = (String)vector.lastElement()).startsWith("125-")) {
                            this.tf.write("getResponseFromServer()", 0, "Timeout waiting for dataset recall");
                            continue;
                        }
                        aFtpReturnCode.setProcessCode(205);
                        aFtpReturnCode.setMessage("Timeout waiting for a response from the host");
                    } else {
                        aFtpReturnCode.setProcessCode(206);
                        aFtpReturnCode.setMessage("Failed to receive a response from the host");
                    }
                    break block8;
                }
                if (string == null) {
                    this.tf.write("getResponseFromServer()", 0, "Null response from host");
                    aFtpReturnCode.setMessage("No response from host");
                    aFtpReturnCode.setProcessCode(233);
                    break block8;
                }
                vector.addElement(string);
                this.tf.write("getResponseFromServer()", 0, string);
                AStatusWindow.write(string);
                if (string.length() > 3 && Character.isDigit(string.charAt(0)) && Character.isDigit(string.charAt(1)) && Character.isDigit(string.charAt(2)) && string.charAt(3) == ' ') break;
            }
            int n = Integer.parseInt(string.substring(0, 1));
            if (n == 4) {
                n = 5;
            }
            aFtpReturnCode.setCommandCode(n);
            aFtpReturnCode.setServerResponse(vector);
        }
        this.tf.write("getResponseFromServer()", 2, "exit");
        return aFtpReturnCode;
    }

    public void interrupt() {
        this.tf.write("interrupt()", 1, "entry");
        this.ftpThread.interrupt();
        this.tf.write("interrupt()", 1, "exit");
    }

    private AFtpReturnCode issueStandardCommand(String string) {
        this.tf.write("issueStandardCommand()", 1, "entry");
        this.tf.write("issueStandardCommand()", 0, string);
        AStatusWindow.write(string);
        AFtpReturnCode aFtpReturnCode = this.sendCommandToServer(string);
        if (aFtpReturnCode.getProcessCode() == 0) {
            aFtpReturnCode = this.getResponseFromServer();
        }
        if (aFtpReturnCode.getProcessCode() == 0) {
            Vector vector = aFtpReturnCode.getServerResponse();
            vector.insertElementAt(string, 0);
            aFtpReturnCode.setServerResponse(vector);
        }
        this.tf.write("issueStandardCommand()", 1, "exit");
        return aFtpReturnCode;
    }

    public AFtpReturnCode logon() {
        AFtpLogonWindow aFtpLogonWindow;
        this.tf.write("logon()", 1, "entry");
        AFtpReturnCode aFtpReturnCode = new AFtpReturnCode();
        boolean bl = false;
        Vector vector = new Vector(0, 1);
        ARepository aRepository = this.aFtpLogonParameters.getRepository();
        if (aRepository != null && (this.aFtpLogonParameters.getHostType() == 1 || this.aFtpLogonParameters.getHostType() == 1) && (this.aFtpLogonParameters.getUserid().equals("") || this.aFtpLogonParameters.getPassword().equals(""))) {
            aFtpLogonWindow = new AFtpLogonWindow(AUtilities.mainWindow, this.aFtpLogonParameters, "Enter your userid and password");
            if (aFtpLogonWindow.getUserCanceled()) {
                aFtpReturnCode = new AFtpReturnCode();
                aFtpReturnCode.setProcessCode(1);
                aFtpReturnCode.setMessage("User canceled");
                this.tf.write("logon()", 0, "User canceled from AFtpLogon window");
                return aFtpReturnCode;
            }
            if (this.aFtpLogonParameters.isChanged()) {
                aRepository.setFtpUserid(aFtpLogonWindow.getUserid());
                aRepository.setFtpPassword(aFtpLogonWindow.getPassword());
            }
        }
        while (true) {
            Serializable serializable;
            if (bl) {
                serializable = aRepository == null ? null : AUtilities.mainWindow;
                aFtpLogonWindow = new AFtpLogonWindow((JFrame)serializable, this.aFtpLogonParameters, aFtpReturnCode);
                if (aFtpLogonWindow.getUserCanceled()) {
                    aFtpReturnCode = new AFtpReturnCode();
                    aFtpReturnCode.setProcessCode(1);
                    aFtpReturnCode.setMessage("User canceled");
                    this.tf.write("logon()", 0, "User canceled from AFtpLogon window");
                    return aFtpReturnCode;
                }
                if (this.aFtpLogonParameters.isChanged() && this.aFtpLogonParameters.getRepository() != null) {
                    aRepository.setFtpUserid(aFtpLogonWindow.getUserid());
                    aRepository.setFtpPassword(aFtpLogonWindow.getPassword());
                }
                bl = false;
            }
            vector.removeAllElements();
            this.aFtpLogonParameters.setConnectionType(1);
            switch (this.aFtpLogonParameters.getConnectionType()) {
                case 1: {
                    aFtpReturnCode = this.openControlConnectionNoProxy(this.aFtpLogonParameters);
                    break;
                }
                case 2: {
                    aFtpReturnCode = this.openControlConnectionSocksServer(this.aFtpLogonParameters);
                    break;
                }
            }
            if (aFtpReturnCode.getProcessCode() == 0) {
                aFtpReturnCode = this.getResponseFromServer();
            }
            if (aFtpReturnCode.getCommandCode() == 2) {
                vector.addAll(aFtpReturnCode.getServerResponse());
                aFtpReturnCode = this.user(this.aFtpLogonParameters.getUserid());
            }
            if (aFtpReturnCode.getCommandCode() == 3) {
                vector.addAll(aFtpReturnCode.getServerResponse());
                aFtpReturnCode = this.pass(this.aFtpLogonParameters.getPassword());
            }
            if (aFtpReturnCode.getCommandCode() == 2) {
                serializable = this.aFtpLogonParameters.getLogonCommands();
                Enumeration enumeration = ((Vector)serializable).elements();
                while (enumeration.hasMoreElements()) {
                    vector.addAll(aFtpReturnCode.getServerResponse());
                    aFtpReturnCode = this.issueStandardCommand((String)enumeration.nextElement());
                    if (aFtpReturnCode.getCommandCode() == 2) continue;
                }
            }
            if (aFtpReturnCode.getCommandCode() == 2) {
                vector.addAll(aFtpReturnCode.getServerResponse());
                aFtpReturnCode = this.mode("S");
            }
            if (aFtpReturnCode.getCommandCode() == 2) {
                vector.addAll(aFtpReturnCode.getServerResponse());
                aFtpReturnCode = this.stru("F");
            }
            if (aFtpReturnCode.getCommandCode() == 2) {
                vector.addAll(aFtpReturnCode.getServerResponse());
                if (this.aFtpLogonParameters.getHostType() == 1) {
                    aFtpReturnCode = this.quote("SITE DATASETMODE NOAUTORECALL RETPD QUOTESOVERRIDE CONDDISP=DELETE NOWRAPRECORD UCSTRUNC UCSSUB");
                } else if (this.aFtpLogonParameters.getHostType() == 3) {
                    aFtpReturnCode = this.quote("SITE DATASETMODE NOAUTORECALL RETPD CONDDISP=DELETE NOWRAPRECORD UCSTRUNC UCSSUB");
                } else if (this.aFtpLogonParameters.getHostType() == 4) {
                    // empty if block
                }
            }
            if (aFtpReturnCode.getCommandCode() == 2) break;
            bl = true;
        }
        vector.addAll(aFtpReturnCode.getServerResponse());
        aFtpReturnCode.setServerResponse(vector);
        this.setConnected(true);
        if (aFtpReturnCode.getCommandCode() != 2) {
            try {
                this.controlSocket.close();
            }
            catch (IOException iOException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        this.tf.write("logon()", 1, "exit");
        return aFtpReturnCode;
    }

    public String makeTempName(String string) {
        String string2;
        this.tf.write("makeTempName()", 2, "entry.  inName = " + string);
        int n = -1;
        String string3 = string.replace('\\', '.').replace('/', '.');
        int n2 = string.lastIndexOf(46);
        if (n2 < 0) {
            n = string3.lastIndexOf(46);
            string2 = n < 0 ? "EBRXTEMP" : string.substring(0, n + 1) + "EBRXTEMP";
        } else if (n2 == 0) {
            string2 = "EBRXTEMP" + string;
        } else {
            n = string3.lastIndexOf(46, n2 - 1);
            if (n < 0) {
                string2 = "EBRXTEMP" + string.substring(n2);
                if (string.startsWith("'")) {
                    string2 = "'" + string2;
                } else if (string.startsWith("/")) {
                    string2 = "/" + string2;
                } else if (string.startsWith("\\")) {
                    string2 = "\\" + string2;
                }
            } else {
                string2 = string.substring(0, n + 1) + "EBRXTEMP" + string.substring(n2);
            }
        }
        this.tf.write("makeTempName()", 2, "exit.  outName = " + string2);
        return string2;
    }

    /*
     * Loose catch block
     */
    private AFtpReturnCode openActiveDataConnectionNoProxy() {
        AFtpReturnCode aFtpReturnCode;
        block16: {
            this.tf.write("openActiveDataConnectionNoProxy()", 2, "entry");
            aFtpReturnCode = new AFtpReturnCode();
            this.dataSocket = this.serverSocket.accept();
            Object var5_2 = null;
            try {
                this.serverSocket.close();
                break block16;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            {
                break block16;
                catch (IOException iOException) {
                    this.tf.write("openActiveDataConnectionNoProxy()", 0, iOException.toString());
                    aFtpReturnCode.setProcessCode(230);
                    aFtpReturnCode.setException(iOException);
                    aFtpReturnCode.setMessage("Unknown TCP/IP error setting options after connecting to host.");
                    AFtpReturnCode aFtpReturnCode2 = aFtpReturnCode;
                    Object var5_3 = null;
                    try {
                        this.serverSocket.close();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    this.serverSocket = null;
                    return aFtpReturnCode2;
                }
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                try {
                    this.serverSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.serverSocket = null;
                throw throwable;
            }
        }
        this.serverSocket = null;
        try {
            this.dataSocket.setSoTimeout(30000);
        }
        catch (SocketException socketException) {
            this.tf.write("openActiveDataConnectionNoProxy", 0, socketException.toString());
            aFtpReturnCode.setProcessCode(231);
            aFtpReturnCode.setException(socketException);
            aFtpReturnCode.setMessage("Unknown TCP/IP error setting options after connecting to host.");
            try {
                this.dataSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return aFtpReturnCode;
        }
        try {
            this.dataStreamReader = this.dataSocket.getInputStream();
            this.dataStreamWriter = this.dataSocket.getOutputStream();
        }
        catch (IOException iOException) {
            this.tf.write("openActiveDataConnectionNoProxy", 0, iOException.toString());
            aFtpReturnCode.setProcessCode(232);
            aFtpReturnCode.setException(iOException);
            aFtpReturnCode.setMessage("Error while initializing I/O after connecting to host.");
            try {
                this.dataSocket.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
            return aFtpReturnCode;
        }
        this.tf.write("openActiveDataConnectionNoProxy()", 2, "exit");
        return aFtpReturnCode;
    }

    public AFtpReturnCode openControlConnectionNoProxy(AFtpLogonParameters aFtpLogonParameters) {
        this.tf.write("openControlConnectionNoProxy()", 1, "entry");
        this.tf.write("openControlConnectionNoProxy()", 2, "host: \"" + aFtpLogonParameters.getHost() + "\"");
        this.tf.write("openControlConnectionNoProxy()", 2, "port: \"" + aFtpLogonParameters.getPort() + "\"");
        AFtpTimedSocket aFtpTimedSocket = new AFtpTimedSocket(aFtpLogonParameters.getHost(), aFtpLogonParameters.getPort());
        AFtpReturnCode aFtpReturnCode = aFtpTimedSocket.connect();
        if (aFtpReturnCode.getProcessCode() == 0) {
            this.controlSocket = aFtpTimedSocket.getSocket();
        }
        if (aFtpReturnCode.getProcessCode() == 0) {
            try {
                this.controlSocket.setSoTimeout(30000);
            }
            catch (SocketException socketException) {
                this.tf.write("openControlConnectionNoProxy", 0, socketException.toString());
                aFtpReturnCode.setProcessCode(208);
                aFtpReturnCode.setException(socketException);
                aFtpReturnCode.setMessage("Unknown TCP/IP error setting options after connecting to host.");
                try {
                    this.controlSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (aFtpReturnCode.getProcessCode() == 0) {
            try {
                this.controlStreamReader = new BufferedReader(new InputStreamReader(this.controlSocket.getInputStream()));
                this.controlStreamWriter = new PrintWriter(this.controlSocket.getOutputStream(), true);
            }
            catch (IOException iOException) {
                this.tf.write("openControlConnectionNoProxy", 0, iOException.toString());
                aFtpReturnCode.setProcessCode(207);
                aFtpReturnCode.setException(iOException);
                aFtpReturnCode.setMessage("Error while initializing I/O after connecting to host.");
                try {
                    this.controlSocket.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
        }
        this.tf.write("openControlConnectionNoProxy()", 1, "exit");
        return aFtpReturnCode;
    }

    /*
     * Unable to fully structure code
     */
    public AFtpReturnCode openControlConnectionSocksServer(AFtpLogonParameters var1_1) {
        block26: {
            this.tf.write("openControlConnectionSocksServer()", 1, "entry");
            var2_2 = new AFtpReturnCode();
            var7_3 = var1_1.getHost();
            var8_4 = Integer.parseInt(var1_1.getPort());
            var9_5 = new byte[var7_3.length() + 5];
            var10_6 = new byte[var7_3.length() + 20];
            var12_7 = System.getProperties();
            this.proxyHost = var12_7.getProperty("socksProxyHost", "");
            this.proxyPort = var12_7.getProperty("socksProxyPort", "");
            this.tf.write("openControlConnectionSocksServer()", 2, "proxy host: \"" + this.proxyHost + "\"");
            this.tf.write("openControlConnectionSocksServer()", 2, "proxy port: \"" + this.proxyPort + "\"");
            if (this.proxyPort.equals("")) {
                this.proxyPort = "1080";
            }
            if (this.proxyHost.equals("")) {
                this.tf.write("openControlConnectionSocksServer", 0, "Proxy host address is blank.");
                var2_2.setProcessCode(234);
                var2_2.setMessage("No proxy address specified");
                return var2_2;
            }
            var3_8 = new AFtpTimedSocket(this.proxyHost, this.proxyPort);
            var2_2 = var3_8.connect();
            if (var2_2.getProcessCode() != 0) {
                return var2_2;
            }
            this.controlSocket = var3_8.getSocket();
            try {
                this.controlSocket.setSoTimeout(30000);
            }
            catch (SocketException var13_9) {
                this.tf.write("openControlConnectionSocksServer()", 0, var13_9.toString());
                var2_2.setProcessCode(210);
                var2_2.setException(var13_9);
                var2_2.setMessage("Unknown TCP/IP error setting options after connecting to host.");
                try {
                    this.controlSocket.close();
                }
                catch (IOException var14_15) {
                    // empty catch block
                }
                return var2_2;
            }
            var10_6[0] = 4;
            var10_6[1] = 1;
            var10_6[2] = (byte)(var8_4 / 256);
            var10_6[3] = (byte)(var8_4 % 256);
            var11_21 = 9;
            try {
                var4_22 = InetAddress.getByName(var1_1.getHost());
                var9_5 = var4_22.getAddress();
                var10_6[4] = var9_5[0];
                var10_6[5] = var9_5[1];
                var10_6[6] = var9_5[2];
                var10_6[7] = var9_5[3];
                var10_6[8] = 0;
                break block26;
            }
            catch (UnknownHostException var13_10) {
                var10_6[4] = 0;
                var10_6[5] = 0;
                var10_6[6] = 0;
                var10_6[7] = 1;
                var10_6[8] = 0;
                var9_5 = var7_3.getBytes();
                var14_16 = 0;
                ** while (var14_16 < var7_3.length())
            }
lbl-1000:
            // 1 sources

            {
                var10_6[var11_21++] = var9_5[var14_16];
                ++var14_16;
                continue;
            }
lbl64:
            // 1 sources

            var10_6[var11_21++] = 0;
        }
        try {
            var5_23 = this.controlSocket.getInputStream();
            var6_24 = this.controlSocket.getOutputStream();
            this.controlStreamReader = new BufferedReader(new InputStreamReader(var5_23));
            this.controlStreamWriter = new PrintWriter(var6_24, true);
        }
        catch (IOException var13_11) {
            this.tf.write("openControlConnectionSocksServer()", 0, var13_11.toString());
            var2_2.setProcessCode(209);
            var2_2.setException(var13_11);
            var2_2.setMessage("Error while initializing I/O after connecting to host.");
            try {
                this.controlSocket.close();
            }
            catch (IOException var14_17) {
                // empty catch block
            }
            return var2_2;
        }
        try {
            var6_24.write(var10_6, 0, 9);
            var6_24.flush();
        }
        catch (IOException var13_12) {
            this.tf.write("openControlConnectionSocksServer()", 0, var13_12.toString());
            var2_2.setProcessCode(212);
            var2_2.setException(var13_12);
            var2_2.setMessage("Could not make initial contact with socks server " + var1_1.getProxyServer());
            try {
                this.controlSocket.close();
            }
            catch (IOException var14_18) {
                // empty catch block
            }
            return var2_2;
        }
        try {
            var5_23.read(var10_6, 0, 8);
        }
        catch (InterruptedIOException var13_13) {
            this.tf.write("openControlConnectionSocksServer()", 0, var13_13.toString());
            var2_2.setException(var13_13);
            var2_2.setProcessCode(211);
            var2_2.setMessage("Timeout waiting for respose from socks server " + var1_1.getProxyServer());
            try {
                this.controlSocket.close();
            }
            catch (IOException var14_19) {
                // empty catch block
            }
            return var2_2;
        }
        catch (IOException var14_20) {
            this.tf.write("openControlConnectionSocksServer()", 0, var14_20.toString());
            var2_2.setProcessCode(213);
            var2_2.setException(var14_20);
            var2_2.setMessage("I/O error receiving initial response from socks server " + var1_1.getProxyServer());
            try {
                this.controlSocket.close();
            }
            catch (IOException var15_25) {
                // empty catch block
            }
            return var2_2;
        }
        if (var10_6[1] != 90) {
            var13_14 = "Socks server connection failed.  RC = " + Byte.toString(var10_6[1]);
            this.tf.write("openControlConnectionSocksServer()", 0, var13_14);
            var2_2.setProcessCode(214);
            var2_2.setMessage(var13_14);
            return var2_2;
        }
        this.tf.write("openControlConnectionSocksServer()", 1, "Connected to host " + var1_1.getHost());
        this.tf.write("openControlConnectionSocksServer()", 1, "exit");
        return var2_2;
    }

    public AFtpReturnCode openPassiveDataConnectionNoProxy(AFtpLogonParameters aFtpLogonParameters) {
        this.tf.write("openPassiveDataConnectionNoProxy()", 1, "entry");
        this.tf.write("openPassiveDataConnectionNoProxy()", 2, "host: \"" + aFtpLogonParameters.getHost() + "\"");
        this.tf.write("openPassiveDataConnectionNoProxy()", 2, "port: \"" + aFtpLogonParameters.getPort() + "\"");
        AFtpTimedSocket aFtpTimedSocket = new AFtpTimedSocket(aFtpLogonParameters.getHost(), aFtpLogonParameters.getPort());
        AFtpReturnCode aFtpReturnCode = aFtpTimedSocket.connect();
        if (aFtpReturnCode.getProcessCode() == 0) {
            this.dataSocket = aFtpTimedSocket.getSocket();
        }
        if (aFtpReturnCode.getProcessCode() == 0) {
            try {
                this.dataSocket.setSoTimeout(30000);
            }
            catch (SocketException socketException) {
                this.tf.write("openpassiveDataConnectionNoProxy", 0, socketException.toString());
                aFtpReturnCode.setProcessCode(208);
                aFtpReturnCode.setException(socketException);
                aFtpReturnCode.setMessage("Unknown TCP/IP error setting options after connecting to host.");
                try {
                    this.dataSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (aFtpReturnCode.getProcessCode() == 0) {
            try {
                this.dataStreamReader = this.dataSocket.getInputStream();
                this.dataStreamWriter = this.dataSocket.getOutputStream();
            }
            catch (IOException iOException) {
                this.tf.write("openPassiveDataConnectionNoProxyServer", 0, iOException.toString());
                aFtpReturnCode.setProcessCode(207);
                aFtpReturnCode.setException(iOException);
                aFtpReturnCode.setMessage("Error while initializing I/O after connecting to host.");
                try {
                    this.dataSocket.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
        }
        this.tf.write("openPassiveDataConnectionNoProxy()", 1, "exit");
        return aFtpReturnCode;
    }

    /*
     * Unable to fully structure code
     */
    public AFtpReturnCode openPassiveDataConnectionSocksServer(AFtpLogonParameters var1_1) {
        block24: {
            this.tf.write("openPassiveDataConnectionSocksServer()", 1, "entry");
            var5_2 = new byte[var1_1.getHost().length() + 5];
            var6_3 = new byte[var1_1.getHost().length() + 20];
            var8_4 = Integer.parseInt(var1_1.getPort());
            var3_5 = new AFtpTimedSocket(this.proxyHost, this.proxyPort);
            var2_6 = var3_5.connect();
            if (var2_6.getProcessCode() != 0) {
                return var2_6;
            }
            this.dataSocket = var3_5.getSocket();
            try {
                this.dataSocket.setSoTimeout(30000);
            }
            catch (SocketException var9_7) {
                this.tf.write("openPassiveDataConnectionSocksServer()", 0, var9_7.toString());
                var2_6.setProcessCode(218);
                var2_6.setException(var9_7);
                var2_6.setMessage("Unknown TCP/IP error setting options after making data connection to host.");
                try {
                    this.dataSocket.close();
                }
                catch (IOException var10_13) {
                    // empty catch block
                }
                return var2_6;
            }
            var6_3[0] = 4;
            var6_3[1] = 1;
            var6_3[2] = (byte)(var8_4 / 256);
            var6_3[3] = (byte)(var8_4 % 256);
            var7_19 = 9;
            try {
                var4_20 = InetAddress.getByName(var1_1.getHost());
                var5_2 = var4_20.getAddress();
                var6_3[4] = var5_2[0];
                var6_3[5] = var5_2[1];
                var6_3[6] = var5_2[2];
                var6_3[7] = var5_2[3];
                var6_3[8] = 0;
                break block24;
            }
            catch (UnknownHostException var9_8) {
                var6_3[4] = 0;
                var6_3[5] = 0;
                var6_3[6] = 0;
                var6_3[7] = 1;
                var6_3[8] = 0;
                var5_2 = var1_1.getHost().getBytes();
                var10_14 = 0;
                ** while (var10_14 < var1_1.getHost().length())
            }
lbl-1000:
            // 1 sources

            {
                var6_3[var7_19++] = var5_2[var10_14];
                ++var10_14;
                continue;
            }
lbl50:
            // 1 sources

            var6_3[var7_19++] = 0;
        }
        try {
            this.dataStreamReader = this.dataSocket.getInputStream();
            this.dataStreamWriter = this.dataSocket.getOutputStream();
        }
        catch (IOException var9_9) {
            this.tf.write("openPassiveDataConnectionSocksServer()", 0, var9_9.toString());
            var2_6.setProcessCode(217);
            var2_6.setException(var9_9);
            var2_6.setMessage("Error while initializing I/O after making data connection to host.");
            try {
                this.dataSocket.close();
            }
            catch (IOException var10_15) {
                // empty catch block
            }
            return var2_6;
        }
        try {
            this.dataStreamWriter.write(var6_3, 0, 9);
            this.dataStreamWriter.flush();
        }
        catch (IOException var9_10) {
            this.tf.write("openPassiveDataConnectionSocksServer()", 0, var9_10.toString());
            var2_6.setProcessCode(220);
            var2_6.setException(var9_10);
            var2_6.setMessage("Could not make contact for data connection with socks server " + var1_1.getProxyServer());
            try {
                this.dataSocket.close();
            }
            catch (IOException var10_16) {
                // empty catch block
            }
            return var2_6;
        }
        try {
            this.dataStreamReader.read(var6_3, 0, 8);
        }
        catch (InterruptedIOException var9_11) {
            this.tf.write("openPassiveDataConnectionSocksServer()", 0, var9_11.toString());
            var2_6.setException(var9_11);
            var2_6.setProcessCode(219);
            var2_6.setMessage("Timeout waiting for data connection respose from socks server " + var1_1.getProxyServer());
            try {
                this.dataSocket.close();
            }
            catch (IOException var10_17) {
                // empty catch block
            }
            return var2_6;
        }
        catch (IOException var10_18) {
            this.tf.write("openPassiveDataConnectionSocksServer()", 0, var10_18.toString());
            var2_6.setProcessCode(221);
            var2_6.setException(var10_18);
            var2_6.setMessage("I/O error receiving initial response on data connection from socks server " + var1_1.getProxyServer());
            try {
                this.dataSocket.close();
            }
            catch (IOException var11_21) {
                // empty catch block
            }
            return var2_6;
        }
        if (var6_3[1] != 90) {
            var9_12 = "Socks server data connection failed.  RC = " + Byte.toString(var6_3[1]);
            this.tf.write("openPassiveDataConnectionSocksServer()", 0, var9_12);
            var2_6.setProcessCode(222);
            var2_6.setMessage(var9_12);
            return var2_6;
        }
        this.tf.write("openPassiveDataConnectionSocksServer", 1, "Connected to host " + var1_1.getHost());
        this.tf.write("openPassiveDataConnectionSocksServer()", 1, "exit");
        return var2_6;
    }

    public AFtpReturnCode openSourceFile(String string) {
        this.tf.write("openSourceFile()", 1, "entry");
        AFtpReturnCode aFtpReturnCode = this.pasv();
        if (aFtpReturnCode.getCommandCode() == 2 && (aFtpReturnCode = this.retr(string)).getCommandCode() == 1) {
            aFtpReturnCode.setCommandCode(2);
        }
        this.tf.write("openSourceFile()", 1, "exit");
        return aFtpReturnCode;
    }

    public AFtpReturnCode openTargetFile(String string) {
        this.tf.write("openTargetFile()", 1, "entry");
        AFtpReturnCode aFtpReturnCode = this.pasv();
        if (aFtpReturnCode.getCommandCode() == 2 && (aFtpReturnCode = this.dele(string)).getCommandCode() == 5) {
            aFtpReturnCode.setCommandCode(2);
        }
        if (aFtpReturnCode.getCommandCode() == 2 && (aFtpReturnCode = this.stor(string)).getCommandCode() == 1) {
            aFtpReturnCode.setCommandCode(2);
        }
        this.tf.write("openTargetFile()", 1, "exit");
        return aFtpReturnCode;
    }

    private AFtpReturnCode pasv() {
        this.tf.write("pasv()", 1, "entry");
        AFtpReturnCode aFtpReturnCode = new AFtpReturnCode();
        AFtpReturnCode aFtpReturnCode2 = this.issueStandardCommand("PASV");
        if (aFtpReturnCode2.getCommandCode() != 2) {
            this.tf.write("pasv()", 0, "PASV command failed.  ftpRC = " + aFtpReturnCode2.toString());
            return aFtpReturnCode2;
        }
        StringTokenizer stringTokenizer = new StringTokenizer((String)aFtpReturnCode2.getServerResponse().elementAt(1), "()");
        stringTokenizer.nextToken();
        String string = stringTokenizer.nextToken();
        stringTokenizer = new StringTokenizer(string, ",");
        String string2 = stringTokenizer.nextToken() + "." + stringTokenizer.nextToken() + "." + stringTokenizer.nextToken() + "." + stringTokenizer.nextToken();
        int n = Integer.parseInt(stringTokenizer.nextToken()) * 256 + Integer.parseInt(stringTokenizer.nextToken());
        string = Integer.toString(n);
        this.tf.write("pasv()", 2, "host = " + string2 + "  port = " + string);
        AFtpLogonParameters aFtpLogonParameters = new AFtpLogonParameters(string2, string, "", "", new Vector(), 0);
        switch (this.aFtpLogonParameters.getConnectionType()) {
            case 2: {
                aFtpReturnCode = this.openPassiveDataConnectionSocksServer(aFtpLogonParameters);
                break;
            }
            case 1: {
                aFtpReturnCode = this.openPassiveDataConnectionNoProxy(aFtpLogonParameters);
            }
        }
        this.tf.write("pasv()", 1, "exit");
        if (aFtpReturnCode.getProcessCode() != 0) {
            return aFtpReturnCode;
        }
        return aFtpReturnCode2;
    }

    public AFtpReturnCode put(String string, String string2) {
        return this.put(string, string2, 0);
    }

    public AFtpReturnCode put(String string, String string2, int n) {
        this.tf.write("put()", 1, "entry");
        this.tf.write("put()", 1, "remoteFile = \"" + string2 + "\"");
        this.tf.write("put()", 1, "localFile = \"" + string + "\"");
        this.tf.write("put()", 1, "blockSize = " + Integer.toString(n));
        AFtpReturnCode aFtpReturnCode = new AFtpReturnCode();
        this.useActive = false;
        this.tf.write("put()", 1, "mode = " + (this.useActive ? "active" : "passive"));
        String string3 = this.makeTempName(string2);
        AStatusWindow.write("#PUT \"" + string + "\" to \"" + string2 + "\"");
        int n2 = 3;
        int n3 = 0;
        this.currentTransferBytesSent = 0;
        File file = new File(string);
        int n4 = (int)file.length();
        byte[] byArray = new byte[n4];
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            fileInputStream.read(byArray, 0, n4);
            fileInputStream.close();
            if (n4 > 0 && byArray[n4 - 1] == 26) {
                --n4;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.tf.write("put", 0, fileNotFoundException.toString());
            aFtpReturnCode.setException(fileNotFoundException);
            aFtpReturnCode.setProcessCode(225);
            aFtpReturnCode.setMessage("File to transfer not found: " + file.getAbsolutePath());
        }
        catch (IOException iOException) {
            this.tf.write("put", 0, iOException.toString());
            aFtpReturnCode.setException(iOException);
            aFtpReturnCode.setProcessCode(226);
            aFtpReturnCode.setMessage("Error reading file to transfer: " + file.getAbsolutePath());
        }
        if (aFtpReturnCode.getProcessCode() == 0 && !this.currentTransferMode.equals("S")) {
            aFtpReturnCode = this.mode("S");
        }
        if (aFtpReturnCode.getProcessCode() == 0 && aFtpReturnCode.getCommandCode() == 0) {
            aFtpReturnCode.setCommandCode(2);
        }
        int n5 = 0;
        while (n5 <= n2 && !Thread.currentThread().isInterrupted()) {
            n3 = this.currentTransferBytesSent;
            if (aFtpReturnCode.getCommandCode() == 2) {
                aFtpReturnCode = this.useActive ? this.port() : this.pasv();
            }
            if (aFtpReturnCode.getCommandCode() == 2) {
                if (n5 > 0) {
                    AStatusWindow.write("#Attempting to restart FTP transfer...");
                    if (this.rest(String.valueOf(n3)).getCommandCode() == 3) {
                        AStatusWindow.write("#Restart successful");
                        this.tf.write("get", 0, "Re-starting transfer in middle of file...");
                    } else {
                        AStatusWindow.write("#This host does not support this restart...");
                        AStatusWindow.write("#Restarting transfer from beginning of the file...");
                        this.currentTransferBytesSent = 0;
                        this.dele(string3);
                        this.tf.write("get", 0, "Re-starting transfer from beginning of file...");
                    }
                } else {
                    this.dele(string3);
                }
            }
            if (aFtpReturnCode.getCommandCode() == 2) {
                aFtpReturnCode = this.stor(string3);
            }
            if (aFtpReturnCode.getCommandCode() != 1 || this.useActive && (aFtpReturnCode = this.openActiveDataConnectionNoProxy()).getProcessCode() != 0) break;
            AFtpReturnCode aFtpReturnCode2 = this.sendDataToServer(byArray, n4, n);
            if (Thread.currentThread().isInterrupted() || (aFtpReturnCode = this.getResponseFromServer()).getCommandCode() == 2) break;
            AStatusWindow.write("#Error occurred... Analyzing...");
            if (aFtpReturnCode.getCommandCode() == 5) {
                this.tf.write("put", 0, "Server returned error.  Stop transfer");
                AStatusWindow.write("#Host FTP server returned an error message... Transfer attempt stopped");
                break;
            }
            AStatusWindow.write("#Apparent socket or network error...");
            if (n3 > 0) {
                if (this.currentTransferBytesSent == n3) {
                    AStatusWindow.write("#No more data is being sent... Transfer stopped.");
                    this.tf.write("put", 0, "No more data being sent.  Stop transfer");
                    break;
                }
                n5 = 0;
            } else if (n5 >= n2) {
                AStatusWindow.write("#Exceeded maximum number of restries.  Transfer stopped.");
                this.tf.write("put", 0, "Exceeded maximum number of retries.  Transfer stopped");
                break;
            }
            this.tf.write("put", 0, "Socket error during upload...");
            AStatusWindow.write("#Checking for host connection...");
            aFtpReturnCode = this.verifyConnection(true);
            if (aFtpReturnCode.getCommandCode() != 2) {
                if (aFtpReturnCode.getProcessCode() != 1) {
                    AStatusWindow.write("#User canceled.");
                    this.tf.write("put", 0, "User canceled logon. Transfer stopped.");
                } else {
                    AStatusWindow.write("#Unrecoverable error.  Transfer stopped.");
                    this.tf.write("put", 0, "Unrecoverable error during logon.  Stop transfer.");
                }
                aFtpReturnCode = aFtpReturnCode2;
                break;
            }
            AStatusWindow.write("#Host connection verified.");
            if (aFtpReturnCode.getCommandCode() == 2) {
                aFtpReturnCode = this.type(this.currentTransferType);
            }
            if (aFtpReturnCode.getCommandCode() != 2) break;
            AStatusWindow.write("#Retry the transfer...");
            ++n5;
        }
        if (aFtpReturnCode.getCommandCode() == 2) {
            aFtpReturnCode = this.dele(string2);
            if ((aFtpReturnCode.getCommandCode() == 2 || aFtpReturnCode.getCommandCode() == 5) && (aFtpReturnCode = this.rnfr(string3)).getCommandCode() == 3) {
                aFtpReturnCode = this.rnto(string2);
            }
            if (aFtpReturnCode.getCommandCode() != 2) {
                this.dele(string3);
            }
        }
        if (aFtpReturnCode.getCommandCode() != 2) {
            int n6 = aFtpReturnCode.getProcessCode();
            if (n6 == 0) {
                n6 = 199;
            }
            String string4 = "<HTML>Error during transfer of file:<br>" + string2 + HTML_BREAK + "(tempname = " + string3 + ")" + HTML_PARAGRAPH + aFtpReturnCode.toString() + HTML_END;
            AUtilities.showErrorMessage(n6, string4);
        }
        this.tf.write("put()", 1, "exit");
        return aFtpReturnCode;
    }

    private AFtpReturnCode sendCommandToServer(String string) {
        this.tf.write("sendCommandToServer()", 2, "entry");
        this.lastCommandIssued = string;
        AFtpReturnCode aFtpReturnCode = new AFtpReturnCode();
        try {
            this.controlStreamWriter.println(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.tf.write("sendCommandToServer()", 2, "exit");
        return aFtpReturnCode;
    }

    private AFtpReturnCode sendDataToServer(byte[] byArray, int n, int n2) {
        this.tf.write("sendDataToServer()", 2, "entry");
        this.tf.write("sendDataToServer()", 2, "Total bytes to send: " + Integer.toString(n));
        AFtpReturnCode aFtpReturnCode = new AFtpReturnCode();
        long l = System.currentTimeMillis();
        try {
            if (n2 == 0) {
                int n3 = 65536;
                int n4 = 262144;
                int n5 = this.currentTransferBytesSent;
                while (n5 + n3 < n && !Thread.currentThread().isInterrupted()) {
                    this.dataStreamWriter.write(byArray, n5, n3);
                    this.currentTransferBytesSent = n5 += n3;
                    this.tf.write("sendDataToServer", 2, "Bytes sent: " + Integer.toString(n5));
                    if (n5 % n4 != 0) continue;
                    long l2 = System.currentTimeMillis();
                    int n6 = n4 / (l2 == l ? 1 : (int)(l2 - l));
                    this.tf.write("sendDataToServer", 2, Integer.toString(n5) + " bytes at " + Integer.toString(n6) + "KB");
                    l = l2;
                }
                if (Thread.currentThread().isInterrupted()) {
                    this.tf.write("sendDataToServer", 0, "Transfer interrupted");
                } else {
                    this.dataStreamWriter.write(byArray, n5, n - n5);
                    this.dataStreamWriter.flush();
                    this.tf.write("sendDataToServer", 2, "Bytes sent: " + Integer.toString(n));
                }
            }
        }
        catch (Exception exception) {
            this.tf.write("sendDataToServer", 0, exception.toString());
            aFtpReturnCode.setException(exception);
            aFtpReturnCode.setProcessCode(223);
            aFtpReturnCode.setMessage("Error sending data to host");
        }
        try {
            this.dataSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.tf.write("sendDataToServer()", 2, "exit");
        return aFtpReturnCode;
    }

    public void setLogonParameters(AFtpLogonParameters aFtpLogonParameters) {
        this.tf.write("setLogonParameters()", 1, "entry");
        this.tf.write("setLogonParameters()", 2, "host in = " + aFtpLogonParameters.getHost());
        this.tf.write("setLogonParameters()", 2, "port in = " + aFtpLogonParameters.getPort());
        this.aFtpLogonParameters = aFtpLogonParameters;
        this.tf.write("setLogonParameters()", 2, "host out = " + this.aFtpLogonParameters.getHost());
        this.tf.write("setLogonParameters()", 2, "port out = " + this.aFtpLogonParameters.getPort());
        this.tf.write("setLogonParameters()", 1, "exit");
    }

    public boolean showLogonWindow(String string) {
        this.tf.write("showLogonWindow()", 1, "entry");
        AFtpLogonWindow aFtpLogonWindow = new AFtpLogonWindow(null, this.aFtpLogonParameters, string);
        this.tf.write("showLogonWindow()", 1, "exit");
        return !aFtpLogonWindow.getUserCanceled();
    }
}

