/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ADetailsWindow {
    private Frame dialogOwner;
    private JDialog dialog;
    private JLabel titleLabel;
    private JLabel nameInRepLabel;
    private JLabel orderNumLabel;
    private JLabel shelfNameLabel;
    private JLabel shelfTitleLabel;
    private JLabel totalNumBooksLabel;
    private JLabel missingBooksLabel;
    private JLabel indexNameLabel;
    private JLabel belongsToGroupLabel;
    private JLabel sizeLabel;
    private JLabel dateLabel;
    private JList groupList;
    private JScrollPane groupScrollPane;
    private AFileObject aFileObject;
    private ARepository aRepository;
    private String key = "";
    private ATraceFile tf;

    public ADetailsWindow(Frame frame, AFileObject aFileObject, String string, ARepository aRepository) {
        JPanel jPanel;
        this.dialogOwner = frame;
        this.aFileObject = aFileObject;
        this.aRepository = aRepository;
        this.key = string;
        this.dialog = new JDialog(this.dialogOwner, true);
        this.dialog.setTitle("SCL - Details Window");
        ((Component)this.dialog).setSize(new Dimension(450, 320));
        this.dialog.setResizable(true);
        this.dialog.setLocationRelativeTo(this.dialogOwner);
        this.tf = new ATraceFile(this);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this.dialog).setLocation(dimension.width / 2 - 225, dimension.height / 2 - 160);
        JPanel jPanel2 = jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel2.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        this.titleLabel = new JLabel("");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.1;
        this.titleLabel.setAlignmentX(0.5f);
        gridBagConstraints.insets = new Insets(30, 30, 0, 30);
        this.addToGrid(gridBagConstraints, gridBagLayout, jPanel2, this.titleLabel);
        this.nameInRepLabel = new JLabel("");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.1;
        this.nameInRepLabel.setAlignmentX(0.5f);
        gridBagConstraints.insets = new Insets(0, 30, 0, 30);
        this.addToGrid(gridBagConstraints, gridBagLayout, jPanel2, this.nameInRepLabel);
        this.dateLabel = new JLabel("");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.1;
        this.dateLabel.setAlignmentX(0.5f);
        gridBagConstraints.insets = new Insets(0, 30, 0, 30);
        this.addToGrid(gridBagConstraints, gridBagLayout, jPanel2, this.dateLabel);
        this.orderNumLabel = new JLabel("");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 0.1;
        this.orderNumLabel.setAlignmentX(0.5f);
        gridBagConstraints.insets = new Insets(0, 30, 0, 30);
        this.addToGrid(gridBagConstraints, gridBagLayout, jPanel2, this.orderNumLabel);
        this.sizeLabel = new JLabel("");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 0.1;
        this.sizeLabel.setAlignmentX(0.5f);
        gridBagConstraints.insets = new Insets(0, 30, 0, 30);
        this.addToGrid(gridBagConstraints, gridBagLayout, jPanel2, this.sizeLabel);
        this.shelfNameLabel = new JLabel("");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weightx = 0.1;
        this.shelfNameLabel.setAlignmentX(0.5f);
        gridBagConstraints.insets = new Insets(0, 30, 0, 30);
        this.addToGrid(gridBagConstraints, gridBagLayout, jPanel2, this.shelfNameLabel);
        this.shelfTitleLabel = new JLabel("");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.weightx = 0.1;
        this.shelfTitleLabel.setAlignmentX(0.5f);
        gridBagConstraints.insets = new Insets(0, 30, 0, 30);
        this.addToGrid(gridBagConstraints, gridBagLayout, jPanel2, this.shelfTitleLabel);
        this.totalNumBooksLabel = new JLabel("");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.weightx = 0.1;
        this.totalNumBooksLabel.setAlignmentX(0.5f);
        gridBagConstraints.insets = new Insets(0, 30, 0, 30);
        this.addToGrid(gridBagConstraints, gridBagLayout, jPanel2, this.totalNumBooksLabel);
        this.missingBooksLabel = new JLabel("");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.weightx = 0.1;
        this.missingBooksLabel.setAlignmentX(0.5f);
        gridBagConstraints.insets = new Insets(0, 30, 0, 30);
        this.addToGrid(gridBagConstraints, gridBagLayout, jPanel2, this.missingBooksLabel);
        this.indexNameLabel = new JLabel("");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weightx = 0.1;
        this.indexNameLabel.setAlignmentX(0.5f);
        gridBagConstraints.insets = new Insets(0, 30, 30, 30);
        this.addToGrid(gridBagConstraints, gridBagLayout, jPanel2, this.indexNameLabel);
        this.belongsToGroupLabel = new JLabel("");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.weightx = 0.1;
        this.belongsToGroupLabel.setAlignmentX(0.5f);
        gridBagConstraints.insets = new Insets(0, 30, 0, 30);
        this.addToGrid(gridBagConstraints, gridBagLayout, jPanel2, this.belongsToGroupLabel);
        this.groupList = new JList();
        this.groupScrollPane = new JScrollPane(){

            public Dimension getPreferredSize() {
                return new Dimension(180, 80);
            }
        };
        this.groupScrollPane.setHorizontalScrollBarPolicy(31);
        this.groupScrollPane.getViewport().add(this.groupList);
        this.groupScrollPane.setAlignmentX(0.5f);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(0, 30, 30, 30);
        this.addToGrid(gridBagConstraints, gridBagLayout, jPanel2, this.groupScrollPane);
        JPanel jPanel3 = new JPanel();
        JButton jButton = new JButton("OK");
        jButton.setMnemonic('O');
        jPanel3.add((Component)jButton, "Center");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ADetailsWindow.this.dialog.dispose();
            }
        });
        this.dialog.getContentPane().add((Component)jPanel2, "Center");
        this.dialog.getContentPane().add((Component)jPanel3, "South");
        this.setValues(string);
        ((Component)this.dialog).setVisible(true);
    }

    private void addToGrid(GridBagConstraints gridBagConstraints, GridBagLayout gridBagLayout, Container container, Component component) {
        gridBagLayout.setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    private void setValues(String string) {
        long l;
        String string2 = this.aFileObject.date().toString();
        long l2 = this.aFileObject.date().getTime();
        if (l2 == (l = new Date(0L).getTime())) {
            string2 = "Unknown";
        }
        if (string.equals("Group")) {
            this.shelfNameLabel.setVisible(false);
            this.shelfTitleLabel.setVisible(false);
            this.belongsToGroupLabel.setVisible(false);
            this.groupScrollPane.setVisible(false);
            this.titleLabel.setText("Title : " + this.aFileObject.groupObjectPtr().title());
            this.nameInRepLabel.setText("Name in repository : " + this.aFileObject.nameInRepository());
            this.dateLabel.setText("Creation Date : " + string2);
            this.totalNumBooksLabel.setText("Total number of books : " + this.aFileObject.groupObjectPtr().fileObjectsSet().size());
            this.missingBooksLabel.setText("Number of missing books : " + this.aFileObject.groupObjectPtr().missingFileObjectsSet().size());
            this.indexNameLabel.setText("Index Name : " + this.indexName(this.aFileObject.groupObjectPtr()));
        } else if (string.equals("File")) {
            this.shelfNameLabel.setVisible(false);
            this.shelfTitleLabel.setVisible(false);
            this.totalNumBooksLabel.setVisible(false);
            this.missingBooksLabel.setVisible(false);
            this.indexNameLabel.setVisible(false);
            this.titleLabel.setText("Title : " + this.aFileObject.title());
            this.orderNumLabel.setText("Order number : " + this.getOrderNumber(this.aFileObject));
            if (this.aFileObject.referenceCount() < 0) {
                this.sizeLabel.setText("");
                this.nameInRepLabel.setText("Filename : " + this.aFileObject.fileNameType());
            } else {
                this.sizeLabel.setText("Size : " + this.aFileObject.sizeAsInt() + " bytes");
                this.nameInRepLabel.setText("Name in repository : " + this.aFileObject.nameInRepository());
            }
            this.dateLabel.setText("Creation Date : " + string2);
            if (this.aFileObject.pcFileType().toUpperCase().equals("BKS")) {
                this.belongsToGroupLabel.setVisible(false);
                this.groupScrollPane.setVisible(false);
            } else if (this.aFileObject.referenceCount() < 0) {
                String[] stringArray = new String[this.aFileObject.missingFromGroupSet().size()];
                int n = 0;
                String string3 = "";
                Enumeration enumeration = this.aFileObject.missingFromGroupSet().elements();
                while (enumeration.hasMoreElements()) {
                    AGroupObject aGroupObject = (AGroupObject)enumeration.nextElement();
                    stringArray[n] = string3 = aGroupObject.nameInRepository() + " (" + aGroupObject.title() + ")";
                    ++n;
                }
                this.belongsToGroupLabel.setText("Missing from shelves : ");
                this.groupList.setListData(stringArray);
                if (stringArray.length == 0) {
                    this.belongsToGroupLabel.setVisible(false);
                    this.groupScrollPane.setVisible(false);
                }
            } else {
                String string4 = this.belongsToGroup(this.aFileObject);
                StringTokenizer stringTokenizer = new StringTokenizer(string4, "\n");
                String[] stringArray = new String[stringTokenizer.countTokens()];
                int n = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    String string5;
                    stringArray[n] = string5 = stringTokenizer.nextToken();
                    ++n;
                }
                this.belongsToGroupLabel.setText("Contained in shelves : ");
                this.groupList.setListData(stringArray);
                if (stringArray.length == 0) {
                    this.belongsToGroupLabel.setVisible(false);
                    this.groupScrollPane.setVisible(false);
                }
            }
        }
    }

    private String belongsToGroup(AFileObject aFileObject) {
        String string = "";
        Enumeration enumeration = this.aRepository.catalog().groupObjectsSet().elements();
        while (enumeration.hasMoreElements()) {
            AGroupObject aGroupObject = (AGroupObject)enumeration.nextElement();
            Enumeration enumeration2 = aGroupObject.fileObjectsSet().elements();
            while (enumeration2.hasMoreElements()) {
                AFileObject aFileObject2 = (AFileObject)enumeration2.nextElement();
                String string2 = aFileObject.fileNameType();
                String string3 = aFileObject2.fileNameType();
                if (this.aRepository.hostType() == 1) {
                    string3 = aFileObject2.nameInRepository();
                    string2 = aFileObject.nameInRepository();
                }
                if (!string3.equals(string2)) continue;
                string = string.length() == 0 ? aGroupObject.nameInRepository() + " (" + aGroupObject.title() + ")" : string + "\n" + aGroupObject.nameInRepository() + " (" + aGroupObject.title() + ")";
            }
        }
        return string;
    }

    private String getOrderNumber(AFileObject aFileObject) {
        String string = "";
        this.tf.write("getOrderNumber() start, filename:", 18, aFileObject.fileNameType());
        if (aFileObject.pcFileType().toUpperCase().equals("BKS") || aFileObject.pcFileType().toUpperCase().equals("BKI")) {
            string = "Unknown";
            return string;
        }
        String string2 = this.belongsToGroup(aFileObject);
        this.tf.write("getOrderNumber()", 19, "temp:" + string2);
        int n = string2.indexOf(" ");
        if (n == -1) {
            return string;
        }
        String string3 = AUtilities.strip(string2.substring(0, n), '\'');
        if (this.aRepository.hostType() == 5) {
            n = string3.lastIndexOf(File.separator);
            if (n != -1) {
                string3 = string3.substring(n + 1);
            }
        } else if (this.aRepository.hostType() == 3 && (n = string3.lastIndexOf(47)) != -1) {
            string3 = string3.substring(n + 1);
        }
        string3 = this.aRepository.cacheDirectory() + string3;
        this.tf.write("shelfName:", 18, string3);
        String string4 = new String();
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(string3, "r");
            while (string4 != null) {
                string4 = randomAccessFile.readLine();
                if (string4 != null && string4.startsWith("BKNAME=", 0)) {
                    String string5 = string4.substring(7);
                    if (!string5.equals(aFileObject.fileName())) continue;
                    break;
                }
                if (string4 == null || !string4.startsWith("SH", 0)) continue;
                string = string4.substring(2);
            }
            randomAccessFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.tf.write("getOrderNumber() exit, orderNumber:", 18, string);
        return string;
    }

    private String indexName(AGroupObject aGroupObject) {
        AFileObject aFileObject;
        String string = "N/A";
        boolean bl = false;
        Enumeration enumeration = aGroupObject.fileObjectsSet().elements();
        while (enumeration.hasMoreElements()) {
            aFileObject = (AFileObject)enumeration.nextElement();
            if (!aFileObject.pcFileType().toUpperCase().equals("BKI")) continue;
            string = aFileObject.fileName();
            bl = true;
            break;
        }
        if (!bl) {
            enumeration = aGroupObject.missingFileObjectsSet().elements();
            while (enumeration.hasMoreElements()) {
                aFileObject = (AFileObject)enumeration.nextElement();
                if (!aFileObject.pcFileType().toUpperCase().equals("BKI")) continue;
                string = aFileObject.fileName() + " (Missing)";
                break;
            }
        }
        return string;
    }
}

